/* definition of the FAIL macro for failed unification : results in 
   backtracking during sequential execution */

#define SEQ_MOLECULE_ADDRESS(term)  (MOLECULE_PTR *) &term[INDEX(term)]

#define TAG_IS_SEQ_MOLECULE(slot)\
	COMPARE_LONG_TAG(slot, SEQ_MOLECULE)

#define ALLOC_SEQ_MOLECULE(term1,molecule,StackLimit)\
{\
    StackLimit -= (sizeof(MOLECULE_PTR)/sizeof(SLOT));\
    INSERT_INDEX(term1, StackLimit - term1, SEQ_MOLECULE);\
    molecule = (MOLECULE_PTR *) StackLimit;\
}


#define COPY_SEQ_MOLECULE(term1, term2,StackLimit)\
{\
    MOLECULE_PTR *molecule1, *molecule2;\
    ALLOC_SEQ_MOLECULE(term1, molecule1,StackLimit);\
    molecule2 = SEQ_MOLECULE_ADDRESS(term2);\
    *molecule1 = *molecule2;\
}


#define FAIL()  \
{\
    SHORT temp;\
    for(; TR > VV->TR; TR--)\
        INSERT_SLOT_TAG(*(TR-1), UNBOUND_VAR);\
    FL = VV->FL;\
    while (FL < 0)\
    {\
        TOS = (LONG *) VV;\
	VV = VV->PrevChoicePt;\
	if (VV == NULL)\
	    break;\
	for(; TR > VV->TR; TR--)\
	{\
	    if (TAG_IS_SEQ_MOLECULE(*(TR-1))) \
	        StackLimit = (SLOT *) (SEQ_MOLECULE_ADDRESS((*(TR-1))) + 1);\
            INSERT_SLOT_TAG(*(TR-1), UNBOUND_VAR);\
	}\
	FL = VV->FL;\
    }\
    if (VV == NULL)\
	suspend = TRUE;\
    else \
    {\
        V = VV;\
	PTerm = VV->PTerm;\
	PTuple = VV->PTuple;\
	PC = FL;\
    }\
}

