/* 
  these are procedures used by the ipsc2 version of the byte code interpreter
*/

UnifyVarTermProc()
{
    SLOT *term = (SLOT *) Instr[PC].arg[1];
    SLOT *tuple = CTuple;
    MOLECULE_PTR *molecule;
    BOOLEAN Unify(), SeqUnify(), thrumolecule = FALSE;

    Deref_Term(term, CTuple);
    CTerm = &CTuple[Instr[PC].arg[0]];
    Deref_Term(CTerm, CTuple);
    if (TAG_IS_TUPLE_INDEX_1(CTerm))
	CTerm = &CTuple[INDEX(CTerm)];
    if (TAG_IS_UNBOUND(CTerm))
    {
	if (seqexecution) *TR++ = CTerm;
	if (TAG_IS_FUNCTOR(term))
	   if (seqexecution)
	   {
	       ALLOC_SEQ_MOLECULE(CTerm, molecule, StackLimit);
	       INSERT_MOLEC_TERMS(molecule, term);
	       INSERT_MOLEC_TUPLE(molecule, CTuple);
	   }
	   else INSERT_ADDRESS(CTerm, term)
	else if (TAG_IS_MOLECULE(term))
	{
	    molecule = MOLECULE_ADDRESS(term);
	    COPY_MOLECULE(CTerm, term, molecule);
	}
	else if (TAG_IS_SEQ_MOLECULE(term))
	    COPY_SEQ_MOLECULE(CTerm, term, StackLimit);
	PC++;
    }
    else
    {
	if (TAG_IS_MOLECULE(term))
	{
	    molecule = MOLECULE_ADDRESS(term);
	    term = TERMS(molecule);
	    tuple = TUPLE(molecule);
	    thrumolecule = TRUE;
	}
	if (TAG_IS_SEQ_MOLECULE(term))
	{
	    molecule = SEQ_MOLECULE_ADDRESS(term);
	    term = TERMS(molecule);
	    tuple = TUPLE(molecule);
	}
	switch (SLOT_TAG(CTerm))
	{
	case MOLECULE:
	    molecule = MOLECULE_ADDRESS(CTerm);
	    if (seqexecution)
	    {
		if (SeqUnify(TERMS(molecule), TUPLE(molecule), 
			     term, tuple, TRUE, Stack, &TR))
		    PC++;
		else PC = Instr[PC].arg[2];
	    }
	    else if (Unify(TERMS(molecule), TUPLE(molecule), 
			   term, tuple, TRUE))
	         PC++;
	    else PC = Instr[PC].arg[2];
	    break;
	case SEQ_MOLECULE:
	    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
	    if (SeqUnify(TERMS(molecule), TUPLE(molecule), 
			 term, tuple, thrumolecule, Stack, &TR))
	    PC++;
	    else PC = Instr[PC].arg[2];
	    break;
	case FUNCTOR:
	case CLOSED_TERM:
	    if (seqexecution)
	    {
		if (SeqUnify(CTerm, CTuple, term, tuple,
			     thrumolecule, Stack, &TR))
		PC++;
		else PC = Instr[PC].arg[2];
	    }
	    else if (Unify(CTerm,CTuple, term, tuple, thrumolecule))
	         PC++;
	    else PC = Instr[PC].arg[2];
	    break;
	default:
	    PC = Instr[PC].arg[2];  /* fail */
	    break;
	}
    }
    if (PC == Instr[PC].arg[2])
        if (seqexecution)
            FAIL()
	else suspend = (PC < 0);
}


UnifyVarVarProc()
{
    SLOT *term1 = &CTuple[Instr[PC].arg[0]],
    	 *term2 = &CTuple[Instr[PC].arg[1]];
    SLOT *tuple1, *tuple2;
    MOLECULE_PTR *molecule;
    BOOLEAN Unify(), SeqUnify();
	    Deref_Term(term1, CTuple);
    Deref_Term(term2, CTuple);
    if (TAG_IS_TUPLE_INDEX_1(term1))
        term1 = &CTuple[INDEX(term1)];
    if (TAG_IS_TUPLE_INDEX_1(term2))
        term2 = &CTuple[INDEX(term2)];

    if (TAG_IS_UNBOUND(term1))
    {
	if (seqexecution) *TR++ = term1;
	switch(SLOT_TAG(term2))
	{
	case FUNCTOR:
	case CLOSED_TERM:
	    INSERT_ADDRESS(term1, term2);
	    break;
	case MOLECULE:
	     COPY_SLOT(term1, term2);
	case UNBOUND_VAR:
	    if (term1 != term2)
	    INSERT_INDEX(term1,term2 - CTuple,TUPLE_INDEX_1);
	    break;
	case INTEGER:
	    COPY_INTEGER(term1, term2);
	    break;
	default:
	    OsPrint("illegal slot tag in rhs of =\n");
	    OsKillSys();
	    suspend = TRUE;
	}
	PC++;
    }
    else if (TAG_IS_UNBOUND(term2))
    {
	if (seqexecution) *TR++ = term2;
	switch(SLOT_TAG(term1))
	{
	case FUNCTOR:
	case CLOSED_TERM:
	    INSERT_ADDRESS(term2, term1);
	    break;
	case MOLECULE:
	     COPY_SLOT(term2, term1);
	case INTEGER:
	    COPY_INTEGER(term2, term1);
	    break;
	default:
	    OsPrint("illegal slot tag in lhs of =\n");
	    OsKillSys();
	    suspend = TRUE;
	}
	PC++;
    }
    else if (TAG_IS_MOLECULE(term1) || TAG_IS_MOLECULE(term2))
    {
	if (TAG_IS_MOLECULE(term1))
	{
	    molecule = MOLECULE_ADDRESS(term1);
	    term1 = TERMS(molecule);
	    tuple1 = TUPLE(molecule);
	}
	else if (TAG_IS_SEQ_MOLECULE(term1))
	{
	    molecule = SEQ_MOLECULE_ADDRESS(term1);
	    term1 = TERMS(molecule);
	    tuple1 = TUPLE(molecule);
	}
	else tuple1 = CTuple;
	if (TAG_IS_MOLECULE(term2))
	{
	    molecule = MOLECULE_ADDRESS(term2);
	    term2 = TERMS(molecule);
	    tuple2 = TUPLE(molecule);
	}
	else if (TAG_IS_SEQ_MOLECULE(term2))
	{
	    molecule = SEQ_MOLECULE_ADDRESS(term2);
	    term2 = TERMS(molecule);
	    tuple2 = TUPLE(molecule);
	}
	else tuple2 = CTuple;
	if (seqexecution)
	{
	     if (SeqUnify(term1, tuple1, term2, tuple2,
			  TRUE, Stack, &TR))
	         PC++;
	     else PC = Instr[PC].arg[2];
	}
	else if (Unify(term1, tuple1, term2, tuple2, TRUE))
	     PC++;
	else PC = Instr[PC].arg[2];
    }
    else if (TAG_IS_SEQ_MOLECULE(term1) || 
	     TAG_IS_SEQ_MOLECULE(term2))
    {
	if (TAG_IS_SEQ_MOLECULE(term1))
	{
	    molecule = SEQ_MOLECULE_ADDRESS(term1);
	    term1 = TERMS(molecule);
	    tuple1 = TUPLE(molecule);
	}
	else tuple1 = CTuple;
	if (TAG_IS_SEQ_MOLECULE(term2))
	{
	    molecule = SEQ_MOLECULE_ADDRESS(term2);
	    term2 = TERMS(molecule);
	    tuple2 = TUPLE(molecule);
	}
	else tuple2 = CTuple;
	if (SeqUnify(term1, tuple1, term2, tuple2,
		     FALSE, Stack, &TR))
	     PC++;
	else PC = Instr[PC].arg[2];
    }
    else if (TAG_IS_FUNCTOR(term1) && TAG_IS_FUNCTOR(term2))
    {
	if (seqexecution)
	{
	     if (SeqUnify(term1, CTuple, term2, CTuple,
			  FALSE, Stack, &TR))
	         PC++;
	     else PC = Instr[PC].arg[2];
	}
	else if (Unify(term1, CTuple, term2, CTuple, FALSE))
	     PC++;
	else PC = Instr[PC].arg[2];
    }
    else if (TAG_IS_INTEGER(term1) && TAG_IS_INTEGER(term2) &&
	    (INTVALUE(term1) == INTVALUE(term2)))
	     PC++;
    else PC = Instr[PC].arg[2];
    
    if (PC == Instr[PC].arg[2])
        if (seqexecution)
            FAIL()
	else suspend = (PC < 0);
}



UnifyStrctProc()
{
    MOLECULE_PTR *molecule;
    
    TOMstack = 4 * Instr[PC].arg[3]; 
    CTerm = (SLOT *) Instr[PC].arg[0];
    Mstack[TOMstack++] = PTuple; /* stack current PTuple
				   upon entry into struct */
    Mstack[TOMstack++] = (SLOT *)++nextterm;
    Mstack[TOMstack++] = (SLOT *)PSubtermground;
    Mstack[TOMstack++] = PTerm;
    PTerm = &PTerm[nextterm];
    Deref_Term(PTerm, PTuple);
    switch (SLOT_TAG(PTerm))
    {
    case TUPLE_INDEX_1:
	if (TAG_IS_CLOSED_TERM(CTerm))
	     COPY_SLOT(&PTuple[INDEX(PTerm)], CTerm)
	else INSERT_INDEX(&PTuple[INDEX(PTerm)], (CTerm - term_space), TERM_SPC_INDEX_2);
	PTerm = Mstack[--TOMstack];
	TOMstack -= 3;    /* pop the stack - nexterm and 
			    PTuple unchanged */
	PC = Instr[PC].arg[1];   /* next argument */
	break;
	    case MOLECULE:
    case TERM_SPC_INDEX_2:
	if (TAG_IS_MOLECULE(PTerm))
	{
	    molecule = MOLECULE_ADDRESS(PTerm);
	    PTerm = TERMS(molecule);
	    PTuple = TUPLE(molecule);
	    PSubtermground = TRUE;
	}
	else 
	{
	    PTerm = &term_space[INDEX(PTerm)];
	    PTuple = CTuple;
	}
	/* no break. Fall into next case */
    case FUNCTOR:
    case CLOSED_TERM:
	if ((ARITY(PTerm) == ARITY(CTerm)) &&
	    (GET_FUNCTOR(PTerm) == GET_FUNCTOR(CTerm)))
	{
	    PC++;
	    nextterm = 0;
	}
	else PC = Instr[PC].arg[2];    /* fail unification */
	break;

    case TUPLE_INDEX_2:
	INSERT_ADDRESS(&CTuple[INDEX(PTerm)],CTerm);
	PC = Instr[PC].arg[1];   /* next argument */
	PTerm = Mstack[--TOMstack];
	TOMstack -= 3;    /* pop the stack - PSubtermground,
			     nexterm and  PTuple unchanged */
	PC = Instr[PC].arg[1];   /* next argument */
	break;
	
    default:
	PC = Instr[PC].arg[2];   /* fail unification */
    }
}




Unify1stVarProc(Msgptr)
MESSAGE *Msgptr;
{
    MOLECULE_PTR *molecule;
    SHORT index = Instr[PC].arg[0];

    CTerm = &A[index]; 
    /* CTerm must be unbound */
    PSubterm = &PTerm[++nextterm];
    Deref_Term(PSubterm, PTuple);
    switch (SLOT_TAG(PSubterm))
    {
    case TUPLE_INDEX_1:
	INSERT_INDEX(&PTuple[INDEX(PSubterm)], 
		     index,TUPLE_INDEX_2);
	break;
    case CLOSED_TERM:
	if ( ARITY_IS_ZERO(PSubterm))
	     COPY_ATOM(CTerm, PSubterm);
	else INSERT_ADDRESS(CTerm, PSubterm);
	break;
    case MOLECULE:
	molecule = MOLECULE_ADDRESS(PSubterm);
	COPY_MOLECULE(CTerm, PSubterm, molecule);
	break;
    case FUNCTOR:
	if (PSubtermground)
	{
	    Malloc_Molecule(molecule);
	    INSERT_MOLEC_TERMS(molecule, PSubterm);
	    INSERT_MOLEC_TUPLE(molecule, PTuple);
	    INSERT_MOLECULE(CTerm, molecule);
	}
	else INSERT_INDEX(CTerm, PSubterm - term_space, 
			  TERM_SPC_INDEX_2);
	break;
    case TUPLE_INDEX_2:
	COPY_INDEX(CTerm, PSubterm, TUPLE_INDEX_1);
	break;
    case TERM_SPC_INDEX_2:
	COPY_INDEX(CTerm, PSubterm, TERM_SPC_INDEX_1);
	break;
    case INTEGER:
    case REAL:
	COPY_ATOM(CTerm, PSubterm);
	break;
    default:
	OsPrintf("error! illegal slot_tag in Unify1stVar\n");
	suspend = TRUE;
    }
    PC++;
}

UnifyVarProc(Msgptr)
MESSAGE *Msgptr;
{
    MOLECULE_PTR *molecule;
    BOOLEAN Unify();
    SHORT index = Instr[PC].arg[0];

    CTerm = &A[index];
    Deref_Term(CTerm, CTuple);
    PSubterm = &PTerm[++nextterm];
    Deref_Term(PSubterm, PTuple);

    if (TAG_IS_TUPLE_INDEX_1(CTerm))
        CTerm = &A[INDEX(CTerm)];
    if (TAG_IS_UNBOUND(CTerm))
    {
	switch (SLOT_TAG(PSubterm))
	{
	case TUPLE_INDEX_1:
	    INSERT_INDEX(&PTuple[INDEX(PSubterm)], 
	     index, TUPLE_INDEX_2);
	    break;
	case CLOSED_TERM:
	    if ( ARITY_IS_ZERO(PSubterm))
	         COPY_ATOM(CTerm, PSubterm);
	    else INSERT_ADDRESS(CTerm, PSubterm);
	    break;
	case MOLECULE:
	    molecule = MOLECULE_ADDRESS(PSubterm);
	    COPY_MOLECULE(CTerm, PSubterm, molecule);
	    break;
	case FUNCTOR:
	    if (PSubtermground)
	    {
		Malloc_Molecule(molecule);
		INSERT_MOLEC_TERMS(molecule, PSubterm);
		INSERT_MOLEC_TUPLE(molecule, PTuple);
		INSERT_MOLECULE(CTerm, molecule);
	    }
	    else INSERT_INDEX(CTerm, PSubterm - term_space, 
	      TERM_SPC_INDEX_2);
	    break;
	case TUPLE_INDEX_2:
	    if (index != INDEX(PSubterm))
	        COPY_INDEX(CTerm, PSubterm, TUPLE_INDEX_1);
	    break;
	case TERM_SPC_INDEX_2:
	    COPY_INDEX(CTerm, PSubterm, TERM_SPC_INDEX_1);
	    break;
	case INTEGER:
	case REAL:
	    COPY_ATOM(CTerm, PSubterm);
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in UnifyVar\n");
	    suspend= TRUE;
	}
	PC++;
    }
    else if (TAG_IS_TUPLE_INDEX_1(PSubterm))
    {
	switch(SLOT_TAG(CTerm))
	{
	case CLOSED_TERM:
	    if ( ARITY_IS_ZERO(CTerm))
	         COPY_ATOM(&PTuple[INDEX(PSubterm)], CTerm);
	    else INSERT_ADDRESS(&PTuple[INDEX(PSubterm)], CTerm);
	    break;
	case MOLECULE:
	    molecule = MOLECULE_ADDRESS(PSubterm);
	    COPY_MOLECULE(&PTuple[INDEX(PSubterm)], CTerm, molecule);
	    break;
	case FUNCTOR:
	    INSERT_INDEX(&PTuple[INDEX(PSubterm)], CTerm - term_space, TERM_SPC_INDEX_2);
	    break;
	case TUPLE_INDEX_2:
	    COPY_INDEX(&PTuple[INDEX(PSubterm)], CTerm, TUPLE_INDEX_1);
	    break;
	case TERM_SPC_INDEX_2:
	    COPY_INDEX(&PTuple[INDEX(PSubterm)], CTerm, TERM_SPC_INDEX_1);
	    break;
	case INTEGER:
	case REAL:
	    COPY_ATOM(&PTuple[INDEX(PSubterm)], CTerm);
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in UnifyVar\n");
	    suspend = TRUE;
	}
	PC++;
    }
    else if(TAG_IS_INTEGER(PSubterm))
         if (TAG_IS_INTEGER(CTerm) && 
	     INTEGERS_EQUAL(PSubterm, CTerm))
              PC++;
	 else PC = Instr[PC].arg[1]; 
    else if (TAG_IS_REAL(PSubterm))
         if (TAG_IS_REAL(CTerm) && 
	     REALS_EQUAL(PSubterm, CTerm))
              PC++;
	 else PC = Instr[PC].arg[1]; 
    else 
    {
	BOOLEAN thrumolecule = FALSE;
	SLOT *tempPTuple, *tempCTuple;
	
	if (TAG_IS_MOLECULE(PSubterm))
	{
	    tempPTuple = TUPLE((MOLECULE_ADDRESS(PSubterm)));
	    PSubterm = TERMS((MOLECULE_ADDRESS(PSubterm)));
	    thrumolecule = TRUE;
	}
	else tempPTuple = Msgptr->goalResp;

	if (TAG_IS_MOLECULE(CTerm))
	{
	    tempCTuple = TUPLE((MOLECULE_ADDRESS(CTerm)));
	    CTerm = TERMS((MOLECULE_ADDRESS(CTerm)));
	}
	else tempCTuple = CTerm;

	if (!Unify(PSubterm, tempPTuple, CTerm, tempCTuple, thrumolecule))
	         PC = Instr[PC].arg[1]; 
         else PC++;
    }
}



SendFactRespProc(Msgptr)
MESSAGE *Msgptr;
{

    SHORT tupsize, newtupsize, termsize;
    SLOT *cterm, *newterm;
    MOLECULE_PTR *molecule;
    PVECTOR	*resp_priority = NULLPTR;

    tupsize = newtupsize = TUPLESIZE(PTuple);
    for (i = 1; i < tupsize; i++)
    {   
	if (TAG_IS_TUPLE_INDEX_2(&PTuple[i]))
	{
	    cterm = &CTuple[INDEX(&PTuple[i])];
	    Deref_Term(cterm, CTuple);
	    switch (SLOT_TAG(cterm))
	    {
	    case ABSOLUTE_ADDRESS:
	    case MOLECULE:
	    case CLOSED_TERM:
		COPY_SLOT((&PTuple[i]),cterm);
		break;
	    case REAL:
	    case INTEGER:
	    case UNBOUND_VAR:
		COPY_ATOM((&PTuple[i]),cterm);
		break;
	    case TUPLE_INDEX_1:
		INSERT_SLOT_TAG(&PTuple[i], UNBOUND_VAR);
		break;
	    case FUNCTOR:
		INSERT_INDEX((&PTuple[i]),(cterm - term_space), TERM_SPC_INDEX_2);
		break;
	    case TUPLE_INDEX_2:
		COPY_INDEX((&PTuple[i]), cterm, TUPLE_INDEX_1);
		break;
	    case TERM_SPC_INDEX_2:
		COPY_INDEX((&PTuple[i]), cterm, TERM_SPC_INDEX_1);
		break;
	    default:
		OsPrintf("illegal slot tag in SendFactResp\n");
		suspend = TRUE;
	    }
	} /* TUP INDEX 2 */

	if (TAG_IS_TERM_INDEX_2(&PTuple[i]))
	{
	    cterm = &term_space[INDEX(&PTuple[i])];
	    if (NoVarsIn(cterm, CTuple))
	    {
		if (CTuple == A)  /* in A regs  */
		{
		    Malloc_Slots(CTuple, TUPLESIZE(A));
		    *CTuple = *A;  /* tuplesize */
		    for (i = 1; i < TUPLESIZE(CTuple); i++)
		    CTuple[i] = A[i];   
		}
		/* create molecule */ 
		Malloc_Molecule(molecule);
		INSERT_MOLEC_TUPLE(molecule, CTuple);
		INSERT_MOLEC_TERMS(molecule, cterm);
		INSERT_MOLECULE(&PTuple[i], molecule);
	    }
	    else 
	    {
		/* copy term */
		termsize = TermSize(cterm, CTuple);
		Malloc_Slots(newterm, termsize);
		INSERT_ADDRESS(&PTuple[i], newterm);
		CopyTerm(cterm, CTuple, &newterm, &newtupsize);
	    }
	}
    }
    Malloc_ArcTuple(RTuple, newtupsize, Instr[PC].arg[0]);
    INSERT_TUPLE_SIZE(RTuple, newtupsize);
    for (i = 1; i < tupsize; i++)
        RTuple[i] = PTuple[i];

    if (newtupsize > tupsize)
        InitTuple((&RTuple[tupsize]), (newtupsize - tupsize));
    
    /* send response */
    if (DEBUG)
    {
	OsPrintf("BE: after unif. the parent term is  =\n   ");
	PrintTerm(PTerm, RTuple);
	OsPrintf("\n");
	PrintTerm(PTerm, RTuple);
	OsPrintf("\n");
    }
    X[2]++;   /* no of resps sent to parent */
    if (DEBUG)
	OsPrintf("sending response to goal slot %x\n", Msgptr->goalSlot);

#ifdef PRIORITY
	PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, resp_priority);
#endif

    if (Msgptr->statusbits & STAT_DET)
        SendRespMsg((MSGTYPE_RESPDATA | MSGTYPE_RESPCNUM |
		     MSGTYPE_RESPRNUM), MSGCHAREID(Msgptr),
		    MSGGSLOT(Msgptr), RTuple, 1, 1,
		    Msgptr->respEP, resp_priority)
    else DelayRespMsg(MSGTYPE_RESPDATA,MSGCHAREID(Msgptr),
		      Msgptr->goalSlot, RTuple, 0, 0,
		      Msgptr->respEP,delayedmsg, resp_priority);
}




SendClauseRespProc(Msgptr)
MESSAGE *Msgptr;
{
    SHORT tupsize, newtupsize, termsize;
    SLOT *cterm, *newterm, *newPTuple;
    MOLECULE_PTR *molecule;
    PVECTOR	 *clause_resp_priority = NULLPTR;

    if (DEBUG)
    {
	OsPrintf("CLAUSERESP: solution found for query %x\n",ptrQ);
	OsPrintf("CLAUSERESP: before close resp is :\n");
	BePrintTuple(CTuple);
    }
    if (ptrQ != NULL)
        PTuple = ptrQ->ptrParentT;

    tupsize = newtupsize = TUPLESIZE(PTuple);
    if (PTuple != Y)   /* may still be in Y regs */
    {
	for (i = 0; i < tupsize; i++)
            Y[i] = PTuple[i];   
    }
    for (i = 1; i < tupsize; i++)
    {   
	if (TAG_IS_TUPLE_INDEX_2(&Y[i]))
	{
	    cterm = &CTuple[INDEX(&Y[i])];
	    Deref_Term(cterm, CTuple);
	    switch (SLOT_TAG(cterm))
	    {
	    case MOLECULE:
	    case REAL:
	    case INTEGER:
	    case UNBOUND_VAR:
		COPY_SLOT((&Y[i]),cterm);
		break;
	    case CLOSED_TERM:
		INSERT_ADDRESS(&Y[i], cterm);
		break;
	    case TUPLE_INDEX_1:
		INSERT_SLOT_TAG(&Y[i], UNBOUND_VAR);
		break; 
	    case FUNCTOR:
		INSERT_INDEX((&Y[i]),(cterm - term_space), TERM_SPC_INDEX_2);
		break;
	    default:
		OsPrintf("illegal slot tag in SendClauseResp\n");
		suspend = TRUE;
	    }
	} /* TUP INDEX 2 */
	
	if (TAG_IS_TERM_INDEX_2(&Y[i]))
	{
	    cterm = &term_space[INDEX(&Y[i])];
	    if (NoVarsIn(cterm, CTuple))
	    {
		if (CTuple == A)  /* in A regs  */
		{
		    Malloc_Slots(CTuple, TUPLESIZE(A));
		    *CTuple = *A;  /* tuplesize */
		    for (i = 1; i < TUPLESIZE(CTuple); i++)
		    CTuple[i] = A[i];   
		}
		/* create molecule */ 
		Malloc_Molecule(molecule);
		INSERT_MOLEC_TUPLE(molecule, CTuple);
		INSERT_MOLEC_TERMS(molecule, cterm);
		INSERT_MOLECULE(&Y[i], molecule);
	    }
	    else 
	    {
		/* copy term */
		termsize = TermSize(cterm, CTuple);
		Malloc_Slots(newterm, termsize);
		INSERT_ADDRESS(&Y[i], newterm);
		CopyTerm(cterm, Y, &newterm, &newtupsize);
	    }
	}
    }
    
    /* copy response from registers and send it */
    
    Malloc_ArcTuple(RTuple, newtupsize, Instr[PC].arg[0]);
    INSERT_TUPLE_SIZE(RTuple, newtupsize);
    for (i = 1; i < tupsize; i++)
        RTuple[i] = Y[i];
    if (newtupsize > tupsize)
        InitTuple((&RTuple[tupsize]), (newtupsize - tupsize));
    if (DEBUG)
    {    
	OsPrintf("CLAUSERESP: after close - resp is :\n");
	BePrintTuple(RTuple);
    }
    /* send response */
    {

#ifdef PRIORITY
	if (ptrQ == NULL)
	   PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, clause_resp_priority)
	else
	   PGEN_IDENTICAL_PVECTOR(ptrQ->priority_vector, clause_resp_priority);
#endif

	if (ptrQ == NULL)
	    if (Msgptr->statusbits & STAT_DET)
	        SendRespMsg((MSGTYPE_RESPDATA | 
			     MSGTYPE_RESPCNUM | MSGTYPE_RESPRNUM),
			    MSGCHAREID(Msgptr),MSGGSLOT(Msgptr), 
			    RTuple, 1 , 1, Msgptr->respEP,
			    clause_resp_priority)
	    else SendRespMsg(MSGTYPE_RESPDATA,
			     MSGCHAREID(Msgptr), MSGGSLOT(Msgptr), 
			     RTuple, 0, 0, Msgptr->respEP,
			     clause_resp_priority)
	else if (ptrQ->statusbits & STAT_DET)
	     SendRespMsg((MSGTYPE_RESPDATA | 
		     MSGTYPE_RESPCNUM | MSGTYPE_RESPRNUM), 
		    QUERYCHAREID(ptrQ), ptrQ->parentGnum, 
		    RTuple, 1, 1, ptrQ->respEP,
		    clause_resp_priority)
	else SendRespMsg(MSGTYPE_RESPDATA, 
			 QUERYCHAREID(ptrQ), ptrQ->parentGnum, 
			 RTuple, 0 , 0, ptrQ->respEP,
			 clause_resp_priority);
    }
    if (allbuiltins)
    {
	X[2]++;   /* # of responses incremented by 1 */
	X[3]--;   /* treat it as a builtin */
    }
    else ptrQ->respNum++;
}



SUnify1stVarProc()
{
    MOLECULE_PTR *molecule;
    
    CTerm = &CTuple[Instr[PC].arg[0]];
    PSubterm = &PTerm[++nextterm];
    Deref_Term(PSubterm, PTuple);
    switch (SLOT_TAG(PSubterm))
    {
    case TUPLE_INDEX_1:
	PSubterm = &PTuple[INDEX(PSubterm)];
	/* fall into next case */
    case UNBOUND_VAR:
	/* orient from child to parent */
	if (CTerm != PSubterm)
	{
	    *TR++ = CTerm;
	    INSERT_ADDRESS(CTerm, PSubterm);
	}
	break;
    case SEQ_MOLECULE:
	*TR++ = CTerm;
	COPY_SEQ_MOLECULE(CTerm, PSubterm, StackLimit);
	break;
    case CLOSED_TERM:
	*TR++ = CTerm;
	if ( ARITY_IS_ZERO(PSubterm))
	     COPY_ATOM(CTerm, PSubterm);
	else INSERT_ADDRESS(CTerm, PSubterm);
	break;
    case MOLECULE:
	*TR++ = CTerm;
	molecule = MOLECULE_ADDRESS(PSubterm);
	COPY_MOLECULE(CTerm, PSubterm, molecule);
	break;
    case FUNCTOR:
	*TR++ = CTerm;
	ALLOC_SEQ_MOLECULE(CTerm, molecule, StackLimit);
	INSERT_MOLEC_TERMS(molecule, PSubterm);
	INSERT_MOLEC_TUPLE(molecule, PTuple);
	break;
    case INTEGER:
    case REAL:
	*TR++ = CTerm;
	COPY_ATOM(CTerm, PSubterm);
	break;
    default:
	OsPrintf("error! illegal slot_tag in SUnify1stVar\n");
	suspend = TRUE;
    }
    PC++;
}



SUnifyVarProc()
{
    MOLECULE_PTR *molecule;
    SLOT *tempPTuple, *tempCTuple;
    
    CTerm = &CTuple[Instr[PC].arg[0]];
    Deref_Term(CTerm, CTuple);
    PSubterm = &PTerm[++nextterm];
    Deref_Term(PSubterm, PTuple);
    switch (SLOT_TAG(CTerm))
    {
    case TUPLE_INDEX_1:
	 CTerm = &CTuple[INDEX(CTuple)];
	 /* no break - drop into next case */
    case UNBOUND_VAR:
	switch (SLOT_TAG(PSubterm))
	{
	case TUPLE_INDEX_1:
	    PSubterm = &PTuple[INDEX(PSubterm)];
	    /* fall into next case */
	case UNBOUND_VAR:
	    /* orient from child to parent */
	    if (CTerm != PSubterm)
	    {
		*TR++ = CTerm;
	        INSERT_ADDRESS(CTerm, PSubterm);
	    }
	    break;
	case SEQ_MOLECULE:
	    *TR++ = CTerm;
	    COPY_SEQ_MOLECULE(CTerm, PSubterm, StackLimit);
	    break;
	case CLOSED_TERM:
	    *TR++ = CTerm;
	    if ( ARITY_IS_ZERO(PSubterm))
	        COPY_ATOM(CTerm, PSubterm);
	    else INSERT_ADDRESS(CTerm, PSubterm);
	    break;
	case MOLECULE:
	    *TR++ = CTerm;
	    molecule = MOLECULE_ADDRESS(PSubterm);
	    COPY_MOLECULE(CTerm, PSubterm, molecule);
	    break;
	case FUNCTOR:
	    *TR++ = CTerm;
	    ALLOC_SEQ_MOLECULE(CTerm, molecule, StackLimit);
	    INSERT_MOLEC_TERMS(molecule, PSubterm);
	    INSERT_MOLEC_TUPLE(molecule, PTuple);
	    break;
	case INTEGER:
	case REAL:
	    *TR++ = CTerm;
	    COPY_ATOM(CTerm, PSubterm);
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
	    suspend= TRUE;
	}
	PC++;
	break;

    case MOLECULE:
	switch (SLOT_TAG(PSubterm))
	{
	case TUPLE_INDEX_1:
	    PSubterm = &PTuple[INDEX(PSubterm)];
	    /* continue into next case */
	case UNBOUND_VAR:
	    COPY_SLOT(PSubterm, CTerm);
	    *TR++ = PSubterm;
	    PC++;
	    break;
	case SEQ_MOLECULE:
	    molecule = MOLECULE_ADDRESS(CTerm);
	    CTerm = TERMS(molecule);
	    tempCTuple = TUPLE(molecule);
	    molecule = SEQ_MOLECULE_ADDRESS(PSubterm);
	    PSubterm = TERMS(molecule);
	    tempPTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm,tempPTuple, CTerm,
			 tempCTuple, TRUE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case FUNCTOR:
	case CLOSED_TERM:
	    molecule = MOLECULE_ADDRESS(CTerm);
	    CTerm = TERMS(molecule);
	    tempCTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm,PTuple, CTerm,tempCTuple, 
			 TRUE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case MOLECULE:
	    molecule = MOLECULE_ADDRESS(CTerm);
	    CTerm = TERMS(molecule);
	    tempCTuple = TUPLE(molecule);
	    molecule = MOLECULE_ADDRESS(PSubterm);
	    PSubterm = TERMS(molecule);
	    tempPTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm,tempPTuple, CTerm,
			 tempCTuple, TRUE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case INTEGER:
	case REAL:
	    FAIL();
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
	    suspend = TRUE;
	}	
	break;

     case SEQ_MOLECULE:
	switch (SLOT_TAG(PSubterm))
	{
	case TUPLE_INDEX_1:
	    PSubterm = &PTuple[INDEX(PSubterm)];
	    /* continue into next case */
	case UNBOUND_VAR:
	    COPY_SEQ_MOLECULE(PSubterm, CTerm, StackLimit);
	    *TR++ = PSubterm;
	    PC++;
	    break;
	case SEQ_MOLECULE:
	    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
	    CTerm = TERMS(molecule);
	    tempCTuple = TUPLE(molecule);
	    molecule = SEQ_MOLECULE_ADDRESS(PSubterm);
	    PSubterm = TERMS(molecule);
	    tempPTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm,tempPTuple, CTerm,
			 tempCTuple, FALSE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case FUNCTOR:
	case CLOSED_TERM:
	    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
	    CTerm = TERMS(molecule);
	    tempCTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm,PTuple, CTerm,tempCTuple, 
			 FALSE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case MOLECULE:
	    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
	    CTerm = TERMS(molecule);
	    tempCTuple = TUPLE(molecule);
	    molecule = MOLECULE_ADDRESS(PSubterm);
	    PSubterm = TERMS(molecule);
	    tempPTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm,tempPTuple, CTerm,
			 tempCTuple, TRUE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case INTEGER:
	case REAL:
	    FAIL();
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
	    suspend = TRUE;
	}
	break;

    case FUNCTOR:
	switch (SLOT_TAG(PSubterm))
	{
	case TUPLE_INDEX_1:
	    PSubterm = &PTuple[INDEX(PSubterm)];
	    /* continue into next case */
	case UNBOUND_VAR:
	    ALLOC_SEQ_MOLECULE(PSubterm, molecule, StackLimit);
	    INSERT_MOLEC_TERMS(molecule, CTerm);
	    INSERT_MOLEC_TUPLE(molecule, CTuple);
	    *TR++ = PSubterm;
	    PC++;
	    break;
	case SEQ_MOLECULE:
	    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
	    CTerm = TERMS(molecule);
	    tempCTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm, PTuple, CTerm,
			 tempCTuple, FALSE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case FUNCTOR:
	case CLOSED_TERM:
	    if (SeqUnify(PSubterm,PTuple, CTerm,CTuple, 
	 FALSE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case MOLECULE:
	    molecule = MOLECULE_ADDRESS(PSubterm);
	    PSubterm = TERMS(molecule);
	    tempPTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm,tempPTuple, CTerm,
			 CTuple, TRUE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case INTEGER:
	case REAL:
	    FAIL();
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
	    suspend = TRUE;
	}

     case CLOSED_TERM:
	switch (SLOT_TAG(PSubterm))
	{
	case TUPLE_INDEX_1:
	    PSubterm = &PTuple[INDEX(PSubterm)];
	    /* continue into next case */
	case UNBOUND_VAR:
	    INSERT_ADDRESS(PSubterm, CTerm);
	    *TR++ = PSubterm;
	    PC++;
	    break;
	case SEQ_MOLECULE:
	    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
	    CTerm = TERMS(molecule);
	    tempCTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm, PTuple, CTerm,
			 tempCTuple, FALSE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case FUNCTOR:
	case CLOSED_TERM:
	    if (SeqUnify(PSubterm,PTuple, CTerm,CTuple, 
	 FALSE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case MOLECULE:
	    molecule = MOLECULE_ADDRESS(PSubterm);
	    PSubterm = TERMS(molecule);
	    tempPTuple = TUPLE(molecule);
	    if (SeqUnify(PSubterm,tempPTuple, CTerm,
			 CTuple, TRUE, Stack, &TR))
	         PC++;
	    else FAIL();
	    break;
	case INTEGER:
	case REAL:
	    FAIL();
	    break;
	default:
	    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
	    suspend = TRUE;
	}
	break;

     case INTEGER:
	switch (SLOT_TAG(PSubterm))
	{
	case TUPLE_INDEX_1:
	    PSubterm = &PTuple[INDEX(PSubterm)];
	    /* continue into next case */
	case UNBOUND_VAR:
	    COPY_SLOT(PSubterm, CTerm);
	    *TR++ = PSubterm;
	    PC++;
	    break;
	case SEQ_MOLECULE:
	    FAIL();
	    break;
	case INTEGER:
	    if (INTVALUE(PSubterm) != INTVALUE(CTerm))
	        FAIL()
	    else PC++;
	    break;
	default:
	    FAIL();
	}
	break;

     default:
	 FAIL();
     }
}





SUnifyStrctProc()
{
    MOLECULE_PTR *molecule;
    
    TOMstack = 4 * Instr[PC].arg[2];  
    CTerm = (SLOT *) Instr[PC].arg[0];
    Mstack[TOMstack++] = PTuple; /* stack current PTuple
				    upon entry into struct */
    Mstack[TOMstack++] = (SLOT *)++nextterm;
    Mstack[TOMstack++] = (SLOT *)PSubtermground;
    Mstack[TOMstack++] = PTerm;
    PTerm = &PTerm[nextterm];
    Deref_Term(PTerm, PTuple);
    switch (SLOT_TAG(PTerm))
    {
    case TUPLE_INDEX_1:
	PTerm = &PTuple[INDEX(PTerm)];
	/* fall into next case */
    case UNBOUND_VAR:
	if (TAG_IS_CLOSED_TERM(CTerm))
	INSERT_ADDRESS(PTerm, CTerm)
	else 
	{
	    ALLOC_SEQ_MOLECULE(PTerm, molecule, StackLimit);
	    INSERT_MOLEC_TERMS(molecule, CTerm);
	    INSERT_MOLEC_TUPLE(molecule, CTuple);
	}
	*TR++ = PTerm;
	PTerm = Mstack[--TOMstack];
	TOMstack -= 3;    /* pop the stack - nexterm and 
			     PTuple unchanged */
	PC = Instr[PC].arg[1];   /* next argument */
	break;
	
    case MOLECULE:
    case SEQ_MOLECULE:
	if (TAG_IS_MOLECULE(PTerm))
	{
	    molecule = MOLECULE_ADDRESS(PTerm);
	    PSubtermground = TRUE;
	}
	else molecule = SEQ_MOLECULE_ADDRESS(PTerm);
	
	PTerm = TERMS(molecule);
	PTuple = TUPLE(molecule);
	
	/* no break. Fall into next case */
	
    case FUNCTOR:
    case CLOSED_TERM:
	if ((ARITY(PTerm) == ARITY(CTerm)) &&
	    (GET_FUNCTOR(PTerm) == GET_FUNCTOR(CTerm)))
	{
	    PC++;
	    nextterm = 0;
	}
	else FAIL();
	break;
	
    default:
	FAIL();
    }
}



ISVarVarProc()
{
    SLOT *leftterm, *rightterm;
    BOOLEAN failed = FALSE;

    leftterm  = &CTuple[Instr[PC].arg[0]];
    Deref_Term(leftterm, CTuple);
    rightterm = &CTuple[Instr[PC].arg[1]];
    Deref_Term(rightterm, CTuple);
    if (!TAG_IS_INTEGER(rightterm))
    {
	OsPrint("integer reqd. in rhs of IS\n");
	OsKillSys();
    }
    else
    {
	if (TAG_IS_INTEGER(leftterm))
	failed = (INTVALUE(leftterm) != INTVALUE(rightterm));
	else if (TAG_IS_UNBOUND(leftterm))
	{
	    if (seqexecution) *TR++ = leftterm;
	    INSERT_INTEGER(leftterm, INTVALUE(rightterm));
	}
	else if (TAG_IS_TUPLE_INDEX_1(leftterm))
	{
	    if (seqexecution) *TR++ = &CTuple[INDEX(leftterm)];
	    INSERT_INTEGER(&CTuple[INDEX(leftterm)], 
			   INTVALUE(rightterm));
	}
	PC = failed ? Instr[PC].arg[2] : PC+1;
	if (failed)
	     if (seqexecution)
	          FAIL()
	     else suspend = (PC < 0);
    }
}


TryMeElseProc()
{
    switch (SLOT_TAG(switchterm))
    {
    case TUPLE_INDEX_1:
	PC++;
	break;
    case FUNCTOR:
    case CLOSED_TERM:
	if (ARITY_IS_ZERO(switchterm))
	    PC = Instr[PC].arg[1];
	else if (GET_FUNCTOR(switchterm) == CONS)
	     PC = Instr[PC].arg[2];
	else PC = Instr[PC].arg[3];
	break;
    case MOLECULE:
	{
	    MOLECULE_PTR *molecule;
	    
	    molecule = MOLECULE_ADDRESS(switchterm);
	    switchterm = TERMS(molecule);
	    if (GET_FUNCTOR(switchterm) == CONS)
	        PC = Instr[PC].arg[2];
	    else PC = Instr[PC].arg[3];
	}
	break;
    case SEQ_MOLECULE:
	{
	    MOLECULE_PTR *molecule;
	    
	    molecule = SEQ_MOLECULE_ADDRESS(switchterm);
	    switchterm = TERMS(molecule);
	    if (GET_FUNCTOR(switchterm) == CONS)
	         PC = Instr[PC].arg[2];
	    else PC = Instr[PC].arg[3];
	}
	break;
    case INTEGER:
    case REAL:
	PC = Instr[PC].arg[0];
	break;
    default: 
	OsPrint("illegal slot tag in term during switch on term\n");
    }
    if (PC < 0)
        if (seqexecution)
	{
	    VV->FL = -2;  /* fail this predicate */
	    FAIL()
	}
	else suspend = TRUE;
}


