
#define BUILTIN_WRITE 1
#define BUILTIN_NL 2
#define BUILTIN_IS 3
#define BUILTIN_NE 4
#define BUILTIN_LT 5
#define BUILTIN_GT 6
#define BUILTIN_EQ 7
#define BUILTIN_DIV 8
#define BUILTIN_EQLT 9
#define BUILTIN_EQGT 10
#define BUILTIN_VAR 11
#define BUILTIN_NONVAR 12
#define BUILTIN_FUNCTOR 13
#define BUILTIN_ATOM 14
#define BUILTIN_ARG 15
#define BUILTIN_INT 16
#define BUILTIN_EQUAL 17
#define BUILTIN_NEQUAL 18
#define BUILTIN_UNIV 19
#define BUILTIN_PRVARS 20
#define HALT	21
#define NULLFACT 22
#define CUT 23


#define MAX(A,B) (A > B) ? A : B



#define Deref_Term(term, tuple)\
{ \
    BOOLEAN done;\
    done = FALSE;\
    while (!done)\
	switch(SLOT_TAG(term))\
	{ \
	case ABSOLUTE_ADDRESS:\
	    	term = ABS_ADDRESS(term);\
		break;\
\
	case TUPLE_INDEX_1:\
		if (!TAG_IS_UNBOUND(&(tuple[INDEX(term)]))) \
			term = &(tuple[INDEX(term)]);\
		else done = TRUE;\
		break;\
\
	case RELATIVE_INDEX:\
		term = term + INDEX(term);\
		break;\
\
	case TERM_SPC_INDEX_1:\
		term = &(term_space[INDEX(term)]);\
		break;\
\
	default:\
		done = TRUE;\
	} \
}



/* returns the number of unbound variables in the tuple. It also reassigns
   them to TUPLE indices in the child tuple  */ 

#define UnboundVars(ptuple, ctupsize, numvars)\
{ \
    SHORT i;\
    SHORT    tsize = TUPLESIZE(ptuple);\
    for(numvars = 0, i = 1; i < tsize; i++)\
	if (TAG_IS_UNBOUND(&(ptuple[i])))\
	{ \
	    INSERT_INDEX(&(ptuple[i]), ctupsize + numvars, TUPLE_INDEX_2);\
	    numvars++;\
	}\
}



#define InitTuple(tuple1, size)\
{\
    SHORT IT_i;\
\
    for (IT_i = 0; IT_i < size; IT_i++) \
    INSERT_SLOT_TAG(&(tuple1[IT_i]), UNBOUND_VAR); \
}



#define CopyTuple(tuple1, tuple2)\
{ \
    SHORT i;\
    SHORT    tsize = TUPLESIZE(tuple2);\
\
    if (tsize == 1)\
    	tuple1 = NULL;\
    else\
    {\
	for ( i = 1; i < tsize; i++)\
	    COPY_SLOT(&(tuple1[i]), &(tuple2[i]));\
    }\
}



#define APPLYOP(result,v1,v2,op) \
if (op == GET_FUNCTOR(&FUNCTOR_PLUS)) result = v1 + v2;\
else if (op == GET_FUNCTOR(&FUNCTOR_MINUS)) result = v1 - v2;\
else if (op == GET_FUNCTOR(&FUNCTOR_MULTIPLY)) result = v1 * v2;\
else if (op == GET_FUNCTOR(&FUNCTOR_MOD)) result = (int)v1 % (int)v2;\
else if (op == GET_FUNCTOR(&FUNCTOR_DIVIDE) || op == GET_FUNCTOR(&FUNCTOR_DIV)) result = v1/v2;



#define RELOP(v1,op,v2) \
	((TAG_IS_REAL(v1) ? REALVALUE(v1):INTVALUE(v1))\
	 op\
	 (TAG_IS_REAL(v2) ? REALVALUE(v2):INTVALUE(v2)))




#define Chase_Term(term, tuple)\
{ \
    BOOLEAN done;\
    done = FALSE;\
    while (!done)\
	switch(SLOT_TAG(term))\
	{ \
	case ABSOLUTE_ADDRESS:\
	    	term = ABS_ADDRESS(term);\
		break;\
	case RELATIVE_INDEX:\
		term = term + INDEX(term);\
		break;\
	case TERM_SPC_INDEX_1:\
		term = &(term_space[INDEX(term)]);\
		break;\
	default:\
		done = TRUE;\
	} \
}




