/*
 *		chare kernel entry point
 *
 *		spawns a Single Copy of loop().
 */

#include <stdio.h>
#include <signal.h>
#include "cksys.h"
#include "host.h"

int numPe = 1;			/* parallel processors to apply to loop() */
extern int SysMem;
int Millisec;			/* elapsed real time */
SPINLOCK countlock;
extern int ElapsedTimes[];

main(argc,argv)
{
  ParseCommandOptions(argc,argv);
  McInit();
  OsSpinInit(countlock);
  OsInitial();
  UsrHostInit(argc,argv);
  UsrNodeInit(argc,argv);
  /*printf("calling loop.\n");*/
  loop(0);
  WriteStats();
  exit(0);
}

WriteStats()
{
	CkStats();
	OsPrintf("%d ms elapsed time\n", ElapsedTimes[0]);
}
