#include <stdio.h>
#include <varargs.h>
#include "host.h"

SPINLOCK printLock;


WriteInit()
{
	OsSpinInit( printLock );
}


OsPrintf(va_alist)
va_dcl
{
	va_list args;
	char *format;

	OsSpinLock( printLock );
	va_start(args);
	format = va_arg(args,char *);
	_doprnt(format,args,stdout);
	va_end(args);
	OsSpinUnlock( printLock );
}

Fprintf(va_alist)
va_dcl
{
	va_list args;
	FILE *stream;
	char *format;

	OsSpinLock( printLock );
	va_start(args);
	stream = va_arg(args,FILE *);
	format = va_arg(args,char *);
	_doprnt(format,args,stream);
	va_end(args);
	OsSpinUnlock( printLock );
}

DoPrint(va_alist)
va_dcl
{
	va_list args;
	char *format;

	OsSpinLock( printLock );
	va_start(args);
	format = va_arg(args,char *);
	_doprnt(format,args,stdout);
	va_end(args);
	OsSpinUnlock( printLock );
}
