
#include "host.h"
#include "cksys.h"

#define MaxChares 50000
#define MaxResps 100000

int	PrintQueStat = FALSE;
extern 	shared	int	numPe;
int	ChareStackLength = 0;
int	MaxChareStackLength = 0;

int	RespStackLength[MaxPe];
int	MaxStackLength[MaxPe];

SPINLOCK chareLock;
SPINLOCK respLock[MaxPe];

int ChareStackTop;
int ChareStack[3*MaxChares];

int RespStackSize; /* max. size of each stack */
int RespStackTop[MaxPe];
int RespStack[3*MaxResps];  /* Stacks for all the pes are clubbed together in
			       one. Split using RespStackSize.
			       So, Resp stack for pe k goes
			       from k*RespStackSize to (k+1) * RespStackSize */

/* extern int CurrentAR,  CurrentMsg,  CurrentEP; */


QSInit()
{int Penum;

OsSpinInit(chareLock);
ChareStackTop = -1;

for (Penum=0; Penum<MaxPe; Penum++) 
{
 OsSpinInit(respLock[Penum]);
 RespStackTop[Penum] = -1;
 RespStackLength[Penum] = 0;
 MaxStackLength[Penum] = 0;
 }

 RespStackSize = (3*MaxResps)/MaxPe;
}


QSEmptyResponses(Penum)
int Penum;
{
return(RespStackTop[Penum] < 0);
}


QSEmptyChares()
{
return(ChareStackTop < 0);
}


PickNextMsg(JobType, CurrentAR,  CurrentMsg,  CurrentEP)
 JOBTYPE *JobType;
 int *CurrentAR,  *CurrentMsg,  *CurrentEP;
     /* First check if there is any response for local chares
	(note: this assumes anchoring, and so avoid the need to lock chares)
	If empty, check the global pool of CreateChare messages */
{ QsLockResponses(MyPenum);
  if (QSEmptyResponses(MyPenum))
    {QsUnlockResponses(MyPenum);
     QsLockChares();
     if (QSEmptyChares()) {QsUnlockChares(); return(NULL); }
       else { QmDeQueueChare(CurrentAR,CurrentMsg,CurrentEP); 
			*JobType = JOBTYPE_CHARE;
	      QsUnlockChares(); }}
  else
    {QmDeQueueResponse(MyPenum,CurrentAR,CurrentMsg,CurrentEP);
     *JobType = JOBTYPE_RESP;
     QsUnlockResponses(MyPenum);}
return(1);
}



QSEnQueueChare(EP,Msg,MsgSize,AR)
{
	QsLockChares();
	QmEnQueueChare(EP,Msg,AR);
	QsUnlockChares();
}


QSEnQueueResponse(Penum,EP,Msg,MsgSize,AR)
{
	QsLockResponses(Penum);
	QmEnQueueResponse(Penum,EP,Msg,AR);
	QsUnlockResponses(Penum);
}


QSEnQueueChareGen(EP,Msg,MsgSize,AR,Prio,NeedToPack)
{
	QsLockChares();
	QmEnQueueChare(EP,Msg,AR);
	QsUnlockChares();
}


QSEnQueueResponseGen(Penum,EP,Msg,MsgSize,AR,Prio,NeedToPack)
{
	QsLockResponses(Penum);
	QmEnQueueResponse(Penum,EP,Msg,AR);
	QsUnlockResponses(Penum);
}


QmEnQueueChare(EP,Msg,AR)
{
	ChareStackLength++;
	if ( ChareStackLength > MaxChareStackLength)
		MaxChareStackLength = ChareStackLength;

if (ChareStackTop > 3*MaxChares)
  {printf("Stack Overflow. Program Quits.\n");
   exit(1);}
/*OsPrintf("Enqueue chare by PE %d at %d\n", MyPenum, ChareStackTop+1 );*/
ChareStackTop++; ChareStack[ChareStackTop] = EP;
ChareStackTop++; ChareStack[ChareStackTop] = Msg;
ChareStackTop++; ChareStack[ChareStackTop] = AR;
}


QmDeQueueChare(CurrentAR,CurrentMsg,CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
{
	ChareStackLength--;

 /*OsPrintf("Dequeue chare at %d by PE %d\n", ChareStackTop, MyPenum );*/
 *CurrentAR = ChareStack[ChareStackTop]; ChareStackTop--;
 *CurrentMsg = ChareStack[ChareStackTop]; ChareStackTop--;
 *CurrentEP = ChareStack[ChareStackTop]; ChareStackTop--;
}


QmEnQueueResponse(Penum,EP,Msg,AR)
{
int j;
int	TotStackLength = 0;

RespStackLength[Penum]++;
for (j=0; j<numPe; j++) 
 TotStackLength += RespStackLength[j];

 TotStackLength += ChareStackLength;
if( TotStackLength > MaxStackLength[Penum] )
	MaxStackLength[Penum] = TotStackLength;

if (RespStackTop[Penum] > RespStackSize)
  {printf("Message Stack Overflow. Program Quits.\n");
   exit(1);}
/*OsPrintf("enqueue response for %d by %d\n", Penum, MyPenum);*/
RespStackTop[Penum]++; 
RespStack[RespStackSize*Penum + RespStackTop[Penum]] = EP;
RespStackTop[Penum]++;
RespStack[RespStackSize*Penum + RespStackTop[Penum]] = Msg;
RespStackTop[Penum]++; 
RespStack[RespStackSize*Penum + RespStackTop[Penum]] = AR;
}

QmDeQueueResponse(Penum, CurrentAR, CurrentMsg, CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
{
RespStackLength[Penum]--;
if (RespStackTop[Penum] < 0)
OsPrintf("Stack underflow.. error in Queueing.\n");
 *CurrentAR = RespStack[RespStackSize*Penum + RespStackTop[Penum]]; RespStackTop[Penum]--;
 *CurrentMsg = RespStack[RespStackSize*Penum + RespStackTop[Penum]]; RespStackTop[Penum]--;
 *CurrentEP = RespStack[RespStackSize*Penum + RespStackTop[Penum]]; RespStackTop[Penum]--;
/*OsPrintf("deque response for %d by %d\n", Penum, MyPenum);*/
}

QsLockChares()
{
    OsSpinLock( chareLock );
}


QsUnlockChares()
{
    OsSpinUnlock( chareLock );
}


QsLockResponses(Penum)
int Penum;
{
    OsSpinLock( respLock[Penum] );
}


QsUnlockResponses(Penum)
int Penum;
{
    OsSpinUnlock( respLock[Penum] );
}


QueueStatus()
{
	int i, max_stack_length = 0;

	for ( i=0; i<numPe; i++)
		if ( MaxStackLength[i] > max_stack_length )
			max_stack_length = MaxStackLength[i];

	OsPrintf("Queue Status: MaxStackLength %d\n", max_stack_length);
}

