/*----------------------------------------------------------------------
 *
 *		unix routines
 *
 *--------------------------------------------------------------------*/

#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>
#include <signal.h>
#include "cksys.h"
#include "host.h"

#define RUSAGE_SELF 0
#define RUSAGE_CHILDREN -1

int (*intHandler)();
shared int ElapsedTimes[MaxPe];

/*------------------------------------------------------- ParseCommandOptions */

ParseCommandOptions(argc,argv)
int argc;
char **argv;
{
	/* configure the chare kernel according to command line parameters.
	 * by convention, chare kernel parameters begin with '+'.
	 */
	extern int SysMem, numPe, PrintQueStat, MemTrace, PrintMemStat, PrintChareStat;
	int i;

	for( i=0; i<argc; i++ ) {
		if( strcmp( argv[i], "+m" ) == 0 && i+1 < argc ) {
			sscanf(argv[++i],"%d", &SysMem) ;
			printf("ck: memory set to %dK\n", SysMem);
			SysMem <<= 10;
		}
		else if( sscanf( argv[i], "+m%d", &SysMem ) == 1 ) {
			printf("ck: memory set to %dK\n", SysMem);
			SysMem <<= 10;
		}

		else if( strcmp( argv[i], "+p" ) == 0 && i+1 < argc ) {
			sscanf(argv[++i], "%d", &numPe);
			if (numPe > MaxPe || numPe < 1) {
				printf("ck: invalid number of processors (must be 1-%d)\n", MaxPe);
				exit(1);
			}
		}
		else if ( sscanf( argv[i], "+p%d", &numPe ) == 1 ) {
			if (numPe > MaxPe || numPe < 1) {
				printf("ck: invalid number of processors (must be 1-%d)\n", MaxPe);
				exit(1);
			}
		}

		else if( strcmp( argv[i], "+qs" ) == 0 ) {
			PrintQueStat = TRUE;
			printf("Queue Statistics Turned On\n");
		}

		else if( strcmp( argv[i], "+cs" ) == 0 ) {
			PrintChareStat = TRUE;
			printf("Chare Statistics Turned On\n");
		}

		else if( strcmp( argv[i], "+mems" ) == 0 ) {
			PrintMemStat = TRUE;
			printf("Memory Statistics Turned On\n");
		}

		else if( strcmp(argv[i], "+mt") == 0 && i+1 < argc )
			if (sscanf(argv[++i], "%d", &MemTrace) != 1) {
				printf("ck: missing argument to +mt\n");
				exit(1);
			}
			else printf("ck: memory trace level %d\n", MemTrace);
		else if (sscanf(argv[i], "+mt%d", &MemTrace) == 1)
			printf("ck: memory trace level %d\n", MemTrace);
	}
}



OsInitial()
{
	int OsInterrupt();

	/*intHandler = signal(SIGINT,OsInterrupt);
	if( (int)intHandler == -1 ) exit(1);*/
}

/*
 *   OsInterrupt - signal handler for SIGINT
 *
 *   Handles control-C pressed by the user.
 *   It should be set during initialization, after parallel jobs have
 *   been brought up.
 */

OsInterrupt()
{
	extern shared int SysDone;

	OsPrintf("CK: killed by user\n");
	OsKillSys();
	signal(SIGINT,SIG_DFL);
	(*intHandler)();
	exit(1);
}


/*
 *   OsTimer - timing functions
 *
 *   provides a single timer which can be stopped and restarted, or read out
 *   in elapsed milliseconds.  do OsTimer(TIMER_INIT) to begin timing.
 *   OsTimer(TIMER_READ) at any time returns elapsed time in milliseconds.
 *   OsTimer(TIMER_STOP) stops timing until an OsTimer(TIMER_START).
 */

OsTimer(func)
TIMEFUNC func;
{
	static shared struct rusage resource[MaxPe];
	struct rusage tempres;
	struct timeval tp, stp;

	switch(func) {
	case TIMER_INIT:
		getrusage( RUSAGE_SELF, &resource[MyPenum] );
		break;

	case TIMER_READ:
	{
		long i,j;

		getrusage( RUSAGE_SELF, &tempres );
		i = (tempres.ru_utime.tv_sec - resource[MyPenum].ru_utime.tv_sec) * 1000000;
		j = (tempres.ru_utime.tv_usec - resource[MyPenum].ru_utime.tv_usec);
		i = (i+j)/1000L;	
		return( (int)i );
	}

	/*===  the TIMER_STOP and TIMER_START functions do not work yet.
	 *===  they must maintain a total elapsed time variable. */

	default:
		OsPrintf("OsTimer: function out of range: %d\n", func);
	}
}

/*------------------------------------------------- Spin barrier functions */

SpinBarInit(b)
SPINBAR *b;
{
	OsSpinInit(b->lock);
	b->nprevious = 0;
	b->nwaiting = 0;
}

SpinBarWait(b)
SPINBAR *b;
{
	extern shared int SysDone;

	/* wait for all processes.
	 *	returns 0 if all processes have met at the barrier.
	 *         1 if OsKillSys was called
	 */
	while (b->nprevious) ;

	OsSpinLock(b->lock);
		if (b->nwaiting == 0)
			b->nwaiting = numPe;
		b->nwaiting--;
	OsSpinUnlock(b->lock);

	while (b->nwaiting)
		if (SysDone)
			return 1;

	OsSpinLock(b->lock);
		if (b->nprevious == 0)
			b->nprevious = numPe;
		b->nprevious--;
	OsSpinUnlock(b->lock);
	return (SysDone ? 1 : 0);
}
