#ifndef INCLUDE_CKSYS
#define INCLUDE_CKSYS
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#include "host.h"

typedef enum { TIMER_INIT, TIMER_START, TIMER_STOP, TIMER_READ } TIMEFUNC;
typedef enum { JOBTYPE_CHARE, JOBTYPE_RESP } JOBTYPE;

typedef struct {
	int rootpe;
	char *dataarea;
} ChareIDType;

/* spin barrier definitions
 *
 *	type SPINBAR is for declaring barriers.
 * OsBarrierInit(SPINBAR b) initializes a barrier.
 * OsBarrier(SPINBAR b) waits at a barrier for *numPe* processors.
 * OsBarrier normally returns 0 after synchronization is complete.
 * It returns 1 if OsKillSys was called while waiting.  The caller
 * is responsible for checking the return value and acting accordingly.
 */
typedef struct {
	SPINLOCK lock;
	char nwaiting;
	char nprevious;
} SPINBAR;

#define OsBarrierInit(b) SpinBarInit(&(b))
#define OsBarrier(b) SpinBarWait(&(b))
#define KLUDGEFLAG1

#endif
