#include "chare.h"
#include "machine.h"
#include "extern.h"

#define MSGPASSING

CoMsgWait(peNum)
int peNum;
{   /* wait untill either chare msg or data msg is ready */
    do {
        CoMsgNoWait(peNum);	/* process all pending messages */
	McProcStat(peNum);	/* do periodic work for ldb	*/

        if (PE(peNum).inChareQ.head == NULLPTR
    	      && PE(peNum).inDataQ.head == NULLPTR 
              && PE(peNum).inRoutQ.head == NULLPTR) 
	    McSuspendPe(peNum); 	
	} while (PE(peNum).inChareQ.head == NULLPTR 
		&& PE(peNum).inDataQ.head == NULLPTR);
}

CoMsgNoWait(peNum)
int peNum;
{   /* move pending msg to queue, and process other msg */
    SYSMSG *mPtr,*newPtr,*McGetPendingMsg();
    CHAREID   *idPtr;

    while ((mPtr = McGetPendingMsg(peNum)) != NULL)  { 
    /*if ((mPtr = McGetPendingMsg(peNum)) != NULL)  {*/
	if (SYSMSGLOAD(mPtr) >= 0) {
	    McUpdateStat(peNum,SYSMSGLASTPE(mPtr),SYSMSGLOAD(mPtr));
	    }
    	if (SYSMSGTYPE(mPtr)==SYSMSGTYPE_CHAR 
		|| SYSMSGTYPE(mPtr)==SYSMSGTYPE_DATA) {
		QmPutLocalMsg(mPtr,peNum);
		}
  	else if (SYSMSGTYPE(mPtr) ==  SYSMSGTYPE_CTRA) {
    		LdbContractMid(peNum,mPtr);	 
		}
  	else if (SYSMSGTYPE(mPtr) == SYSMSGTYPE_ROUT) {
 		LdbRoutMsg(peNum,mPtr);	 
	 	}
  	else if (SYSMSGTYPE(mPtr) == SYSMSGTYPE_PECH) {
		idPtr = SYSMSGLOGICID(mPtr);
		idPtr->remotePE = SYSMSGSRCPE(mPtr);
		idPtr->remoteCH = (int) SYSMSGSRCCH(mPtr);
		while (idPtr->pendingMsg.head != NULLPTR) {
		    newPtr = (SYSMSG*)QmDeQueue(&idPtr->pendingMsg);
		    SYSMSGDESTPE(newPtr)=SYSMSGNEXTPE(newPtr)=SYSMSGSRCPE(mPtr);
		    SYSMSGDESTCH(newPtr)=SYSMSGSRCCH(mPtr);
		    McSendMsg(newPtr,peNum);
		    }
		Free_Block(mPtr,SYSMSGSIZE(mPtr));
		}
  	else if (SYSMSGTYPE(mPtr) == SYSMSGTYPE_KILL) {
		McSysFinal(peNum);
		}
  	else {
		PE(peNum).loadNum++;
		Free_Block(mPtr,SYSMSGSIZE(mPtr));
		}
	}
}

CoGranDiff(peNum)
int	peNum;
{
    int t,k;

    t = McGetSysClk(peNum);
    k = t/ip.CSinterval;
    if (k > PE(peNum).diffCount) {
	PE(peNum).diffCount = k;
	LdbDiffProc(peNum);
	}
}

CoReDistr(peNum)
int	peNum;
{
    int t,k;

    t = McGetSysClk(peNum);
    k = t/ip.CSinterval;
    if (k > PE(peNum).diffCount) {
	PE(peNum).diffCount = k;
	LdbReDistr(peNum);
	}
}

