?- sum_tree(A, B) when ever.
sum_tree(A, B) :-
	flatten(A, C),
	sum_list(C, B).

?- flatten(nil, A) when ever.
?- flatten(t(nil, A, B), C) when ever.
?- flatten(t(t(A, B, C), D, E), F) when ever.
flatten(t(t(A, B, C), D, E), F) :-
	flatten(t(A, B, t(C, D, E)), F).
flatten(t(nil, A, B), [A|C]) :-
	flatten(B, C).
flatten(nil, []).

?- sum_list(A, B) when ever.
sum_list(A, B) :-
	sum_list1(A, 0, B).

?- sum_list1(A.B, C, D) when ever.
?- sum_list1([], A, B) when ever.
sum_list1([], A, A).
sum_list1([A|B], C, D) :-
	plus(C, A, E),
	sum_list1(B, E, D).

?- balanced(A) when ever.
balanced(A) :-
	balanced(A, B),
	stack(B).

?- balanced(.(125, A), B) when ever.
?- balanced(.(41, A), B) when ever.
?- balanced(.(123, A), B) when ever.
?- balanced(.(40, A), B) when ever.
?- balanced([], A) when ever.
balanced([], []).
balanced([40|A], [push('(')|B]) :-
	balanced(A, B).
balanced([123|A], [push('{')|B]) :-
	balanced(A, B).
balanced([41|A], [pop('(')|B]) :-
	balanced(A, B).
balanced([125|A], [pop('}')|B]) :-
	balanced(A, B).

?- stack(A) when ever.
stack(A) :-
	stack(A, []).

?- stack([], []) when ever.
?- stack(pop(A).B, C.D) when ever.
?- stack(push(A).B, C) when ever.
stack([push(A)|B], C) :-
	stack(B, [A|C]).
stack([pop(A)|B], [C|D]) :-
	C = A,
	stack(B, D).
stack([], []).

?- part(A, B.C, D, E) when ground(A) and ground(B).
?- part(A, [], B, C) when ever.
part(A, [], [], []).
part(A, [B|C], D, E) :-
	B =< A,
	!,
	D = [B|F],
	E = G,
	part(A, C, F, G).
part(A, [B|C], D, E) :-
	B > A,
	!,
	D = F,
	E = [B|G],
	part(A, C, F, G).

?- part1(A, B.C, D, E) when ground(A) and ground(B).
?- part1(A, [], B, C) when ever.
part1(A, [], [], []).
part1(A, [B|C], D, E) :-
	B =< A,
	!,
	D = [B|F],
	E = G,
	part1(A, C, F, G).
part1(A, [B|C], D, [B|E]) :-
	part1(A, C, D, E).

?- part2(A, B.C, D, E) when ever.
?- part2(A, [], B, C) when ever.
part2(A, [], [], []).
part2(A, [B|C], D, E) :-
	(if B =< A then
		D = [B|F],
		part2(A, C, F, E)
	else
		E = [B|G],
		part2(A, C, D, G)
	).

% Error: cant make part3/4 deterministic
?- delete_first(A, B.C, D) when ground(A) and ground(B).
delete_first(A, [B|C], D) :-
	B = A,
	!,
	D = C,
	true.
delete_first(A, [B|C], [B|D]) :-
	delete_first(A, C, D).

?- lmerge(A, B, C) when A and B.
lmerge([A|B], C, D) :-
	!,
	D = [A|E],
	lmerge(B, C, E).
lmerge(A, [B|C], D) :-
	!,
	D = [B|E],
	lmerge(A, C, E).
lmerge([], A, B) :-
	!,
	B = A,
	true.
lmerge(A, [], B) :-
	!,
	B = A,
	true.

?- merge(A, B, C) when A or B.
merge(A, B, C) :-
	nonvar(A),
	A = [D|E],
	!,
	C = [D|F],
	merge(E, B, F).
merge(A, B, C) :-
	nonvar(B),
	B = [D|E],
	!,
	C = [D|F],
	merge(A, E, F).
merge(A, B, C) :-
	nonvar(A),
	A = [],
	!,
	C = B,
	true.
merge(A, B, C) :-
	nonvar(B),
	B = [],
	!,
	C = A,
	true.

?- combine_s(A, B, C, D, E) when A or B.
combine_s(A, B, C, D, E) :-
	nonvar(A),
	A = succeeded,
	!,
	E = C,
	true.
combine_s(A, B, C, D, E) :-
	nonvar(B),
	B = succeeded,
	!,
	E = D,
	true.

?- p(A, B) when ground(A).
p(f(A), B) :-
	q(A, C),
	!,
	B = a,
	true.
p(h, A) :-
	!,
	A = c,
	true.
p(A, B) :-
	r(A, B).

?- qsort(A, B) when ever.
qsort(A, B) :-
	qsort(A, [], B).

?- qsort(A.B, C, D) when ever.
?- qsort([], A, B) when ever.
qsort([], A, A).
qsort([A|B], C, D) :-
	part(A, B, E, F),
	qsort(F, C, G),
	qsort(E, [A|C], D).

?- concat(A.B, C, D) when ever.
?- concat([], A, B) when ever.
concat([], A, A).
concat([A|B], C, [A|D]) :-
	concat(B, C, D).

?- done(A, B, C) when A or B.
done(A, B, C) :-
	nonvar(A),
	A = done,
	!,
	C = 1,
	true.
done(A, B, C) :-
	nonvar(B),
	B = done,
	!,
	C = 2,
	true.

?- p(g(f(b))) when ever.
?- p(g(a)) when ever.
?- p(f(A)) when ever.
p(f(A)) :-
	!,
	q.
p(f(A)) :-
	!,
	r.
p(g(a)) :-
	!,
	r.
p(g(f(b))) :-
	!,
	r.

