/****************************************************************
Copyright (C) The University of Melbourne 1993
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name of The University of Melbourne 
or any of its entities not be used in advertising or publicity
pertaining to distribution of the software without specific,
written prior permission.

THE UNIVERSITY OF MELBOURNE DISCLAIMS ALL WARRANTIES WITH REGARD
TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY
OF MELBOURNE OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

AUTHORS : Jason Lee (jasonl@cs.mu.oz.au)
	  Andrew Davison (ad@cs.mu.oz.au)

COMMENTS : Just dumps readable (maybe) print out of parse tree
	   Not very good, but then is just for debugging.
****************************************************************/

/* Include all the header files needed */
#include "bebop.h"
#include "y.tab.h"

/* Extern declaration */
extern const char *token_table[];

/* Dump_tree : just dumps, possibly unreadable , useless print out of tree */
void dump_tree(TREEPTR root)
{
	int op;
	VARPTR var;
	FAPTR pred;
	TLISTPTR list;

	if (root)
	{
		op = OP(root);
		if (op < 0)
		{
			dump_tree(OP1(root));
			dump_tree(OP2(root));
			return;
		}

		if (op >= TOK_CUT && op <= TOK_PIPE)
		{
			dump_tree(OP1(root));
			fprintf(stderr,"%.1s ", tok_lookup(op));
			if (op == TOK_FULLSTOP)
			{
				fprintf(stderr,"\n\n");
			}
			dump_tree(OP2(root));
			return;
		}

		if (op < TOK_START_TABLE )
		{
			if (op == TOK_VAR)
			{
				var = VART(root);
				fprintf(stderr,"%s  ", var->varname);
				dump_tree(var->value);
				return;
			}

			if (op == TOK_ATOM)
			{
				pred = PREDT(root).functor;
				fprintf(stderr,"%s", pred->faname);
				dump_tree(PREDT(root).args);
				return;
			}

			fprintf(stderr,"%s ", CONSTT(root)->constant);
			return;
		}

		if (op > TOK_START_TABLE && op < TOK_END_TABLE)
		{
			dump_tree(OP1(root));
			fprintf(stderr,"%s ", tok_lookup(op));
			dump_tree(OP2(root));
			return;
		}

		if (op == TOK_CLAUSES || op == TOK_PNU || op == TOK_NU || op == TOK_DBS)
		{
			list = LIST(root);

			while(list)
			{
				dump_tree(list->tree);
				list = list->next;
			}
			return;
		}

		dump_tree(OP1(root));
		fprintf(stderr," ");
		dump_tree(OP2(root));
		return;
	}

	return;
}
