%Copyright (C) The University of Melbourne 1993
%All Rights Reserved

%Permission to use, copy, modify, and distribute this software and
%its documentation for any purpose and without fee is hereby
%granted, provided that the above copyright notice appear in all
%copies and that both that the copyright notice and this
%permission notice and warranty disclaimer appear in supporting
%documentation, and that the name of The University of Melbourne 
%or any of its entities not be used in advertising or publicity
%pertaining to distribution of the software without specific,
%written prior permission.

%THE UNIVERSITY OF MELBOURNE DISCLAIMS ALL WARRANTIES WITH REGARD
%TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
%MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY
%OF MELBOURNE OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
%SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
%WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
%IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
%THIS SOFTWARE.

%AUTHORS : Jason Lee (jasonl@cs.mu.oz.au)
%	   Andrew Davison (ad@cs.mu.oz.au)

%   Comments :
%		Compile bebop files given. If file not found say so.

bebop(A) :-
	% check arg is ground, if not error
	(ground(A) ->
		$bebop2(A)
	 ;
		writeln(user_error,'Bebop : compile files needs ground file names, that is atoms'),
		nl(user_error),
		flushOutput(user_error)
	).

% No more files to compile
$bebop2([]) :-
	!.

%If user include suffix, remove it
$bebop2(File.bp) :-
	!,
	$bebop2(File).

$bebop2([File.bp | Fs]) :-
	!,
	$bebop2(File),
	$bebop2(Fs).

% May be prolog file, error!!
$bebop2(File.nl) :-
	!,
	write(user_error, 'Bebop : bebop file name given to compile looks like a prolog file - '),
	write(user_error, File),
	writeln(user_error, '.nl'),
	nl(user_error),
	flushOutput(user_error).

$bebop2([File.nl | Fs]) :-
	!,
	write(user_error, 'Bebop : bebop file name given to compile looks like a prolog file - '),
	write(user_error, File),
	writeln(user_error, '.nl'),
	nl(user_error),
	flushOutput(user_error),
	$bebop2(Fs).

% May be compiled prolog file, error!!
$bebop2(File.no) :-
	!,
	write(user_error, 'Bebop : bebop file name given to compile looks like a compiled prolog file - '),
	write(user_error, File),
	writeln(user_error, '.no'),
	nl(user_error),
	flushOutput(user_error).

$bebop2([File.no | Fs]) :-
	!,
	write(user_error, 'Bebop : bebop file name given to compile looks like a compiled prolog file - '),
	write(user_error, File),
	writeln(user_error, '.no'),
	nl(user_error),
	flushOutput(user_error),
	$bebop2(Fs).

% May be compiled prolog file, error!!
$bebop2(File.ns) :-
	!,
	write(user_error, 'Bebop : bebop file name given to compile looks like a compiled prolog file - '),
	write(user_error, File),
	writeln(user_error, '.ns'),
	nl(user_error),
	flushOutput(user_error).

$bebop2([File.ns | Fs]) :-
	!,
	write(user_error, 'Bebop : bebop file name given to compile looks like a compiled prolog file - '),
	write(user_error, File),
	writeln(user_error, '.ns'),
	nl(user_error),
	flushOutput(user_error),
	$bebop2(Fs).

% Not any of above, therefore filename, but may be given
% as a string so change it to an atom
$bebop2([File | Fs]) :-
	!,
	% Is it a string, eg "filename" ??
	% If so change to atom
	(atomToString(Atom, [File |Fs]) ->
		((append(_, ".nl", [File |Fs]); append(_, ".no", [File |Fs]); append(_, ".ns", [File |Fs])) ->
			write(user_error, 'Bebop : bebop file name given to compile looks like some kind of prolog file - '),
			writeln(user_error, Atom),
			nl(user_error),
			flushOutput(user_error)
		;
			$bebop2(Atom)
		)
	 ;
		$bebop2(File),
		$bebop2(Fs)
	).

% At last we have a file so compile
$bebop2(File) :-
	atomToString(File, FileName_bp),
	% Need the suffix
	(\+ append(_, ".bp", FileName_bp) ->
		append(FileName_bp, ".bp", FileName)
	 ;
		FileName = FileName_bp
	),
	(open(FileName, read, _) ->
		% assume that the compiler bebop
		% is in the users path
		append("bebop -w ", FileName, Compile),
		($bcompile(Compile, true) ->
			write('Bebop file '),
			write(FileName),
			writeln(' successfully compiled')
	 	;
			write('Bebop file '),
			write(FileName),
			writeln(' unsuccessfully compiled')
		),
		nl,
		flushOutput(user)
	 ;
		write(user_error, 'Bebop : no file called '),
		writeln(user_error, FileName),
		nl(user_error),
		flushOutput(user_error)
	).

% call system to compile the file 
% Fails if compililation failed.
$bcompile(Command, Status) :-
	system(Command, 0),
	Status = true.

