/* $Id: is.c,v 1.7 1993/05/26 21:01:57 sverker Exp $ */

#include <errno.h>
#include <string.h>
#include "include.h"
#include "term.h"
#include "tree.h"
#include "predicate.h"
#include "exstate.h"
#include "engine.h"
#include "unify.h"
#include "initial.h"
#include "storage.h"
#include "config.h"
#include "names.h"
#include <math.h>

Functor functor_add;
Functor functor_sub;
Functor functor_mul;
Functor functor_div;
Functor functor_idiv;
Functor functor_mod;
Functor functor_min;
Functor functor_max;
Functor functor_and;
Functor functor_or;
Functor functor_xor;
Functor functor_shl;
Functor functor_shr;
Functor functor_neg;
Functor functor_plus;
Functor functor_integer;
Functor functor_com;
Functor functor_float;

Functor functor_acos;
Functor functor_asin;
Functor functor_atan;
Functor functor_ceil;
Functor functor_cos;
Functor functor_cosh;
Functor functor_exp;
Functor functor_fabs;
Functor functor_floor;
Functor functor_log;
Functor functor_log10;
Functor functor_pow;
Functor functor_sin;
Functor functor_sinh;
Functor functor_sqrt;
Functor functor_tan;
Functor functor_tanh;

#define BinaryEvalCast(Name, Expr) \
void Name(tmp1, tmp2, val) \
     Term tmp1, tmp2; \
     Term *val; \
{ \
  double a, b; \
 \
  if (IsINT(tmp1) && IsINT(tmp2)) { \
    long a, b; \
    a = IntVal(Int(tmp1)); \
    b = IntVal(Int(tmp2)); \
    MakeIntegerTerm(*val, (Expr)); \
    return; \
  } \
 \
  if (IsINT(tmp1)) \
    a = (double)IntVal(Int(tmp1)); \
  else \
    a = FltVal(Flt(tmp1)); \
 \
  if (IsINT(tmp2)) \
    b = (double)IntVal(Int(tmp2)); \
  else \
    b = FltVal(Flt(tmp2)); \
   \
  MakeFloatTerm(*val, (Expr)); \
  return; \
}

#define BinaryEvalInt(Name, Expr) \
void Name(tmp1, tmp2, val) \
     Term tmp1, tmp2; \
     Term *val; \
{ \
  long a, b; \
 \
  if (IsINT(tmp1) && IsINT(tmp2)) { \
    long a, b; \
    a = IntVal(Int(tmp1)); \
    b = IntVal(Int(tmp2)); \
    MakeIntegerTerm(*val, (Expr)); \
    return; \
  } \
 \
  if (IsFLT(tmp1)) \
    a = (long)FltVal(Flt(tmp1)); \
  else \
    a = IntVal(Int(tmp1)); \
 \
  if (IsFLT(tmp2)) \
    b = (long)FltVal(Flt(tmp2)); \
  else \
    b = IntVal(Int(tmp2)); \
   \
  MakeIntegerTerm(*val, (Expr)); \
  return; \
}

#define BinaryEvalFlt(Name, Expr) \
void Name(tmp1, tmp2, val) \
     Term tmp1, tmp2; \
     Term *val; \
{ \
  double a, b; \
 \
  if (IsFLT(tmp1) && IsFLT(tmp2)) { \
    double a, b; \
    a = FltVal(Flt(tmp1)); \
    b = FltVal(Flt(tmp2)); \
    MakeFloatTerm(*val, (Expr)); \
    return; \
  } \
 \
  if (IsINT(tmp1)) \
    a = (double)IntVal(Int(tmp1)); \
  else \
    a = FltVal(Flt(tmp1)); \
 \
  if (IsINT(tmp2)) \
    b = (double)IntVal(Int(tmp2)); \
  else \
    b = FltVal(Flt(tmp2)); \
   \
  MakeFloatTerm(*val, (Expr)); \
  return; \
}

#define UnaryEvalCast(Name, Expr) \
void Name(tmp1, val) \
     Term tmp1; \
     Term *val; \
{ \
  double a; \
 \
  if (IsINT(tmp1)) { \
    long a; \
    a = IntVal(Int(tmp1)); \
    MakeIntegerTerm(*val, (Expr)); \
    return; \
  } \
 \
  a = FltVal(Flt(tmp1)); \
  MakeFloatTerm(*val, (Expr)); \
  return; \
}

#define UnaryEvalInt(Name, Expr) \
void Name(tmp1, val) \
     Term tmp1; \
     Term *val; \
{ \
  long a; \
 \
  if (IsFLT(tmp1)) \
    a = (long)FltVal(Flt(tmp1)); \
  else \
    a = IntVal(Int(tmp1)); \
   \
  MakeIntegerTerm(*val, (Expr)); \
  return; \
}

#define UnaryEvalFlt(Name, Expr) \
void Name(tmp1, val) \
     Term tmp1; \
     Term *val; \
{ \
  double a; \
 \
  if (IsINT(tmp1)) \
    a = (double)IntVal(Int(tmp1)); \
  else \
    a = FltVal(Flt(tmp1)); \
   \
  MakeFloatTerm(*val, (Expr)); \
  return; \
}

#define BinaryEvalTest(Name, Test) \
bool Name(Arg) \
	Argdecl;\
{ \
  Term res, tmp1, tmp2;\
  double a, b; \
 \
  res = akl_eval(A(0), exs, &tmp1);\
  if (res != TRUE)\
    return res;\
  res = akl_eval(A(1), exs, &tmp2);\
  if (res != TRUE)\
    return res;\
 \
  if (IsINT(tmp1) && IsINT(tmp2)) { \
    long a, b; \
    a = IntVal(Int(tmp1)); \
    b = IntVal(Int(tmp2)); \
    if(Test) return TRUE; \
    else return FALSE; \
  } \
 \
  if (IsINT(tmp1)) \
    a = (double)IntVal(Int(tmp1)); \
  else \
    a = FltVal(Flt(tmp1)); \
 \
  if (IsINT(tmp2)) \
    b = (double)IntVal(Int(tmp2)); \
  else \
    b = FltVal(Flt(tmp2)); \
   \
  if(Test) return TRUE; \
  else return FALSE; \
}

BinaryEvalCast(eval_add, a+b)
BinaryEvalCast(eval_sub, a-b)
BinaryEvalCast(eval_mul, a*b)
BinaryEvalFlt(eval_div, a/b)     

BinaryEvalInt(eval_idiv, a/b)
BinaryEvalInt(eval_mod, a%b)
BinaryEvalInt(eval_min, (a < b) ? a : b)
BinaryEvalInt(eval_max, (a > b) ? a : b)
BinaryEvalInt(eval_and, a&b)
BinaryEvalInt(eval_or, a|b)
BinaryEvalInt(eval_xor, a^b)
BinaryEvalInt(eval_shl, a<<b)
BinaryEvalInt(eval_shr, a>>b)

BinaryEvalFlt(eval_pow, pow(a,b))

UnaryEvalCast(eval_neg, -a)
UnaryEvalCast(eval_plus, a)

UnaryEvalInt(eval_integer, a)
UnaryEvalInt(eval_com, ~a)

UnaryEvalFlt(eval_float, a)
UnaryEvalFlt(eval_acos, acos(a))
UnaryEvalFlt(eval_asin, asin(a))
UnaryEvalFlt(eval_atan, atan(a))
UnaryEvalFlt(eval_ceil, ceil(a))
UnaryEvalFlt(eval_cos, cos(a))
UnaryEvalFlt(eval_cosh, cosh(a))
UnaryEvalFlt(eval_exp, exp(a))
UnaryEvalFlt(eval_fabs, fabs(a))
UnaryEvalFlt(eval_floor, floor(a))
UnaryEvalFlt(eval_log, log(a))
UnaryEvalFlt(eval_log10, log10(a))
UnaryEvalFlt(eval_sin, sin(a))
UnaryEvalFlt(eval_sinh, sinh(a))
UnaryEvalFlt(eval_sqrt, sqrt(a))
UnaryEvalFlt(eval_tan, tan(a))
UnaryEvalFlt(eval_tanh, tanh(a))

#define BinaryEvalCase(Functor, Name) \
  if (op == Functor) { \
    Name(tmp1, tmp2, val); \
    return TRUE; \
  }

#define UnaryEvalCase(Functor, Name) \
  if (op == Functor) { \
    Name(tmp1, val); \
    return TRUE; \
  }

bool akl_eval(expr0, exs, val)
     Term expr0;
     exstate *exs;
     Term *val;
{
  Term expr, arg1, arg2, tmp1, tmp2;
  bool res;
  Functor op;
  int arity;

  Deref(expr, expr0);
  IfVarSuspend(expr);

  if (IsINT(expr) || IsFLT(expr)) {
    *val = expr;
    return TRUE;
  }

  if (!(IsSTR(expr)))
    return FALSE;

  op = StrFunctor(Str(expr));
  arity = StrArity(Str(expr));

  if (arity == 2) {
    GetStrArg(arg1, Str(expr), 0);
    GetStrArg(arg2, Str(expr), 1);
    res = akl_eval(arg1, exs, &tmp1);
    if (res != TRUE)
      return res;
    res = akl_eval(arg2, exs, &tmp2);
    if (res != TRUE)
      return res;

    BinaryEvalCase(functor_add, eval_add);
    BinaryEvalCase(functor_sub, eval_sub)
    BinaryEvalCase(functor_mul, eval_mul)
    BinaryEvalCase(functor_div, eval_div)
    BinaryEvalCase(functor_idiv, eval_idiv)
    BinaryEvalCase(functor_mod, eval_mod)
    BinaryEvalCase(functor_min, eval_min)
    BinaryEvalCase(functor_max, eval_max)
    BinaryEvalCase(functor_and, eval_and)
    BinaryEvalCase(functor_or, eval_or)
    BinaryEvalCase(functor_xor, eval_xor)
    BinaryEvalCase(functor_shl, eval_shl)
    BinaryEvalCase(functor_shr, eval_shr)
    BinaryEvalCase(functor_pow, eval_pow)

  }
  else if (arity == 1) {
    GetStrArg(arg1, Str(expr), 0);
    res = akl_eval(arg1, exs, &tmp1);
    if (res != TRUE)
      return res;

    UnaryEvalCase(functor_neg, eval_neg)
    UnaryEvalCase(functor_plus, eval_plus)
    UnaryEvalCase(functor_integer, eval_integer)
    UnaryEvalCase(functor_com, eval_com)
    UnaryEvalCase(functor_float, eval_float)
    UnaryEvalCase(functor_acos, eval_acos)
    UnaryEvalCase(functor_asin, eval_asin)
    UnaryEvalCase(functor_atan, eval_atan)
    UnaryEvalCase(functor_ceil, eval_ceil)
    UnaryEvalCase(functor_cos, eval_cos)
    UnaryEvalCase(functor_cosh, eval_cosh)
    UnaryEvalCase(functor_exp, eval_exp)
    UnaryEvalCase(functor_fabs, eval_fabs)
    UnaryEvalCase(functor_floor, eval_floor)
    UnaryEvalCase(functor_log, eval_log)
    UnaryEvalCase(functor_log10, eval_log10)
    UnaryEvalCase(functor_sin, eval_sin)
    UnaryEvalCase(functor_sinh, eval_sinh)
    UnaryEvalCase(functor_sqrt, eval_sqrt)
    UnaryEvalCase(functor_tan, eval_tan)
    UnaryEvalCase(functor_tanh, eval_tanh)
  }

  return FALSE;
}

BinaryEvalTest(akl_eval_equal, a==b)
BinaryEvalTest(akl_eval_not_equal, a!=b)
BinaryEvalTest(akl_eval_less, a<b)
BinaryEvalTest(akl_eval_greater, a>b)
BinaryEvalTest(akl_eval_less_equal, a<=b)
BinaryEvalTest(akl_eval_greater_equal, a>=b)
     
bool akl_is(Arg)
     Argdecl;
{
  register Term X0;
  bool res;
  Term val;

  res = akl_eval(A(1), exs, &val);

  if (res == TRUE) {
    Deref(X0, A(0));
    return unify(X0, val, exs->andb, exs);
  }
  else
    return res;
}


void initialize_is() {

  functor_add = store_functor(store_atom("+"),2);
  functor_sub = store_functor(store_atom("-"),2);
  functor_mul = store_functor(store_atom("*"),2);
  functor_div = store_functor(store_atom("/"),2);
  functor_idiv = store_functor(store_atom("//"),2);
  functor_mod = store_functor(store_atom("mod"),2);
  functor_min = store_functor(store_atom("min"),2);
  functor_max = store_functor(store_atom("max"),2);
  functor_and = store_functor(store_atom("/\\"),2);
  functor_or = store_functor(store_atom("\\/"),2);
  functor_xor = store_functor(store_atom("#"),2);
  functor_shl = store_functor(store_atom("<<"),2);
  functor_shr = store_functor(store_atom(">>"),2);
  functor_neg = store_functor(store_atom("-"),1);
  functor_plus = store_functor(store_atom("+"),1);
  functor_integer = store_functor(store_atom("integer"),1);
  functor_com = store_functor(store_atom("\\"),1);
  functor_float = store_functor(store_atom("float"),1);

  functor_acos = store_functor(store_atom("acos"),1);
  functor_asin = store_functor(store_atom("asin"),1);
  functor_atan = store_functor(store_atom("atan"),1);
  functor_ceil = store_functor(store_atom("ceil"),1);
  functor_cos = store_functor(store_atom("cos"),1);
  functor_cosh = store_functor(store_atom("cosh"),1);
  functor_exp = store_functor(store_atom("exp"),1);
  functor_fabs = store_functor(store_atom("fabs"),1);
  functor_floor = store_functor(store_atom("floor"),1);
  functor_log = store_functor(store_atom("log"),1);
  functor_log10 = store_functor(store_atom("log10"),1);
  functor_pow = store_functor(store_atom("pow"),2);
  functor_sin = store_functor(store_atom("sin"),1);
  functor_sinh = store_functor(store_atom("sinh"),1);
  functor_sqrt = store_functor(store_atom("sqrt"),1);
  functor_tan = store_functor(store_atom("tan"),1);
  functor_tanh = store_functor(store_atom("tanh"),1);

  define("is", akl_is, 2);

  define("=:=", akl_eval_equal, 2);
  define("=\\=", akl_eval_not_equal, 2);
  define("<", akl_eval_less, 2);
  define(">", akl_eval_greater, 2);
  define("=<", akl_eval_less_equal, 2);
  define(">=", akl_eval_greater_equal, 2);
}
