extern char *malloc(), *realloc();

# line 2 "yacc.y"
#include <stdio.h>
#include <setjmp.h>
#include <signal.h>
#include "tag.h"
#include "structs.h"
#define  	YYMAXDEPTH	300
#define		PNULL		-1
#define		BOTTOM		-2
#define		MAXNOID		100
/*
#define		NUMOFCELL	50000
*/
#define		MAXAUXEQN	100
#define 	MAXIFLEVEL	16
#define		FNTABSIZE	100
#define		MAXEQNSINEXP	25
#define		NUMOFFILES	10
/*
#define		WRSTKLN		10000
#define		RDSTKLN		10000
*/
#define		MAXNUMCONSULT	10
/*macros for accessing the field in a particular heapcell */
#define		heap_tag(i)	heap[i].tag
#define		heap_lptr(i)	heap[i].lfld.lptr
#define		heap_name(i)	heap[i].lfld.name
#define		heap_numb(i)	heap[i].lfld.numdata
#define		heap_offs(i)	heap[i].lfld.var_offset
#define		heap_rptr(i)	heap[i].rptr
#define		heap_auxv(i)	heap[i].auxval
#define		heap_eqnt(i)	heap[i].eqntype
#define		heap_next(i)	heap[i].next_free_cell

extern FILE *yyin; 
extern char yytext[];
extern int line;
extern int yyleng;
extern int functor_count;
extern char *functor_array[];
extern short int bracket_count;
extern short int list_read_flag;
char *openfilename;

int	NUMOFCELL     = 50000;
int	WRSTKLN	      = 10000;
int	RDSTKLN	      = 10000;
int	FSTKSIZE      = 25000;
int	TRAILSTKSIZE  = 30000;
int	VARSTKSIZE    = 60000;
int	SOPSTKSIZE    = 10000;


/*
struct heapcell 	heap[NUMOFCELL];
struct readst		*read_stack[RDSTKLN];
struct writest_cell 	write_stack[WRSTKLN];
*/

struct heapcell 	*heap;
varstkptrtype           *trailstk;
                             /*trailstk stores pointers to var cell whose*/
                             /* bindings are to be undone on backtracking*/
struct frame_stk_cell   *fstk;
struct var_stk_cell     *varstk;
struct sop_stack_cell 	*sopstk;
struct readst  		**read_stack;
struct writest_cell 	*write_stack;
					/*In the type field of the write-stack*/
					/*PFALSE is for num & PTRUE for string*/
int			readst_top, writest_top, read_ptr;
struct {char *fname;
	short int cflag;	/*PTRUE for reconsult; PFALSE for consult*/
	short int line;
	FILE *fptr;
	short int time;
       }		consult_array[MAXNUMCONSULT];
int			consult_ptr;
struct file_struct	files[NUMOFFILES];
int			fileindex;
struct fn_hash_cell 	*fn_hash_table[FNTABSIZE];
cellptrtype 		*tempeqn;
cellptrtype		flattened_in_exp[MAXEQNSINEXP];	
			    /*used to  handle  flattened eqns of*/
			    /*exp in the f(..) => exp where eqns*/
	/*tempeqnstk is used as a stack to handle the "if" in the manner*/
	/*described in the file if.handle. The routines  push_tempeqnstk*/
	/*and pop_tempeqnstk manipulate this structure.			*/
struct tempeqnstk_cell 	tempeqnstk[MAXIFLEVEL];
short  int		top_tempeqnstk = 0; 	/*stk-ptr for tempeqnstk*/
int			curr_temp_eqn_slot = 0; /*tempeqn's index*/
int			curr_temp_exp_slot = 0; /*flattened_in_exp's index*/
int			num_of_eqns  = 0; 	/*record no. of equations*/
char			*tempvartab[MAXNOID];
int			var_tab_ptr; 		/*keep track of no. of vars*/
						/*in the function*/
int			num_of_formals = 0; 	/*keep track of # of formals*/
int			num_of_actuals ; 	/*keep track of # of actuals*/
int			numgoals = 0;	    /*keep track of # of goals solved*/
int			report_last_var;    /*1 if query is functional else 0*/
cellptrtype		x, i, j, k, l, insert_pt, exec_code, rcode, endlist;
				/*rcode is used to pass the structure*/
				/*constructed by yyparse to the read */
				/*list routine. The list-read routine*/
				/*checks if the structure constructed*/
				/*is a list and nothing else.	     */
int			m, n; 
char			*s, *str;
struct molecule		*next_mol;	    /*Pointer to next free molecule*/
short int		isempty_file;	    /*for empty input file*/
short int		yyprs_begin ;	    /*to identify first call to yylex*/
short int 		timestamp = 0;      /*used for reconsulting*/
short int 		currstamp;          /*used for reconsulting*/
short int 		reconsult_flag;     /* --- do ------*/
short int 		isreconsult;        /* --- do ------*/
struct spycell		*spyptr ;
int			spyframe;
short int		spyflag;
short int		err_flag = PFALSE;
short int		execOVER;	     /*used for user interrupts*/
jmp_buf		 	initbuff, execbuff, parserrbuff;

#include "memman.h"
#include "init.h"
#include "inframe.h"

# line 127 "yacc.y"
typedef union  {
	char *string;
	int  intval;
        } YYSTYPE;
# define TOR 257
# define TAND 258
# define TNOT 259
# define TLESSP 260
# define TGREATERP 261
# define TNUMBERP 262
# define TLISTP 263
# define TGREATEREQ 264
# define TLESSEQ 265
# define TPLUS 266
# define TMINUS 267
# define TMUL 268
# define TDIVIDE 269
# define TMOD 270
# define TDIV 271
# define TABS 272
# define TEQ 273
# define TNULL 274
# define TATOM 275
# define TBOOL 276
# define TISVAR 277
# define TCPUTIME 278
# define TSHOWTIME 279
# define TREAD 280
# define TREADB 281
# define TWRITE 282
# define TWRITEB 283
# define TCONSTRUCTOR 284
# define TCONSULT 285
# define TRECONSULT 286
# define TSAVE 287
# define TTRACE 288
# define TIF 289
# define TELSE 290
# define TTHEN 291
# define TWHERE 292
# define TTRUE 293
# define TFALSE 294
# define TCONS 295
# define TCAR 296
# define TCDR 297
# define TLINE 298
# define TCHAR 299
# define TINT 300
# define TLIST 301
# define TLBRACK 302
# define TRBRACK 303
# define TBELONG 304
# define TLPAR 305
# define TRPAR 306
# define TLBRACE 307
# define TRBRACE 308
# define TQMARK 309
# define TDEF 310
# define TCOMMA 311
# define TSEMCOL 312
# define TEQUAL 313
# define TPERIOD 314
# define TBAR 315
# define TCOLON 316
# define TID 317
# define TNATOM 318
# define TNUM 319
# define TFUNCTORNM 320
# define TSTRING 321
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 1176 "yacc.y"


/*programs section */

bus_error()
{
	signal(SIGBUS, bus_error);
	printf("Bus Error : abort : No core image produced\n");
	longjmp(execbuff, 0);
}

seg_violation()
{
	signal(SIGSEGV, seg_violation);
	printf("Segmentation Fault : abort : No core image produced\n");
	longjmp(execbuff, 0);
}

onintr()		/*interrupt handler*/
{
char *request; short int over;
	signal(SIGINT, onintr);		/*reset for next interrupt*/
	request = (char *) malloc (20);
	over = PFALSE;
	while (over == PFALSE)
	  {
	   printf("What now? (type h for help): ");
	   scanf(" %s", request);
	   (void) getchar();		/*eat the carriage return*/
	   if (!strcmp(request, "h") || !strcmp(request, "he") || 
	       !strcmp(request, "hel") || !strcmp(request, "help"))
	       {
		printf("\ntype a for abort\n");
		printf("type c for continue\n");
		printf("type t for trace\n");
		printf("type u for untrace\n");
		printf("type r for reset\n");
		printf("type e for erase constructors\n");
		printf("\n\n");
	       }
	   else
	       if (!strcmp(request, "a") || !strcmp(request, "ab") ||
                   !strcmp(request, "abo") || !strcmp(request, "abor") ||
	           !strcmp(request, "abort"))
		 {
		  printf("\n[ query execution aborted ]\n");
		  over = PTRUE;
		  if (execOVER == PTRUE)
			longjmp(execbuff, 0);
		  else 
			longjmp(initbuff, 0);
		 }
	       else
	       if (!strcmp(request, "t") || !strcmp(request, "tr") ||
                   !strcmp(request, "tra") || !strcmp(request, "trac") ||
	           !strcmp(request, "trace"))
		   {
			debug = PTRUE;
		        over = PTRUE; 
			/*printf("eql> ");
			fflush(stdout);*/
		   }
	       else
	       if (!strcmp(request, "r") || !strcmp(request, "re") ||
                   !strcmp(request, "res") || !strcmp(request, "rese") ||
	           !strcmp(request, "reset"))
			{int jj;
			 execOVER = PFALSE;
			 for(jj = 0; jj < functor_count; jj++)
				 free(functor_array[jj]);
			 functor_count = 0;
			 printf("\neql> ");
			 longjmp(initbuff, 0);
		         over = PTRUE; 
			}
	       else
	       if (!strcmp(request, "c") || !strcmp(request, "co") ||
		   !strcmp(request, "con") || !strcmp(request, "cont") ||
		   !strcmp(request, "conti") || !strcmp(request, "contin") ||
		   !strcmp(request, "continu") || !strcmp(request, "continue"))
		      {
		        over = PTRUE; 
		        /*printf("eql> ");
			fflush(stdout);*/
		      }
	       else 
	       if (!strcmp(request, "u") || !strcmp(request, "un") ||
		   !strcmp(request, "unt") || !strcmp(request, "untr") ||
		   !strcmp(request, "untra") || !strcmp(request, "untrac") ||
		   !strcmp(request, "untrace")) 
			{ over = PTRUE;
			  debug = PFALSE;
			}
	       else 
	       if (!strcmp(request, "e") || !strcmp(request, "er") ||
		   !strcmp(request, "era") || !strcmp(request, "eras") ||
		   !strcmp(request, "erase")) 
			{ int jj;
			  over = PTRUE;
			  printf("\neql> ");
			  fflush(stdout);
			  for(jj = 0; jj < functor_count; jj++)
				 free(functor_array[jj]);
			  functor_count = 0;
			}
	       else 
		   printf("Unknown Option\n");	
	   };
}

main(argc,argv)
int argc;
char *argv[];

{
int i, k, tmp_index, l_bound = 0, u_bound = 0;
FILE *fopen();
	printf("EqL Version 1.0\n\n");
	execOVER = PFALSE;
	consult_ptr = 0;
	tempeqn = (cellptrtype *) calloc(MAXAUXEQN, sizeof(cellptrtype));
	consult_array[consult_ptr].fname = "standard input"; 
	consult_array[consult_ptr].fptr = stdin;
	consult_array[consult_ptr].line = 0;
	consult_array[consult_ptr].time = timestamp++;
	consult_array[consult_ptr++].cflag = PFALSE;
	report_last_var = PNULL;
	tmp_index = 1;
	while (tmp_index < argc)
	  if (argv[tmp_index][0] == '-')
	     switch (argv[tmp_index][1])
	      {
	       case 'h'   :
		  NUMOFCELL = atoi(argv[++tmp_index]);
		  ++tmp_index;
		  break;
	       case 't'	  :
		  TRAILSTKSIZE = atoi(argv[++tmp_index]) + 500; 
		  ++tmp_index;
                  break; 
	       case 'v'	  :
		  VARSTKSIZE = atoi(argv[++tmp_index]) + 500;  
		  ++tmp_index;
                  break;  
	       case 'c'   :
		  FSTKSIZE = atoi(argv[++tmp_index]);  
		  ++tmp_index;
                  break;  
	       case 'w'   :
		  WRSTKLN = atoi(argv[++tmp_index]);  
		  ++tmp_index;
                  break;  
	       case 'r'   :
		  RDSTKLN = atoi(argv[++tmp_index]);  
		  ++tmp_index;
                  break;  
	       case 'e'    :
		  SOPSTKSIZE = atoi(argv[++tmp_index]) + 125;  
		  ++tmp_index;
                  break;  
	       case 'f'    :
		  l_bound = tmp_index++;
		  while ((tmp_index < argc) && (argv[tmp_index][0] != '-')) 
			++tmp_index;
		  u_bound = tmp_index - 1;
		  break;
	       default     :
		  printf("illegal option %s to eql : abort\n", argv[tmp_index]);
		  exit(-1);
		  break;
	      }
	  else {printf("Usage: eql [-erwlvth #] [-f file_1 .. file_n]\n"); 
		exit(-1);};
	heap = (struct heapcell *) calloc(NUMOFCELL, sizeof(struct heapcell));
	freep = (int *) calloc(NUMOFCELL, sizeof(int));
	read_stack = (struct readst **) 
				calloc(RDSTKLN, sizeof(struct readst *));
	write_stack = (struct writest_cell *)
				calloc(WRSTKLN, sizeof(struct writest_cell));
	trailstk = (varstkptrtype *) 
				calloc(TRAILSTKSIZE, sizeof(varstkptrtype));
  	fstk = (struct frame_stk_cell *)
			        calloc(FSTKSIZE, sizeof(struct frame_stk_cell));
	varstk = (struct var_stk_cell *)
				calloc(VARSTKSIZE, sizeof(struct var_stk_cell));
 	sopstk = (struct sop_stack_cell *)
			calloc(SOPSTKSIZE, sizeof(struct sop_stack_cell));
	for(i = u_bound; i > l_bound; i--)
	     {  openfilename = argv[i];
		if ((yyin = fopen(argv[i],"r")) == NULL) 
	   		printf("cannot open file: %s\n", argv[i]);
		else 
		     { consult_array[consult_ptr].fname = argv[i];
		       consult_array[consult_ptr].fptr = yyin;
		       consult_array[consult_ptr].line = 0;
		       consult_array[consult_ptr].time = timestamp++;
		       consult_array[consult_ptr++].cflag = PFALSE;
		     };	
	     };
	if (l_bound == 0)		/*no files in the command line*/
		printf("eql> ");
	setjmp(initbuff);
	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, onintr);
			/*keep ignoring  signal  if  they are already*/
			/*being ignored (process being run in backgd)*/
			/*NOT so for segsegv, sigbus; always catch'em*/
	signal(SIGSEGV, seg_violation);
	signal(SIGBUS, bus_error);
	initialize();
	setjmp(execbuff);
	setjmp(parserrbuff);
      while(PTRUE)
       {
	while (consult_ptr > 0) 
	   { k = consult_ptr - 1;
	     yyin = consult_array[k].fptr;
	     openfilename = consult_array[k].fname;
	     line = consult_array[k].line;
	     currstamp = consult_array[k].time;
	     isreconsult = consult_array[k].cflag;
	     if (isempty_file == PTRUE)
	       {
		     isempty_file = PFALSE;
		     /*if (k > 0)
		          printf("\b\b\b\b\b\bFile: %s consulted\n", 
						consult_array[k].fname);*/
		     consult_ptr--;
		     if (consult_ptr == 1)	/*stdin*/
			printf("eql> ");
	       }
	     else 
		{ yyprs_begin = PTRUE;
		  yyparse();
		  if (err_flag != PTRUE)
		   {
		    consult_array[k].line = line;
		    if (report_last_var >= 0)
                         execute(exec_code, var_tab_ptr, 
					tempvartab, report_last_var);
		   };
		    execOVER = PTRUE;
		    setjmp(execbuff);
                  	/* var_tab_ptr tells the # of cells needed for vars*/
		  	/* tempvartab  stores the names  of the  vars whose*/
		  	/* values are  reported after the execution is over*/
		    for(j = 0; j < var_tab_ptr; j++)
                	free(tempvartab[j]);
                    var_tab_ptr = 0;
		    report_last_var = PNULL;
		  err_flag = PFALSE;
	          if (isempty_file != PTRUE)
		      if (yyin == stdin) 
		        if (consult_ptr == 1)
		    	   printf("eql> ");
			else if (consult_array[consult_ptr - 1].fptr == stdin)
				     printf("| ");
		};
 	   };
       if (feof(stdin) != 0)		/*eof seen in stdin*/
		{printf("  \n[ EqL execution halted ]\n\n");
                        return;}
       else {consult_ptr = 1; printf("eql> ");};
      };
}


yyerror(s)
char *s;

{
	printf("Syntax error near token \"%s\"" , yytext);
	if (yyin != stdin) 
		printf("in line: %d in file: %s", line + 1, openfilename);
	printf("\n");
	isempty_file = PFALSE;
		/*This is needed because sometimes*/
		/*on an error the yacc may reduce */
		/*by the epsilon rule and that may*/
		/*cause isempty_file to become set*/
		/*which causes interpreter to halt*/
	err_flag = PTRUE;
}


free_fn_cell(q)
struct fn_hash_cell *q;

{ free(q);
}

/*delete_old_fns takes a position in function index table*/
/*a function name and num of formals and deletes all the */
/*functions with identical names and number of arguments */
/*and whose timestamps is less than currstamp		 */
delete_old_fns(fn_tab_index, fn_name, numofargs)
int fn_tab_index;
char *fn_name;
int numofargs;

{ struct fn_hash_cell *p, *q, *head;
  short int nomore;
        q = fn_hash_table[fn_tab_index];
	p = head = (struct fn_hash_cell *) 
				calloc(1, sizeof(struct fn_hash_cell));
						/*head is a dummy header*/
	head->next_candidate = q;
	nomore = PTRUE;
	while ((q != NULL) && (nomore == PTRUE))
	   if ((!strcmp(q->funcname, fn_name)) &&
		 (q->num_of_args == numofargs) &&
		    (q->timestamp < currstamp))		/*if old defn.*/
		{ p->next_candidate = q->next_candidate;
		  free_fn_cell(q);
		  if (q->lastdef == 1) 
			nomore = PFALSE;     /*last defn. found, stop search*/
		  q = p->next_candidate;
	        }
	   else { p = q;
		  q = q->next_candidate;
		};
	fn_hash_table[fn_tab_index] = head->next_candidate;
	free(head);
}
		  
		    
	  
  

insert_fn_in_hash_tab(argptr, bodyptr, nameptr, numofargs, numofvars)
cellptrtype argptr, bodyptr;
char *nameptr;
int 	    numofargs, numofvars;

{
    struct fn_hash_cell *j, *p;
    int k, notokay;

	k = hashf(nameptr);
	if (isreconsult == PTRUE) 
		delete_old_fns(k, nameptr, numofargs);
	j = fn_hash_table[k];
		/* create a fn_hash_cell pointed to by p and */
		/* then insert in the  function hash table     */
	p = (struct fn_hash_cell *) calloc(1, sizeof(struct fn_hash_cell));
	p->funcname = nameptr;
	p->num_of_args = numofargs;
	p->num_of_vars = numofvars;
	p->fn_body = bodyptr;
	p->fn_args_ptr = argptr;
	p->lastdef = 1;
	p->timestamp = currstamp;
	/*disp_func(p);*/
	if (j == NULL)		/* no fn-entry in that bucket */
		{ fn_hash_table[k] = p;
		  p->next_candidate = NULL;
		}
	   else
		  /* there is a fn. in the bucket */
		{ notokay = 1;
		  while((notokay == 1) && (j->next_candidate != NULL))
			    /* both conditions can't be false simultaneously*/
			{ if ((!strcmp(j->funcname, nameptr)) && 
			      (j->num_of_args == numofargs) &&
			      ((j->next_candidate->num_of_args != numofargs) ||
			      (strcmp(j->next_candidate->funcname, nameptr))))
					/*if we are at the point where j holds*/
					/*a fn with identical name and arity &*/
					/* j->next doesn't then  we are at the*/
					/*last entry for this fn in the bucket*/
			     	notokay = 0;
			  else
				j = j->next_candidate;
			}
		  if (notokay == 0)
			{ 	/*we are at the last def. of this fn.*/
				/*so insert the current fn. at this pt.*/
			  j->lastdef = 0;
		  	  p->next_candidate = j->next_candidate;
		  	  j->next_candidate = p;
			}
		  else
			{	/*we are at the end of the list*/
			  if ((!strcmp(j->funcname, nameptr)) && 
					(j->num_of_args == numofargs))
				j->lastdef = 0;
			  p->next_candidate = j->next_candidate;
			  j->next_candidate = p;
			}
			 
		}
}

insert_and_sort_eqns(bodyptr)
cellptrtype bodyptr;
	{ 
	  insert_eqns(bodyptr);
	  sort_eqns(bodyptr);
	}


insert_eqns(bodyptr)
cellptrtype bodyptr;
{ cellptrtype p, q, r;
  int i, count;
  p = bodyptr;
         /* p points to the cell pointing to the list of equations now */
  r = heap[p].rptr;
	 /* save the pointer to the list of equations in the body in r. */
	 /* Add all the equations in tempeqn in the begining of the */
	 /* current equation list.				    */
  for(i=0; i < curr_temp_eqn_slot; i++)
 	{ q = node(GEQNODE, tempeqn[i], PNULL, heap[tempeqn[i]].auxval,
					       heap[tempeqn[i]].eqntype);
	  heap[p].rptr = q;
	  p = q;
	}
		/* The for loop above does the insertion.*/
		/* Now add the equations pointed to by r */
		/* at the end. p points to the last inserted equation.*/
  heap[p].rptr = r;
}

/*insert_eqns_of_exp  is used  for inserting the flattened*/
/*equations arising out of EXP in f(...) => EXP where EQNS*/

insert_eqns_of_exp(bodyptr)
cellptrtype bodyptr;
{ cellptrtype p, q, r;
  int i, count;
  p = bodyptr;
         /* p points to the cell pointing to the list of equations now */
  r = heap[p].rptr;
	 /* save the pointer to the list of equations in the body in r. */
	 /* Add all the equations in  flattened_in_exp in  the begining */
	 /* of the current equation list.				*/
  for(i=0; i < curr_temp_exp_slot; i++)
 	{ q = node(GEQNODE, flattened_in_exp[i], PNULL, 
			heap[flattened_in_exp[i]].auxval,
					   heap[flattened_in_exp[i]].eqntype);
	  heap[p].rptr = q;
	  p = q;
	}
		/* The for loop above does the insertion.*/
		/* Now add the equations pointed to by r */
		/* at the end. p points to the last inserted equation.*/
  heap[p].rptr = r;
}
sort_eqns(bodyptr)
cellptrtype bodyptr;
/* Now the list of equations has to be sorted.*/
/* The priority value is the sort key.	    */
{ cellptrtype p, q, r;
  int i, count;
	p = bodyptr;
	q = heap[p].rptr;
	if (q == PNULL) return;
	/* No equations so return*/
	r = heap[q].rptr;
	if (r == PNULL) return;
	/*only one equation so no need to sort*/
	count = -1;
	 	/*count = -1 to enter the while loop */
		/*using bubble sort to do the sorting */
	while (count != 0) 
 	   { count = 0;
	     while (r != PNULL)
		{ if (heap[q].auxval > heap[r].auxval)
		      { heap[p].rptr = r;
			heap[q].rptr = heap[r].rptr;
			heap[r].rptr = q;
			++count;
		      }
		   p = heap[p].rptr;
		   q = heap[p].rptr;
		   r = heap[q].rptr;
		 };
	     p = bodyptr;
	     q = heap[p].rptr;
             r = heap[q].rptr;
	    }
}		 

/*flatten is used to convert an expression into an equation	*/
/*It takes a pointer to an expression and creates an equation	*/
/* creating a new variable name. A cell containing the offset	*/
/*of the variable introduced is returned.			*/

cellptrtype flatten(p)
cellptrtype p;
	{ cellptrtype i;
	  if ((heap_tag(p) == GNUM) || (heap_tag(p) == GID) ||
	      (heap_tag(p) == GNATOM) || (heap_tag(p) == GTRUE) ||
	      (heap_tag(p) == GFALSE) || (heap_tag(p) == GCONS)) 
			return(p);
	  i = nodegid(GID, var_tab_ptr, PNULL, PNULL, 0);
	  tempvartab[var_tab_ptr] = "";
	  ++var_tab_ptr;
	  tempeqn[curr_temp_eqn_slot] = node(GEQN, i, p, calc_eqn_prio(i,p),
							 find_eqn_type(i,p));
	  curr_temp_eqn_slot++;
	  return(i);
	}


cellptrtype
node(tag, p1, p2, v1, v2)
short int tag;
cellptrtype p1, p2;
short int v2;
int v1;

	{ cellptrtype i;
	  i = getfreecell(heap);
	  heap[i].tag = tag;
	  heap[i].lfld.lptr = p1;
	  heap[i].rptr = p2;
	  heap[i].eqntype = v2;
	  heap[i].auxval = v1;
	  return(i);

	}
 
cellptrtype
nodegid(tag, offset, p, v1, v2)
short int tag;
short int offset;
cellptrtype p;
short int v2;
int v1;

	{ cellptrtype i;
          i = getfreecell(heap);
          heap[i].tag = tag;
          heap[i].lfld.var_offset = offset;
          heap[i].rptr = p;
          heap[i].eqntype = v2;
	  heap[i].auxval = v1;
	  return(i);
	}

cellptrtype
nodenum(tag, value, p, v1, v2)
short int tag;
int value;
cellptrtype p;
int v1;
short int v2;
        { cellptrtype i;
          i = getfreecell(heap);
          heap[i].tag = tag;
          heap[i].lfld.numdata = value;
          heap[i].rptr = p; 
          heap[i].eqntype = v2; 
          heap[i].auxval = v1;
	  return(i);
	}

int var_search(p)
char *p;

{	int i;
	if (list_read_flag == PTRUE) 
		{printf("variables illegal in input list: abort\n");
		 longjmp(execbuff, 0);
		 return;
		};
	if (p[0] == '_')
	   {i = var_tab_ptr++;
	    tempvartab[i] = "";
	    return(i);
	   }
	else
	   {for(i=0; i < var_tab_ptr; i++)
		if (!strcmp(p, tempvartab[i]))
			return(i);
	    ++var_tab_ptr;
	    tempvartab[i] = (char *) calloc(strlen(p) + 1, sizeof(char));
	    strcpy(tempvartab[i], p);
	    return(i);
	   };
}

int var_look(p)
char *p;

{	int i;
	for(i=0; i < var_tab_ptr; i++)
		if (!strcmp(p, tempvartab[i]))
			return(i);
	return(PNULL);
}


/*------------------------------------------------------*/
/* hash : adds up the character values in the string	*/
/* 	  and forms the remainder modulo the array size	*/
/* Provided by bj.					*/
/*------------------------------------------------------*/
int hashf(s)
char *s;
{
	int hashval;

	for (hashval = 0; *s != '\0'; )
	     hashval += *s++;

	return (hashval % FNTABSIZE);
	}

/*The routine push_tempeqnstk pushes the current tempeqn and */
/*the curr_temp_eqn_slot into the stack and reallocates space */
/*to tempeqn and sets curr_temp_eqn_slot to 0. 			*/

push_tempeqnstk()
	{
	 tempeqnstk[top_tempeqnstk].tempeqn = tempeqn;
	 tempeqnstk[top_tempeqnstk].curr_temp_eqn_slot = curr_temp_eqn_slot;
	 tempeqn = (cellptrtype *) calloc(MAXAUXEQN, sizeof(cellptrtype));
	 curr_temp_eqn_slot = 0;
	 top_tempeqnstk++;
	 if (top_tempeqnstk > 16)
		{
		 printf("If can be nested only 16 levels\n");
		 longjmp(parserrbuff, 0);
		};
	}

/*pop_tempeqnstk is inverse of push_tempeqnstk */
pop_tempeqnstk()
	{
	 free(tempeqn);
	 --top_tempeqnstk;
	 if (top_tempeqnstk < 0) 
			{
			 printf("IF equation-stack out of order: panic\n");
			 longjmp(parserrbuff, 0);
			};
	 tempeqn = tempeqnstk[top_tempeqnstk].tempeqn;
	 curr_temp_eqn_slot = tempeqnstk[top_tempeqnstk].curr_temp_eqn_slot; 
	}



int yyexca[] ={
-1, 0,
	0, 5,
	-2, 0,
-1, 1,
	0, -1,
	-2, 0,
-1, 18,
	314, 20,
	-2, 47,
-1, 30,
	305, 147,
	-2, 70,
-1, 31,
	305, 146,
	-2, 71,
-1, 95,
	305, 146,
	-2, 71,
-1, 96,
	305, 147,
	-2, 70,
-1, 140,
	0, 3,
	284, 3,
	-2, 0,
-1, 154,
	260, 0,
	261, 0,
	264, 0,
	265, 0,
	-2, 130,
-1, 155,
	260, 0,
	261, 0,
	264, 0,
	265, 0,
	-2, 132,
-1, 156,
	260, 0,
	261, 0,
	264, 0,
	265, 0,
	-2, 134,
-1, 157,
	260, 0,
	261, 0,
	264, 0,
	265, 0,
	-2, 136,
-1, 179,
	311, 148,
	-2, 150,
-1, 235,
	306, 54,
	312, 54,
	314, 54,
	-2, 104,
-1, 289,
	314, 45,
	-2, 47,
-1, 340,
	306, 55,
	312, 55,
	314, 55,
	-2, 105,
-1, 341,
	306, 56,
	312, 56,
	314, 56,
	-2, 106,
	};
# define YYNPROD 151
# define YYLAST 1200
int yyact[]={

   160,     8,    15,   335,   333,   135,    18,    62,    62,   206,
   232,   233,   136,   234,    68,    69,   299,    70,   324,   323,
   322,   321,   320,   319,   294,   135,    92,   131,   130,   134,
    61,    62,   136,   227,   103,   135,   318,   317,   107,   293,
   108,   171,   136,   316,   315,   135,   128,   223,   224,   134,
    61,    62,   136,   170,   231,   314,   313,   131,   130,   134,
    61,    62,    10,    11,   126,   248,   247,   131,   130,   134,
    61,    62,   143,   144,   145,   146,   147,   148,   149,   150,
   151,   152,   153,   154,   155,   156,   157,   143,    66,   158,
   164,   143,   166,   165,   210,   211,   162,   161,    13,    64,
   174,   175,   179,   182,   296,   183,   141,   296,   295,   229,
   200,   201,   202,   203,   204,   205,    71,   207,   208,   209,
   332,   212,   213,   214,   215,   216,   143,   311,   218,    80,
    81,   141,    84,    82,   140,   310,    83,    85,    78,    79,
    76,    77,    74,    75,   266,   265,   286,    80,    81,   264,
    84,    82,    71,   263,    83,    85,    78,    79,    76,    77,
    74,    75,   262,   261,   239,   252,   238,   240,   242,   182,
   237,   244,   245,    71,   221,   287,    39,    57,    55,    43,
    46,    56,    58,   168,    33,   220,   371,   167,   370,    34,
    44,    42,    45,    47,    48,    53,    54,    36,    35,    98,
    97,   284,    49,    50,    51,    52,    63,   369,   356,   355,
    40,    41,    24,    26,    27,     8,   354,   353,   285,    25,
   352,   289,    37,   181,   195,   194,   351,   350,   349,   348,
   347,   346,    18,   345,    31,    30,    38,    61,    62,   341,
   340,   339,   305,     2,   309,   280,   279,   193,   191,   196,
   192,    80,    81,   179,    84,    82,   275,   268,    83,    85,
    78,    79,    76,    77,    74,    75,   198,   197,     5,   267,
   260,   259,   325,     4,   258,   257,    10,    11,   256,   255,
   253,   251,   326,   327,   328,   329,   235,   219,   289,   228,
    39,    57,    55,    43,    46,    56,    58,   222,    33,   226,
   361,   173,   172,    34,    44,    42,    45,    47,    48,    53,
    54,    36,    35,    98,    97,   123,    49,    50,    51,    52,
    63,   122,   121,   120,    40,    41,    24,    26,    27,   119,
   118,   117,   143,    25,   362,   116,    37,   176,   115,   114,
   113,   112,   111,   110,   109,   106,   105,   104,    31,    30,
    38,    61,    62,    39,    57,    55,    43,    46,    56,    58,
   159,    33,   102,   101,   100,    99,    34,    44,    42,    45,
    47,    48,    53,    54,    36,    35,    98,    97,    91,    49,
    50,    51,    52,    63,    88,    87,    65,    40,    41,    24,
    26,    27,   368,   367,   366,   365,    25,    94,   364,    37,
   297,   169,   331,   125,    90,    86,   124,    89,    12,    74,
    75,    95,    96,    38,    61,    62,    39,    57,    55,    43,
    46,    56,    58,    67,    33,   178,    28,    59,   177,    34,
    44,    42,    45,    47,    48,    53,    54,    36,    35,    21,
    20,    22,    49,    50,    51,    52,    63,   129,    19,   288,
    40,    41,    24,    26,    27,    32,    16,    29,    81,    25,
    84,    82,    37,   127,    83,    85,    78,    79,    76,    77,
    74,    75,    14,   132,    31,    30,    38,    61,    62,    39,
    57,    55,    43,    46,    56,    58,     1,    33,   138,     9,
   139,    23,    34,    44,    42,    45,    47,    48,    53,    54,
    36,    35,    98,    97,     3,    49,    50,    51,    52,    63,
    17,    60,     6,    40,    41,    24,    26,    27,     7,     0,
     0,   133,    25,   137,     0,    37,     0,     0,   298,    76,
    77,    74,    75,   246,     0,     0,     0,    31,    30,    38,
    61,    62,    39,    57,    55,    43,    46,    56,    58,     0,
    33,     0,     0,     0,     0,    34,    44,    42,    45,    47,
    48,    53,    54,    36,    35,    98,    97,     0,    49,    50,
    51,    52,    63,     0,     0,     0,    40,    41,    24,    26,
    27,     0,   142,     0,   225,    25,     0,     0,   217,     0,
     0,     0,   133,     0,   137,     0,   338,   302,   303,   304,
    31,    30,    38,    61,    62,    39,    57,    55,    43,    46,
    56,    58,     0,    33,     0,     0,     0,    93,    34,    44,
    42,    45,    47,    48,    53,    54,    36,    35,    98,    97,
     0,    49,    50,    51,    52,    63,     0,     0,     0,    40,
    41,    24,    26,    27,     0,   230,    80,    81,    25,    84,
    82,   163,     0,    83,    85,    78,    79,    76,    77,    74,
    75,     0,     0,    31,    30,    38,    61,    62,     0,   290,
   292,   343,   344,     0,     0,     0,   300,   133,   133,   137,
   137,   312,     0,     0,   133,   291,   137,    80,    81,     0,
    84,    82,     0,    73,    83,    85,    78,    79,    76,    77,
    74,    75,    72,    80,    81,     0,    84,    82,     0,     0,
    83,    85,    78,    79,    76,    77,    74,    75,    80,    81,
   180,    84,    82,     0,     0,    83,    85,    78,    79,    76,
    77,    74,    75,     0,   301,     0,   290,   330,     0,     0,
     0,   283,     0,   337,   300,     0,     0,     0,     0,   334,
   336,   133,   133,   137,   137,    80,    81,   282,    84,    82,
     0,     0,    83,    85,    78,    79,    76,    77,    74,    75,
     0,     0,   281,    78,    79,    76,    77,    74,    75,     0,
   363,     0,     0,     0,     0,     0,   243,     0,   133,     0,
   137,    80,    81,     0,    84,    82,     0,     0,    83,    85,
    78,    79,    76,    77,    74,    75,     0,    80,    81,   271,
    84,    82,     0,     0,    83,    85,    78,    79,    76,    77,
    74,    75,    80,    81,     0,    84,    82,     0,     0,    83,
    85,    78,    79,    76,    77,    74,    75,     0,     0,    80,
    81,     0,    84,    82,     0,   168,    83,    85,    78,    79,
    76,    77,    74,    75,     0,    80,    81,     0,    84,    82,
     0,   241,    83,    85,    78,    79,    76,    77,    74,    75,
    80,    81,     0,    84,    82,     0,   236,    83,    85,    78,
    79,    76,    77,    74,    75,     0,    80,    81,   360,    84,
    82,     0,     0,    83,    85,    78,    79,    76,    77,    74,
    75,     0,    80,    81,   359,    84,    82,     0,     0,    83,
    85,    78,    79,    76,    77,    74,    75,    80,    81,   358,
    84,    82,     0,     0,    83,    85,    78,    79,    76,    77,
    74,    75,     0,    80,    81,   357,    84,    82,     0,     0,
    83,    85,    78,    79,    76,    77,    74,    75,     0,    80,
    81,   342,    84,    82,     0,     0,    83,    85,    78,    79,
    76,    77,    74,    75,    80,    81,   199,    84,    82,     0,
     0,    83,    85,    78,    79,    76,    77,    74,    75,     0,
    80,    81,   278,    84,    82,     0,     0,    83,    85,    78,
    79,    76,    77,    74,    75,     0,    80,    81,   277,    84,
    82,     0,     0,    83,    85,    78,    79,    76,    77,    74,
    75,    80,    81,   276,    84,    82,     0,     0,    83,    85,
    78,    79,    76,    77,    74,    75,     0,    80,    81,   274,
    84,    82,     0,     0,    83,    85,    78,    79,    76,    77,
    74,    75,     0,    80,    81,   273,    84,    82,     0,     0,
    83,    85,    78,    79,    76,    77,    74,    75,    80,    81,
   272,    84,    82,     0,     0,    83,    85,    78,    79,    76,
    77,    74,    75,     0,    80,    81,   270,    84,    82,     0,
     0,    83,    85,    78,    79,    76,    77,    74,    75,     0,
    80,    81,   269,    84,    82,     0,     0,    83,    85,    78,
    79,    76,    77,    74,    75,    80,    81,   254,    84,    82,
     0,     0,    83,    85,    78,    79,    76,    77,    74,    75,
     0,    80,    81,   250,    84,    82,     0,     0,    83,    85,
    78,    79,    76,    77,    74,    75,     0,   186,   187,   249,
     0,     0,     0,     0,     0,    80,    81,     0,    84,    82,
     0,   308,    83,    85,    78,    79,    76,    77,    74,    75,
   188,   190,   185,   189,     0,     0,     0,   307,   184,    80,
    81,     0,    84,    82,     0,     0,    83,    85,    78,    79,
    76,    77,    74,    75,     0,     0,     0,     0,    84,    82,
     0,   306,    83,    85,    78,    79,    76,    77,    74,    75 };
int yypact[]={

   -41,   124,  -218, -1000, -1000,   157,  -215, -1000, -1000,    81,
 -1000, -1000,  -228,  -303, -1000,  -196, -1000, -1000,   389,   113,
    80,    79,   117,   112,    73,    94,    60,    59,    58,    57,
 -1000, -1000, -1000,   220,    42,    41,    40,   220, -1000,   220,
 -1000, -1000,    39,    38,    37,    36,    35,    34,    33,    30,
    26,    25,    24, -1000, -1000,    18,    17,    16,    10,   115,
   111, -1000, -1000,   220, -1000,  -260,  -303,  -180, -1000, -1000,
 -1000,   157,   220,   220,   220,   220,   220,   220,   220,   220,
   220,   220,   220,   220,   220,   220,   157,   220,  -221,   346,
   157,   220,  -128,    98, -1000,  -263,  -275,    -3,    -4,   220,
   220,    31,   -83,   261,   220,   862,   -51,   660,   928,   220,
   220,   220,   220,   220,   220,  -308,   220,   220,   220,  -223,
   220,   220,   220,   220,   283,   157,   912,   -19,  -125,  -137,
 -1000, -1000, -1000, -1000, -1000,    -8,  -270,   -16, -1000,  -205,
  -255,  -307, -1000,   389,   912,   912, -1000, -1000,   139,   139,
   261,   261,   200,   928,   507,   507,   507,   507,  -196,   -20,
   565,  -141,  -145,   220,   912,  -139,   550,   220,   220, -1000,
   220,   220,   220,  -252,   833,   817, -1000,   -25,  -146,   912,
   -26, -1000,   534,   801, -1000,   -27,   -28,   -31,   -32,   -35,
   -36,  -148,  -149,  -158,  -162,  -166,  -167,   -37,   -49, -1000,
   786,   770,   498,   754,   739,   723,   -50,   707,   692,   676,
   -60,   -61,   461,   446,   430,  -110,   912,   220,  -160,  -135,
   220,  -250,  -250,  -277,  -292,  -207,    97, -1000,  -290,  -255,
 -1000,   157, -1000, -1000, -1000, -1000,   220,   220,   220,   660,
 -1000,   220,   888, -1000,   864,   848,   -62,  -176,  -184, -1000,
 -1000, -1000,   220, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,  -262,  -274,  -281,  -295,  -297,  -299, -1000, -1000, -1000,
 -1000,   220, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000,   220,   220,   220,   220,   660, -1000,   220, -1000,   912,
   110, -1000,  -191,  -313,  -314,  -250,  -250, -1000,   -65, -1000,
  -204, -1000, -1000,   -66,   -67,   645, -1000, -1000, -1000, -1000,
   220,   220, -1000,   -73,   -75,   -76,   -77,   -78,   -79,   -80,
   -86,   -89,   -90,   -97,   -98,   629,   613,   598,   582,    -6,
 -1000,   157,  -250,    95,    92,    91,    90,    89, -1000, -1000,
 -1000, -1000, -1000,   -99,  -118, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,  -196,  -120, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000 };
int yypgo[]={

     0,     0,   448,   504,   518,     2,   510,   299,   423,   512,
   511,   491,   489,   488,   617,   360,   428,   447,   449,   463,
   486,   473,   472,   456,   441,   427,   426,   457,   455,   425 };
int yyr1[]={

     0,    20,    20,    20,    20,    20,    20,    20,     8,     8,
     8,     8,     8,     8,     9,     9,     9,     3,    22,    22,
    23,    23,     4,     4,    19,    19,    28,    21,    21,    21,
    21,    17,    17,    17,    17,    17,    17,    17,    17,    17,
    17,    13,    13,     7,     7,    18,    18,     2,    25,    24,
    24,    10,    11,     6,     6,     6,     6,     6,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,    14,    14,    15,
    15,     5,     5,    27,    12,    12,    26,    26,    29,    16,
    16 };
int yyr2[]={

     0,    13,    11,     9,     3,     1,     3,     3,     7,     3,
     7,     3,     3,     7,     3,     5,     3,     5,     3,     3,
     3,     7,    13,    11,     3,     7,     3,    11,    11,    11,
    11,     3,     3,     3,     3,     3,    13,    11,     9,     7,
     3,     7,     5,     3,     7,     3,     7,     3,     5,     7,
     9,     9,     9,     7,     9,    13,    13,     7,     7,     9,
    13,    11,     9,     9,     7,     9,     9,     7,     7,     5,
     3,     3,     3,    11,    11,     7,     7,     7,     7,     7,
     7,     5,     9,     7,     9,     9,     9,     9,     9,     9,
    13,    13,    13,    13,    13,    13,     9,    13,    13,    13,
    13,    13,    13,     9,     9,    13,    13,     7,     3,     7,
     7,     5,     3,     3,     9,     9,    13,     9,     9,     9,
     9,     9,     9,     9,     3,     9,     9,     3,     3,    13,
     7,    13,     7,    13,     7,    13,     7,     3,     7,     3,
     7,     7,     3,     3,     3,     3,     3,     3,     3,     7,
     3 };
int yychk[]={

 -1000,   -20,   284,    -3,   314,   309,    -9,    -4,   256,   -12,
   317,   318,   284,   316,   -22,    -5,   -23,    -6,    -1,    -2,
   283,   282,   -24,   -11,   295,   302,   296,   297,   -26,   -27,
   318,   317,   -28,   267,   272,   281,   280,   305,   319,   259,
   293,   294,   274,   262,   273,   275,   263,   276,   277,   285,
   286,   287,   288,   278,   279,   261,   264,   260,   265,   -25,
   -10,   320,   321,   289,   314,   305,   316,    -8,   317,   318,
   320,   312,   313,   304,   270,   271,   268,   269,   266,   267,
   257,   258,   261,   264,   260,   265,   292,   305,   305,   290,
   292,   305,    -1,   -14,   303,   317,   318,   283,   282,   305,
   305,   305,   305,    -1,   305,   305,   305,    -1,    -1,   305,
   305,   305,   305,   305,   305,   305,   305,   305,   305,   305,
   305,   305,   305,   305,   291,   292,    -1,   -19,   306,   -17,
   318,   317,   -21,   -28,   319,   295,   302,   -27,   -13,    -8,
   314,   311,    -6,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -5,   -15,
    -1,   318,   317,   305,    -1,    -5,    -1,   315,   311,   303,
   316,   316,   305,   305,    -1,    -1,   306,   -16,   -29,    -1,
   -14,   306,    -1,    -1,   306,   300,   275,   276,   298,   301,
   299,   299,   301,   298,   276,   275,   300,   318,   317,   306,
    -1,    -1,    -1,    -1,    -1,    -1,   317,    -1,    -1,    -1,
   317,   318,    -1,    -1,    -1,    -1,    -1,   305,    -5,   306,
   310,   311,   305,   317,   318,   -17,    -7,   303,   305,   314,
    -3,   309,   317,   318,   320,   306,   311,   311,   311,    -1,
   306,   311,    -1,   -14,    -1,    -1,   -15,   318,   317,   306,
   306,   306,   311,   306,   306,   306,   306,   306,   306,   306,
   306,   311,   311,   311,   311,   311,   311,   306,   306,   306,
   306,   311,   306,   306,   306,   306,   306,   306,   306,   306,
   306,   311,   311,   311,   311,    -1,   306,   310,   -18,    -1,
    -2,   -19,   -17,   316,   316,   315,   311,   303,    -7,   306,
   -17,    -3,   -15,   -15,   -15,    -1,   303,   303,   303,   306,
   311,   311,   -16,   318,   317,   318,   317,   318,   317,   318,
   317,   318,   317,   318,   317,    -1,    -1,    -1,    -1,    -1,
   -18,   292,   311,   317,   -28,   317,   -28,   -17,    -7,   306,
   306,   306,   306,   -15,   -15,   306,   306,   306,   306,   306,
   306,   306,   306,   306,   306,   306,   306,   306,   306,   306,
   306,   306,    -5,   -17,   303,   303,   303,   303,   303,   306,
   306,   306 };
int yydef[]={

    -2,    -2,     0,     4,     6,     7,     0,    14,    16,     0,
   144,   145,     0,     0,    15,    18,    19,   142,    -2,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -2,    -2,    72,     0,     0,     0,     0,     0,   108,     0,
   112,   113,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   124,   127,   128,     0,     0,     0,     0,     0,
     0,   143,    26,     0,    17,     0,     0,     0,     9,    11,
    12,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,   137,     0,    69,    -2,    -2,     0,     0,     0,
     0,     0,     0,    81,     0,     0,     0,     0,   111,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    48,     0,     0,    24,
    31,    32,    33,    34,    35,     0,     0,     0,    40,     0,
    -2,     0,   141,     0,    53,    57,    75,    76,    77,    78,
    79,    80,   109,   110,    -2,    -2,    -2,    -2,    21,     0,
   139,     0,     0,     0,    58,     0,     0,     0,     0,    68,
     0,     0,     0,     0,     0,     0,    64,     0,     0,    -2,
     0,    67,   137,     0,    83,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   107,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    49,     0,     0,     0,
     0,     0,     0,    32,    31,    43,     0,    42,     0,     0,
     2,     0,     8,    10,    13,    -2,     0,     0,     0,    52,
    59,     0,     0,   138,     0,     0,     0,     0,     0,    62,
    63,    65,     0,    66,    82,    84,    85,    86,    87,    88,
    89,     0,     0,     0,     0,     0,     0,    96,   103,   114,
   115,     0,   117,   118,   119,   120,   121,   122,   123,   125,
   126,     0,     0,     0,     0,    51,    50,     0,    23,    -2,
     0,    25,     0,     0,     0,     0,     0,    41,     0,    39,
    43,     1,   140,     0,     0,     0,    61,    73,    74,   104,
     0,     0,   149,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    22,     0,     0,     0,     0,     0,     0,     0,    44,    38,
    -2,    -2,    60,     0,     0,    90,    97,    91,    98,    92,
    99,    93,   100,    94,   101,    95,   102,   116,   129,   131,
   133,   135,    46,     0,    27,    29,    28,    30,    37,   105,
   106,    36 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"TOR",	257,
	"TAND",	258,
	"TNOT",	259,
	"TLESSP",	260,
	"TGREATERP",	261,
	"TNUMBERP",	262,
	"TLISTP",	263,
	"TGREATEREQ",	264,
	"TLESSEQ",	265,
	"TPLUS",	266,
	"TMINUS",	267,
	"TMUL",	268,
	"TDIVIDE",	269,
	"TMOD",	270,
	"TDIV",	271,
	"TABS",	272,
	"TEQ",	273,
	"TNULL",	274,
	"TATOM",	275,
	"TBOOL",	276,
	"TISVAR",	277,
	"TCPUTIME",	278,
	"TSHOWTIME",	279,
	"TREAD",	280,
	"TREADB",	281,
	"TWRITE",	282,
	"TWRITEB",	283,
	"TCONSTRUCTOR",	284,
	"TCONSULT",	285,
	"TRECONSULT",	286,
	"TSAVE",	287,
	"TTRACE",	288,
	"TIF",	289,
	"TELSE",	290,
	"TTHEN",	291,
	"TWHERE",	292,
	"TTRUE",	293,
	"TFALSE",	294,
	"TCONS",	295,
	"TCAR",	296,
	"TCDR",	297,
	"TLINE",	298,
	"TCHAR",	299,
	"TINT",	300,
	"TLIST",	301,
	"TLBRACK",	302,
	"TRBRACK",	303,
	"TBELONG",	304,
	"TLPAR",	305,
	"TRPAR",	306,
	"TLBRACE",	307,
	"TRBRACE",	308,
	"TQMARK",	309,
	"TDEF",	310,
	"TCOMMA",	311,
	"TSEMCOL",	312,
	"TEQUAL",	313,
	"TPERIOD",	314,
	"TBAR",	315,
	"TCOLON",	316,
	"TID",	317,
	"TNATOM",	318,
	"TNUM",	319,
	"TFUNCTORNM",	320,
	"TSTRING",	321,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"stsym : stsym TCONSTRUCTOR TCOLON fnmlist TPERIOD pgm",
	"stsym : TCONSTRUCTOR TCOLON fnmlist TPERIOD pgm",
	"stsym : TCONSTRUCTOR TCOLON fnmlist TPERIOD",
	"stsym : pgm",
	"stsym : /* empty */",
	"stsym : TPERIOD",
	"stsym : TQMARK",
	"fnmlist : fnmlist TCOMMA TID",
	"fnmlist : TID",
	"fnmlist : fnmlist TCOMMA TNATOM",
	"fnmlist : TNATOM",
	"fnmlist : TFUNCTORNM",
	"fnmlist : fnmlist TCOMMA TFUNCTORNM",
	"defgoal : def",
	"defgoal : TQMARK query",
	"defgoal : error",
	"pgm : defgoal TPERIOD",
	"query : eqlist",
	"query : bodytype",
	"bodytype : exp",
	"bodytype : expp TWHERE eqlist",
	"def : funcd TLPAR patterns TRPAR TDEF body",
	"def : funcd TLPAR TRPAR TDEF body",
	"patterns : term",
	"patterns : term TCOMMA patterns",
	"tstring : TSTRING",
	"strterm : TLBRACK TID TCOLON TID TRBRACK",
	"strterm : TLBRACK TNATOM TCOLON TID TRBRACK",
	"strterm : TLBRACK TID TCOLON tstring TRBRACK",
	"strterm : TLBRACK TNATOM TCOLON tstring TRBRACK",
	"term : TNATOM",
	"term : TID",
	"term : strterm",
	"term : tstring",
	"term : TNUM",
	"term : TCONS TLPAR term TCOMMA term TRPAR",
	"term : TLBRACK term TBAR term TRBRACK",
	"term : tconstructor TLPAR comps TRPAR",
	"term : tconstructor TLPAR TRPAR",
	"term : list",
	"list : TLBRACK comps TRBRACK",
	"list : TLBRACK TRBRACK",
	"comps : term",
	"comps : term TCOMMA comps",
	"body : exp",
	"body : expp TWHERE eqlist",
	"expp : exp",
	"ifcond : TIF exp",
	"thenpt : ifcond TTHEN exp",
	"thenpt : thenwhp TWHERE eqlist TRPAR",
	"thenwhp : ifcond TTHEN TLPAR exp",
	"elsewhp : thenpt TELSE TLPAR exp",
	"eqn : exp TEQUAL exp",
	"eqn : TWRITEB TLPAR wrlist TRPAR",
	"eqn : TWRITE TLPAR TNATOM TCOMMA wrlist TRPAR",
	"eqn : TWRITE TLPAR TID TCOMMA wrlist TRPAR",
	"eqn : exp TBELONG exp",
	"exp : thenpt TELSE exp",
	"exp : elsewhp TWHERE eqlist TRPAR",
	"exp : TCONS TLPAR exp TCOMMA exp TRPAR",
	"exp : TLBRACK exp TBAR exp TRBRACK",
	"exp : TCAR TLPAR exp TRPAR",
	"exp : TCDR TLPAR exp TRPAR",
	"exp : funcall TLPAR TRPAR",
	"exp : funcall TLPAR arglist TRPAR",
	"exp : tconstructor TLPAR explist TRPAR",
	"exp : tconstructor TLPAR TRPAR",
	"exp : TLBRACK explist TRBRACK",
	"exp : TLBRACK TRBRACK",
	"exp : TNATOM",
	"exp : TID",
	"exp : tstring",
	"exp : TLBRACK TID TCOLON exp TRBRACK",
	"exp : TLBRACK TNATOM TCOLON exp TRBRACK",
	"exp : exp TMOD exp",
	"exp : exp TDIV exp",
	"exp : exp TMUL exp",
	"exp : exp TDIVIDE exp",
	"exp : exp TPLUS exp",
	"exp : exp TMINUS exp",
	"exp : TMINUS exp",
	"exp : TABS TLPAR exp TRPAR",
	"exp : TREADB TLPAR TRPAR",
	"exp : TREADB TLPAR TINT TRPAR",
	"exp : TREADB TLPAR TATOM TRPAR",
	"exp : TREADB TLPAR TBOOL TRPAR",
	"exp : TREADB TLPAR TLINE TRPAR",
	"exp : TREADB TLPAR TLIST TRPAR",
	"exp : TREADB TLPAR TCHAR TRPAR",
	"exp : TREAD TLPAR TCHAR TCOMMA TNATOM TRPAR",
	"exp : TREAD TLPAR TLIST TCOMMA TNATOM TRPAR",
	"exp : TREAD TLPAR TLINE TCOMMA TNATOM TRPAR",
	"exp : TREAD TLPAR TBOOL TCOMMA TNATOM TRPAR",
	"exp : TREAD TLPAR TATOM TCOMMA TNATOM TRPAR",
	"exp : TREAD TLPAR TINT TCOMMA TNATOM TRPAR",
	"exp : TREAD TLPAR TNATOM TRPAR",
	"exp : TREAD TLPAR TCHAR TCOMMA TID TRPAR",
	"exp : TREAD TLPAR TLIST TCOMMA TID TRPAR",
	"exp : TREAD TLPAR TLINE TCOMMA TID TRPAR",
	"exp : TREAD TLPAR TBOOL TCOMMA TID TRPAR",
	"exp : TREAD TLPAR TATOM TCOMMA TID TRPAR",
	"exp : TREAD TLPAR TINT TCOMMA TID TRPAR",
	"exp : TREAD TLPAR TID TRPAR",
	"exp : TWRITEB TLPAR wrlist TRPAR",
	"exp : TWRITE TLPAR TNATOM TCOMMA wrlist TRPAR",
	"exp : TWRITE TLPAR TID TCOMMA wrlist TRPAR",
	"exp : TLPAR exp TRPAR",
	"exp : TNUM",
	"exp : exp TOR exp",
	"exp : exp TAND exp",
	"exp : TNOT exp",
	"exp : TTRUE",
	"exp : TFALSE",
	"exp : TNULL TLPAR exp TRPAR",
	"exp : TNUMBERP TLPAR exp TRPAR",
	"exp : TEQ TLPAR exp TCOMMA exp TRPAR",
	"exp : TATOM TLPAR exp TRPAR",
	"exp : TLISTP TLPAR exp TRPAR",
	"exp : TBOOL TLPAR exp TRPAR",
	"exp : TISVAR TLPAR TID TRPAR",
	"exp : TCONSULT TLPAR exp TRPAR",
	"exp : TRECONSULT TLPAR exp TRPAR",
	"exp : TSAVE TLPAR exp TRPAR",
	"exp : TTRACE",
	"exp : TTRACE TLPAR TID TRPAR",
	"exp : TTRACE TLPAR TNATOM TRPAR",
	"exp : TCPUTIME",
	"exp : TSHOWTIME",
	"exp : TGREATERP TLPAR exp TCOMMA exp TRPAR",
	"exp : exp TGREATERP exp",
	"exp : TGREATEREQ TLPAR exp TCOMMA exp TRPAR",
	"exp : exp TGREATEREQ exp",
	"exp : TLESSP TLPAR exp TCOMMA exp TRPAR",
	"exp : exp TLESSP exp",
	"exp : TLESSEQ TLPAR exp TCOMMA exp TRPAR",
	"exp : exp TLESSEQ exp",
	"explist : exp",
	"explist : exp TCOMMA explist",
	"wrlist : exp",
	"wrlist : exp TCOMMA wrlist",
	"eqlist : eqlist TSEMCOL eqn",
	"eqlist : eqn",
	"tconstructor : TFUNCTORNM",
	"funcd : TID",
	"funcd : TNATOM",
	"funcall : TID",
	"funcall : TNATOM",
	"exph : exp",
	"arglist : exph TCOMMA arglist",
	"arglist : exp",
};
#endif /* YYDEBUG */
#line 1 "/usr/lib/yaccpar"
/*	@(#)yaccpar 1.10 89/04/04 SMI; from S5R3 1.10	*/

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 159 "yacc.y"
{
			 /*disp_heap();*/
			 /*printf("%d goals solved\n", numgoals);*/
			 /*numgoals = 0;*/
			 yyval.intval = yypvt[-0].intval;
			} break;
case 2:
# line 166 "yacc.y"
{yyval.intval = yypvt[-0].intval;} break;
case 3:
# line 168 "yacc.y"
{yyval.intval = PNULL;} break;
case 4:
# line 170 "yacc.y"
{yyval.intval = yypvt[-0].intval;} break;
case 5:
# line 171 "yacc.y"
{isempty_file = PTRUE; 
		 	 yyval.intval = PNULL;
			} break;
case 6:
# line 175 "yacc.y"
{isempty_file = PTRUE;
			 yyval.intval = PNULL;
			} break;
case 7:
# line 179 "yacc.y"
{isempty_file = PTRUE;
			 yyval.intval = PNULL;
			} break;
case 8:
# line 185 "yacc.y"
{ 
			  functor_array[functor_count] = yypvt[-0].string;
			  ++functor_count;
			} break;
case 9:
# line 190 "yacc.y"
{ 
			  functor_array[functor_count] = yypvt[-0].string;
			  ++functor_count;
			} break;
case 10:
# line 195 "yacc.y"
{ 
			  functor_array[functor_count] = yypvt[-0].string;
			  ++functor_count;
			} break;
case 11:
# line 200 "yacc.y"
{ 
			  functor_array[functor_count] = yypvt[-0].string;
			  ++functor_count;
			} break;
case 12:
# line 206 "yacc.y"
{
			} break;
case 13:
# line 209 "yacc.y"
{
			} break;
case 14:
# line 216 "yacc.y"
{ rcode = PNULL; yyval.intval = yypvt[-0].intval;} break;
case 15:
# line 219 "yacc.y"
{ yyval.intval = yypvt[-0].intval;} break;
case 16:
# line 221 "yacc.y"
{rcode = PNULL;} break;
case 17:
# line 225 "yacc.y"
{ yyval.intval = yypvt[-1].intval;} break;
case 18:
# line 228 "yacc.y"
{
			 heap[yypvt[-0].intval].auxval = heap[heap[yypvt[-0].intval].lfld.lptr].auxval;
				/*The auxval field of eqlist is being used*/
				/*for parsing so we have to restore    the*/
				/*priority value stored there.		  */
			 m = num_of_eqns + curr_temp_eqn_slot;
                         exec_code = node(GWHERE, PNULL, yypvt[-0].intval, m, 0);
                                /*dummy node to facilitate sorting */
				/*and to store the no. of equations*/
                         insert_eqns(exec_code);
                         sort_eqns(exec_code);
			 curr_temp_eqn_slot = 0;
			 num_of_eqns = 0;
			 report_last_var = 0;
			 yyval.intval = yypvt[-0].intval;
			 rcode = PNULL;
                        } break;
case 19:
# line 246 "yacc.y"
{
			 m = num_of_eqns + curr_temp_eqn_slot + 1;
                          /* $1 points to a list of equations*/
                         exec_code = node(GWHERE, PNULL, yypvt[-0].intval, m, 0);
                                /*dummy node to facilitate sorting*/
				/*return this cell to the heap after sorting*/
                         insert_eqns(exec_code);
                         sort_eqns(exec_code);
			 curr_temp_eqn_slot = 0;
			 num_of_eqns = 0;
			 report_last_var = 1;
			 yyval.intval = yypvt[-0].intval;
                        } break;
case 20:
# line 263 "yacc.y"
{
                         i = nodegid(GID, var_tab_ptr, PNULL, PNULL, 0);
                         tempvartab[var_tab_ptr] = "";
				/*The last slot in tempvartab contains the*/
				/*value of  the  expression to be reported*/
                         ++var_tab_ptr;
                         m = calc_eqn_prio(i, yypvt[-0].intval);
                         n = find_eqn_type(i, yypvt[-0].intval);
                         j = node(GEQN, i, yypvt[-0].intval, m, n);
                         yyval.intval = node(GEQNODE, j, PNULL, m, n);
			 rcode = yypvt[-0].intval;		/*rcode used by list read*/
                        } break;
case 21:
# line 276 "yacc.y"
{
			 rcode = PNULL;
			 insert_eqns_of_exp(heap[yypvt[-0].intval].auxval);
			 heap[yypvt[-0].intval].auxval = heap[heap[yypvt[-0].intval].lfld.lptr].auxval;
				/*The auxval field of eqlist is being used*/
				/*for parsing so we have to restore    the*/
				/*priority value stored there.		  */
                         i = nodegid(GID, var_tab_ptr, PNULL, PNULL, 0);
                         tempvartab[var_tab_ptr] = "";
                         ++var_tab_ptr;
				/*The last slot in tempvartab contains the*/
				/*value of  the  expression to be reported*/
                         m = calc_eqn_prio(i, yypvt[-2].intval);
                         n = find_eqn_type(i, yypvt[-2].intval);
                         j = node(GEQN, i, yypvt[-2].intval, m, n);
                         yyval.intval = node(GEQNODE, j, yypvt[-0].intval, m, n);
                        } break;
case 22:
# line 298 "yacc.y"
{
			 insert_eqns(yypvt[-0].intval);
			                        /*insert_eqns is called only*/
						/*if  num_of_eqns  is  zero.*/
			 sort_eqns(yypvt[-0].intval);
			 curr_temp_eqn_slot = 0;
			 num_of_eqns = 0;
			 insert_fn_in_hash_tab(yypvt[-3].intval, yypvt[-0].intval, yypvt[-5].string, 
					num_of_formals, var_tab_ptr);
			 num_of_formals = 0;
			 yyval.intval = yypvt[-0].intval;
			} break;
case 23:
# line 311 "yacc.y"
{
			 insert_eqns(yypvt[-0].intval);
			 sort_eqns(yypvt[-0].intval);
			 curr_temp_eqn_slot = 0;
			 num_of_eqns = 0;
			 insert_fn_in_hash_tab(PNULL, yypvt[-0].intval, yypvt[-4].string, 
					num_of_formals, var_tab_ptr);
			 num_of_formals = 0;
			 yyval.intval = yypvt[-0].intval;
			} break;
case 24:
# line 324 "yacc.y"
{
			 yyval.intval = node(GFORMAL, yypvt[-0].intval, PNULL, PNULL,0);
			 ++num_of_formals;
			} break;
case 25:
# line 329 "yacc.y"
{
			 yyval.intval = node(GFORMAL, yypvt[-2].intval, yypvt[-0].intval, PNULL,0);
			 ++num_of_formals;
			} break;
case 26:
# line 336 "yacc.y"
{m = strlen(yypvt[-0].string) - 1;
			 i = node(GCONS, PNULL, PNULL, ISTRING, 0);
			 while(m >= 0)
			      { x = getfreecell(heap);
				heap[x].tag = GNATOM;
				str = (char *) malloc(2);
				str[0] = yypvt[-0].string[m];
				str[1] = '\0';
				heap[x].lfld.name = str;
				heap[x].rptr = PNULL;
				heap[x].auxval = PNULL;
				heap[x].eqntype = 0;
				j = node(GCONS, x, i, ISTRING, 0);
				i = j;
				--m;
			      };
			 yyval.intval = i;
			} break;
case 27:
# line 357 "yacc.y"
{i = nodegid(GID, var_search(yypvt[-3].string), PNULL, PNULL, 0);
			 j = nodegid(GID, var_search(yypvt[-1].string), PNULL, PNULL, 0); 
			 yyval.intval = node(GCONS, i, j, ISTRING, 0);
			} break;
case 28:
# line 362 "yacc.y"
{if (strlen(yypvt[-3].string) > 1) 
				{printf("Illegal string catenation : error\n");
				 longjmp(parserrbuff, 0);
				};
			 i = nodegid(GNATOM, 0, PNULL, PNULL, 0);
			 heap[i].lfld.name = yypvt[-3].string;
			 j = nodegid(GID, var_search(yypvt[-1].string), PNULL, PNULL, 0); 
			 yyval.intval = node(GCONS, i, j, ISTRING, 0);
			} break;
case 29:
# line 372 "yacc.y"
{i = nodegid(GID, var_search(yypvt[-3].string), PNULL, PNULL, 0);
			 yyval.intval = node(GCONS, i, yypvt[-1].intval, ISTRING, 0);
			} break;
case 30:
# line 376 "yacc.y"
{if (strlen(yypvt[-3].string) > 1) 
				{printf("Illegal string catenation : error\n");
				 longjmp(parserrbuff, 0);
				};
			 i = nodegid(GNATOM, 0, PNULL, PNULL, 0);
			 heap[i].lfld.name = yypvt[-3].string;
			 yyval.intval = node(GCONS, i, yypvt[-1].intval, ISTRING, 0);
			} break;
case 31:
# line 387 "yacc.y"
{
			 x = getfreecell(heap);
			 heap[x].tag = GNATOM;
			 heap[x].lfld.name = yypvt[-0].string;
			 yyval.intval = x; 
			 heap[x].rptr = PNULL;
			 heap[x].auxval = PNULL;
			 heap[x].eqntype = 0;
			} break;
case 32:
# line 397 "yacc.y"
{
			 yyval.intval = nodegid(GID, var_search(yypvt[-0].string), PNULL, PNULL, 0);
			} break;
case 33:
# line 401 "yacc.y"
{
			 yyval.intval = yypvt[-0].intval;
			} break;
case 34:
# line 405 "yacc.y"
{
			 yyval.intval = yypvt[-0].intval;
			} break;
case 35:
# line 409 "yacc.y"
{
			 yyval.intval = node(GNUM, atoi(yypvt[-0].string), PNULL, PNULL,0);
			} break;
case 36:
# line 413 "yacc.y"
{
			 yyval.intval = node(GCONS, yypvt[-3].intval, yypvt[-1].intval, PNULL,0);
			} break;
case 37:
# line 417 "yacc.y"
{
			 yyval.intval = node(GCONS, yypvt[-3].intval, yypvt[-1].intval, PNULL, 0);
			} break;
case 38:
# line 421 "yacc.y"
{
			 yyval.intval = node(GCONS, yypvt[-3].intval, yypvt[-1].intval, PTRUE, 0);
			} break;
case 39:
# line 425 "yacc.y"
{
			 yyval.intval = node(GCONS, yypvt[-2].intval, PNULL, PTRUE, 0);
			} break;
case 40:
# line 429 "yacc.y"
{
			 yyval.intval = yypvt[-0].intval;
			} break;
case 41:
# line 435 "yacc.y"
{
			 yyval.intval = yypvt[-1].intval;
			} break;
case 42:
# line 439 "yacc.y"
{
			 yyval.intval = node(GCONS, PNULL, PNULL, PNULL,0);
			} break;
case 43:
# line 445 "yacc.y"
{
			 i = node(GCONS, PNULL, PNULL, PNULL,0);
			 yyval.intval = node(GCONS, yypvt[-0].intval, i, PNULL,0);
			} break;
case 44:
# line 450 "yacc.y"
{
			 yyval.intval = node(GCONS, yypvt[-2].intval, yypvt[-0].intval, PNULL,0);
			} break;
case 45:
# line 456 "yacc.y"
{
			 yyval.intval = node(GWHERE, yypvt[-0].intval, PNULL, curr_temp_eqn_slot,0);
			} break;
case 46:
# line 460 "yacc.y"
{
			 insert_eqns_of_exp(heap[yypvt[-0].intval].auxval);
			 heap[yypvt[-0].intval].auxval = heap[heap[yypvt[-0].intval].lfld.lptr].auxval;
				/*The auxval field of eqlist is being used*/
				/*for parsing so we have to restore    the*/
				/*priority value stored there.		  */
			 m = num_of_eqns + curr_temp_eqn_slot;
		         yyval.intval = node(GWHERE, yypvt[-2].intval, yypvt[-0].intval, m, 0);
			} break;
case 47:
# line 472 "yacc.y"
{
			int j;
			for(j = 0; j < curr_temp_eqn_slot; j++)
				flattened_in_exp[j] = tempeqn[j];
			curr_temp_exp_slot = curr_temp_eqn_slot;
			if (curr_temp_exp_slot >= MAXEQNSINEXP)
			 {printf("Too much nesting in expressions: aborting\n");
			  longjmp(parserrbuff, 0);
			 };
			curr_temp_eqn_slot = 0;
			} break;
case 48:
# line 487 "yacc.y"
{ 
			 i = flatten(yypvt[-0].intval);
			 yyval.intval = i;
			 push_tempeqnstk();
			 /*printf("inside then\n");*/
			} break;
case 49:
# line 496 "yacc.y"
{
			 i = nodenum(GTRUE, PTRUE, PNULL, PNULL, 0);
	  		 tempeqn[curr_temp_eqn_slot++] = node(GEQN, yypvt[-2].intval, i, 
				calc_eqn_prio(yypvt[-2].intval, i), find_eqn_type(yypvt[-2].intval, i));
			 j = node(GWHEREIF, yypvt[-0].intval, PNULL, curr_temp_eqn_slot, 0);
			 insert_eqns(j);
			 sort_eqns(j);
                         free(tempeqn);
                         tempeqn = (cellptrtype *) calloc(MAXAUXEQN, sizeof(cellptrtype));
			 curr_temp_eqn_slot = 0;
			 yyval.intval = node(GIF, yypvt[-2].intval, j, PNULL,0);
			 /*printf("inside else\n");*/
			} break;
case 50:
# line 510 "yacc.y"
{
			 endlist = heap[yypvt[-1].intval].auxval;
			 heap[heap[yypvt[-3].intval].rptr].rptr = yypvt[-1].intval;
			 heap[yypvt[-1].intval].auxval = heap[heap[yypvt[-1].intval].lfld.lptr].auxval;
				/*The auxval field of eqlist is being used*/
				/*for parsing so we have to restore    the*/
				/*priority value stored there.		  */
			 insert_eqns(heap[yypvt[-3].intval].rptr);
			 free(tempeqn);
			 pop_tempeqnstk();
			 insert_eqns(endlist);
			 sort_eqns(heap[yypvt[-3].intval].rptr);
			 /*sort_eqns(endlist);*/
                         free(tempeqn);
                         tempeqn = (cellptrtype *) calloc
					     (MAXAUXEQN, sizeof(cellptrtype));
			 curr_temp_eqn_slot = 0;
			 j = heap[heap[heap[yypvt[-3].intval].rptr].lfld.lptr].lfld.lptr;
			 yyval.intval = node(GIF, j, yypvt[-3].intval, PNULL,0);
			 /*printf("inside else\n");*/
			} break;
case 51:
# line 534 "yacc.y"
{
			 i = nodenum(GTRUE, PTRUE, PNULL, PNULL, 0);
	  		 k = node(GEQN, yypvt[-3].intval, i, calc_eqn_prio(yypvt[-3].intval, i),
						 find_eqn_type(yypvt[-3].intval, i));
			 l = node(GEQNODE, k, PNULL, calc_eqn_prio(yypvt[-3].intval, i),
                                                 find_eqn_type(yypvt[-3].intval, i));
			 j = node(GWHEREIF, yypvt[-0].intval, l, curr_temp_eqn_slot, 0);
			 push_tempeqnstk();
			 yyval.intval = j;
			} break;
case 52:
# line 547 "yacc.y"
{
			 i = node(GFALSE, PFALSE, PNULL, PNULL, 0);
			 j = heap[yypvt[-3].intval].lfld.lptr;
	  		 k = node(GEQN, j, i, calc_eqn_prio(j, i),
						 find_eqn_type(j, i));
			 l = node(GEQNODE, k, PNULL, calc_eqn_prio(j, i),
                                                 find_eqn_type(j, i));
			 j = node(GWHEREIF, yypvt[-0].intval, l, curr_temp_eqn_slot, 0);
			 push_tempeqnstk();
                         l = node(GIFBODY, heap[yypvt[-3].intval].rptr, j, PNULL,0);
						/*reuse l*/
                         heap[yypvt[-3].intval].rptr = l;
			 yyval.intval = yypvt[-3].intval;
			} break;
case 53:
# line 564 "yacc.y"
{
			 yyval.intval = node(GEQN, yypvt[-2].intval, yypvt[-0].intval, calc_eqn_prio(yypvt[-2].intval,yypvt[-0].intval), 
						 find_eqn_type(yypvt[-2].intval,yypvt[-0].intval));
			} break;
case 54:
# line 569 "yacc.y"
{
			 i = node(GWRITE, PNULL, yypvt[-1].intval, GWRITE, 0);
			 j = nodegid(GID, var_search("_"), PNULL, PNULL, 0);
			 yyval.intval = node(GEQN, i, j, calc_eqn_prio(i, j), 
						 find_eqn_type(i, j));
			} break;
case 55:
# line 576 "yacc.y"
{
			 i = node(GWRITE, PNULL, yypvt[-1].intval, PNULL, 0);
			 heap[i].lfld.name = yypvt[-3].string;
			 j = nodegid(GID, var_search("_"), PNULL, PNULL, 0);
			 yyval.intval = node(GEQN, i, j, calc_eqn_prio(i, j), 
						 find_eqn_type(i, j));
			} break;
case 56:
# line 584 "yacc.y"
{
			 i = node(GWRITE, PNULL, yypvt[-1].intval, PNULL, 1);
			 heap[i].lfld.var_offset = var_search(yypvt[-3].string);
			 j = nodegid(GID, var_search("_"), PNULL, PNULL, 0);
			 yyval.intval = node(GEQN, i, j, calc_eqn_prio(i, j), 
						 find_eqn_type(i, j));
			} break;
case 57:
# line 592 "yacc.y"
{
			 yyval.intval = node(GBELONG, yypvt[-2].intval, yypvt[-0].intval, calc_eqn_prio(yypvt[-2].intval,yypvt[-0].intval), 
						 find_eqn_type(yypvt[-2].intval,yypvt[-0].intval));
			} break;
case 58:
# line 600 "yacc.y"
{
			 i = node(GFALSE, PFALSE, PNULL, PNULL, 0);
			 k = heap[yypvt[-2].intval].lfld.lptr;
	  		 tempeqn[curr_temp_eqn_slot++] = node(GEQN, k, i, 
				calc_eqn_prio(k, i), find_eqn_type(k, i));
			 j = node(GWHEREIF, yypvt[-0].intval, PNULL, curr_temp_eqn_slot, 0);
			 insert_eqns(j);
			 sort_eqns(j);
                         l = node(GIFBODY, heap[yypvt[-2].intval].rptr, j, PNULL,0);
                         heap[yypvt[-2].intval].rptr = l;
			 yyval.intval = yypvt[-2].intval;
			 /*printf("if recognized\n");*/
			 pop_tempeqnstk();
			 	/*if recognized so restore tempeqn */
			} break;
case 59:
# line 616 "yacc.y"
{
			 endlist = heap[yypvt[-1].intval].auxval;
			 heap[yypvt[-1].intval].auxval = heap[heap[yypvt[-1].intval].lfld.lptr].auxval;
                                /*The auxval field of eqlist is being used*/
                                /*for parsing so we have to restore    the*/
                                /*priority value stored there.            */
			 k = heap[heap[heap[yypvt[-3].intval].rptr].rptr].rptr;
			 heap[k].rptr = yypvt[-1].intval;
                         insert_eqns(k);
                         free(tempeqn);
                         pop_tempeqnstk();
                         insert_eqns(endlist);
                         sort_eqns(k);
                         free(tempeqn);
			 pop_tempeqnstk();
			 	/*if recognized so restore tempeqn */
			} break;
case 60:
# line 634 "yacc.y"
{
			 i = flatten(yypvt[-3].intval);
			 j = flatten(yypvt[-1].intval);
			 yyval.intval = node(GCONS, i, j, PNULL,0);
			} break;
case 61:
# line 640 "yacc.y"
{
			 i = flatten(yypvt[-3].intval);
			 j = flatten(yypvt[-1].intval);
			 yyval.intval = node(GCONS, i, j, PNULL,0);
			} break;
case 62:
# line 646 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GCAR, i, PNULL, PNULL,0);
			} break;
case 63:
# line 651 "yacc.y"
{ 
                         i = flatten(yypvt[-1].intval); 
                         yyval.intval = node(GCDR, i, PNULL, PNULL,0); 
                        } break;
case 64:
# line 656 "yacc.y"
{
			 yyval.intval = yypvt[-2].intval;
			 heap[yypvt[-2].intval].eqntype = var_look(heap[yypvt[-2].intval].lfld.name);
			} break;
case 65:
# line 661 "yacc.y"
{
			 heap[yypvt[-3].intval].rptr = yypvt[-1].intval;
			 num_of_actuals = heap[yypvt[-1].intval].eqntype;
			 heap[yypvt[-3].intval].auxval = heap[yypvt[-3].intval].auxval + 
						num_of_actuals* FNTABSIZE;
					/*auxval MOD FNTABSIZE is number of */
					/*parameters while auxval DIV FNTAB-*/
					/*-SIZE is the hash value of the fn.*/
			 heap[yypvt[-3].intval].eqntype = var_look(heap[yypvt[-3].intval].lfld.name);
					/*eqntype stores the offset of the id*/
					/*in case the name of the fn. is  be-*/
					/*ing passed as a parameter   (higher*/
					/*order function).		     */
			 yyval.intval = yypvt[-3].intval;
			} break;
case 66:
# line 677 "yacc.y"
{
			 yyval.intval = node(GCONS, yypvt[-3].intval, yypvt[-1].intval, PTRUE, 0);
			} break;
case 67:
# line 681 "yacc.y"
{
			 yyval.intval = node(GCONS, yypvt[-2].intval, PNULL, PTRUE, 0);
			} break;
case 68:
# line 685 "yacc.y"
{
			 yyval.intval = yypvt[-1].intval;
			} break;
case 69:
# line 689 "yacc.y"
{
			 yyval.intval = node(GCONS, PNULL, PNULL, PNULL, 0);
			} break;
case 70:
# line 693 "yacc.y"
{
			 x = getfreecell(heap);
			 heap[x].tag = GNATOM;
			 heap[x].lfld.name = yypvt[-0].string;
			 heap[x].rptr = PNULL;
			 heap[x].auxval = PNULL;
			 heap[x].eqntype = 0;
			 yyval.intval = x;
			} break;
case 71:
# line 703 "yacc.y"
{
			 yyval.intval = nodegid(GID, var_search(yypvt[-0].string), PNULL, PNULL, 0);
			} break;
case 72:
# line 707 "yacc.y"
{
			 yyval.intval = yypvt[-0].intval;
			} break;
case 73:
# line 711 "yacc.y"
{j = flatten(yypvt[-1].intval); 
			 i = nodegid(GID, var_search(yypvt[-3].string), PNULL, PNULL, 0);
			 yyval.intval = node(GCONS, i, j, ISTRING, 0);
			} break;
case 74:
# line 716 "yacc.y"
{if (strlen(yypvt[-3].string) > 1) 
				{printf("Illegal string catenation : error\n");
				 longjmp(parserrbuff, 0);
				};
			 j = flatten(yypvt[-1].intval);
			 i = nodegid(GNATOM, 0, PNULL, PNULL, 0);
			 heap[i].lfld.name = yypvt[-3].string;
			 yyval.intval = node(GCONS, i, j, ISTRING, 0);
			} break;
case 75:
# line 726 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GMOD, i, j, PNULL, 0);
			} break;
case 76:
# line 732 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GDIV, i, j, PNULL, 0);
			} break;
case 77:
# line 738 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GMUL, i, j, PNULL, 0);
			} break;
case 78:
# line 744 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GDIVIDE, i, j, PNULL, 0);
			} break;
case 79:
# line 750 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GPLUS, i, j, PNULL, 0);
			} break;
case 80:
# line 756 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GMINUS, i, j, PNULL, 0);
			} break;
case 81:
# line 762 "yacc.y"
{
			 i = flatten(yypvt[-0].intval);
			 yyval.intval = node(GUMINUS, i, PNULL, PNULL, 0);
			} break;
case 82:
# line 767 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GABS, i, PNULL, PNULL, 0);
			} break;
case 83:
# line 772 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, GREAD, PNULL);
			 heap[yyval.intval].lfld.name = "tty";
			} break;
case 84:
# line 777 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, GREAD, GNUM);
			 heap[yyval.intval].lfld.name = "tty";
			} break;
case 85:
# line 782 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, GREAD, GATOM);
			 heap[yyval.intval].lfld.name = "tty";
			} break;
case 86:
# line 787 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, GREAD, GBOOL);
			 heap[yyval.intval].lfld.name = "tty";
			} break;
case 87:
# line 792 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, GREAD, GLINE);
			 heap[yyval.intval].lfld.name = "tty";
			} break;
case 88:
# line 797 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, GREAD, GLIST);
			 heap[yyval.intval].lfld.name = "tty";
			} break;
case 89:
# line 802 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, GREAD, GCHAR);
			 heap[yyval.intval].lfld.name = "tty";
			} break;
case 90:
# line 807 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, PNULL, GCHAR);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 91:
# line 812 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, PNULL, GLIST);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 92:
# line 817 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, PNULL, GLINE);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 93:
# line 822 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, PNULL, GBOOL);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 94:
# line 827 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, PNULL, GATOM);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 95:
# line 832 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, PNULL, GNUM);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 96:
# line 837 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, PNULL, PNULL);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 97:
# line 843 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, BOTTOM, GCHAR);
			 heap[yyval.intval].lfld.var_offset = var_search(yypvt[-1].string);
			} break;
case 98:
# line 848 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, BOTTOM, GLIST);
			 heap[yyval.intval].lfld.var_offset = var_search(yypvt[-1].string);
			} break;
case 99:
# line 853 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, BOTTOM, GLINE);
			 heap[yyval.intval].lfld.var_offset = var_search(yypvt[-1].string);
			} break;
case 100:
# line 858 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, BOTTOM, GBOOL);
			 heap[yyval.intval].lfld.var_offset = var_search(yypvt[-1].string);
			} break;
case 101:
# line 863 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, BOTTOM, GATOM);
			 heap[yyval.intval].lfld.var_offset = var_search(yypvt[-1].string);
			} break;
case 102:
# line 868 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, BOTTOM, GNUM);
			 heap[yyval.intval].lfld.var_offset = var_search(yypvt[-1].string);
			} break;
case 103:
# line 873 "yacc.y"
{
			 yyval.intval = node(GREAD, PNULL, PNULL, BOTTOM, PNULL);
			 heap[yyval.intval].lfld.var_offset = var_search(yypvt[-1].string);
			} break;
case 104:
# line 878 "yacc.y"
{
			 yyval.intval = node(GWRITE, PNULL, yypvt[-1].intval, GWRITE, 0);
			} break;
case 105:
# line 882 "yacc.y"
{
			 yyval.intval = node(GWRITE, PNULL, yypvt[-1].intval, PNULL, 0);
			 heap[yyval.intval].lfld.name = yypvt[-3].string;
			} break;
case 106:
# line 888 "yacc.y"
{
			 yyval.intval = node(GWRITE, PNULL, yypvt[-1].intval, PNULL, 1);
			 heap[yyval.intval].lfld.var_offset = var_search(yypvt[-3].string);
			} break;
case 107:
# line 893 "yacc.y"
{
			 yyval.intval = yypvt[-1].intval;
			} break;
case 108:
# line 897 "yacc.y"
{
			 yyval.intval = nodenum(GNUM, atoi(yypvt[-0].string), PNULL, PNULL, 0);
			} break;
case 109:
# line 901 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GOR, i, j, PNULL, 0);
			} break;
case 110:
# line 907 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GAND, i, j, PNULL, 0);
			} break;
case 111:
# line 913 "yacc.y"
{
			 i = flatten(yypvt[-0].intval);
			 yyval.intval = node(GNOT, i, PNULL, PNULL, 0);
			} break;
case 112:
# line 918 "yacc.y"
{
			 yyval.intval = nodenum(GTRUE, PTRUE, PNULL, PNULL, 0);
			} break;
case 113:
# line 922 "yacc.y"
{
			 yyval.intval = nodenum(GFALSE, PFALSE, PNULL, PNULL, 0);
			} break;
case 114:
# line 926 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GNULL, i, PNULL, PNULL, 0);
			} break;
case 115:
# line 931 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GNUMBERP, i, PNULL, PNULL, 0);
			} break;
case 116:
# line 936 "yacc.y"
{
			 i = flatten(yypvt[-3].intval);
			 j = flatten(yypvt[-1].intval);
			 yyval.intval = node(GEQ, i, j, PNULL, 0);
			} break;
case 117:
# line 942 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GATOM, i, PNULL, PNULL, 0);
			} break;
case 118:
# line 947 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GLISTP, i, PNULL, PNULL, 0);
			} break;
case 119:
# line 952 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GISBOOL, i, PNULL, PNULL, 0);
			} break;
case 120:
# line 957 "yacc.y"
{
			 i = nodegid(GID, var_search(yypvt[-1].string), PNULL, PNULL, 0);
			 yyval.intval = node(GISVAR, i, PNULL, PNULL, 0);
			} break;
case 121:
# line 962 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GCONSULT, i, PNULL, PNULL, 0);
			} break;
case 122:
# line 967 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GRECONSULT, i, PNULL, PNULL, 0);
			} break;
case 123:
# line 972 "yacc.y"
{
			 i = flatten(yypvt[-1].intval);
			 yyval.intval = node(GSAVE, i, PNULL, PNULL, 0);
			} break;
case 124:
# line 977 "yacc.y"
{
			 yyval.intval = node(GTRACE, PNULL, PNULL, PNULL, 0);
			 heap[yyval.intval].lfld.name = NULL;
			} break;
case 125:
# line 982 "yacc.y"
{
			 yyval.intval = node(GTRACE, PNULL, PNULL, PNULL, 0);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 126:
# line 987 "yacc.y"
{
			 yyval.intval = node(GTRACE, PNULL, PNULL, PNULL, 0);
			 heap[yyval.intval].lfld.name = yypvt[-1].string;
			} break;
case 127:
# line 992 "yacc.y"
{
			 yyval.intval = node(GCPUTIME, PNULL, PNULL, PNULL, 0);
			} break;
case 128:
# line 996 "yacc.y"
{
			 yyval.intval = node(GSHOWTIME, PNULL, PNULL, PNULL, 0);
			} break;
case 129:
# line 1000 "yacc.y"
{
			 i = flatten(yypvt[-3].intval);
			 j = flatten(yypvt[-1].intval);
			 yyval.intval = node(GGREATERP, i, j, PNULL, 0);
			} break;
case 130:
# line 1006 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GGREATERP, i, j, PNULL, 0);
			} break;
case 131:
# line 1012 "yacc.y"
{
			 i = flatten(yypvt[-3].intval);
			 j = flatten(yypvt[-1].intval);
			 yyval.intval = node(GGREATEREQ, i, j, PNULL, 0);
			} break;
case 132:
# line 1018 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GGREATEREQ, i, j, PNULL, 0);
			} break;
case 133:
# line 1024 "yacc.y"
{
			 i = flatten(yypvt[-3].intval);
			 j = flatten(yypvt[-1].intval);
			 yyval.intval = node(GLESSP, i, j, PNULL, 0);
			} break;
case 134:
# line 1030 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GLESSP, i, j, PNULL, 0);
			} break;
case 135:
# line 1036 "yacc.y"
{
			 i = flatten(yypvt[-3].intval);
			 j = flatten(yypvt[-1].intval);
			 yyval.intval = node(GLESSEQ, i, j, PNULL, 0);
			} break;
case 136:
# line 1042 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 j = flatten(yypvt[-0].intval);
			 yyval.intval = node(GLESSEQ, i, j, PNULL, 0);
			} break;
case 137:
# line 1050 "yacc.y"
{
			 i = node(GCONS, PNULL, PNULL, PNULL, 0);
			 k = flatten(yypvt[-0].intval);
			 yyval.intval = node(GCONS, k, i, PNULL, 0);
			} break;
case 138:
# line 1056 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 yyval.intval = node(GCONS, i, yypvt[-0].intval, PNULL, 0);
			} break;
case 139:
# line 1063 "yacc.y"
{
			 k = flatten(yypvt[-0].intval);
			 yyval.intval = node(GWRITE, k, PNULL, PNULL, 0);
			} break;
case 140:
# line 1068 "yacc.y"
{
			 i = flatten(yypvt[-2].intval);
			 yyval.intval = node(GWRITE, i, yypvt[-0].intval, PNULL, 0);
			} break;
case 141:
# line 1076 "yacc.y"
{int l;
			 yyval.intval = yypvt[-2].intval;
			 insert_pt = heap[yyval.intval].auxval;
			 i = node(GEQNODE, yypvt[-0].intval, PNULL, heap[yypvt[-0].intval].auxval,
						      heap[yypvt[-0].intval].eqntype);
			 heap[insert_pt].rptr = i;
			 if (heap[yypvt[-0].intval].tag == GBELONG)
				for (l = 0; l < curr_temp_eqn_slot; l++)
					heap[tempeqn[l]].tag = GBELONG;
			 insert_eqns(insert_pt);
			 heap[yyval.intval].auxval = i;
			 ++num_of_eqns;
			 curr_temp_eqn_slot = 0;
			} break;
case 142:
# line 1091 "yacc.y"
{int l;
			i = node(GEQNODE, yypvt[-0].intval, PNULL, heap[yypvt[-0].intval].auxval,
                                                    heap[yypvt[-0].intval].eqntype);
			k = node(GEQNODE, PNULL, i, PNULL, PNULL);
					/*k is a dummy node to help in insert*/
					/*it can be freed  after  eq'ns  have*/
					/*been inserted.		     */
			++num_of_eqns;
			if (heap[yypvt[-0].intval].tag == GBELONG)
				for (l = 0; l < curr_temp_eqn_slot; l++)
					heap[tempeqn[l]].tag = GBELONG;
			insert_eqns(k);
			curr_temp_eqn_slot = 0;
			yyval.intval = heap[k].rptr;
			heap[yyval.intval].auxval = i;
			} break;
case 143:
# line 1110 "yacc.y"
{
			 x = getfreecell(heap);
			 heap[x].tag = GNATOM;
			 heap[x].lfld.name = yypvt[-0].string;
			 heap[x].rptr = PNULL;
			 heap[x].auxval = PNULL;
			 heap[x].eqntype = 0;
			 yyval.intval = x;
			} break;
case 144:
# line 1122 "yacc.y"
{
			yyval.string = yypvt[-0].string;
			} break;
case 145:
# line 1126 "yacc.y"
{
			yyval.string = yypvt[-0].string;
			} break;
case 146:
# line 1133 "yacc.y"
{
                         x = getfreecell(heap);
                         heap[x].tag = GFUNCALL;
                         heap[x].lfld.name = yypvt[-0].string;
                         heap[x].auxval = hashf(yypvt[-0].string);
                         yyval.intval = x;
                         heap[x].rptr = PNULL;
                         heap[x].eqntype = 0;
			} break;
case 147:
# line 1143 "yacc.y"
{
                         x = getfreecell(heap);
                         heap[x].tag = GFUNCALL;
                         heap[x].lfld.name = yypvt[-0].string;
                         heap[x].auxval = hashf(yypvt[-0].string);
                         yyval.intval = x;
                         heap[x].rptr = PNULL;
                         heap[x].eqntype = 0;
                        } break;
case 148:
# line 1155 "yacc.y"
{
			 yyval.intval = flatten(yypvt[-0].intval);
			} break;
case 149:
# line 1161 "yacc.y"
{
			 num_of_actuals = ++heap[yypvt[-0].intval].eqntype;
			 yyval.intval = node(GACTUAL, yypvt[-2].intval, yypvt[-0].intval, PNULL, num_of_actuals);
			} break;
case 150:
# line 1166 "yacc.y"
{
			 num_of_actuals = 1;
			 i = flatten(yypvt[-0].intval);
			 yyval.intval = node(GACTUAL, i, PNULL, PNULL, num_of_actuals);
				/*the 5th field is used to compute */
				/*the no. of actuals by passing up */
			} break;
	}
	goto yystack;		/* reset registers in driver code */
}
