/*lhs and rhs are pointers to the lhs and */
/*the rhs of the equation respectively,   */
/*envl & envr are the environments of the */
/*lhs and rhs side, respectively. 	  */

/*ffail changed to a macro*/

int ffail()
{ register fstkptrtype x;
  register int soptr;
  register int i;
  if (failflag == PFALSE)
	{ failflag = PTRUE;
	  /*printf("ffail called\n");*/
	      /*backtrack: take all the backtrack actions*/ 
        x = currenv = top_fstk = mrb;       /*go to the most recent bktrk pt*/
        if (x != BOTTOM)
           {
            next_candidate =  fstk_nc(x);   /*get the next_candidate address*/
            parent_frame = fstk_par_ptr(x); /*get the parent frame pointer*/
            restart_eqn = fstk_call_eqn(x);
                                            /*get the calling equation no.*/
            for (i = fstk_tp(x) ; i < trail_top; i++)
                 { int v;
				/*mixing of types for trailstack*/
				/*Since Equation trail stack and*/
				/*variable trail stack are identical*/
                   v = trailstk[i];
		   if (v >= 0)		/*v is a var address on varstack*/
                       var_cell_type(v) = UNBOUND;
		   else		/*v is an equation address on delay stack*/
			sop_done(-v) = '0';
			
                 };
                       /* unbind all  the  variables  which  lie  between*/
                       /* trail_top - 1  & trail_base which is in fstk_tp*/
            trail_top = fstk_tp(x);         /*restore the trail_top.*/
	    read_ptr = fstk_rdptr(x);	    /*restore the read  ptr.*/
	    writest_top = fstk_wrptr(x);    /*restore the write ptr.*/
	    sopstk_top = fstk_sopptr(x);    /*restore the sopstk_ptr*/
/*
	    if (sopstk_top > 0)
		for(soptr = 0; soptr < sopstk_top; soptr++)
		     sop_done(soptr) = '0';
*/
	    if (fstk_bp(x) < BOTTOM)	    /*decode the if  frame.*/
	       {			    /*subtle control here!!*/
		do_else = PTRUE;
		mrb = (-1) * (fstk_bp(x) + 10);
	       }
	    else
	       {
                varstk_top = fstk_data(x);  /*release all the cells allocated*/
            	mrb = fstk_bp(x);           /*update the mrb*/
	       };
	  };
        };
}

#include "arith.h"
#include "bool.h"
#include "io.h"

int fidcons(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{register varstkptrtype	i;
 auto struct molecule *cptr;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GCONS)
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	i = envl + heap_offs(lhs);
        while (PTRUE)
	  switch (var_cell_type(i))
	    {
	     case UNBOUND 	:
  	 	    if (next_mol->next != NULL)
        		    {cptr = next_mol;
         		     next_mol = next_mol->next;
        		     }
  		     else  		/*Out of molecules so allocate more*/
        		    {struct molecule *molptr; int jj;
			     molptr = (struct molecule *)
                                          calloc(2000, sizeof(struct molecule));
         		     for(jj = 0; jj < 1999; jj++)
                		     molptr[jj].next = molptr + jj + 1;
                              		        /*next  field  points  to*/
						/*next entry in the array*/
         		     molptr[1999].next = NULL;
         		     next_mol->next = molptr;
         		     molptr = next_mol;
         		     next_mol = next_mol->next;
         		     cptr = molptr;
        		    };
		 cptr->code_ptr = rhs;
		 cptr->env_ptr  = envr;
		 var_cell_type(i) = CONSTYPE;
		 var_cell_data_cons(i) = cptr;
		 if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		 return;
		 break;
	     case  VARTYPE	:
		 while (var_cell_type(i) == VARTYPE)
			{
			 /*envl = var_cell_env(i);*/
			 i = var_cell_data_var(i);
			};
		 break;
	     case  CONSTYPE	:
		 (*action_array[ACONSCONS])
				(var_cell_data_cons(i)->env_ptr, envr,
				 var_cell_data_cons(i)->code_ptr, rhs);
		 return;
		 break;
	     default		:	/*types are unequal so fail*/
		 ffail();
		 return;
		 break;
	    };
}


int fidnum(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{register varstkptrtype	i;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GNUM)
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	i = envl+ heap_offs(lhs);
        while (PTRUE)
	  switch (var_cell_type(i))
	    {
	     case UNBOUND 	:
		 var_cell_type(i) = INTTYPE;
		 var_cell_data_int(i) = heap_numb(rhs);
		 if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		 return;
		 break;
	     case  VARTYPE	:
		 while (var_cell_type(i) == VARTYPE)
			{
			 /*envl = var_cell_env(i);*/
			 i = var_cell_data_var(i);
			};
		 break;
	     case  INTTYPE	:
		 if (var_cell_data_int(i) != heap_numb(rhs))
			ffail();
			/*else if they are equal then the equation is	*/
			/*solved so do nothing and simply come out.	*/
		 return;
		 break;
	     default		:	/*types are unequal so fail*/
		 ffail();
		 return;
		 break;
	    };
}

int fidatom(envl, envr, lhs, rhs)
register varstkptrtype envl, envr; 
register cellptrtype lhs, rhs;

{register varstkptrtype	i;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GNATOM)
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	i = envl + heap_offs(lhs);
        while (PTRUE)
	  switch (var_cell_type(i))
	    {
	     case UNBOUND 	:
		 var_cell_type(i) = ATOMTYPE;
		 var_cell_data_atom(i) = heap_name(rhs);
		 if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		 return;
		 break;
	     case  VARTYPE	:
		 while (var_cell_type(i) == VARTYPE)
			{
			 /*envl = var_cell_env(i);*/
			 i = var_cell_data_var(i);
			};
		 break;
	     case  ATOMTYPE	:
		 if (strcmp(var_cell_data_atom(i), heap_name(rhs)))
			ffail();
			/*else if they are equal then the equation is	*/
			/*solved so do nothing and simply come out.	*/
		 return;
		 break;
	     default		:	/*types are unequal so fail*/
		 ffail();
		 return;
		 break;
	    };
}


int fidid(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{register varstkptrtype	i1, i2;

	i1 = envl + heap_offs(lhs);
 	while (var_cell_type(i1) == VARTYPE)
		{
		 /*envl = var_cell_env(i1);*/
		 i1 = var_cell_data_var(i1);
		};
	i2 = envr + heap_offs(rhs);
	while (var_cell_type(i2) == VARTYPE)
		{
		 /*envr = var_cell_env(i2);*/
		 i2 = var_cell_data_var(i2);
		};
      if (i2 != i1)
        while (PTRUE)
	  switch (var_cell_type(i1))
	    {
	     case UNBOUND 	:
		 if (var_cell_type(i2) != UNBOUND)
		      var_cell(i1) = var_cell(i2);	
		 else		/*both i1 and i2 are unbound*/
		     {
		      var_cell_type(i1) = VARTYPE;
		      var_cell_data_var(i1) = i2;
		      /*var_cell_env(i1) = envr;*/
		     }
		 if (i1 < fstk_data(mrb)) trailstk[trail_top++] = i1;
		 return;
		 break;
/*
	     case  VARTYPE	:
		 while (var_cell_type(i1) == VARTYPE)
			{
			 envl = var_cell_env(i1);
			 i1 = var_cell_data_var(i1);
			};
		 break;
*/
	     default		:	
/*
		 if (var_cell_type(i2) == VARTYPE)
		 	while (var_cell_type(i2) == VARTYPE)
			        {
			 	 envr = var_cell_env(i2);
                        	 i2 = var_cell_data_var(i2);
				};
*/
		 if (var_cell_type(i2) == UNBOUND)
			{
			 var_cell(i2) = var_cell(i1);
		 	 if (i2 < fstk_data(mrb)) trailstk[trail_top++] = i2;
			}
		 else	
			       /*reach here only if both i1 and */
			       /*i2 are bound to  ground  terms.*/
		     if ((var_cell_type(i1) == var_cell_type(i2)) &&
			 ((*value_comp_fn[var_cell_type(i1)]) (i1, i2)));
		     else
		 	ffail();
		 return;
		 break;
	    };
}

int fatomatom(envl, envr, lhs, rhs)
varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{ if (strcmp(heap_name(lhs), heap_name(rhs)))
	ffail();
}

int fnumnum(envl, envr, lhs, rhs)
varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{ if(heap_numb(lhs) != heap_numb(rhs))
	ffail();
}

int fsuccess(envl, envr, lhs, rhs)
varstkptrtype envl, envr;
cellptrtype lhs, rhs;

{
	/*success function is a no op*/
}

int fconscons(envl, envr, lhs, rhs)
varstkptrtype envl, envr;
cellptrtype lhs, rhs;
 
{short int a_no;
 cellptrtype ustack[41];        /*small pushdown stack for unification.*/
 register cellptrtype p, q, lhs1, rhs1;
 register short int utop;                /*utop is the stack pointer for ustack.*/
                                /*It always points to  the  last  full */
                                /*location on the ustack.              */
 
ustack[0] = lhs;                        /*push lhs*/
ustack[1] = rhs;                        /*push rhs*/
utop = 1;
while ((utop > 0) && (failflag == PFALSE))   /*continue unifying only if succ*/
        { rhs1 = ustack[utop--]; 
          lhs1 = ustack[utop--]; 
	  p = heap_lptr(lhs1);
	  q = heap_lptr(rhs1);
          if ((heap_tag(lhs1) == GCONS) && (heap_tag(rhs1) == GCONS))
             if (p == PNULL) 
		 if (q == PNULL)
                    ;     /*both lhs1 and rhs1 are empty lists so do nothing*/
		 else ffail();			/*q is nonempty, p is empty*/
             else
		   if (q == PNULL)
			ffail();		/*p is nonempty, q is empty*/
                   else				/*both p and q are nonempty*/
		       {
			ustack[++utop] = heap_rptr(lhs1);
                   	ustack[++utop] = heap_rptr(rhs1);
                   	ustack[++utop] = p;
                   	ustack[++utop] = q;
		       }
 	  else 
	     { 
	       a_no = find_eqn_type(lhs1, rhs1);
	       (*action_array[a_no])(envl, envr, lhs1, rhs1);
	     };
        };
}


int ffuncall(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;
{struct fn_hash_cell *f, *nc;
 auto cellptrtype tempcellptr, eqp, cp;
 auto varstkptrtype tempfptr; 
 auto fstkptrtype   callenv;
 auto short int last_call, isspycall = PFALSE;
 auto varstkptrtype base;
 struct spycell *spyp;
 register cellptrtype actual_arg, first_act_arg;
 auto cellptrtype nc_farg, first_nc_farg;
	if (heap_tag(rhs) == GFUNCALL)		/*fn call always on left.*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	actual_arg = heap_rptr(lhs);		/*PNULL for 0-ary fn.*/
	if (actual_arg != PNULL) 
		first_act_arg = heap_lptr(actual_arg);
	if (failflag == PFALSE)
	      {
		f = get_fn_cell(heap_auxv(lhs) % FNTABSIZE, 
				  heap_auxv(lhs) / FNTABSIZE, heap_name(lhs));
				/* heap_auxv(lhs) % F is bucket  number.*/
				/* heap_eqnt(lhs) / F is number of args.*/
				/* heap_name(lhs)  is  name  of  the fn.*/
		if ((f == NULL) && (heap_eqnt(lhs) != PNULL))
		   {
		    base = fstk_data(currenv) + heap_eqnt(lhs);
		    while (var_cell_type(base) == VARTYPE)
			base = var_cell_data_var(base);
		    if (var_cell_type(base) == ATOMTYPE) 
			f = get_fn_cell(hashf(var_cell_data_atom(base)),
					 heap_auxv(lhs) / FNTABSIZE, 
					 var_cell_data_atom(base));
		    else f = NULL;
		   };
		if (f == NULL)
	               printf("undefined function %s/%d : failing\n", 
				    heap_name(lhs), heap_auxv(lhs)/FNTABSIZE);
			/*check if f would unify with top level functor*/
		if (f != NULL)
			{ nc_farg = f->fn_args_ptr;
			  first_nc_farg = heap_lptr(nc_farg);};
				/*Note: no need to do clause indexing*/
				/*for zero-ary functions.*/
		while ((f != NULL)  && (actual_arg != PNULL) && 
					/*actual_arg is PNULL for 0-ary fn.*/
   			(clause_index(envl, first_nc_farg, first_act_arg)
				== PFALSE)) 
		   { 
		     if (f->lastdef == 1)		/*No next candidate */
			f = NULL;
		     else
		        {
		  	  f = f->next_candidate;
			  nc_farg = f->fn_args_ptr;
			  first_nc_farg = heap_lptr(nc_farg);
		        };
		   };
		if (f != NULL)
		   {
		    if ((spyflag == PTRUE) && (debug == PFALSE))
			{ spyp = spyptr->next;
			  while (spyp != NULL)
			    if (!strcmp(spyp->fname, f->funcname))
				{ debug = PTRUE; 
				  isspycall = PTRUE;
				  break;
				}
			    else  spyp = spyp->next;
			};
		    if (debug == PTRUE) 
		         printf("trying %s at frame ", f->funcname); 
		   };
	      }
	else
	      {	f = next_candidate;
			/*if failflag is set then backtrack-*/
			/*ing has occured on this  function.*/
		failflag = PFALSE;	
			/*start backtracking and reset failflag*/
		    /*VERY SUBTLE CONTROL HERE. TAKE CARE*/
		if (f != NULL)
		   {
		    if ((spyflag == PTRUE) && (debug == PFALSE))
			{ spyp = spyptr->next;
			  while (spyp != NULL)
			    if (!strcmp(spyp->fname, f->funcname))
				{ debug = PTRUE; 
				  isspycall = PTRUE;
				  break;
				}
			    else  spyp = spyp->next;
			};
		    if (debug == PTRUE)
		         printf("retrying %s at frame ", f->funcname); 
		   };
	      };
	if (f == NULL) 
		ffail();	/*If no such fn is defined then fail*/
	else
		{ 
		  if (f->lastdef == 1)		/*No next candidate */
			nc = NULL;
		  else
		      {
		  	nc = f->next_candidate;
			nc_farg = nc->fn_args_ptr;
			first_nc_farg = heap_lptr(nc_farg);
		      };
		  while ((nc != NULL)  && (actual_arg != PNULL) &&
					/*actual_arg is PNULL for 0-ary fn.*/
			 (clause_index(envl, first_nc_farg, first_act_arg)
				== PFALSE)) 
					/*envl is env of actuals*/
			{
		  	 if (nc->lastdef == 1)		/*No next candidate */
			 	 nc = NULL;
		  	 else
			      {
		  		 nc = nc->next_candidate;
				 nc_farg = nc->fn_args_ptr;
				 first_nc_farg = heap_lptr(nc_farg);
			      };
		         }; 
		  eqp = heap_rptr(f->fn_body);
		  callenv = varstk_top;
				   /*callenv is the new frame added*/
		  cp = fstk_eqp(currenv);
		  if (cp != BOTTOM)
				/*check if we are solving the last equation*/
			 if ((fstk_intro_rhs(currenv) == PNULL) &&
				    /*if inroduced equation is already solved*/
				  (cp == PNULL) && 
					/*and we're solving the last eqn*/
 /*< changed to <= 8/3/87*/	      (mrb <= currenv) && (nc == NULL))
					 	/*and LEO can be done*/
			   { modify_caller_frame(eqp, f->num_of_vars,
                                                heap_lptr(f->fn_body), rhs,
                                                envr);
                                        /*overwrite the caller frame for LEO*/
                                        /*currenv is the frame to be overwr.*/
                             last_call = PTRUE;
                           }
			else
			   {
		            push_on_fstk(eqp,nc,f->num_of_vars,heap_lptr(f->fn_body),rhs,envr,currenv,current_eqnl,isbelong,(nc != NULL));
				   /*currenv is  parent  frame  of  callenv.*/
				   /*Note: push_on_fstk  increments top_fstk*/
				   /*and the top of data stack (varstk_top).*/
				   /*Last parameter is equation to be solved*/
				   /*on   returning  to  the  parent  frame.*/
				   /*isbelong tells if the frame corresponds*/
				   /*to a <- equation. isbelong is a  global*/
				   /*variable set by execute.		    */ 
			    last_call = PFALSE;
			   }
				/*< changed to <= 8/3/87*/
		  else if ((mrb <= currenv) && (nc == NULL))
				/*caller and callee arn't bktrk pt so do LEO*/
			 {  
			   modify_caller_frame(eqp, f->num_of_vars, 
						heap_lptr(f->fn_body), rhs, 
						envr);
					/*overwrite the caller frame for LEO*/
				   	/*currenv is the frame to be overwr.*/
			   last_call = PTRUE;
			 }
		       else
			   {
		            push_on_fstk(eqp,nc,f->num_of_vars,heap_lptr(f->fn_body),rhs,envr,currenv,current_eqnl,isbelong,(nc != NULL));
				   /*currenv is  parent  frame  of  callenv.*/
				   /*Note: push_on_fstk  increments top_fstk*/
				   /*and the top of data stack (varstk_top).*/
				   /*Last parameter is equation to be solved*/
				   /*on   returning  to  the  parent  frame.*/
			   last_call = PFALSE;
			  };
	 	  if (debug == PTRUE)
			if (last_call == PFALSE) 
			        printf("%d with : ", top_fstk - 1); 
			else
			        printf("%d with : ", currenv); 
		  unify_params(envl, callenv, actual_arg, f->fn_args_ptr);
				   /*actual_arg     is  the list of actuals*/
				   /*f->fn_args_ptr is  the  list of formals*/
				   /*envl is the environment of the actuals*/
		  		   /*callenv is  the  env't of  the formals*/
			/*unify_params unifies the formals and actuals*/
		  if (failflag == PFALSE) 	/*i.e. Unification succeeds*/
			if (last_call == PFALSE)
			  	currenv = top_fstk - 1;
		  if (isspycall == PTRUE)
		      { debug = PFALSE;	
			fstk_trace(currenv) = PTRUE;
		      };
		};
}

/*clause_index does clause indexing*/

int
clause_index(actualenv, formal_1st_arg, actual_1st_arg)
register varstkptrtype 	actualenv;
register cellptrtype 	formal_1st_arg, actual_1st_arg;
{cellptrtype p, q, r, s;
 varstkptrtype offset;
	switch (heap_tag(formal_1st_arg))
	   {
	     case GCONS	:
		  switch (heap_tag(actual_1st_arg))
		    {
			/* OLDCODE: only top level functor matched
		      case GCONS : 
			 if (((heap_lptr(formal_1st_arg) == PNULL) &&
			      (heap_lptr(actual_1st_arg) != PNULL)) ||
			     ((heap_lptr(formal_1st_arg) != PNULL) &&
			      (heap_lptr(actual_1st_arg) == PNULL)))  
			 	return(PFALSE);
			 else return(PTRUE);
			 break;*/
			/* END OLDCODE*/
		      case GCONS : 
			 r = heap_lptr(formal_1st_arg);
			 s = heap_lptr(actual_1st_arg);
			 if (r != PNULL)
			      if (s == PNULL) 
				    return(PFALSE);
						/*[] versus non null*/
			      else 	/*match 1st elem. of the 2 conses*/
				 if ((heap_tag(r) == GCONS) && 
						(heap_tag(s) == GCONS)) 
			   	           if (((heap_lptr(r) == PNULL) &&
                                                (heap_lptr(s) != PNULL)) ||
                                               ((heap_lptr(r) != PNULL) &&
                                                (heap_lptr(s) == PNULL)))
                                                     return(PFALSE);
				           else return(PTRUE);
				 else
					   return(clause_index(actualenv, 
								r, s));
			 else if (s == PNULL)
				  return(PTRUE);
			      else return(PFALSE);
			 break;
		      case GID	: 
			offset = actualenv + heap_offs(actual_1st_arg);
					/*get offset of the var on varstk*/
			while (var_cell_type(offset) == VARTYPE)
				offset = var_cell_data_var(offset);
			if (var_cell_type(offset) == UNBOUND) return(PTRUE);
			/*OLDCODE begin
			if (var_cell_type(offset) == CONSTYPE) 
				{ p = var_cell_data_cons(offset)->code_ptr;
				  if (((heap_lptr(formal_1st_arg) == PNULL) &&
				       (heap_lptr(p) != PNULL)) || 
				      ((heap_lptr(formal_1st_arg) != PNULL) &&
				       (heap_lptr(p) == PNULL))) 
				  	return(PFALSE);
				  else return(PTRUE);
				}
			else return(PFALSE); OLDCODE END*/
			if (var_cell_type(offset) == CONSTYPE) 
			   { p = var_cell_data_cons(offset)->code_ptr;
			     s = heap_lptr(p);
			     r = heap_lptr(formal_1st_arg);
			     if (r != PNULL) 
			       if (s == PNULL)
				     return(PFALSE); 
						/*[] versus non null*/
			       else 	/*match 1st elem. of the 2 conses*/
				 if ((heap_tag(r) == GCONS) && 
							(heap_tag(s) == GCONS))
			   	           if (((heap_lptr(r) == PNULL) &&
                                                (heap_lptr(s) != PNULL)) ||
                                               ((heap_lptr(r) != PNULL) &&
                                                (heap_lptr(s) == PNULL)))
                                                     return(PFALSE);
				           else return(PTRUE);
				 else
				   return(clause_index(var_cell_data_cons(offset)->env_ptr, r, s));
			     else if (s == PNULL)
				        return(PTRUE);
			          else return(PFALSE);
			   }
			else return(PFALSE);
			break;
		     default : 
			return(PFALSE);
			break;
		    };
		 break;
	    case GNUM	:
		 switch (heap_tag(actual_1st_arg))
		    {
		     case GNUM	:
			  if (heap_numb(actual_1st_arg) 
					!= heap_numb(formal_1st_arg))	
				return(PFALSE);
			  else  return(PTRUE);
			  break;
		     case GID	:
			  offset = actualenv + heap_offs(actual_1st_arg);
                                        /*get offset of the var on varstk*/
                          while (var_cell_type(offset) == VARTYPE)
                                offset = var_cell_data_var(offset);
                          if (var_cell_type(offset) == UNBOUND) return(PTRUE);
                          if ((var_cell_type(offset) == INTTYPE) &&
				  (var_cell_data_int(offset) 
                                        == heap_numb(formal_1st_arg))) 
			       return(PTRUE);
			  else return(PFALSE);
			  break;
		     default	:
			  return(PFALSE);
			  break;
		    };
		 break;
	    case GNATOM	:
		 switch (heap_tag(actual_1st_arg))
		    {
		     case GNATOM	:
			  if (strcmp(heap_name(actual_1st_arg), 
					 heap_name(formal_1st_arg)))	
				return(PFALSE);
			  else  return(PTRUE);
			  break;
		     case GID	:
			  offset = actualenv + heap_offs(actual_1st_arg);
                                        /*get offset of the var on varstk*/
                          while (var_cell_type(offset) == VARTYPE)
                                offset = var_cell_data_var(offset);
                          if (var_cell_type(offset) == UNBOUND) return(PTRUE);
                          if ((var_cell_type(offset) == ATOMTYPE) &&
				  (!strcmp(var_cell_data_atom(offset), 
                                         heap_name(formal_1st_arg)))) 
			       return(PTRUE);
			  else return(PFALSE);
			  break;
		     default	:
			  return(PFALSE);
			  break;
		    };
		 break;
	    default	:
		 return(PTRUE);
		 break;
	   };   
}

int fidtrue(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{register varstkptrtype	i;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GTRUE)
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	i = envl+ heap_offs(lhs);
        while (PTRUE)
	  switch (var_cell_type(i))
	    {
	     case UNBOUND 	:
		 var_cell_type(i) = TRUETYPE;
		 var_cell_data_bool(i) = PTRUE;
		 if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		 return;
		 break;
	     case  VARTYPE	:
		 while (var_cell_type(i) == VARTYPE)
			{
			 /*envl = var_cell_env(i);*/
			 i = var_cell_data_var(i);
			};
		 break;
	     case  TRUETYPE	:
			/*else if they are equal then the equation is	*/
			/*solved so do nothing and simply come out.	*/
		 return;
		 break;
	     default		:	/*types are unequal so fail*/
		 ffail();
		 return;
		 break;
	    };
}

int fidfalse(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{register varstkptrtype	i;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GFALSE)
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	i = envl+ heap_offs(lhs);
        while (PTRUE)
	  switch (var_cell_type(i))
	    {
	     case UNBOUND 	:
		 var_cell_type(i) = FALSTYPE;
		 var_cell_data_bool(i) = PFALSE;
		 if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		 return;
		 break;
	     case  VARTYPE	:
		 while (var_cell_type(i) == VARTYPE)
			{
			 /*envl = var_cell_env(i);*/
			 i = var_cell_data_var(i);
			};
		 break;
	     case  FALSTYPE	:
			/*else if they are equal then the equation is	*/
			/*solved so do nothing and simply come out.	*/
		 return;
		 break;
	     default		:	/*types are unequal so fail*/
		 ffail();
		 return;
		 break;
	    };
}

int fwritewrite(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct writest_cell *out1, *out2;
	if (heap_auxv(lhs) == PNULL)		/*write without bktrk*/
		out1 = fwrite(lhs, envl);
	else out1 = fbwrite(lhs, envl);
	if (heap_auxv(rhs) == PNULL)		/*write without bktrk*/
		out2 = fwrite(rhs, envr);
	else out2 = fbwrite(rhs, envr);
	if (out1->type != out2->type)
		ffail();
	else if (out1->type == INTTYPE)
		    if (out1->data.num == out2->data.num); else ffail();
	     else
	        if (out1->type == ATOMTYPE)
		    if (!strcmp(out1->data.string, out2->data.string));
		        else ffail();
		else
		   if (out1->type == CONSTYPE)
			fconscons((out1->data.mol)->env_ptr,
			          (out2->data.mol)->env_ptr,
			          (out1->data.mol)->code_ptr,
			          (out2->data.mol)->code_ptr);
}

int freadread(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct readst	*rdval1, *rdval2;
	if (heap_auxv(lhs) == PNULL)		/*read without bktrk*/
		rdval2 = fread(lhs, envl);
	else rdval2 = fbread(lhs, envl);
	if (rdval2 == NULL) {ffail(); return;};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		rdval1 = fread(rhs, envr);
	else rdval1 = fbread(rhs, envr);
	if (rdval1 == NULL) {ffail(); return;};
	if (rdval1->typefld != rdval2->typefld)
		ffail();
	else
	    if(rdval1->typefld == INTTYPE)		/*both are numbers*/
			{if(rdval1->valfld.numval != rdval2->valfld.numval)
				ffail();}
	    else if (rdval1->typefld == CONSTYPE)
			 fconscons(envl, envr, rdval2->valfld.listval,
					       rdval1->valfld.listval);
	         else
		     if (strcmp(rdval1->valfld.atomval, rdval2->valfld.atomval))
				ffail();
}
	
int freadwrite(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct readst	*rdval;
 struct writest_cell *wrval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GREAD)	/*write on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		rdval = fread(rhs, envr);
	else rdval = fbread(rhs, envr);
	if (rdval == NULL) {ffail(); return;};
	if (heap_auxv(lhs) == PNULL)		/*write without bktrk*/
		 wrval = fwrite(lhs, envl);
	else wrval = fbwrite(lhs, envl);
	if (rdval->typefld != wrval->type)
		ffail();
	else
	    if(rdval->typefld == INTTYPE)		/*both are numbers*/
			{if(rdval->valfld.numval != wrval->data.num)
				ffail();}
	    else if (rdval->typefld == CONSTYPE)
			 fconscons(envr, (wrval->data.mol)->env_ptr, 
				               rdval->valfld.listval,
					       (wrval->data.mol)->code_ptr);
	         else
		     if (strcmp(rdval->valfld.atomval, wrval->data.string))
				ffail();
}

int fconsread(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct readst	*rdval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GREAD)	/*cons on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		rdval = fread(rhs, envr);
	else rdval = fbread(rhs, envr);
	if (rdval == NULL) {ffail(); return;};
	if (rdval->typefld == CONSTYPE) 
	    	fconscons(envl, envr, lhs, rdval->valfld.listval);
	else 
	        ffail();
}

int fconswrite(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct writest_cell *wrval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GWRITE)	/*cons on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		wrval = fwrite(rhs, envr);
	else wrval = fbwrite(rhs, envr);
	if (wrval->type == UNBOUND) return;
	if (wrval->type == CONSTYPE) 
	    	fconscons(envl, (wrval->data.mol)->env_ptr, 
			  lhs,  (wrval->data.mol)->code_ptr);
	else 
	        ffail();
}

int fboolread(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct readst	*rdval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GREAD)	/*bool on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		rdval = fread(rhs, envr);
	else rdval = fbread(rhs, envr);
	if (rdval == NULL) {ffail(); return;};
	if (heap_tag(lhs) == GTRUE)
	       {if (rdval->typefld != TRUETYPE) 
	       	       ffail();}
	else if (rdval->typefld != FALSTYPE)
		ffail();
}

int fboolwrite(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct writest_cell *wrval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GWRITE)	/*bool on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		wrval = fwrite(rhs, envr);
	else wrval = fbwrite(rhs, envr);
	if (wrval->type == UNBOUND) return;
	if (heap_tag(lhs) == GTRUE)
	       {if (wrval->type != TRUETYPE) 
	       	       ffail();}
	else if (wrval->type != FALSTYPE)
		ffail();
}


int fnumread(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct readst	*rdval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GREAD)	/*number on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		rdval = fread(rhs, envr);
	else rdval = fbread(rhs, envr);
	if (rdval == NULL) {ffail(); return;};
	if ((rdval->typefld == INTTYPE) && 
			(heap_numb(lhs) == rdval->valfld.numval));
	else
		ffail();
}

int fnumwrite(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct writest_cell *wrval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GWRITE)	/*number on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		wrval = fwrite(rhs, envr);
	else wrval = fbwrite(rhs, envr);
	if (wrval->type == UNBOUND) return;
	if ((wrval->type == INTTYPE) && 
			(heap_numb(lhs) == wrval->data.num));
	else
		ffail();
}


int fatomread(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct readst	*rdval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GREAD)	/*atom on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		rdval = fread(rhs, envr);
	else rdval = fbread(rhs, envr);
	if (rdval == NULL) {ffail(); return;};
	if ((rdval->typefld == ATOMTYPE) && 
			(!strcmp(heap_name(lhs), rdval->valfld.atomval)));
	else
		ffail();
}

int fatomwrite(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{struct writest_cell *wrval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GWRITE)	/*atom on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		wrval = fwrite(rhs, envr);
	else wrval = fbwrite(rhs, envr);
	if (wrval->type == UNBOUND) return;
	if ((wrval->type == ATOMTYPE) && 
			(!strcmp(heap_name(lhs), wrval->data.string)));
	else
		ffail();
}


int fidread(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{register varstkptrtype	i;
 auto struct molecule *cptr;
 struct readst	*rdval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GREAD)	/*id on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	i = envl+ heap_offs(lhs);
	if (heap_auxv(rhs) == PNULL)		/*read without bktrk*/
		rdval = fread(rhs, envr);
	else rdval = fbread(rhs, envr);
	if (rdval == NULL) {ffail(); return;};
        while (PTRUE)
	  switch (var_cell_type(i))
	    {
	     case UNBOUND 	:
		 var_cell_type(i) = rdval->typefld;
		 switch (rdval->typefld) {
			case ATOMTYPE	:
				var_cell_data_atom(i) = rdval->valfld.atomval;
				break;
			case INTTYPE	:
				var_cell_data_int(i) = rdval->valfld.numval;
			 	break;
			case FALSTYPE 	:
		 		var_cell_data_bool(i) = PFALSE;
				break;
			case TRUETYPE 	:
		 		var_cell_data_bool(i) = PTRUE;
				break;
			case CONSTYPE   :
				if (next_mol->next != NULL)
                              	    {cptr = next_mol;
                               	    next_mol = next_mol->next;
                               	    }
                       	        else     /*Out of molecules so allocate more*/
                                  {struct molecule *molptr;
                                   molptr = (struct molecule *)
                                          calloc(2000, sizeof(struct molecule));
                                   for(i = 0; i < 1999; i++)
                                        molptr[i].next = molptr + i + 1;
                                                /*next  field  points  to*/
                                                /*next entry in the array*/
                                   molptr[1999].next = NULL;
                                   next_mol->next = molptr;
                                   molptr = next_mol;
                                   next_mol = next_mol->next;
                                   cptr = molptr;
                                  };
                  	        cptr->code_ptr = rdval->valfld.listval;
                 		cptr->env_ptr  = envr;
                 		var_cell_data_cons(i) = cptr;
                 		break;
			default		:
				printf("Internal Error : panic\n");
				longjmp(execbuff, 0);
				break;
		      }
		 if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		 return;
		 break;
	     case  VARTYPE	:
		 while (var_cell_type(i) == VARTYPE)
			{
			 /*envl = var_cell_env(i);*/
			 i = var_cell_data_var(i);
			};
		 break;
	     case  INTTYPE	:
		 if ((rdval->typefld != INTTYPE) || 
			(var_cell_data_int(i) != rdval->valfld.numval))
			ffail();
		 return;
		 break;
	     case  ATOMTYPE	:
		 if ((rdval->typefld != ATOMTYPE) ||
			(strcmp(rdval->valfld.atomval, var_cell_data_atom(i))))
				ffail();
		 return;
		 break;
	    case   CONSTYPE	:
		 if (rdval->typefld == CONSTYPE) 
			fconscons(var_cell_data_cons(i)->env_ptr, envr,
                                  var_cell_data_cons(i)->code_ptr, 
				  rdval->valfld.listval);
		 else ffail();
		 return;
		 break;
	     case  TRUETYPE	:
		 if (rdval->typefld != TRUETYPE)
			ffail();
		 return;
		 break;
	     case  FALSTYPE	:
		 if (rdval->typefld != FALSTYPE)
			ffail();
		 return;
		 break;
	     default		:	
		 printf("Internal Error : panic\n");
		 longjmp(execbuff, 0);
		 break;
	    };
}


int fidwrite(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{register varstkptrtype	i;
 auto struct molecule *cptr;
 struct writest_cell *wrval;
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
	if (heap_tag(lhs) == GWRITE)	/*id on the left*/
		{ tempcellptr = rhs;
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	i = envl+ heap_offs(lhs);
	if (heap_auxv(rhs) == PNULL)		/*write without bktrk*/
		wrval = fwrite(rhs, envr);
	else wrval = fbwrite(rhs, envr);
	if (wrval->type == UNBOUND) return;
        while (PTRUE)
	  switch (var_cell_type(i))
	    {
	     case UNBOUND 	:
		 var_cell_type(i) = wrval->type;
		 switch (wrval->type) {
			case ATOMTYPE	:
				var_cell_data_atom(i) = wrval->data.string;
				break;
			case INTTYPE	:
				var_cell_data_int(i) = wrval->data.num;
			 	break;
			case FALSTYPE 	:
		 		var_cell_data_bool(i) = PFALSE;
				break;
			case TRUETYPE 	:
		 		var_cell_data_bool(i) = PTRUE;
				break;
			case CONSTYPE   :
				if (next_mol->next != NULL)
                              	    {cptr = next_mol;
                               	    next_mol = next_mol->next;
                               	    }
                       	        else     /*Out of molecules so allocate more*/
                                  {struct molecule *molptr;
                                   molptr = (struct molecule *)
                                          calloc(2000, sizeof(struct molecule));
                                   for(i = 0; i < 1999; i++)
                                        molptr[i].next = molptr + i + 1;
                                                /*next  field  points  to*/
                                                /*next entry in the array*/
                                   molptr[1999].next = NULL;
                                   next_mol->next = molptr;
                                   molptr = next_mol;
                                   next_mol = next_mol->next;
                                   cptr = molptr;
                                  };
                 		var_cell_data_cons(i) = wrval->data.mol;
                 		break;
			default		:
				printf("Internal Error : panic\n");
				longjmp(execbuff, 0);
				break;
		      }
		 if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		 return;
		 break;
	     case  VARTYPE	:
		 while (var_cell_type(i) == VARTYPE)
			 i = var_cell_data_var(i);
		 break;
	     case  INTTYPE	:
		 if ((wrval->type != INTTYPE) || 
			(var_cell_data_int(i) != wrval->data.num))
			ffail();
		 return;
		 break;
	     case  ATOMTYPE	:
		 if ((wrval->type != ATOMTYPE) ||
			(strcmp(wrval->data.string, var_cell_data_atom(i))))
				ffail();
		 return;
		 break;
	    case   CONSTYPE	:
		 if (wrval->type == CONSTYPE) 
			fconscons(var_cell_data_cons(i)->env_ptr, 
				  (wrval->data.mol)->env_ptr,
                                  var_cell_data_cons(i)->code_ptr, 
				  (wrval->data.mol)->code_ptr);
		 else ffail();
		 return;
		 break;
	     case  TRUETYPE	:
		 if (wrval->type != TRUETYPE)
			ffail();
		 return;
		 break;
	     case  FALSTYPE	:
		 if (wrval->type != FALSTYPE)
			ffail();
		 return;
		 break;
	     default		:	
		 printf("Internal Error : panic\n");
		 longjmp(execbuff, 0);
		 break;
	    };
}



/*The ASOP action is taken only if one side of the equation is*/
/*a strict operator and  the other  side is  one of GID, GNULL*/
/*GNUM, GTRUE, GFALSE or another strict operator.             */

int 
fasopnum(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs; 		/*lhs is ALWAYS sop*/

{ auto int rhsvalue;
  auto int lhsvalue;
  auto short int tag;
  rhsvalue = heap_numb(rhs);
  tag = heap_tag(lhs);
  lhsvalue = (*arith_op[tag])(envl, lhs, envr, rhs);
  if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
  if (rhsvalue != lhsvalue) 
	ffail();
}

int 
fbsopbool(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs; 		/*lhs is ALWAYS sop*/

{ auto short int tag;
  auto int rhsvalue;
  auto int lhsvalue;
  rhsvalue = heap_numb(rhs);
  tag = heap_tag(lhs);
  lhsvalue = (*bool_op[tag])(envl, lhs, envr, rhs);
  if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
  if (rhsvalue != lhsvalue)
	ffail();
}

int
fasopasop(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;          /*lhs is ALWAYS sop*/
 
{ auto int rhsvalue, lhsvalue;
  auto short int lhstag, rhstag;
  lhstag = heap_tag(lhs);
  rhstag = heap_tag(rhs);
  lhsvalue = (*arith_op[lhstag])(envl, lhs, envr, rhs);
  if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
  rhsvalue = (*arith_op[rhstag])(envr, rhs, envl, lhs);
  if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
  if (lhsvalue != rhsvalue) ffail(); 
}

	
int
fbsopbsop(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;          /*lhs is ALWAYS sop*/
 
{ auto int rhsvalue, lhsvalue;
  auto short int lhstag, rhstag;
  lhstag = heap_tag(lhs);
  rhstag = heap_tag(rhs);
  lhsvalue = (*bool_op[lhstag])(envl, lhs, envr, rhs);
  if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
  rhsvalue = (*bool_op[rhstag])(envr, rhs, envl, lhs);
  if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
  if (lhsvalue != rhsvalue) ffail(); 
}
	

int 
fasopid(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs; 		/*lhs is ALWAYS sop*/

{ auto short int tag;
  auto int lhsvalue, rhsvalue; 
  auto varstkptrtype i;
  i = envr + heap_offs(rhs);
  while (PTRUE)
     switch (var_cell_type(i))
       {
	case VARTYPE	:
		/*envr = var_cell_env(i);*/
		i = var_cell_data_var(i);
		break;
	case INTTYPE	:
		rhsvalue = var_cell_data_int(i);
  		tag = heap_tag(lhs);
		lhsvalue = (*arith_op[tag])(envl, lhs, envr, rhs);
  		if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
  		if (lhsvalue != rhsvalue) ffail();
		return;
		break;
	case UNBOUND	:
  		tag = heap_tag(lhs);
		var_cell_data_int(i) = (*arith_op[tag])(envl, lhs, envr, rhs);
  		if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
		var_cell_type(i) = INTTYPE;
		if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		return;
		break;
	 default	:
		ffail();
		return;
		break;
       };
}

int 
fbsopid(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs; 		/*lhs is ALWAYS sop*/

{ auto short int tag;
  auto int lhsvalue, rhsvalue; 
  auto varstkptrtype i;
  i = envr + heap_offs(rhs);
  while (PTRUE)
     switch (var_cell_type(i))
       {
	case VARTYPE	:
		/*envr = var_cell_env(i);*/
		i = var_cell_data_var(i);
		break;
	case TRUETYPE	:
	case FALSTYPE	:
		rhsvalue = var_cell_data_bool(i);
  		tag = heap_tag(lhs);
		lhsvalue = (*bool_op[tag])(envl, lhs, envr, rhs);
  		if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
  		if (lhsvalue != rhsvalue) ffail();
		return;
		break;
	case UNBOUND	:
  		tag = heap_tag(lhs);
		lhsvalue = (*bool_op[tag])(envl, lhs, envr, rhs);
  		if (eqn_suspended == PTRUE) {eqn_suspended = PFALSE; return;}
		if (lhsvalue == PTRUE)
		      var_cell_type(i) = TRUETYPE;
		else  var_cell_type(i) = FALSTYPE;
		var_cell_data_bool(i) = lhsvalue;
		if (i < fstk_data(mrb)) trailstk[trail_top++] = i;
		return;
		break;
	 default	:
		ffail();
		return;
       };
}

int 
fbsop(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
 auto short int tag;
	tag = heap_tag(rhs);  	
	if ((tag >=  GAND) && (tag <= GLESSP))
		{ tempcellptr = rhs;		/*bsop is the lhs*/
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	tag = heap_tag(rhs);  
	if ((tag >=  GAND) && (tag <= GLESSP))	/*rhs is also a bsop*/
		fbsopbsop(envl, envr, lhs, rhs);
	else 
	  switch (tag)
	    {
		case GID	:
			fbsopid(envl, envr, lhs, rhs);
			break;
		case GTRUE	:
		case GFALSE	:
			fbsopbool(envl, envr, lhs, rhs);
			break;
		default		:
			ffail();
	    };
}

int 
fasop(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;

{
 auto varstkptrtype tempfptr;
 auto cellptrtype tempcellptr;
 auto short int tag;
	tag = heap_tag(rhs);  	
	if ((tag >=  GMOD) && (tag <= GMUL))
		{ tempcellptr = rhs;		/*asop is the lhs*/
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	tag = heap_tag(rhs);  
	if ((tag >=  GMOD) && (tag <= GMUL))	/*rhs is also an asop*/
		fasopasop(envl, envr, lhs, rhs);
	else 
           switch (tag) 
	      {
		case GID	:
			fasopid(envl, envr, lhs, rhs);
			break;
		case GNUM	:
			fasopnum(envl, envr, lhs, rhs);
			break;
	        default		:
			ffail();
	      };
}


int 
fif(envl, envr, lhs, rhs)
register varstkptrtype envl, envr;
register cellptrtype lhs, rhs;
{
 auto varstkptrtype tempfptr, oldbase; 
 auto cellptrtype tempcellptr, elsec, thenc, tempcode, tcode, cp;
 auto short int tag, last_call, type_cond; 
 register varstkptrtype condvar;
 register fstkptrtype tempsenv;
	tag = heap_tag(rhs);  	
	if (tag ==  GIF) 
		{ tempcellptr = rhs;		/*IF is the lhs*/
		  rhs = lhs;
		  lhs = tempcellptr;
		  tempfptr = envr;
		  envr = envl;
		  envl = tempfptr;
		};
	tempcode = heap_rptr(lhs);
	tcode = heap_lptr(lhs);
	switch (heap_tag(tcode))
	   {
		case GID	:
			condvar = heap_offs(tcode) + envl;
			type_cond = var_cell_type(condvar);
			break;
		case GTRUE	:
			type_cond = TRUETYPE;
			break;
		case GFALSE	:
			type_cond = FALSTYPE;
			break;
		default		:
			printf("Condition evaluates to non-boolean : abort\n");
			longjmp(execbuff, 0);
			break;
	   };
		
	cp = fstk_eqp(currenv);
	if (cp != BOTTOM)  /*check if we are solving the last eqn*/
	     if ((fstk_intro_rhs(currenv) == PNULL) &&
				/*introduced eqn is already solved*/
				/*< changed to <= 8/3/87*/
			(cp == PNULL) && (mrb <= currenv))
				/*and we are solving the last eqn*/
				/*and LEO condition is satisfied.*/
			last_call = PTRUE;
		else last_call = PFALSE;
			/*< changed to <= 8/3/87*/
	else if (mrb <= currenv) last_call = PTRUE;
	     else last_call = PFALSE;
	if (type_cond == UNBOUND)        
				/*might have to backtrack to the else part*/
	     if (do_else == PTRUE)
	        {
		 failflag = PFALSE; 		/*subtle control, care needed.*/
		 elsec = heap_rptr(tempcode);
	         if (last_call == PTRUE)
		     modify_caller_frame_if(heap_rptr(elsec), heap_lptr(elsec),
					rhs, envr);
	         else
		    {tempsenv = currenv;
		     while (fstk_bp(tempsenv) < BOTTOM) 
			tempsenv = fstk_par_ptr(tempsenv);
		     oldbase = fstk_data(tempsenv);
		     push_on_fstk(heap_rptr(elsec),NULL,0,heap_lptr(elsec),rhs,envr,currenv,current_eqnl,isbelong,0);
		     currenv = top_fstk - 1;
		     fstk_data(currenv) = oldbase;
				/*this situation is never going to arise*/
			        /*Backtracking to ELSE would cause the  */
				/*Else frame to be overwritten on the   */
				/*frame.			        */
		    };
		 if (debug == 1) 
		       printf("THEN failed, trying ELSE of IF in frame %d\n",
					 currenv);
		 do_else = PFALSE;
	        }
	    else
	      {/*oldbase = fstk_data(currenv);*/
	       thenc = heap_lptr(tempcode);
	       push_on_fstk(heap_rptr(thenc),NULL,0,heap_lptr(thenc),rhs,envr,currenv,current_eqnl,isbelong,1);
	       currenv = top_fstk - 1;
	       /*fstk_data(currenv) = oldbase;*/
	       fstk_bp(currenv) = ((-1) * mrb) - 10;   
					/*encode the if-frame info. in the mrb*/
	       mrb = currenv;
	       if (debug == 1) 
		     printf("trying THEN part of IF in frame %d\n", currenv);
	      } 
	else
	   if (type_cond ==  TRUETYPE) 	/*condition is true*/
	     if (last_call == PTRUE)
		{ thenc = heap_lptr(tempcode); 
		  modify_caller_frame_if(heap_rptr(thenc), heap_lptr(thenc),
					rhs, envr);
		  if (debug == 1) 
		     printf("trying THEN part of IF in frame %d\n", currenv);
		}
	     else
		 {tempsenv = currenv;
		  while (fstk_bp(tempsenv) < BOTTOM) 
			tempsenv = fstk_par_ptr(tempsenv);
		  oldbase = fstk_data(tempsenv);
		  thenc = heap_lptr(tempcode);
		  push_on_fstk(heap_rptr(thenc),NULL,0,heap_lptr(thenc),rhs,envr,currenv,current_eqnl,isbelong,0);
		  currenv = top_fstk - 1;
		  if (debug == 1) 
			printf("trying THEN part of IF in frame %d\n", currenv);
		  fstk_data(currenv) = oldbase;
		}
	  else 
	    if (type_cond == FALSTYPE)	/*condition is false*/
	     if (last_call == PTRUE)
		{ elsec = heap_rptr(tempcode); 
		  modify_caller_frame_if(heap_rptr(elsec), heap_lptr(elsec),
					rhs, envr);
		  if (debug == 1) 
			printf("trying ELSE part of IF in frame %d\n", currenv);
		}
	     else
		 {tempsenv = currenv;
		  while (fstk_bp(tempsenv) < BOTTOM) 
			tempsenv = fstk_par_ptr(tempsenv);
		  oldbase = fstk_data(tempsenv);
		  elsec = heap_rptr(tempcode);
		  push_on_fstk(heap_rptr(elsec),NULL,0,heap_lptr(elsec),rhs,envr,currenv,current_eqnl,isbelong,0);
		  currenv = top_fstk - 1;
		  if (debug == 1) 
			printf("trying ELSE part of IF in frame %d\n", currenv);
		  fstk_data(currenv) = oldbase;
		}
	   else {printf("IF : Condition evaluates to non-boolean value. \n");
		 longjmp(execbuff, 0);
		};
}

assign_actions()

{	action_array[AFAIL]	= ffail;
	action_array[AIDATOM]	= fidatom;
	action_array[AIDNUM]	= fidnum;
	action_array[AIDCONS]	= fidcons;
	action_array[AIDID]	= fidid;
	action_array[AIDFALSE]	= fidfalse;
	action_array[AIDTRUE]	= fidtrue;
	action_array[ACONSCONS] = fconscons;
	action_array[AATOMATOM] = fatomatom;
	action_array[ANUMNUM]	= fnumnum;
	action_array[ASUCCESS]	= fsuccess;
	action_array[AFUNCALL]  = ffuncall;
	action_array[AASOP]	= fasop;
	action_array[ABSOP]	= fbsop;
	action_array[AIF]	= fif;
	action_array[AIDREAD]   = fidread;
	action_array[AATOMREAD]   = fatomread;
	action_array[ANUMREAD]   = fnumread;
	action_array[ABOOLREAD]   = fboolread;
	action_array[ACONSREAD]   = fconsread;
	action_array[AIDWRITE]   = fidwrite;
	action_array[AATOMWRITE]   = fatomwrite;
	action_array[ANUMWRITE]   = fnumwrite;
	action_array[ABOOLWRITE]   = fboolwrite;
	action_array[ACONSWRITE]   = fconswrite;
	action_array[AREADWRITE]   = freadread;
	action_array[AREADWRITE]  = freadwrite;
	action_array[AWRITEWRITE] = fwritewrite;
}
