SPEC MATRIX = INTEGER + READWRITE +
{FORMAL SORTS data.}
{GLOBAL}SORTS 
  row ::= [integer].
  rows ::= [row].
  matrix ::= m(integer,integer,rows).
OPNS
  mult:: (matrix,matrix) -> (boolean,matrix).
LOCAL
OPNS
  mat_mult:: (rows,rows) -> rows.
  row_mult:: (row,rows) -> row.
  col_mult:: (row,row) -> integer.
  first_col:: rows -> (row,rows).
EQNS
  mult(m(N,M,ROWS),m(N2,M2,ROWS2)) =
    if M == N2
    then (true,m(N,M2,mat_mult(ROWS,ROWS2)))
    else (false,m(N,M,ROWS)).
  
  mat_mult([],_) = [].
  mat_mult([R|ROWS],B) = [row_mult(R,B)|mat_mult(ROWS,B)].
  
MACROS (#COL,#ROWS)=first_col([[D|DD]|ROWS]).
EQNS
 $row_mult(_,_) = [].
  row_mult(ROW,[[D|DD]|ROWS]) = [col_mult(ROW,#COL)|row_mult(ROW,#ROWS)].
  
 $col_mult _ = 0.
  col_mult([D|DD],[D2|DD2]) = (D*D2) + col_mult(DD,DD2).

MACROS (#COL,#ROWS)=first_col(ROWS).
EQNS 
 $first_col _ = ([],[]).
  first_col [[D|DD]|ROWS] = ([D|#COL],[DD|#ROWS]).
  
OPNS goal:: system -> system.
     gen:: (integer,integer) -> rows.
     gen:: integer -> row.
EQNS
  gen(I,N) = if I<=0 then [] else [gen N|gen(I-1,N)].
  
  gen I = if I<=0 then [] else [I|gen(I-1)].
      
MACROS #N=10.
      #A=m(#N,#N,gen(#N,#N)).
EQNS goal(S) = system(write(matrix(mult(#A,#A)),S)).

END.
