SPEC ASPINST =

OPNS version :: string.
EQNS version = "V1.0 92/09/12".


IMPORTS STREAM +
        SYSTEM +
        VERSION +
        PATH +
        INTEGER_UTIL +


OPNS header :: system -> system.
EQNS header S = S + language_version false+
                              "  Check Installation  "+version+"\n\n".


OPNS goal :: system -> system.
EQNS goal S =
        let (S,Home ) = get "HOME"  "~" S.
            (S,Pwd  ) = get "PWD"   "." S.
            S = header S.
            S = S@"This program checks the installation of your ASpecT".
            S = S@"environment. First of all lets check the environment".
            S = S@"variables:".
            S = set "ASPECT" "the search path of the system" "" S.
            S = set "SLASH" "the character to delimit filename and path" "/" S.
            S = set "HOMECHAR" "the character replaced by HOME in ASPECT" "~" S.
            S = set "PWDCHAR" "the character replaced by PWD in ASPECT" "." S.
            S = set "PWD" "the name of the current directory" Pwd S.
            S = set "HOME" "the name of the homedirectory" Home S.
            S = set "PATHDEL" "the character to separate paths in ASPECT" ":" S.
            S = S@"\nWith this settings the ASpecT system is searching for".
            S = S@"files in the following directories (in the given order).".
            (SEARCH,S) = search_path S.
            S = S@"Keep in mind that these may change if calling the system".
            S = S@"from another directory.".
            S = output_path SEARCH 0 S.
            (DC,S) = which "defaults.cmd" SEARCH S.
        in if DC == ""
           then let S = S@"I cannot locate the essential file 'defaults.cmd'".
                    S = S@"in any of those directorys. Of cause you may write".
                    S = S@"a specific one for each file (<file>.cmd) but there".
                    S = S@"should be a general one.".
                in S
           else let S = S+"ASpecT would use 'defaults.cmd' file in \""+DC@"\".".
                in S.


OPNS get :: string -> string -> system -> (system,string).
EQNS get IT Def S =
       let (GotIt,It,S) = getenv IT S.
       in  if GotIt
           then (S,It)
           else (S,Def).

OPNS set :: string -> string -> string -> system -> system.
EQNS set Which Msg Default S =
       let S = S+"Checking \""+Which+"\" which should contain "+Msg@".".
           (GotIt,It,S) = getenv Which S.
       in  if GotIt
           then S
           else S+" NOT SET so ASpecT uses default setting \""+Default+"\".\n".

OPNS output_path :: strings -> integer -> system -> system.
EQNS output_path [] N S = 
       if N==0 then S@"1. <current directory>"
       else S.
     output_path [P|Ps] N S =
       output_path Ps (N+1)
       (S + integer_string (N+1) + ". "@P).


MACROS
     (#exist,#sys) = existfile (Path+File) Sys.
     
OPNS which :: string -> strings -> system -> (string,system).
EQNS which _    []              Sys = ("",Sys).
     which File [Path|MorePath] Sys =
       if #exist
       then (Path,#sys)
       else which File MorePath #sys.

END.
