SPEC ASI0 =

  POS +
  IDENTIFIER +
  
SORTS
  spec_identifiers ::= [spec_identifier].
  poss             ::= [pos            ].             
  actual_sorts     ::= [actual_sort    ].     
  actual_opns      ::= [actual_opn     ].      
  definitions      ::= [definition     ].      
  sorts            ::= [sort           ].
  sortdecs         ::= [sortdec        ].            
  eqns             ::= [eqn            ].             
  constructors     ::= [constructor    ].     
  terms            ::= [term           ].            
  items            ::= [item           ].             
  
  specification    ::= spec(spec_identifier,
                            spec_identifiers { FORMAL },
                            spec_identifiers { GLOBAL },
                            spec_identifiers { LOCAL  },
                            definitions      { FORMAL },
                            definitions      { GLOBAL },
                            definitions      { LOCAL  }).

  spec_identifier  ::= specid(spn    :: identifier,
                              specid :: string,
                              path   :: string,
                                        actualize,
                              pos    :: pos).
  
  actualize        ::= act(actual_sorts,actual_opns)
                     | none
                     .
  
  actual_sort      ::= is(identifier,sortdec,pos).
                  
  actual_opn       ::= is(item,item,pos).
  
  definition       ::= sorts  sorts
                     | opns   items
                     | macros eqns
                     | eqns  (items,eqns)
                     | theos (items,eqns)
                     | view  (identifier,identifier,pos,eqns)
                     .
                     
  sort             ::= sort(identifier,constructors,bit,pos).

  constructor      ::= cons(cn::identifier,sort::sortdec,sortdec,pos).

  bit              ::= i 
                     | o
                     .
  
  eqn              ::= eqn(term,term,bit).
  
  term_c           ::= v(integer{L})          { variable    }
                     | o(identifier)          { operation   }
                     | m(integer{L})          { macro       }
                     | p(identifier,integer)  { projection  }
                     | b(builtin)	      { builtin     }
                     .
                     
  builtin          ::= c char 
                     | s string
                     | i integer
                     .
                     
  term             ::= n(term_c,              pos :: pos) { contents    }
                     | a(term,term,           pos :: pos) { application }
                     | t(terms,               pos :: pos) { tuple       }
                     | s(term,sortdec,boolean,pos :: pos) { sorted term }
                     .
                     
  sortdec          ::= n(identifier)        { contents    }
                     | a(sortdec,sortdec)   { application }
                     | t(sortdecs)          { tuple       }
                     .
                     
  item             ::= item(item_id,sortdec,bit,pos).

  item_id          ::= var integer
                     | opn identifier
                     | macro integer
                     .

OPNS
  no_term :: term.
  no_specid :: spec_identifier.
  
EQNS
  no_term = n(v(0),no_pos).
  no_specid = specid(no_ident,"","",none,no_pos).


OPNS
  t_ :: (terms,pos) -> term.
  
FORALL t_ :: (terms,pos) -> term.
EQNS
  t_([T],_) = T.
 $t_ = t.


OPNS
  t_ :: sortdecs -> sortdec.
  
FORALL t_::sortdecs -> sortdec.
EQNS
  t_ [S] = S.
 $t_ = t.


OPNS
  a_ :: (term,term,pos) -> term.
  
EQNS
  a_(T,t([],_),_) = T.
 $a_ = a.

OPNS
  is_tuple :: sortdec -> boolean.
  isname :: sortdec -> boolean.
  name :: sortdec -> identifier.
  
EQNS
  is_tuple(t _) = true.
 $is_tuple _ = false.
 
  isname(n _) = true.
 $isname _ = false.

  name(n SN) = SN.
 $name _ = no_ident.

END.
