#include <stdio.h>

#define SCREEN 0
#define KEYBOARD 1

#define FILE_LEN 5

typedef enum {CLOSED,OPENREAD,OPENWRITE} FILESTATUS;

static TERM CURR_READDEV, CURR_WRITEDEV, DEFAULT_READDEV, DEFAULT_WRITEDEV;
static char UGCHAR;
static unsigned UGMODE;

void
DEFUN(xx_SYSTEMreaddevice_pos_0,(sysi,res,syso),
      TERM sysi AND
      TERM *res AND
      TERM *syso)
 { *syso= sysi;
   *res= (TERM) FILE_I_POS; }
 
void
DEFUN(xx_SYSTEMwritedevice_pos_0,(sysi,res,syso),
      TERM sysi AND
      TERM *res AND
      TERM *syso)
 { *syso= sysi;
   *res= (TERM) FILE_O_POS; }
 
static TERM
DEFUN(LOOKUP_file,(DEV),
      TERM DEV)
 { unsigned handle = (unsigned) DEV;
   TERM fp;
   fp = DEFAULT_READDEV;
   while (!((unsigned) OPN(fp) == handle))
     if(fp->ARGS[4]==NULL) break;
     else fp = fp->ARGS[4];
   if((unsigned) OPN(fp) == handle) return fp;
   fp->ARGS[4] = MK(FILE_LEN,handle,(TERM) NULL,
				    (TERM) 0,
				    (TERM) CLOSED,
				    (TERM) ' ',
				    (TERM) NULL);
   return fp->ARGS[4];
 }

static TERM
DEFUN(OPENIO_file,(FIL,FN,STAT,MODE),
      TERM       FIL  AND
      TERM       FN   AND
      FILESTATUS STAT AND
      char       *MODE)
 {FILE *fopen(),*fp;
  extern char * EXFUN(malloc,(unsigned));
#ifdef NEED_STD_DECL
  extern void EXFUN(free,(char *));
#endif
  TERM RES;

  if ((FILESTATUS)FIL->ARGS[2] != CLOSED)
    RES = false;
  else	{
    char *FNC;
    unsigned LEN=(unsigned)STRINGlength_0(CP(FN));
    FNC = malloc(LEN+1);
    if(FNC==NULL) {
      RES = false;
    } else {
      STRING_TERM_to_CHAR_ARRAY(FN,LEN,FNC);
      if ((fp=fopen(FNC,MODE)) == NULL)
        RES = false;
      else {
        FIL->ARGS[0] = (TERM) fp;
        FIL->ARGS[1] = (TERM) 0;
        FIL->ARGS[2] = (TERM) STAT;
        FIL->ARGS[3] = (TERM) ' ';
        RES = true;
      }
      free(FNC);
    }
  }
  free__RUNTIME_string(FN);
  return RES;
 }
 
void
DEFUN(xx_SYSTEMopenread_0,(DEV,FN,sysi,res,syso),
      TERM DEV  AND
      TERM FN   AND
      TERM sysi AND
      TERM *res AND
      TERM *syso)
 { *syso= sysi;
   *res= OPENIO_file(LOOKUP_file(DEV),FN,OPENREAD, "r"); }

void
DEFUN(xx_SYSTEMopenwrite_0,(DEV,FN,sysi,res,syso),
      TERM DEV  AND
      TERM FN   AND
      TERM sysi AND
      TERM *res AND
      TERM *syso)
 { *syso= sysi;
   *res= OPENIO_file(LOOKUP_file(DEV),FN,OPENWRITE,"w"); }


static TERM
DEFUN(READDEVICE,(FIL),
      TERM FIL)
 {
  if((FILESTATUS)FIL->ARGS[2] != OPENREAD) return false;
  CURR_READDEV->ARGS[3] = (TERM) LAST_CH;
  CURR_READDEV->ARGS[1] = (TERM) FILE_I_POS;
  CURR_READDEV = FIL;
  LAST_CH    = __tchar((int)CURR_READDEV->ARGS[3]);
  FILE_I_POS = (FOURBYTES) CURR_READDEV->ARGS[1];
  STDIN      = (FILE *)    CURR_READDEV->ARGS[0];
  return true;
}

void
DEFUN(xx_SYSTEMreaddevice_0,(DEV,sysi,res,syso),
      TERM DEV  AND
      TERM sysi AND
      TERM *res AND
      TERM *syso) 
  { *syso= sysi;
    *res= READDEVICE(LOOKUP_file(DEV)); }

static TERM
DEFUN(WRITEDEVICE,(FIL),
      TERM FIL)
{
  if((FILESTATUS)FIL->ARGS[2] != OPENWRITE) return false;
  CURR_WRITEDEV->ARGS[1] = (TERM) FILE_O_POS;
  CURR_WRITEDEV = FIL;
  FILE_O_POS = (FOURBYTES) CURR_WRITEDEV->ARGS[1];
  STDOUT     = (FILE *)    CURR_WRITEDEV->ARGS[0];
  return true;
}

void
DEFUN(xx_SYSTEMwritedevice_0,(DEV,sysi,res,syso),
      TERM DEV  AND
      TERM sysi AND
      TERM *res AND
      TERM *syso) 
  { *syso= sysi;
    *res= WRITEDEVICE(LOOKUP_file(DEV)); }

static TERM
DEFUN(CLOSEFILE,(FIL),
      TERM FIL)
{ if ((OPN(FIL) == SCREEN)||(OPN(FIL) == KEYBOARD)) return false;
  if (CURR_READDEV  == FIL) READDEVICE (DEFAULT_READDEV ); else
  if (CURR_WRITEDEV == FIL) WRITEDEVICE(DEFAULT_WRITEDEV);
  if (fclose((FILE *)FIL->ARGS[0]))
    return false;
  else {
    FIL->ARGS[2] = (TERM) CLOSED;
    return true;
  }
}

void
DEFUN(xx_SYSTEMclosefile_0,(DEV,sysi,res,syso),
      TERM DEV  AND
      TERM sysi AND
      TERM *res AND
      TERM *syso) 
 { *syso= sysi;
   *res= CLOSEFILE(LOOKUP_file(DEV)); }

static void
DEFUN_VOID(INIT_file)
 { /* create SCREEN- and KEYBOARD-record been permanent */
   DEFAULT_WRITEDEV= MK(FILE_LEN,SCREEN,  (TERM) stdout,
					  (TERM) 0,
					  (TERM) OPENWRITE,
					  (TERM) ' ',
					  (TERM) NULL);
   DEFAULT_READDEV=  MK(FILE_LEN,KEYBOARD,(TERM) stdin,
					  (TERM) 0,
					  (TERM) OPENREAD,
					  (TERM) ' ',
					  (TERM) DEFAULT_WRITEDEV);
   CURR_READDEV = DEFAULT_READDEV;
   CURR_WRITEDEV = DEFAULT_WRITEDEV;
   READDEVICE(DEFAULT_READDEV);
   WRITEDEVICE(DEFAULT_WRITEDEV);
   UGMODE = (unsigned) false; UGCHAR = ' ';
}

/*******************************************************************************

  write_string(string,system)	-> (boolean,system).

*/

void
DEFUN(xx_SYSTEMwrite_string_0,(S,sysi,res,syso),
      TERM S    AND
      TERM sysi AND
      TERM *res AND
      TERM *syso)
{
  unsigned I,LEN;
  char *SC;
  TERM H=S;
  *syso= sysi;
  while (LEN=OPN(H)) {
    if (LEN > MAXSTR) {SC = (char *)(H->ARGS[1]); LEN -= MAXSTR;}
    else {SC = (char *) &(H->ARGS[1]); }        /** 23.03.89 **/
    for (I=0; I < LEN; I++) C_OUT(*SC++);
    H = H->ARGS[0];
  }
  SC = (char *)(H->ARGS[1]);
  while (*SC) C_OUT(*SC++);
  free__RUNTIME_string(S);
  *res= true;
}

/*******************************************************************************

  readdevice_pos(integer,system) -> (boolean,system).

*/

void
DEFUN(xx_SYSTEMreaddevice_pos_1,(pos,sysi,b,syso),
      TERM pos  AND
      TERM sysi AND
      TERM *b   AND
      TERM *syso)
 { *syso= sysi;
   *b= true;
   fseek(STDIN,(FOURBYTES)pos,0);
   FILE_I_POS = (FOURBYTES)pos;
 }
 
/*******************************************************************************

  read_char(system) -> (boolean,char,system).

*/

void
DEFUN(xx_SYSTEMread_char_0,(sysi,RES1,RES2,syso),
      TERM sysi  AND
      TERM *RES1 AND
      TERM *RES2 AND
      TERM *syso)
 { *syso= sysi;
   if(UGMODE) { UGMODE=(unsigned)false; *RES2 = (TERM)(int) UGCHAR; }
   else *RES2 = (TERM) getc(STDIN);
   if ((int)*RES2 == EOF) *RES1 = false;
   else 		  *RES1 = true,FILE_I_POS++;
 }

/*******************************************************************************

  unread_char(char,system) -> (boolean,system).

*/

void
DEFUN(xx_SYSTEMunread_char_0,(chr,sysi,RES,syso),
      TERM chr  AND
      TERM sysi AND
      TERM *RES AND
      TERM *syso)
  { *syso= sysi;
    if (UGMODE) *RES= false;
    else { *RES= true; UGCHAR= __tchar((int)chr); UGMODE= (unsigned)true; }
  }
  
/*******************************************************************************

  file_string(string,system) -> (boolean,string,system).

*/

static TERM
DEFUN(FILE_string,(fp),
      FILE *fp)
{ char BLOCK[MAXSTR];
  unsigned I,J;
  TERM H,H2;
  char *DEST;
  int C;
  TERM FIRST=true;

  while (TRUE) {
    for (I=0; I < MAXSTR; I++) {
      if ((C = getc(fp)) == EOF) break;
      BLOCK[I] = C;
    }

    if (I) {
      if (I == MAXSTR) {
	if (FIRST) {
	  H2 = MK_string(MAXSTR,MT);
	  H=H2;
	  FIRST=false;
	}
	else {
	  H->ARGS[0]=MK_string(MAXSTR,MT);
	  H=H->ARGS[0];
	}

	DEST = (char *) &(H->ARGS[1]);
	for (J=0; J<MAXSTR; J++) *DEST++ = BLOCK[J];
      }
      else {
	if (FIRST) {
	  H2 = MK_string(I,MT);
	  H=H2;
	}
	else {
	  H->ARGS[0]=MK_string(I,MT);
	  H=H->ARGS[0];
	}
	DEST = (char *) &(H->ARGS[1]);
	for (J=0; J<I; J++) *DEST++ = BLOCK[J];

	return H2;
      }
    }
    else
      if (FIRST) return MT;
      else return H2;
  }
}

void
DEFUN(xx_SYSTEMfile_string_0,(FN,sysi,B,S,syso),
      TERM FN   AND
      TERM sysi AND
      TERM *B   AND
      TERM *S   AND
      TERM *syso)
{
  FILE *fopen(),*fp;
  extern char * EXFUN(malloc,(unsigned));
#ifdef NEED_STD_DECL
  extern void EXFUN(free,(char *));
#endif
  char *FNC;
  unsigned LEN=(unsigned)STRINGlength_0(CP(FN));
  *syso= sysi;
  FNC = malloc(LEN+1);
  if(FNC==NULL) {
    *B = false;
    *S = MT;
  } else {
    STRING_TERM_to_CHAR_ARRAY(FN,LEN,FNC);
    if ((fp=fopen(FNC,"r")) != NULL) {
      *B = true;
      *S = FILE_string(fp);
      fclose(fp);
    }
    else {
      *B = false;
      *S = MT;
    }
    free(FNC);
  }
  free__RUNTIME_string(FN);
}

/*******************************************************************************

  string_file(string,string,system) -> (boolean,system).

*/

void
DEFUN(xx_SYSTEMstring_file_0,(FN,S,sysi,res,syso),
      TERM FN   AND
      TERM S    AND
      TERM sysi AND
      TERM *res AND
      TERM *syso)
{ FILE *fopen(),*fp, *output;
  extern char * EXFUN(malloc,(unsigned));
#ifdef NEED_STD_DECL
  extern void EXFUN(free,(char *));
#endif
  char *FNC;
  unsigned LEN=(unsigned)STRINGlength_0(CP(FN));
  *syso= sysi;
  FNC = malloc(LEN+1);
  if(FNC==NULL) {
    free__RUNTIME_string(S);
    *res= false;
  } else {
    STRING_TERM_to_CHAR_ARRAY(FN,LEN,FNC);
    if ((fp=fopen(FNC,"w")) == NULL) {
      free__RUNTIME_string(S);
      *res= false;
    }
    else { TERM dsys,b;
      output = STDOUT;
      STDOUT = fp;
      SYSTEMwrite_string_0(S,dsys,&b,&dsys);
      fclose(STDOUT);
      STDOUT = output;
      *res= true;
    }
    free(FNC);
  }
  free__RUNTIME_string(FN);
}

/*******************************************************************************
  
  existfile(string,system) -> (boolean,system).

*/

void
DEFUN(xx_SYSTEMexistfile_0,(FN,sysi,res,syso),
      TERM FN   AND
      TERM sysi AND
      TERM *res AND
      TERM *syso)
{ FILE *fopen(),*fp;
  extern char * EXFUN(malloc,(unsigned));
#ifdef NEED_STD_DECL
  extern void EXFUN(free,(char *));
#endif
  char *FNC;
  unsigned LEN=(unsigned)STRINGlength_0(CP(FN));
  *syso= sysi;
  FNC = malloc(LEN+1);
  if(FNC==NULL) {
    *res = false;
  } else {
    STRING_TERM_to_CHAR_ARRAY(FN,LEN,FNC);
    if ((fp=fopen(FNC,"r")) == NULL)
      *res = false;
    else {
      fclose(fp);
      *res = true;
    }
    free(FNC);
  }
  free__RUNTIME_string(FN);
}

/*******************************************************************************
  
  deletefile(string,system) -> (boolean,system).

*/

void
DEFUN(xx_SYSTEMdeletefile_0,(FN,sysi,res,syso),
      TERM FN   AND
      TERM sysi AND
      TERM *res AND
      TERM *syso)
{
  extern char * EXFUN(malloc,(unsigned));
#ifdef NEED_STD_DECL
  extern int EXFUN(unlink,(char *));
  extern void EXFUN(free,(char *));
#endif  
  char *FNC;
  unsigned LEN=(unsigned)STRINGlength_0(CP(FN));
  *syso= sysi;
  FNC = malloc(LEN+1);
  if(FNC==NULL) {
    *res = false;
  } else {
    STRING_TERM_to_CHAR_ARRAY(FN,LEN,FNC);
    if (unlink(FNC) == 0)
      *res = true;
    else 
      *res = false;
    free(FNC);
  }
  free__RUNTIME_string(FN);
}



/*******************************************************************************

  call_argument(system) -> (string,system).

*/

void
DEFUN(xx_SYSTEMcall_argument_0,(sysi,res,syso), 
      TERM sysi AND
      TERM *res AND
      TERM *syso)
{  
   extern char * EXFUN(malloc,(unsigned));
   char     *cmd;
   unsigned i,j,k;
   char     *str;
   char     **argv;
   argv = _RUNTIME_argv;
   *argv++; i=0; j=0; k=0; 
   for (;i<_RUNTIME_argc-1;i++,*argv++,k=0) {
     str= *argv;
     if ((str[k]!='\0')&&(j!=0)) j++;
     while (str[k]!='\0') j++,k++;
     j++;
   }
   cmd=malloc(j+1);
   argv = _RUNTIME_argv;
   *argv++; i=0; j=0; k=0;
   cmd[j]='\0';
   for (;i<_RUNTIME_argc-1;i++,*argv++,k=0) {
     str= *argv;
     if ((str[k]!='\0')&&(j!=0)) cmd[j++]=' ';
     while (str[k]!='\0') cmd[j++]=str[k++];
     cmd[j]='\0';
   }
   *syso= sysi;
   *res= _RUNTIME_mk0STRING(cmd);
   free(cmd);
}

/*******************************************************************************

  new_returnvalue(integer,system) -> system.

*/

TERM
DEFUN(xx_SYSTEMnew_returnvalue_0,(VAL,sysi),
      TERM VAL AND
      TERM sysi)
{
    _RUNTIME_exval = (unsigned) VAL;
    return sysi;
}

/*******************************************************************************

  execute(string,system) -> (boolean,integer,system).

*/

void
DEFUN(xx_SYSTEMexecute_0,(STR,sysi,BOOL,INT,syso),
      TERM STR   AND
      TERM sysi  AND
      TERM *BOOL AND
      TERM *INT  AND
      TERM *syso)
{ char *FNC; unsigned LEN=(unsigned)STRINGlength_0(CP(STR));
  extern char * EXFUN(malloc,(unsigned));
  extern int EXFUN(system,(char *));
#ifdef NEED_STD_DECL
  extern void EXFUN(free,(char *));
#endif
  FNC=malloc(LEN+1);
  *syso= sysi;
  if (FNC == NULL) {
    *BOOL=false;
    *INT=(TERM)255;
  }
  else {
    STRING_TERM_to_CHAR_ARRAY(STR,LEN,FNC);
    *INT=(TERM)system(FNC);
    free(FNC);
    *BOOL=(TERM)(*INT==(TERM)0);
  }
  free__RUNTIME_string(STR);
}

/*******************************************************************************

  getenv(string,system) -> (boolean,string,system).

*/

void
DEFUN(xx_SYSTEMgetenv_0,(STR,sysi,BOOL,SOUT,syso),
      TERM STR   AND
      TERM sysi  AND
      TERM *BOOL AND
      TERM *SOUT AND
      TERM *syso)
{ char *FNC,*ENV; unsigned LEN=(unsigned)STRINGlength_0(CP(STR));
  extern char * EXFUN(malloc,(unsigned));
  extern char * EXFUN(getenv,(char *));
#ifdef NEED_STD_DECL
  extern void EXFUN(free,(char *));
#endif
  FNC=malloc(LEN+1);
  *syso=sysi;
  *BOOL=false;
  if (FNC == NULL) {
    *SOUT=MT;
  }
  else {
    STRING_TERM_to_CHAR_ARRAY(STR,LEN,FNC);
    ENV=getenv(FNC);
    if(ENV==NULL)
      *SOUT=MT;
    else {
      *SOUT=_RUNTIME_mk0STRING(ENV);
      *BOOL=true;
    }
    free(FNC);
  }
  free__RUNTIME_string(STR);
}

unsigned __XINIT_SYSTEM = 0;
void
DEFUN(SYSTEM_Xinitialize,(MODE),unsigned MODE){
if(__XINIT_SYSTEM == 2) return;
if(MODE==1) {INIT_file();__XINIT_SYSTEM = 2;return;}
if(__XINIT_SYSTEM == 0){
   __XINIT_SYSTEM = 1;
   if(FILE_LEN>FL_LEN) FL_LEN=FILE_LEN;
}}

