SPEC STRING_UTIL =

  STRING +
  CHAR +
  INTEGER +
  BOOLEAN +
  
OPNS
  fronttoken:: string -> (boolean,string,string).
  frontchar:: (string,char) -> (boolean,string).
  upper_lower,
  lower_upper:: string -> string.
  isname:: string -> boolean.
  string_integer:: string -> (boolean,integer).

LOCAL
  CHAR_UTIL +
  INTEGER_UTIL +

OPNS
  fronttoken_number:: (string,boolean,integer)
     -> (boolean,string,string,integer).
  fronttoken_nonumber:: (string,boolean) -> (boolean,string,string).
  is_delimiter:: char -> boolean.
  
MACROS
  #fc1 = frontchar S.
  #fc2 = frontchar(string #fc1).
  #ft2 = fronttoken_number(string #fc1,true,(N*10) + 
                            char_integer(char #fc1)-char_integer '0').
  #ft3 = fronttoken_nonumber(string #fc1,true).
  #ft4 = fronttoken_number(S,false,0).
  
EQNS
  fronttoken S = 
    if S == "" 
    then (false,"","")
    elsif is_delimiter(char #fc1)
       then fronttoken(string #fc1)
       elsif boolean #fc2
          then if is_delimiter(char #fc2)
               then (true,char #fc1:"",string #fc1)
               elsif boolean(fronttoken_number(S,false,0))
                  then (boolean #ft4,string.1 #ft4,string.2 #ft4)
                  else fronttoken_nonumber(S,false)
          else (true,char #fc1:"",string #fc1).
            
  fronttoken_number(S,B,N) =
    if S == ""
    then (B,S,S,N)
    elsif digit(char #fc1)
       then (boolean #ft2,
             char #fc1:string.1 #ft2,
             string.2 #ft2,integer #ft2)
       else (B,"",S,N).
         
  fronttoken_nonumber(S,B) =
    if S == ""
    then (B,S,S)
    elsif (char #fc1 == '_') || 
          letter(char #fc1) ||
          (B && digit(char #fc1))
       then (boolean(#ft3),
              char #fc1:string.1 #ft3,
              string.2(#ft3))
       elsif is_delimiter(char #fc1) || B
          then (B,"",S)
          else (true,char #fc1:"",string #fc1).

  is_delimiter C = (C==' ') || (C=='\t') || (C=='\n').

MACROS 
  (#ok,#char,#rest) = frontchar S.
  
EQNS
  frontchar(S,C) = (#ok && (C == #char),#rest).

  upper_lower S =
    if #ok
    then upper_lower #char:upper_lower #rest
    else S.

  lower_upper S =
    if #ok
    then lower_upper #char:lower_upper #rest
    else S.

MACROS 
  (#ok,#name,#rest) =fronttoken S.
  
EQNS
  isname S = #ok && (#rest == "") && letter(char(frontchar S)).

MACROS
  (#ok,_,#rest,#int) =fronttoken_number(S,false,0).
  
EQNS
  string_integer S = (#ok && (#rest == ""),#int).
      
END.
