SPEC SET =

FORMAL SORTS data.

GLOBAL

  INTEGER +

SORTS set ::= empty | ins (data,set).
  
OPNS 

{ constructors are not visible so ... }

  mt :: set.
  data : set :: set.
  
{ the miranda set of setops which are suitable }

  length :: set -> integer.
  
  set ++ set :: set.
  set -- set :: set.

  member :: set -> data -> boolean.
  remove :: data -> set -> set.

{ more setops }

  union :: set -> set -> set.
  intersect :: set -> set -> set.
  
  single :: set -> boolean.
  
  ismt :: set -> boolean.
  
LOCAL

  ERROR +

{SORTS
  set ::= empty | ins(data,set).}
  
EQNS
  [] = empty.

EQNS  
  A : X = if member X A then X
                        else ins(A,X).
EQNS
  length empty = 0.
  length (ins(_,X)) = 1+length X.
  

EQNS
  empty    ++ L = L.
  ins(A,X) ++ L = A:(X++L).
  
EQNS
  X -- empty      = X.
  X -- (ins(B,Y)) = (remove B X) -- Y.

EQNS remove _ empty = empty.
     remove B (ins(A,X)) = if B==A then X 
                           else ins(A,remove B X).
EQNS
  member empty _ = false.
  member (ins(A,X)) B = if A==B then true 
                                else member X B. 
EQNS
  union empty Y = Y.
  union (ins(A,X)) Y = A:union X Y.
  
EQNS
  intersect empty _ = empty.
  intersect (ins(A,X)) Y = if member Y A then ins(A,intersect X Y)
                                         else       intersect X Y.

EQNS
  single (ins(_,empty)) = true.
 $single _ = false.
 
EQNS
  ismt = (==) empty.
  
END.
