/* NO_REMOTE_AVAIL should be defined iff this feature is not available
   at your machine!
*/ 


#ifdef MAC
#undef TRUE
#undef FALSE
/* due to the awkward problem that <rpc/types.h> (included by <rpc/rpc.h>)
   defines TRUE and FALSE (as we need it) on MacIntosh's A/UX */
#endif

#ifdef ATARI
#define NO_REMOTE_AVAIL
#endif


#ifndef NO_REMOTE_AVAIL
#ifdef AIX
#include <sys/select.h>
#endif
#include <rpc/rpc.h>
#endif


/* Server commands */

#define  s_are_you_alive "0"
#define  s_execute_this  "1"
#define  s_finish_up     "2"
#define  s_return_status "3"
#define  s_output_line   "4"


char    *SERVER = NULL;

#ifndef NO_REMOTE_AVAIL
SVCXPRT *xprt   = NULL;   /* if NULL no service available */
#endif


unsigned __XINIT_REMOTE = 0;
void
DEFUN(REMOTE_Xinitialize,(MODE),unsigned MODE)
 { if(__XINIT_REMOTE == 0) {
     __XINIT_REMOTE = 1;
#ifndef NO_REMOTE_AVAIL
     xprt = svcudp_create(RPC_ANYSOCK);
#endif
   }
 }

XCOPY(xcopy_REMOTE_remote) { return CP(A); }

XFREE(xfree_REMOTE_remote)
 { if(DZ_REF(A)) { /* need to kill the server ! */
     if(_X61_X61__RUNTIME_integer(A->ARGS[0],0)) {
       /* no address! */
     } else {
       static char *res=s_finish_up;
       static int stat,mode;
       static char *hostname;
       unsigned LEN;
       LEN=(unsigned)STRINGlength_0(CP(A->ARGS[1]));
       hostname = (char *)malloc(LEN+1);
       STRING_TERM_to_CHAR_ARRAY(A->ARGS[1],LEN,hostname);
#ifndef NO_REMOTE_AVAIL
       stat = callrpc(hostname,(int)A->ARGS[0],1,1,
                      xdr_wrapstring,&res,xdr_int,&mode);
#endif
       /* don't care if it's all right V1.0 */
       free(hostname);
     }
     free__RUNTIME_integer(A->ARGS[0]);
     free__RUNTIME_string(A->ARGS[1]);
     MDEALLOC(2,A);
   }
 }

XEQ(x_X61_X61_REMOTE_remote)
 { if (A1==A2) { /* the one and only case */
      xfree_REMOTE_remote(S,A1);
      xfree_REMOTE_remote(S,A2);
      return true;
   } else {
      xfree_REMOTE_remote(S,A1);
      xfree_REMOTE_remote(S,A2);
      return false;
   }
 }

XREAD(xread_REMOTE_remote)
 { /* the reading of remote handles is */
   /* permitted due to obvious reasons */
   *SYSO = SYSI;
   *OK = false;
   *RES = A;
 }

XWRITE(xwrite_REMOTE_remote)
 { S_OUT("remote(");
   write__RUNTIME_integer(copy__RUNTIME_integer(A->ARGS[0]),SYSI,OK,SYSO);
   C_OUT(',');
   write__RUNTIME_string(copy__RUNTIME_string(A->ARGS[1]),SYSI,OK,SYSO);
   C_OUT(')');
 }


TERM 
DEFUN(REMOTEname_of_server_program_0,(ARG0,ARG1),
      TERM  ARG0 AND
      TERM  ARG1)
 { 
   static unsigned LEN;
   LEN=(unsigned)STRINGlength_0(CP(ARG0));
   free(SERVER);
   SERVER = (char *)malloc(LEN+1);
   STRING_TERM_to_CHAR_ARRAY(ARG0,LEN,SERVER);
   free__RUNTIME_string(ARG0);
   return ARG1;
 }

void
DEFUN(REMOTEcreate_0,(ARG0,ARG1,RES1,RES2,RES3),
      TERM  ARG0 AND
      TERM  ARG1 AND
      TERM *RES1 AND
      TERM *RES2 AND
      TERM *RES3)
 { *RES3 = ARG1;
#ifdef NO_REMOTE_AVAIL
   *RES1 = false;
   *RES2 = MKxx2(0,(TERM)0,ARG0);
#else
   if((xprt==NULL) || (SERVER==NULL)) {
     *RES1 = false;
     *RES2 = MKxx2(0,(TERM)0,ARG0);
   } else {
     int address = 0x40000000;
     while(!pmap_set(address++,1,IPPROTO_UDP,xprt->xp_port));
     address--;
     if(!pmap_unset(address,(u_long)1)) {
       *RES1 = false;
       *RES2 = MKxx2(0,(TERM)0,ARG0);
     } else {
       char *hostname;
       char *cmd;
       unsigned LEN;
       LEN=(unsigned)STRINGlength_0(CP(ARG0));
       hostname = (char *)malloc(LEN+1);
       cmd      = (char *)malloc(LEN+100 /* just a bit too large to be sure */);
       STRING_TERM_to_CHAR_ARRAY(ARG0,LEN,hostname);
       
       sprintf(cmd,"rsh %s -n '%s %d>&/dev/null </dev/null&' > /dev/null",
                   hostname,
                   SERVER,
                   address);
       /*
       sprintf(cmd,"rsh %s -n '%s %d>&/tmp/svout </dev/null&' >> /tmp/svout",
                   hostname,
                   SERVER,
                   address);
       */
       free(hostname);
       if(system(cmd)==0) {;
         free(cmd);
         *RES1 = true;
         *RES2 = MKxx2(0,(TERM)address,ARG0);
       } else {
         free(cmd);
         *RES1 = false;
         *RES2 = MKxx2(0,(TERM)0,ARG0);
       }
     }
   }
#endif
 }

void
DEFUN(REMOTEissue_command_0,(ARG0,ARG1,ARG2,RES1,RES2),
      TERM  ARG0 AND
      TERM  ARG1 AND
      TERM  ARG2 AND
      TERM *RES1 AND
      TERM *RES2)
 { *RES2 = ARG1;
#ifdef NO_REMOTE_AVAIL
   *RES1 = false;
#else
   if(_X61_X61__RUNTIME_integer(ARG1->ARGS[0],0)) {
     /* no address! */
     xfree_REMOTE_remote((SORTREC)0,ARG1);
     *RES1 = false;
   } else {
     static char *res;
     static int stat,mode;
     static char *hostname;
     static unsigned LEN,LEN2;
     LEN=(unsigned)STRINGlength_0(CP(ARG0));
     LEN2=(unsigned)STRINGlength_0(CP(ARG1->ARGS[1]));
     res = (char *)malloc(LEN+10);
     hostname = (char *)malloc(LEN+1);
     STRING_TERM_to_CHAR_ARRAY(ARG0,LEN,hostname);
     sprintf(res,"%s%s",s_execute_this,hostname);
     free(hostname);
     hostname = (char *)malloc(LEN2+1);
     STRING_TERM_to_CHAR_ARRAY(ARG1->ARGS[1],LEN2,hostname);
     stat = callrpc(hostname,ARG1->ARGS[0],1,1,
                    xdr_wrapstring,&res,xdr_int,&mode);
     if (stat != RPC_SUCCESS) {
       *RES1 = false;
     } else {
       *RES1 = true;
     }
     free(hostname);
     free(res);
     xfree_REMOTE_remote((SORTREC)0,ARG1);
   }
#endif
 }

void
DEFUN(REMOTEis_working_0,(ARG0,ARG1,RES1,RES2),
      TERM  ARG0 AND
      TERM  ARG1 AND
      TERM *RES1 AND
      TERM *RES2)
 { *RES2 = ARG1;
#ifdef NO_REMOTE_AVAIL
   *RES1 = false;
   *RES2 = (TERM) 1;
#else
   if(_X61_X61__RUNTIME_integer(ARG0->ARGS[0],0)) {
     /* no address! */
     xfree_REMOTE_remote((SORTREC)0,ARG0);
     *RES1 = false;
     *RES2 = (TERM) 1;
   } else {
     static char *res=s_are_you_alive;
     static int stat,mode;
     static char *hostname;
     static unsigned LEN;
     LEN=(unsigned)STRINGlength_0(CP(ARG0->ARGS[1]));
     hostname = (char *)malloc(LEN+1);
     STRING_TERM_to_CHAR_ARRAY(ARG0->ARGS[1],LEN,hostname);
     stat = callrpc(hostname,ARG0->ARGS[0],1,1,
                    xdr_wrapstring,&res,xdr_int,&mode);
     if (stat != RPC_SUCCESS) {
       *RES1 = false;
     } else {
       if(mode==1)
         *RES1 = true;
       else
         *RES1 = false;
     }
     free(hostname);
     xfree_REMOTE_remote((SORTREC)0,ARG0);
   }
#endif
 }

void
DEFUN(REMOTEreturn_status_0,(ARG0,ARG1,RES1,RES2,RES3),
      TERM  ARG0 AND
      TERM  ARG1 AND
      TERM *RES1 AND
      TERM *RES2 AND
      TERM *RES3)
 { *RES3 = ARG1;
#ifdef NO_REMOTE_AVAIL
   *RES1 = false;
   *RES2 = (TERM) 1;
#else
   if(_X61_X61__RUNTIME_integer(ARG0->ARGS[0],0)) {
     /* no address! */
     xfree_REMOTE_remote((SORTREC)0,ARG0);
     *RES1 = false;
     *RES2 = (TERM) 1;
   } else {
     static char *res=s_return_status;
     static int stat,mode;
     static char *hostname;
     static unsigned LEN;
     LEN=(unsigned)STRINGlength_0(CP(ARG0->ARGS[1]));
     hostname = (char *)malloc(LEN+1);
     STRING_TERM_to_CHAR_ARRAY(ARG0->ARGS[1],LEN,hostname);
     stat = callrpc(hostname,ARG0->ARGS[0],1,1,
                    xdr_wrapstring,&res,xdr_int,&mode);
     if (stat != RPC_SUCCESS) {
       *RES1 = false;
       *RES2 = (TERM) 1;
     } else {
       *RES1 = true;
       *RES2 = (TERM) mode;
     }
     free(hostname);
     xfree_REMOTE_remote((SORTREC)0,ARG0);
   }
#endif
 }

void
DEFUN(REMOTEnext_line_of_output_0,(ARG0,ARG1,RES1,RES2,RES3),
      TERM  ARG0 AND
      TERM  ARG1 AND
      TERM *RES1 AND
      TERM *RES2 AND
      TERM *RES3)
 { *RES3 = ARG1;
#ifdef NO_REMOTE_AVAIL
   *RES1 = false;
   *RES2 = MT;
#else
   if(_X61_X61__RUNTIME_integer(ARG0->ARGS[0],0)) {
     /* no address! */
     xfree_REMOTE_remote((SORTREC)0,ARG0);
     *RES1 = false;
     *RES2 = MT;
   } else {
     static char *res=s_output_line;
     static int stat;
     static char *hostname;
     static char *ln;
     static unsigned LEN;
     LEN=(unsigned)STRINGlength_0(CP(ARG0->ARGS[1]));
     hostname = (char *)malloc(LEN+1);
     STRING_TERM_to_CHAR_ARRAY(ARG0->ARGS[1],LEN,hostname);
     stat = callrpc(hostname,ARG0->ARGS[0],1,1,
                    xdr_wrapstring,&res,xdr_wrapstring,&ln);
     if (stat != RPC_SUCCESS) {
       *RES1 = false;
       *RES2 = MT;
     } else {
       if(ln[0]!=1) {
         *RES1 = true;
         *RES2 = _RUNTIME_mk1STRING(strlen(ln),ln,MT);
       } else {
         *RES1 = false;
         *RES2 = MT;
         free(ln);
       }
     }
     free(hostname);
     xfree_REMOTE_remote((SORTREC)0,ARG0);
   }
#endif
 }


void
DEFUN(REMOTEwho_am_i_0,(ARG0,RES1,RES2,RES3),
      TERM  ARG0 AND
      TERM *RES1 AND
      TERM *RES2 AND
      TERM *RES3)
 { char *name;
   *RES3 = ARG0;
#ifdef NO_REMOTE_AVAIL
   *RES1 = false;
   *RES2 = MT;
#else
   name = (char *)malloc(256);
   if(gethostname(name,256)==0) {
     *RES1 = true;
     *RES2 = _RUNTIME_mk1STRING(strlen(name),name,MT);
   } else {
     *RES1 = false;
     *RES2 = MT;
     free(name);
   }
#endif
 }

TERM
DEFUN(REMOTEwho_0,(ARG0),
      TERM  ARG0)
 { TERM tmp = copy__RUNTIME_string(ARG0->ARGS[1]);
   xfree_REMOTE_remote((SORTREC)0,ARG0);
   return tmp;
 }



