SPEC PROCESS =

  SYSTEM +

SORTS process.

OPNS create_process :: string -> string -> system -> (process,system).
     finished  :: process -> system -> (boolean,process,system).
     succeeded :: process -> system -> (boolean,process,system).
     failed    :: process -> system -> (boolean,integer,process,system).

LOCAL

SORTS process ::= failure | ready | running integer string string.

MACROS (#Stat,#Sys) = update_status Stat Sys.

EQNS finished failure Sys = (true,failure,Sys).
     finished ready   Sys = (true,ready,  Sys).
    $finished Stat    Sys = if (#Stat == ready) ||
                               (#Stat == failure) 
                            then (true,#Stat,#Sys)
                            else (false,#Stat,#Sys).

MACROS (#ok,#Stat,#Sys) = finished Stat Sys.

EQNS succeeded Stat Sys = if #ok then (#Stat==ready,#Stat,#Sys)
                                 else (false,#Stat,#Sys).

EQNS failed Stat Sys = if #ok then (#Stat==failure,0,#Stat,#Sys)
                              else (false,0,#Stat,#Sys).
                                 

OPNS EXTERN fork :: system -> (integer,system).
     EXTERN exec :: string -> string -> system -> system.
     EXTERN exist:: integer -> system -> (boolean,system).

MACROS
     (#pid,#sys) = fork System.

EQNS create_process Command Arguments System =
       if #pid == 0
       then (ready,exec Command Arguments #sys)
       elsif #pid == -1
       then (failure,     #sys)
       else (running #pid Command Arguments,#sys).

OPNS update_status :: process -> system -> (process,system).

MACROS
     (#exist,#sys) = exist PId Sys.

EQNS update_status (running PId Command Arguments) Sys =
        (if #exist
         then running PId Command Arguments
         else ready,
         #sys).
    $update_status Stat Sys = (Stat,Sys).

OPNS goal :: system -> system.
EQNS goal S = system(create_process "ls" "" S).


END.
