SPEC PATH =

  STRINGS +
  
OPNS
  search_path :: system -> (strings,system).
  
LOCAL
  SYSTEM1 +

OPNS
  splitpath :: (string,string,string) -> strings.
  check_paths :: (strings,string,string,string,string,string) -> strings.

OPNS get_env :: (string,string,system) -> (string,system). 
EQNS get_env(IT,ERRVAL,SYS) = 
       let (OK,IT,SYS) = getenv IT SYS.
       in (if OK then IT else ERRVAL,SYS).
      
EQNS search_path Sys = 
       let (ASPECT,  Sys) = get_env("ASPECT",  "",      Sys).
           (SLASH,   Sys) = get_env("SLASH",   "/",     Sys).
           (HOMECHAR,Sys) = get_env("HOMECHAR","~",     Sys).
           (PWDCHAR, Sys) = get_env("PWDCHAR", ".",     Sys).
           (PWD,     Sys) = get_env("PWD" ,    "",      Sys).
           (PWD,     Sys) = if PWD==""
                            then let (OK,PW,Sys) = getwd Sys.
                                 in if OK
                                    then (PW,     Sys)
                                    else (PWDCHAR,Sys)
                            else (PWD,Sys).
           (HOME,    Sys) = get_env("HOME",    HOMECHAR,Sys).
           (PATHDEL, Sys) = get_env("PATHDEL", ":",     Sys).
           Res            = check_paths(splitpath(ASPECT,"",PATHDEL),
                                        PWD,HOME,SLASH,HOMECHAR,PWDCHAR).
       in (if Res==[] then [""] else Res,Sys).

MACROS
  (#ok,#char,#str) = frontstring 1 S.

EQNS  
  splitpath(S,CURR,PDEL) = 
    if #ok
    then  if #char==PDEL
          then [CURR|splitpath(#str,"",PDEL)]
          else splitpath(#str,CURR+#char,PDEL)    
    else [CURR].

OPNS repl_spec :: (string,string,string,string,string,string) -> string.
     check_end_slash :: (string,string) -> string.
  
MACROS
  (#ok,#char,#str) = frontstring 2 S.

EQNS
  repl_spec(S,PWD,HOME,SLASH,HOMECHR,PWDCHR) = 
    if S==PWDCHR              then PWD             else 
    if S==HOMECHR             then HOME            else
    if #char==(PWDCHR+SLASH)  then PWD+ SLASH+#str else
    if #char==(HOMECHR+SLASH) then HOME+SLASH+#str else
                                   S.

MACROS
  (#ok,#char,#str) = frontstring(length S-length SLASH) S.
  
EQNS
  check_end_slash(S,SLASH) =
    if #ok
    then if #str==SLASH then S else S+SLASH
    else S.
      
EQNS
  check_paths([],_,_,_,_,_) = [].
  check_paths([S|SS],PWD,HOME,SLASH,HOMECHR,PWDCHR) = 
     [check_end_slash(repl_spec(S,PWD,HOME,SLASH,HOMECHR,PWDCHR),SLASH)
     |check_paths(SS,PWD,HOME,SLASH,HOMECHR,PWDCHR)].

END.
