SPEC MSORT { mergesort } = 

FORMAL
 
SORTS 
  data. list ::= [data].
   
OPNS 
  compare :: data -> data -> boolean.

GLOBAL

OPNS 
  msort:: list -> list.


LOCAL

OPNS 
  split:: list -> (list,list).
  merge:: (list,list) -> list.
  
MACROS 
  (#part1,#part2) = split(L).
  
EQNS 
  msort([] ) = [].
  msort([D]) = [D].
 $msort(L  ) = merge(msort(#part1),msort(#part2)).
  
  split([       ]) = ([          ],[          ]).
  split([D1     ]) = ([D1        ],[          ]).
  split([D1,D2|L]) = ([D1| #part1],[D2| #part2]).

  merge(L,      [     ]) = L.
  merge([     ],[D2|L2]) = [D2|L2].
  merge([D1|L1],[D2|L2]) = if D1 _compare D2 
                           then [D2|merge([D1|L1],L2)]
                           else [D1|merge(L1,[D2|L2])].
END.
