SPEC MACHSERV =

LOCAL
  PATH +
  INOUT +
  REMOTE +
  READWRITE +
  FILE +
  BATCH +

OPNS
  search_right_path :: (string,string,string,strings,system)
                    -> (string,system).

MACROS
  (#exist,#sys) = existfile(PN+SPN+PFX) SYS.
  
EQNS
  search_right_path(SPN,PFX,PN,[],SYS) = 
    if #exist
    then (PN,#sys)
    else ("",#sys).
  search_right_path(SPN,PFX,P,[PN|PAS],SYS) =
    if #exist
    then (PN,#sys)
    else search_right_path(SPN,PFX,P,PAS,#sys).


  
OPNS read_mach_conf :: (strings,system)
                    -> (boolean,mach_conf,system).

MACROS
     (#p,#s) = search_right_path("net",".cfg","",PATHS,SYS).

EQNS read_mach_conf(PATHS,SYS) =
       in(#p+"net.cfg",[]::mach_conf,readdev,#s).



MACROS
     (#s,#q) = new_job ("sleep 2 ; hostname","Getting hostname\n") Q S.
OPNS start_jobs :: integer -> job_queue -> system -> (job_queue,system).
EQNS start_jobs I Q S =
       if I==0
       then (Q,S)
       else start_jobs (I-1) #q #s.
 
OPNS goal :: system -> system.

MACROS
     (#src_path,#sys_sp) = search_path S.
     (_,#mach_conf,#sys_mc) = read_mach_conf(#src_path,#sys_sp).
     (#ok,#i,#sys_who) = who_am_i #sys_mc.
     (#path_serv,#sys_ps) =
               search_right_path("aspserv","","",#src_path,#sys_who).
     (#rems,#sys_cr) = create_jobs #i #mach_conf 
                          (name_of_server_program (#path_serv+"aspserv")
                           #sys_ps).
     (#q,#s) = start_jobs 50 ([],true,#rems) #sys_cr.
     
EQNS goal S = system(batch_exec (#s,#q)).

END.
