SPEC LONGINT = SYSTEM +

SORTS
  int ::= [integer].
  
OPNS  
  int + int,
  int * int :: int.
  
  sqr, abs:: int -> int.
  
  sgn:: int -> integer. 
  
  int <  int, 
  int <= int, 
  int >  int, 
  int >= int :: boolean.
  
  int _div integer :: int.
  int _mod integer :: integer.
  newbase :: (int,integer,integer) -> int. 
  write_int :: (int,system) -> (boolean,system).
  
LOCAL 
  INTEGER_UTIL + STREAM +

OPNS
  plus :: integer -> int -> int -> int.
  mult1 :: integer -> integer -> int -> int.
  norm :: int -> int.
  write_int1 :: (int,system) -> (boolean,system).
  compare :: int -> int -> integer.
  comp :: int -> int -> integer.
  divmod :: (int,integer,integer) -> (int,integer).
       
MACROS 
  #MAX = 32768.  /* #MAX*#MAX+#MAX < 2^32 */
  #DEZ = 10000.
      
FORALL X,Y,Z :: int.
EQNS 
  abs []    = [].
  abs (A:X) = if A<0 then negate A:X else A:X.
  
  sgn []    = 0.
  sgn (A:X) = if A<0 then -1 elsif A > 0 then 1 else sgn X.
  
  X + Y = plus 0 X Y.
  
  plus C []    []    = if C == 0 then [] else [C].
  plus C []    (B:Y) = plus C (B:Y) [].
  plus C (A:X) []    = if A+C >= #MAX
                       then [(A+  C) _mod #MAX|plus((A+  C) _div #MAX) [] X]
                       else [A+C|X].
  plus C (A:X) (B:Y) = if A+B+C >= #MAX
                       then [(A+B+C) _mod #MAX|plus((A+B+C) _div #MAX) X Y]
                       else [A+B+C|plus 0 X Y].
    
  [   ] * [   ] = [].
  [_|_] * [   ] = [].
  [   ] * [_|_] = [].
  (A:X) * (B:Y) = mult1 A 0 (B:Y) + [0|X*(B:Y)].
  
  mult1 _ C [] = if C == 0 then [] else [C].
  mult1 A C (B:Y) =  
    if (A*B)+C >= #MAX
    then [(A*B)+C _mod #MAX|mult1 A ((A*B)+C _div #MAX) Y]
    else [(A*B)+C|mult1 A 0 Y].
    
  sqr X = X*X.
  
  compare X Y = if sgn X == sgn Y then comp X Y else sgn(sgn X-sgn Y).
  
  comp []    []    = 0.
  comp (A:X) []    = if A==0 then comp X [] else sgn A.
  comp []    (B:Y) = if B==0 then comp [] Y else negate(sgn B).
  comp (A:X) (B:Y) =
    if comp X Y == 0
    then sgn(A-B)
    else comp X Y.
    
  X <  Y = compare X Y <  0.
  
  X <= Y = compare X Y <= 0.
  
  X >  Y = compare X Y >  0.
  
  X >= Y = compare X Y >= 0.
      

  write_int(X,S) = write_int1(newbase(norm X,#MAX,#DEZ),S).
  
  norm [] = [].
  norm [A] = if A == 0 then [] else [A].
 $norm (A:X) =
    if norm X == []
    then norm [A]
    else [A|norm X].
   
  X _div N = int(divmod(X,#MAX,N)).
   
  X _mod N = integer(divmod(X,#MAX,N)). 

MACROS (#DIV,#MOD) = divmod(N:X,B0,B1).
EQNS  
  newbase([],_,_) = [].
 $newbase(N:X,B0,B1) = [#MOD|newbase(#DIV,B0,B1)].
  
MACROS 
  (#DIV,#MOD) = divmod(X,B0,B1).
  #N = N+(#MOD*B0).
      
/* By Ric 28.3.1990, assumes the following laws:
  (I)   (A*B) mod C = ((A mod C)*(B mod C)) mod C
  (II)  (A+B) mod C = ((A mod C)+(B mod C)) mod C
  (III) (A*B) div C = (A div C)*B + ((A mod C)*B) div C
  (IV)  (A+B) div C = (A div C) + (B div C) + ((A mod C)+(B mod C)) div C
*/
EQNS  
  divmod([],_,_) = ([],0).
  divmod(N:X,B0,B1) = 
    (if (#DIV == []) && ((#N _div B1) == 0)
      then []
      else [#N _div B1|#DIV],
      #N _mod B1).
  
OPNS  basedint::integer->string.
MACROS
	#str = integer_string A.
EQNS  basedint A = if (A < 0) then
			"-"++basedint (negate A)
		   else
			(rep (4-(length #str)) '0') ++ #str.
  
MACROS (#B,#S) = write_int1(X,S).
       #S2 = #S + (basedint N).
EQNS    
  write_int1([],S) = (true,S+"0").
  write_int1([N],S) = write(N,S).
 $write_int1(N:X,S) = 
    if #B
    then (true,#S2)
    else (#B,#S).
    
END.
