SPEC IDENTIFIER = STRINGS +
/*****************************************************************************/
/* Identifiers serve different purposes :                                    */
/*   - they can be read/written as numbers (0..N) or                         */
/*     as strings (dependent on io_mode)                                     */
/*   - they provide unique string-identifiers (efficient ==)                 */
/*****************************************************************************/

SORTS EXTERN identifier.  /* == entry, to provide extern READ/WRITE/EQ */
      identifiers ::= [identifier].

OPNS EXTERN no_ident        :: identifier.
     EXTERN id              :: identifier -> string.
     EXTERN nr              :: identifier -> integer.
            add_id          :: string -> system -> (boolean,identifier,system). 
            add_ids         :: strings -> system -> (identifiers,system).
                            /* repeated add_id   */
            get_ids         :: system -> (identifiers,system).
                            /* non-zero ids      */
     EXTERN inout_mode      :: boolean -> system -> system.
                            /* as string/number  */
            renumber        :: identifiers -> system -> system.
            clear_numbering :: system -> system.
                            /* zero ids          */

LOCAL
  HASH  ACTUAL SORTS data    = entry.
                     datas   = entries. 
               OPNS  hash    = hash_id.
                     compare = compare_id. END +
  ARRAY ACTUAL SORTS data    = entry.
                     array   = e_array.    END +
  STRING +
  ERROR +
  READWRITE +
  LISTOPS +

SORTS entry   ::= n(id::string,nr::integer).
      entries ::= [entry].
      e_arrays::= [e_array].
  
OPNS  hash_id :: entry -> integer.
EQNS  hash_id (n(E,_)) = hash E _mod max_size.

OPNS  compare_id :: (entry,entry) -> integer.
EQNS  compare_id (n(E1,_),n(E2,_)) = compare E1 E2.
   
SORTS idtree ::= ids(integer,hashtable,e_arrays).
  
OPNS  no_entry :: entry.
EQNS  no_entry = id_entry no_ident.

OPNS  EXTERN entry_id   :: entry -> identifier.
      EXTERN id_entry   :: identifier -> entry.
      EXTERN set_nr     :: integer -> identifier -> identifier.  /* Pfu-usch */ 
      EXTERN set_idtree :: idtree -> system -> system.              
      EXTERN get_idtree :: system -> (idtree,system).
      EXTERN io_mode    :: boolean.

MACROS 
     (#Tree0,#S) = get_idtree S. 
     (#Exists,#E,#Tree) = add_id STR #Tree0.
     (#Ids,#Tree1) = add_ids STRS #Tree0.

OPNS add_id :: string -> idtree -> (boolean,identifier,idtree).
EQNS add_id STR S = (#Exists,#E,set_idtree #Tree #S).

OPNS add_ids :: strings -> idtree -> (identifiers,idtree).
EQNS add_ids STRS S = (#Ids,set_idtree #Tree1 #S).

MACROS
     (#Exists,#E,#Table) = enter (n(Id,Max),Table).
     #Arrays = assign Max #E Arrays.

EQNS add_id Id (ids(Max,Table,Arrays)) =
       if #Exists && (nr #E >= 0)
       then (true,entry_id #E,ids(Max,#Table,Arrays))
       else (false,set_nr Max (entry_id #E),ids(Max+1,#Table,#Arrays)).

MACROS
     (_,#Id,#Tree0) = add_id S Tree.
     (#Ids,#Tree) = add_ids SS #Tree0.

EQNS add_ids [    ] (Tree::idtree) = ([        ],Tree).
     add_ids [S|SS] (Tree::idtree) = ([#Id|#Ids],#Tree).

MACROS 
     (#Tree,#S) = get_idtree S.

EQNS get_ids S = (get_ids #Tree,set_idtree #Tree #S).

OPNS get_ids :: idtree -> identifiers.
EQNS get_ids (ids(Max,_,Arrays)) = get_ids Max Arrays.

OPNS get_ids :: integer -> e_arrays -> identifiers.
EQNS get_ids _ [] = [].
     get_ids I [A|As] =
       if I < max_size
       then get_ids 0 I A
       else get_ids 0 max_size A ++ get_ids (I-max_size) As.

OPNS get_ids :: integer -> integer -> e_array -> identifiers.
EQNS get_ids I N Array =
       if I == N
       then []
       else [entry_id (entry(value(I,no_entry,Array)))|get_ids (I+1) N Array].

MACROS
     (#Ids,#S) = get_idtree S. 

EQNS clear_numbering S = set_idtree (clear_numbering #Ids) #S.

OPNS clear_numbering :: idtree -> idtree.
EQNS clear_numbering (ids(Max,Table,Arrays)) =
       ids(0,Table,clear_numberings Max Arrays).

OPNS clear_numberings :: integer -> e_arrays -> e_arrays.
EQNS clear_numberings _ [] = [].
     clear_numberings N [A|As] =
       if N < max_size
       then [clear_numbering 0 N        A]
       else [clear_numbering 0 max_size A|clear_numberings (N-maxsize) As].
 
MACROS
     (_,#E) = value (I,no_entry,A). 
     (_,#A) = assign (I,id_entry(set_nr(-1) (entry_id #E)),A).
 
OPNS clear_numbering :: integer -> integer -> e_array -> e_array.
EQNS clear_numbering I N A =
       if I == N
       then A
       else clear_numbering (I+1) N #A.

MACROS 
     (#Tree,#S) = get_idtree S.

EQNS renumber Ids S = set_idtree (renumber Ids (clear_numbering #Tree)) #S.
  

OPNS renumber :: identifiers -> idtree -> idtree.
EQNS renumber [      ] (Tree::idtree) = Tree.
     renumber [Id|Ids] Tree = 
       renumber Ids 
         if nr Id >= 0
         then Tree
         else idtree (adjust Id Tree).
  
MACROS
     (#Tree,#S) = get_idtree S.
     (#Found,#Id) = lookup_id I #Tree.

OPNS lookup_id :: integer -> system -> (boolean,identifier,system).
EQNS lookup_id I S = (#Found,#Id,set_idtree #Tree #S).

MACROS
     (#B,#E) = value I no_entry Arrays.

OPNS lookup_id :: integer -> idtree -> (boolean,identifier).  
EQNS lookup_id I (ids(Max,_,Arrays)) =
       if I < Max
       then (#B,entry_id #E)
       else (false,entry_id no_entry).

OPNS value :: integer -> entry -> e_arrays -> (boolean,entry).
EQNS value _ E [] = (false,E).
     value Idx E [A|As] =
       if Idx < max_size
       then value(Idx,E,A)
       else value(Idx-max_size) E As.

MACROS
     (#Tree0,#S) = get_idtree S.
     (#Nr,#Tree) = adjust Id #Tree0.

OPNS adjust :: identifier -> system -> (integer,system).
EQNS adjust Id S = (#Nr,set_idtree #Tree #S).


OPNS adjust :: identifier -> idtree -> (integer,idtree).
EQNS adjust Id (ids(Max,Tree,Arrays)) =
       (Max,ids(Max+1,Tree,assign Max (id_entry(set_nr Max Id)) Arrays)).


OPNS assign :: integer -> entry -> e_arrays -> e_arrays.
EQNS assign _ E [] =
       let New = e_array(create_array(max_size,n("",0))).
           (_,New) = assign(0,E,New).
       in [New].
     assign Idx E [A|As] =
       if Idx < max_size
       then let (_,A) = assign(Idx,E,A).
            in [A|As]
       else [A|assign (Idx-max_size) E As].

MACROS
     (#StrOk,#Str,#S0) = read("",S). 
     (_,     #Id1,#S1) = add_id    #Str #S0.
     (#IntOk,#Int,#S2) = read(0,S). 
     (#Found,#Id3,#S3) = lookup_id #Int #S2.

OPNS read_ident :: (identifier,system) -> (boolean,identifier,system).
EQNS read_ident (Id,S) =
       if io_mode /* as string/integer ? */
       then if #StrOk
            then (#StrOk,#Id1,#S1)
            else (#StrOk,Id,  #S0)
       else if #IntOk
            then (#Found,#Id3,#S3)
            else (#IntOk,Id,  #S2).

MACROS
     (#Nr,#S) = adjust Id S.    

OPNS write_ident :: (identifier,system) -> (boolean,system). 
EQNS write_ident (Id,S) =
       if io_mode /* as string/integer ? */
       then write (id Id,S)
       elsif (nr Id >= 0) 
       then write (nr Id,S)
       else write (#Nr,#S).

OPNS initial :: idtree.
EQNS initial = ids(0,hashtable(create max_size),
                     [e_array(create_array(max_size,n("",0)))]).

MACROS
     (_,#NOId,#T) = add_id "" initial.

OPNS init :: system -> (identifier,system).  /* sollte in die Initialisierung */
EQNS init S = (#NOId,set_idtree #T S).
  
  /* no_ident = #NOId. */
END.
