SPEC HASH =
FORMAL SORTS data. datas ::= [data].
OPNS 
  compare::(data,data) -> integer.
  hash::data -> integer.
   
 
GLOBAL
  ARRAY ACTUAL SORTS data    = datas.
                     array   = hashtable.
               OPNS  maxsize = max_size.
        END +

/** SORTS hashtable. **/
OPNS
  create:: integer -> (boolean,hashtable).
  enter::(data,hashtable) -> (boolean,data,hashtable).
  lookup::(data,hashtable) -> (boolean,data).
  
LOCAL
  INTEGER +
  
OPNS
  insert::(data,datas) -> (boolean,data,datas).
  search::(data,datas) -> (boolean,data).

MACROS
  #I=hash(D).
  #VAL=datas(value(#I,[],HT)).
  (#EXISTS,#D,#L)=insert(D,#VAL).
EQNS
  create(N) = create_array(N,[]).
  
  enter(D,HT) =
    (#EXISTS,#D,hashtable(assign(#I,#L,HT))).
    
  lookup(D,HT) = search(D,#VAL).
  
MACROS 
  (#B,#D,#DD) =insert(D,DD).
  #COMP=compare(D,D2).
EQNS
  insert(D,[]) = (false,D,[D]).
  insert(D,[D2|DD]) =
    if #COMP < 0
    then (false,D,[D,D2|DD])
    elsif #COMP == 0
    then (true,D2,[D2|DD])
    else (#B,#D,[D2|#DD]).
    
  search(D,[]) = (false,D).
  search(D,[D2|DD]) =
    if #COMP < 0
    then (false,D)
    elsif #COMP == 0
    then (true,D2)
    else search(D,DD).
    
END.
