{ Remote batch jobs support }


SPEC BATCH =

  REMOTE +
  STRINGS +

SORTS mach_conf ::= (strings).

      job.
      jobs ::= [job].

      batch.
      batches ::= [batch].

      job_queue ::= (batches,boolean,jobs).

OPNS  create_jobs :: string -> mach_conf -> system -> (jobs,system).
      new_job :: (string,string) -> job_queue -> system -> (system,job_queue).
      batch_exec :: (system,job_queue) -> (boolean,system).



LOCAL
  SYSTEM +
  LISTOPS +
  STREAM +

SORTS job   ::= idle remote
              | working remote string.

      batch ::= waiting string string.

   
MACROS
     (#yes,#rem,#create) = create MACH S.
     (#more,#sys) = create_jobs I MORE #create.

EQNS create_jobs _ [] S = ([],S).
     create_jobs I [MACH|MORE] S =
       if MACH == I 
       then create_jobs I MORE S
       elsif #yes
       then ([idle #rem|#more],#sys) 
       else (#more,#sys).

OPNS get_output :: remote -> system -> system.
MACROS (#ok,#ln,#sys) = next_line_of_output R S.
EQNS   get_output R S =
          if #ok
          then get_output R (S+#ln)
          else #sys.

MACROS
     (#yes,#sys) = is_working REM S.
     (#ok0,#jo0,#sy0) = finishup JOBS #sys.
     #sy1 = get_output REM (#sys+"[done at "+who REM+"] "+MSG).
     (_,#retstat,#sy2) = return_status REM #sy1.
     (#ok3,#jo3,#sy3) = finishup JOBS #sy2.
     (#ok4,#jo4,#sy4) = finishup JOBS S.

OPNS finishup :: jobs -> system -> (boolean,jobs,system).

EQNS finishup [] S = (true,[],S).
     finishup [working REM MSG|JOBS] S =
       if #yes
       then (#ok0,[working REM MSG|#jo0],#sy0)
       else ((#retstat==0) && #ok3,[idle REM|#jo3],#sy3).
     finishup [idle WHO|JOBS] S = (#ok4,[idle WHO|#jo4],#sy4).
       
OPNS all_ready :: jobs -> boolean.
EQNS all_ready [] = true.
     all_ready [idle _|MORE] = all_ready MORE.
    $all_ready _ = false.

OPNS sort_jobs :: jobs -> jobs.
EQNS sort_jobs [] = [].
     sort_jobs [working WHO MSG|JOBS] = sort_jobs JOBS ++ [working WHO MSG].
     sort_jobs [idle WHO|JOBS] = [idle WHO|sort_jobs JOBS].

MACROS
     (#cmd,#exec) = issue_command CMD WHO S.
OPNS initiate :: job_queue -> system -> (system,job_queue).
EQNS initiate ([],ALLOK,JOBS) S = (S,([],ALLOK,JOBS)).
     initiate ([waiting CMD MSG|MORE],ALLOK,[idle WHO|JOBS]) S =
       if #cmd
       then initiate (MORE,ALLOK,JOBS++[working WHO MSG]) #exec
       else initiate ([waiting CMD MSG|MORE],ALLOK,JOBS)   #exec.
    $initiate QUEUE S = (S,QUEUE).

MACROS
     (#ok,#jobs,#sys) = finishup JOBS SYS.
     (#ok_exec,#ret_exec,#exec)  = execute WHAT (SYS+MSG).
     
EQNS new_job (WHAT,MSG) ([],OK,[]) SYS =
        (#exec,([],OK && #ok_exec && (#ret_exec==0),[])). 
    $new_job (WHAT,MSG) (BATCH,ALLOK,JOBS) SYS =
        initiate (BATCH++[waiting WHAT MSG],ALLOK && #ok,sort_jobs #jobs) #sys.

MACROS
     (#ok,#jobs,#sys) = finishup JOBS SYS.
     (#syq,(#batch,#allok,#jobs2)) = initiate (BATCH,ALLOK,#jobs) #sys.
     (#ok_exec,#ret_exec,#exec)  = execute CMD (#syq+MSG).

EQNS batch_exec (SYS,([],ALLOK,JOBS)) =
        if all_ready JOBS
        then (ALLOK,SYS)
        else batch_exec (#sys,([],ALLOK && #ok,#jobs)).
     batch_exec (SYS,([waiting CMD MSG|BATCH],ALLOK,JOBS)) =
        batch_exec (#exec,(#batch,#allok && #ok_exec && (#ret_exec==0),#jobs2)).

END.
