/*-------------------------------------------------------------------------*/
/* Prolog To Wam Compiler                INRIA Rocquencourt - CLoE Project */
/* C Run-time                                           Daniel Diaz - 1994 */
/*                                                                         */
/* Builtins - Header file                                                  */
/*                                                                         */
/* builtin.h                                                               */
/*-------------------------------------------------------------------------*/

/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

          /* from dec10io.h */

extern FILE *input;
extern char  input_name[];
extern FILE *output;
extern char  output_name[];




/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/

void      Simple_Write_Term     (WamWord *start_adr);

void      Complex_Write_Term    (FILE *out,int prec,Bool quote,Bool op,
                                 WamWord *start_adr);

WamWord   Read_Term             (FILE *in,Bool error_report,Bool error_fail);

int       Compare_Term          (WamWord *start_u_adr,WamWord *start_v_adr);




          /* Inline Functions (math functions on integers as macros)*/

#define Fct_1_neg(x)               (-x)

#define Fct_1_inc(x)               (x+Tag_Value(INT,1))

#define Fct_1_dec(x)               (x-Tag_Value(INT,1))

#define Fct_2_add(x,y)             (x+y)

#define Fct_2_sub(x,y)             (x-y)

#define Fct_2_mul(x,y)             (M_Mul(x,(y>>TAG_SIZE)))

#define Fct_2_div(x,y)             (M_Div(x,y)<<TAG_SIZE)

#define Fct_2_mod(x,y)             (M_Mod(x,y))

#define Fct_2_and(x,y)             (x&y)

#define Fct_2_or(x,y)              (x|y)

#define Fct_2_xor(x,y)             (Tag_INT(UnTag_INT(x)^UnTag_INT(y)))

#define Fct_1_not(x)               ((~x)-((1<<TAG_SIZE)-1))

#define Fct_2_shl(x,y)             (x<<UnTag_INT(y))

#define Fct_2_shr(x,y)             (Tag_INT(UnTag_INT(x) >> UnTag_INT(y)))





          /* Term Comparison Inline Builtins */

Bool      Blt_2_term_eq         (WamWord x,WamWord y);
Bool      Blt_2_term_neq        (WamWord x,WamWord y);
Bool      Blt_2_term_lt         (WamWord x,WamWord y);
Bool      Blt_2_term_lte        (WamWord x,WamWord y);
Bool      Blt_2_term_gt         (WamWord x,WamWord y);
Bool      Blt_2_term_gte        (WamWord x,WamWord y);





          /* Math Inline Builtins */

Bool      Blt_2_eq              (WamWord x,WamWord y);
Bool      Blt_2_neq             (WamWord x,WamWord y);
Bool      Blt_2_lt              (WamWord x,WamWord y);
Bool      Blt_2_lte             (WamWord x,WamWord y);
Bool      Blt_2_gt              (WamWord x,WamWord y);
Bool      Blt_2_gte             (WamWord x,WamWord y);

Bool      Blt_1_var             (WamWord x);
Bool      Blt_1_nonvar          (WamWord x);
Bool      Blt_1_atom            (WamWord x);
Bool      Blt_1_integer         (WamWord x);
Bool      Blt_1_number          (WamWord x);
Bool      Blt_1_atomic          (WamWord x);
Bool      Blt_1_compound        (WamWord x);


Bool      Load_Math_Expression  (WamWord exp,WamWord *result);





          /* Global Variable Builtins */

Bool      Blt_2_g_assign        (WamWord gvar,WamWord gval);
Bool      Blt_2_g_read          (WamWord gvar,WamWord gval);


