/*-------------------------------------------------------------------------*/
/* Prolog to Wam Compiler               INRIA Rocquencourt - ChLoE Project */
/* Buit-In Predicates                                   Daniel Diaz - 1994 */
/*                                                                         */
/* inline bips definitions (for call/1)                                    */
/*                                                                         */
/* inline.pl                                                               */
/*-------------------------------------------------------------------------*/

          /* for call/1, inline Built-ins (e.g. =/2) must be defined here */

:- public (=)/2.

X=X.




:- public (==)/2, (\==)/2, (@<)/2, (@=<)/2, (@>)/2, (@>=)/2.


X == Y:-
	X == Y.

X \== Y:-
	X \== Y.

X @< Y:-
	X @< Y.

X @=< Y:-
	X @=< Y.

X @> Y:-
	X @> Y.

X @>= Y:-
	X @>= Y.




:- public is/2, (=:=)/2, (=\=)/2, (<)/2, (=<)/2, (>)/2, (>=)/2, eval/2.

Var is ExpX:-
	eval(ExpX,X),
	Var=X.

ExpX =:= ExpY:-
	eval(ExpX,X),
	eval(ExpY,Y),
	X =:= Y.

ExpX =\= ExpY:-
	eval(ExpX,X),
	eval(ExpY,Y),
	X =\= Y.

ExpX < ExpY:-
	eval(ExpX,X),
	eval(ExpY,Y),
	X < Y.

ExpX =< ExpY:-
	eval(ExpX,X),
	eval(ExpY,Y),
	X =< Y.

ExpX > ExpY:-
	eval(ExpX,X),
	eval(ExpY,Y),
	X > Y.

ExpX >= ExpY:-
	eval(ExpX,X),
	eval(ExpY,Y),
	X >= Y.




eval(Exp,V):-
	eval1(Exp,V),
	!.

eval(Exp,_):-
	write('Error: '), write(Exp),
	write(' Illegal arithmetic expression'), nl,
	fail.



eval1(Exp,_):-
	var(Exp),
	!,
	fail.

eval1(Exp,Exp):-
	integer(Exp).

eval1([ExpX],V):-
	eval1(ExpX,V).

eval1(+(ExpX),V):-
	eval1(ExpX,V).

eval1(-(ExpX),V):-
	eval1(ExpX,X),
	V is -X.

eval1(ExpX + ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X + Y.

eval1(ExpX - ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X - Y.

eval1(ExpX * ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X * Y.

eval1(ExpX // ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X // Y.

eval1(ExpX mod ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X mod Y.

eval1(ExpX /\ ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X /\ Y.

eval1(ExpX \/ ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X \/ Y.

eval1(ExpX ^ ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X ^ Y.

eval1(\(ExpX),V):-
	eval1(ExpX,X),
	V is \(X).

eval1(ExpX << ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X << Y.

eval1(ExpX >> ExpY,V):-
	eval1(ExpX,X),
	eval1(ExpY,Y),
	V is X >> Y.



:- public var/1, nonvar/1, atom/1, integer/1, number/1, atomic/1, compound/1.

var(X):-
	var(X).

nonvar(X):-
	nonvar(X).

atom(X):-
	atom(X).

integer(X):-
	integer(X).

number(X):-
	number(X).

atomic(X):-
	atomic(X).

compound(X):-
	compound(X).




:- public g_assign/2, g_read/2.


g_assign(Var,Value):-
	g_assign(Var,Value).




g_read(Var,Value):-
	g_read(Var,Value).


