/*  $Id: pce_manual.pl,v 1.9 1993/09/12 10:32:09 jan Exp $

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1993 University of Amsterdam. All rights reserved.
*/


:- module(pce_manual,
	  [ manpce/0
	  , manpce/1
	  ]).


:- use_module(library(pce)).

:- use_module(
	[ 'man/p_card'		% General card infra-structure
	, 'man/p_data'		% Manual specific infra-structure
	, 'man/v_manual'	% Top level window
	]).


:- pce_autoload(man_class_browser,	'man/v_class').
:- pce_autoload(man_editor,		'man/v_editor').
:- pce_autoload(man_card_editor,	'man/v_card').
:- pce_autoload(man_summary_browser,	'man/v_summary').
:- pce_autoload(man_class_hierarchy,	'man/v_hierarchy').
:- pce_autoload(man_keyword_browser,	'man/v_keyword').
:- pce_autoload(man_topic_browser,	'man/v_topic').
:- pce_autoload(man_module_browser,	'man/v_module').
:- pce_autoload(man_statistics,		'man/v_statistics').
:- pce_autoload(isp_frame,		'man/v_inspector').
:- pce_autoload(vis_frame,		'man/v_visual').
:- pce_autoload(man_instance_browser,	'man/v_instance').
:- pce_autoload(man_global,		'man/v_global').
:- pce_autoload(man_object_browser,	'man/v_global').
:- pce_autoload(man_error_browser,	'man/v_error').
:- pce_autoload(man_group_browser,	'man/v_group').

:- pce_global(@manual, new(man_manual)).

manpce :-
	send(@manual, open).


manpce(Spec) :-
	(   method(Spec, Object)
	->  send(@manual, open),
	    (   send(Object, instance_of, class)
	    ->  send(@manual, start_tool, class_browser),
		send(@manual, request_tool_focus, Object)
	    ;	send(@manual, request_selection, @nil, Object, @on)
	    )
	;   format(user_error, '[manpce/1: Cannot find: ~w]~n', Spec)
	).


method(Obj, Obj) :-
	object(Obj), !.
method(->(ClassName, Selector), Method) :- !,
	get(@pce, convert, ClassName, class, Class),
	get(Class, send_method, Selector, Method).
method(<-(ClassName, Selector), Method) :- !,
	get(@pce, convert, ClassName, class, Class),
	get(Class, get_method, Selector, Method).
method(ClassName, Class) :-
	atom(ClassName),
	get(@pce, convert, ClassName, class, Class).
