/*  $Id$

    Part of XPCE
    Designed and implemented by Anjo Anjewierden and Jan Wielemaker
    E-mail: jan@swi.psy.uva.nl

    Copyright (C) 1993 University of Amsterdam. All rights reserved.
*/

:- module(emacs_smail_mode, []).
:- use_module(library(pce)).

:-	new(KB, key_binding(smail, text)),
	send(KB, function, '\C-c\C-s', send_message).

:-	new(_X, syntax_table(smail, text)).

:-	new(MM, emacs_mode_menu(smail, text)),
	send(MM, append, mail, send_message).

:- pce_begin_class(emacs_smail_mode, emacs_text_mode).

resource(send_mail_program, name, '/usr/lib/sendmail -em -t -t').
resource(record,	    file*, '~/mail/mbox-out').

open_message(M, Receiver:string) :->
	"Create an emty message"::
	get(M, resource_value, record, RecordFile),

	send(M, clear),
	send(M, insert, string('To: %s\n', Receiver)),
	send(M, insert, string('Subject: \n')),
	(   RecordFile \== @nil
	->  send(M, insert, string('FCC: %s\n', RecordFile?name))
	;   true
	),
	send(M, insert, string('--text follows this line--\n')),

	send(M, top_of_file),		% goto subject field
	send(M, next_line),
	send(M, end_of_line).


send_message(M) :->
	"Append message to FCC and deliver"::
	(   get(M, field, 'FCC', SaveFile) % append to FCC file
	->  new(F, file(SaveFile)),
	    send(F, open, append),
	    send(F, append, M?contents),
	    send(F, close),
	    send(M, report, progress, 'Appended to %s', SaveFile)
	;   true
	).
	

field(M, Field:name, Value:string) :<-
	"Get value of specified field"::
	get(M, text_buffer, TB),
	new(R, regex(string('^%s:\s +\(.*\)', Field))),
	send(R, search, TB),
	get(R, register_value, TB, 1, Value).

:- pce_end_class.
