%-----------------------------------------------------------------------%
%									%
%			Edipo - sicstus/quintus version			%
%									%
%						August 90		%
%						Ze' Paulo Leal		%
%						Universidade do Porto	%
%									%
%-----------------------------------------------------------------------%
%									%
%	file :		window.pl					%
%	purpose : 	window and display creation			%
%	creation	90/08/01					%
%	last changes :	92/04/10					%
%	bugs :								%
%	comments :	some attr. of window/2 are not impemented	%
%									%
%-----------------------------------------------------------------------%



%	if Name refers to an existing window
%		change Attrs in Name
%	else
%		creates a window Name with Attrs
%	Name is the new working window

window(Name,Attr) :- 
	set_window(Name,Attr,Display,Window,_,UnusedAttr), !,
	set_attr_list(UnusedAttr,Display,Window,_Clear),
	x_flush(Display).


%	selects Name as the working window
%	(like window(Name,[]) if Name is an existing window 
%	but gives an error otherwise)

working_window(Name) :-
	(recorded('$window','$window'(Name,Display,Window,GC),Ref) ->
	    erase(Ref), 
	    recorda('$window','$window'(Name,Display,Window,GC),_)
	;
	    format('[[edipo: unknown window "~w" ]]~n',Name)
	).

	

current_window(Name,Attrs) :-
	recorded('$window','$window'(Name,Display,Window,_),_),
	(var(Attrs) ->
	    findall(A=V,(
		    	current_window_attr(A),
			get_window_attr(A,Display,Window,Name,V)
		    ),Attrs)
	    ;
	    match_window_attr(Attrs,Display,Window,Name)
	).


match_window_attr([],_Display,_Window,_Name).
match_window_attr([Attr=Value|List],Display,Window,Name) :-
	get_window_attr(Attr,Display,Window,Name,Value),
	match_window_attr(List,Display,Window,Name).

get_window_attr(Attr,Display,Window,Name,Value) :-
	(p_get_window_attr(Attr,Display,Window,Name,Value) ->
	    otherwise
	;
	    x_get_window_attr(Display,Window,Attr,Value,S),
	    (S=true -> 	
		otherwise
	    ;
	        format('[[edipo: unknown window attr "~w" ]]~n',Attr),
		fail
	    )
	).

p_get_window_attr(parent,_,_,Name,Value) :-
	recorded('$parent','$parent'(Value,Name),_).
p_get_window_attr(display,Display,_,_,Value) :-
	recorded('$display','$display'(Value,Display),_).

% ----

destroy :- 	
	recorded('$window','$window'(Name,Display,_,_),_), !,
	destroy_window(Name),
	x_flush(Display).

destroy_window(Name) :-
	recorded('$parent','$parent'(Name,Son),Ref), 
	erase(Ref),
	destroy_window(Son),
	fail.
destroy_window(Name) :-
	recorded('$window','$window'(Name,Display,Window,_),WRef), erase(WRef),
	recordz('$zombie',Name,_),
	(
	    recorded('$gc','$gc'(_GCName,Window,_GC),GCRef), 
	    erase(GCRef),
	    fail
	; 
	true),
	x_destroy(Display,Window).

clear :- 	
	recorded('$window','$window'(_,Display,Window,_),_), !,
	x_clear(Display,Window),
	x_flush(Display).


color_off  :-
	\+ clause(color,( !, fail)),
	asserta((color :- !, fail)).


color_on :-
	retract((color :- !, fail)).

:- dynamic color/0.

color :- 
	edipo_on,
	get_display(_,Display), !,
	\+ x_color(Display,1).

color_planes(Planes) :- 
	edipo_on,
	get_display(_,Display), !,
	x_color(Display,Planes).


map :- 	
	recorded('$window','$window'(_,Display,Window,_),_), !,
	x_map(Display,Window),
	x_flush(Display).

unmap :- 	
	recorded('$window','$window'(_,Display,Window,_),_), !,
	x_unmap(Display,Window),
	x_flush(Display).

raise :-
	recorded('$window','$window'(_,Display,Window,_),_), !,
	x_raise(Display,Window),
	x_flush(Display).

lower :-
	recorded('$window','$window'(_,Display,Window,_),_), !,
	x_lower(Display,Window),
	x_flush(Display).




create_unmapped :- recorda('$dont_map','$dont_map',_).

create_mapped :-  recorded('$dont_map','$dont_map',R), erase(R), fail; true.

/* get things */


get_display(Name,D) :- 
	(recorded('$display','$display'(Name,D),_) -> 
	    otherwise
	;
	    x_display(Name,D),
	    (D=0 ->
	         format('[[edipo: cannot conect with "~w" (try: setenv DISPLAY <machine>:0.0>)]]~n',Name),
		 abort
;
		recorda('$display','$display'(Name,D),_),
		/* when no display is available edipo must be initialized */
	        x_my_init_edipo(D),
	        init_edipo
	     )
	 ).
	

get_default_pixels(D,WH,BL) :-
	(
	    recorded('$pixels','$pixels'(WH,BL),_) -> otherwise
	;
	x_get_color_pixel(D,white,WH),
	x_get_color_pixel(D,black,BL),
	recorda('$pixels','$pixels'(WH,BL),_)
    ).


/*
	NONE is 0		
	COPY_FROM_PARENT is 0	
*/

set_window(Name,Attr,Display,Window,GC,Attr) :- 
	recorded('$window','$window'(Name,Display,Window,GC),Ref), !,
	erase(Ref), 
	recorda('$window','$window'(Name,Display,Window,GC),_).
set_window(Name,Attr,Display,Window,GC,UnusedAttr) :-
	get_display('',Display),
	get_default(Attr,parent,[],UA0,ParentName),
	(ParentName=[] -> x_default_root_window(Display,Parent);
	    recorded('$window','$window'(ParentName,Display,Parent,_),_)),

	get_default(UA0,x,20,UA1,X),
	get_default(UA1,y,30,UA2,Y),
	get_default(UA2,width,350,UA3,Width), 
	(Width >0 -> otherwise;	    
	    format('[[edipo: illegal window size ~w]]~n',width=Width), abort),
	get_default(UA3,height,300,UA4,Height), 
	(Height >0 -> otherwise;	    
	    format('[[edipo: illegal window size ~w]]~n',height=Height),abort),
	get_default(UA4,border,0,UA5,Border),
	UnusedAttr=UA5,
	x_create_window(Display,Parent, X,Y,Width,Height,Border, 0,0, 0,0,Window),
	(atom(Name) ->
	    x_set_standart_properties(Display,Window,Name,Name,0,0,0,0);
	    Default='#no name#',
	    x_set_standart_properties(Display,Window,Default,Default,0,0,0,0)
	),
	get_gc(Name,Display,Window,GC),
	x_my_select_input(Display,Window),
						% window default values

	get_default_pixels(Display,WH,_),
	x_set_window_background(Display,Window,WH),

	(recorded('$dont_map','$dont_map',_) -> 
	    true ; 
	    x_map(Display,Window)
	),

	recorda('$parent','$parent'(ParentName,Name),_),
	recorda('$window','$window'(Name,Display,Window,GC),_).
	

get_default([],_,V,[],V).
get_default([A=V|R],A,_,R,V) :- !.
get_default([AV|R],A,D,[AV|S],V) :- get_default(R,A,D,S,V).

get_default_font(_,Font) :-
	recorded('$default_font',Font,_), !.
get_default_font(Display,Font) :-
	x_init_font_list(Display,'-adobe-times-bold-r-*120*'),
	x_list_font(FontName), 
	x_load_font(Display,FontName,Font),
	recorda('$default_font',Font,_), !.

set_attr_list([],D,W,C) :- 
	x_my_change_window(D,W),
	(var(C) -> otherwise; x_clear(D,W)  ).
set_attr_list([A=V|R],D,W,C) :-
	(set_an_attr(A,D,W,V,C) -> otherwise;
	    format('[[edipo: illegal attribute pair ~w]]~n',A=V)),
	set_attr_list(R,D,W,C).

/* configure window */
set_an_attr(x,_,_,V,_) :- x_config_window(x,V).
set_an_attr(y,_,_,V,_) :- x_config_window(y,V).
set_an_attr(width,_,_,V,_) :- x_config_window(width,V).
set_an_attr(height,_,_,V,_) :- x_config_window(height,V).
set_an_attr(border,_,_,V,_) :- x_config_window(border,V).

set_an_attr(parent,D,W,V,_) :-
	recorded('$window','$window'(V,D,P,_),_),	
	x_get_window_attr(D,P,x,X),
	x_get_window_attr(D,P,y,Y),
	x_reparent_window(D,W,P,X,Y),
	recorded('$window','$window'(N,D,W,_),_),
	recorded('$parent','$parent'(_,N),R), erase(R),
	recorda('$parent','$parent'(V,N),_).
set_an_attr(bkg_pixmap,D,W,V,clear) :- 
	get_pixmap(V,P),
/*	x_set_window_attr(bkg_pixmap,P),  this attr should not be set */
	x_set_window_background_pixmap(D,W,P).
set_an_attr(bkg_pixel,D,_,V,clear) :- 
	x_get_color_pixel(D,V,C),
	x_set_window_attr(bkg_pixel,C).
set_an_attr(border_pixmap,D,W,V,_) :- 
	get_pixmap(V,P),
/*	x_set_window_attr(border_pixmap,P),   this attr should not be set */
	x_set_window_border_pixmap(D,W,P).
set_an_attr(border_pixel,D,_,V,_) :- 
	x_get_color_pixel(D,V,C),	
	x_set_window_attr(border_pixel,C).
set_an_attr(cursor,D,_,V,_) :- 
	cursor_number(V,N),
	x_create_font_cursor(D,N,C),
	x_set_window_attr(cursor,C).

cursor(X) :- cursor_number(_,X).

cursor_number('X_cursor', 0).
cursor_number(arrow, 2).
cursor_number(based_arrow_down, 4).
cursor_number(based_arrow_up, 6).
cursor_number(boat, 8).
cursor_number(bogosity, 10).
cursor_number(bottom_left_corner, 12).
cursor_number(bottom_right_corner, 14).
cursor_number(bottom_side, 16).
cursor_number(bottom_tee, 18).
cursor_number(box_spiral, 20).
cursor_number(center_ptr, 22).
cursor_number(circle, 24).
cursor_number(clock, 26).
cursor_number(coffee_mug, 28).
cursor_number(cross, 30).
cursor_number(cross_reverse, 32).
cursor_number(crosshair, 34).
cursor_number(diamond_cross, 36).
cursor_number(dot, 38).
cursor_number(dotbox, 40).
cursor_number(double_arrow, 42).
cursor_number(draft_large, 44).
cursor_number(draft_small, 46).
cursor_number(draped_box, 48).
cursor_number(exchange, 50).
cursor_number(fleur, 52).
cursor_number(gobbler, 54).
cursor_number(gumby, 56).
cursor_number(hand1, 58).
cursor_number(hand2, 60).
cursor_number(heart, 62).
cursor_number(icon, 64).
cursor_number(iron_cross, 66).
cursor_number(left_ptr, 68).
cursor_number(left_side, 70).
cursor_number(left_tee, 72).
cursor_number(leftbutton, 74).
cursor_number(ll_angle, 76).
cursor_number(lr_angle, 78).
cursor_number(man, 80).
cursor_number(middlebutton, 82).
cursor_number(mouse, 84).
cursor_number(pencil, 86).
cursor_number(pirate, 88).
cursor_number(plus, 90).
cursor_number(question_arrow, 92).
cursor_number(right_ptr, 94).
cursor_number(right_side, 96).
cursor_number(right_tee, 98).
cursor_number(rightbutton, 100).
cursor_number(rtl_logo, 102).
cursor_number(sailboat, 104).
cursor_number(sb_down_arrow, 106).
cursor_number(sb_h_double_arrow, 108).
cursor_number(sb_left_arrow, 110).
cursor_number(sb_right_arrow, 112).
cursor_number(sb_up_arrow, 114).
cursor_number(sb_v_double_arrow, 116).
cursor_number(shuttle, 118).
cursor_number(sizing, 120).
cursor_number(spider, 122).
cursor_number(spraycan, 124).
cursor_number(star, 126).
cursor_number(target, 128).
cursor_number(tcross, 130).
cursor_number(top_left_arrow, 132).
cursor_number(top_left_corner, 134).
cursor_number(top_right_corner, 136).
cursor_number(top_side, 138).
cursor_number(top_tee, 140).
cursor_number(trek, 142).
cursor_number(ul_angle, 144).
cursor_number(umbrella, 146).
cursor_number(ur_angle, 148).
cursor_number(watch, 150).
cursor_number(xterm, 152).
