
:- module(dialog,[]).

:- ensure_loaded(library(ytoolkit)).

:- ytoolkit:super_class(dialog:dialog_box).

default(width,300).
default(height,150).
default(font,Font) :- current_font('*bold*',Font).

default(text,text).
default(callback(FieldText),writestring(20,20,FieldText)).

layout :- 
	get_attr(text,Text),
	draw(writeterm(30,30,Text)).		


sub_widgets(DialogBox) :-
	new_widget(field,[
		parent=DialogBox
		,x=20
		,y=50
		,width=DialogBox~width-40
		,callback=dialog:ok(DialogBox,Field,Value)
	],Field),
	new_widget(button,[
		parent=DialogBox
		,x=50
		,y=100
		,text='Ok'
		,callback=dialog:ok(DialogBox,Field,Value)
	],_),
	new_widget(button,[
		parent=DialogBox
		,x=DialogBox~width-150
		,y=100
		,text='Cancel'
		,callback=dialog:cancel(DialogBox)
	],_).


ok(DialB,Field,Value) :-
	current_widget(field,[chars=Chars],Field), 
	name(Value,Chars),			% get_char_value(Chars,Value),
	call_back(DialB,callback(Value)),
	kill_widget(dialog,[],DialB).

cancel(DialB) :- kill_widget(dialog,[],DialB).


