% From the NU-Prolog Reference Manual
%
% getToken/3 reads the next NU-Prolog Token of Type from Stream. 
% Type is an atom
%
%	Token			Type
%
%	[]			end_of_file
%	VarName			var
%	Atom			atom
%	QAtom			quoted
%	Number			number
%	String			string
%	End			end
%	ASCII			junk
%
% where Varname is a string representing the name of a variable, Atom is any
% atom, QAtom is an atom that was quoted, Number is a number, String is a 
% string. End is '. ' - the token returned when the end of a term is 
% encountered, and ASCII is a character code not amongst the unescaped 
% permitted characters.
% ( see NU-Prolog manual....)
%
% Left parentheses are tokenized as the atom ' (' with type atom if they are not
% immediately preceded by a token that could serve as an operator.  
% Periods followed by whitespace tokenize as '. ', also with type atom. Both can
% be distinguished from the quoted atom appearing in input by their type.
 
get_token( Stream, Token, Type) :-
	getToken( Stream, Token, Type).

% tokenize/2 converts all of String into a list of [Token|Type] pairs.

stringToTokens( String, Tokens) :-
	tokenize( String, Tokens).

atom_chars( A, C) :-
	name( A, C).

string( S) :-
	isAsciiL( S). % delays until S is instantiated!

list( L) :-
	L == [_|_]; L == [].

number_chars( N, C) :-
	intToString( N, C). % delays if N a variable & S not ground

termToChars( Term, String) :-
	termToString( Term, String). % converts Term to String in prefix form
					% with atoms quoted as necessary
copy_term( T, T1) :-
	duplicate( T, T1). % T1 is a copy of T2 with different variables but
			% the same internal binding.

write_clause( Stream, Clause) :-
	portraycl( Stream, Clause). % write Clauses with atoms quoted as
		% neccesary and parenteses inserted where neccesary to represent
		% precedence. 

write_clause( Clause) :-
	portraycl( Clause).



write_string( Stream, String) :-
	putl( Stream, String).



