% phones (+Filename)
%
% tokenizes and parses Filename according to a grammar previously
% declared (see the files phones.txt and phones_gr)
% the lines of each section in the file are extracted and facts are
% asserted of the form:
%
% staff( Surname, Firstname, Job_Title, Telephone, Login_Id, Room_no)
% eng( Surname, Firstname, Job_Title, Telephone)
% student( Surname, Firstname, Job_Title, Telephone, Login_Id, Room_no) 

% the arguments are left as the "raw" lists - and manipulated in demo
% they could be represented however required....
%

phones( Filename) :-
		% get tokens and parse file
        get_tokens( Filename, Toks),
       	parse( phones, Toks, Pt1),
		% unify whole file parse tree Pt1 with a sub representing the
		% section of computing staff
 	Plus = pplus( T, sub( stafflist, _, SPt), 1),
	unify( Pt1, Plus),
		% unify the computing staff parse tree with a sub representing
		% all the lines in that section
	Plus1 = pplus( _, mult( line, _, LPts), 2),
	unify( SPt, Plus1),
		% using the parse trees for the lines, assert the staff facts
	assert_staff( LPts),
		% do the same for the engineering section
	Plus2 = pplus( T2, sub( englist, _, EPt), 4),
	unify( T, Plus2),
	Plus3 =pplus( _, mult( shortline, _, SLPts), 5),
	unify( EPt, Plus3),	
	assert_eng( SLPts),
		% and the student section
	Plus4 = pplus( _, sub( stdlist, _, StPt), 7),
	unify( T2, Plus4),
	Plus5 = pplus( _, mult( line, _, StLPts), 8),
	unify( StPt, Plus5),
	assert_student( StLPts).

% assert_staff( +ListOfParseTrees)
%
% unify each line parse tree with a sub representing the various components
% required for each staff fact
%
% in PTN notation: 
% H unify _ ++3 (T::tel1, S::snames, F::fnames,L::login, J::job, R::room)

assert_staff( []).
assert_staff( [H|Rest]) :-
	Plus = pplus( _, [sub( tel1, Tel, T),sub(snames, Sname, S), 
			sub(fnames, Fname, F),
			sub(login, Login, L),
			sub(job, Job, J),
			sub( room, Room, R)], 3),
	unify( H, Plus),
	assert( staff( Sname, Fname, Job, Tel, Login, Room)),
	assert_staff(Rest).

% assert_eng( +ListOfParseTrees)
% 
% same as above, but with the engineering faculty
%
assert_eng( []).
assert_eng( [H|Rest]) :-
	Plus = pplus( _, [sub( tel1, Tel, _),sub(snames, Sname, _), 
			sub(fnames, Fname, _),
			sub( job, Job, _)], 6),
	unify( H, Plus),
	assert( eng( Sname, Fname, Job, Tel)),
	assert_eng(Rest).

% assert_student( +ListOfParseTrees)
%
% same again for students
%
assert_student( []).
assert_student( [H|Rest]) :-
	Plus = pplus( _, [sub( tel1, Tel, _),sub(snames, Sname, _), 
			sub(fnames, Fname, _),
			sub(login, Login, _),
			sub(job, Job, _),
			sub( room, Room, _)], 9),
	unify( H, Plus),
	assert( student( Sname, Fname, Job, Tel, Login, Room)),
	assert_student(Rest).

