
% arith demonstrates the translation of a simple arithmetic operation 
% as a term, in the head of a clause, 
% it is replaced by a variable, and the goal added
% to the body.
%
% grammar is in arith_gr.gr

arith( Basename):-
	name( Basename, Chars),
        append( Chars, ".ari", InputFile),
	append( Chars, ".nl", OutputFile),
		% tokeize and parse the file
        get_tokens( InputFile, Toks),
        program( Toks, [], Node),!,
		% extract the clause parse trees
	unify( Node, pplus( T, mult( clause1, _, ClausePts), 1)), !, 
		% translate each clause
	add_heads( ClausePts,  NewClausePts, 1, _),
		% replace the clause parse trees in the program parse tree
	unify( Newnode, pplus( T, mult( clause1, _, NewClausePts), 1)),
		% print out	
	extract_tokens( Newnode, Tokens2),!,
	print_tokens( OutputFile, Tokens2).		

add_heads( [], [], N, N).
add_heads( [ ClPt|ClPts], [NClPt|NClPts], N, N2) :-
	add_head( ClPt, NClPt, N, N1),
	add_heads( ClPts, NClPts, N1, N2).

% add_head( +ClausePt, -ClausePt, +VarNum, -VarNum)
%
% unify the Clause, with its component head and body parse trees
% and translate them
add_head( ClausePt, NewClausePt, N, N1) :-
	Plus1 = pplus( _,  sseq([ sub( head, _, HeadPt),
			sub( body, _, BodyPt)]), 2),
	unify( ClausePt, Plus1),
	new_clause( ClausePt, HeadPt, BodyPt, NewClausePt, N, N1).

% new_clause( +ClausePt, +HeadPt, +BodyPt, -ClausePt, +VarNum, -VarNum)
%
% unify head parse tree with a sub representing an arithmetic function.
% If it unifies, replace the function with a new variable and
% so unify with the head to give a new head parse tree
% build a new goal - is( NewVar, ArithFunction) and
% call add_body/4 to create the new body
% then build up the new clause from the new head and new body parse trees 
%
% The second clause returns the Clause parse tree unaltered if there is
% no such function in the head
new_clause( _, HeadPt, BodyPt, NewClausePt, N, N1) :-	
	PlusH = pplus( TH, sub( arith, _, APt), 3),
	unify( HeadPt, PlusH), !,  
	newVar( N, N1, Var),
	parse( var, [Var], VPt),
	unify( NewHeadPt,  pplus( TH, sub( var, [Var], VPt), 3)), !,
	build_parse( goal, [ "is( ", VPt, ",", APt, ")"], GoalPt),
	add_body( BodyPt, GoalPt, NewBodyPt, 4),
	build_parse( clause1, [NewHeadPt, NewBodyPt], NewClausePt).
new_clause( ClausePt, _, _, ClausePt, N, N).

% add_body( +BodyPt, +GoalPt, -NewBodyPt, +GapNum)
%
% add the new Goal to the body,
% the first clause deals with the case of no body
% the second, if there is already a body.
add_body(  BodyPt, GoalPt, NewBodyPt, N1) :-
	Plus = pplus( _, sub( body, [], _), N1),
	unify( BodyPt, Plus),
	build_parse(  body, [ ":-",GoalPt], NewBodyPt).
add_body( BodyPt, GoalPt, NewBodyPt, N1) :-
	Plus = pplus( _, sseq([ ":-", sub( goal, _, Goal1Pt), 
				sub( restBody, _, RbodyPt)]), N1),
	unify( BodyPt, Plus),
	build_parse( body, [":-", GoalPt, ",", Goal1Pt, RbodyPt], NewBodyPt).


