/*
 * Toy symbol table
 */
#include "symtab.h"
#include <stdio.h>

symboltype *symtab[256][256];

void initsymtab()
{
  int i1, i2;
  
  for (i1=0; i1<256; i1++)
    for (i2=0; i2<256; i2++)
      symtab[i1][i2] = (symboltype *)NULL;
}

int addsymbol(s, n)
char *s;
int n;
{
  int i1, i2;
  symboltype *p, *q = (symboltype *)NULL;
  int r;

  i1 = s[0];
  i2 = (i1 ? s[1] + n : n) & 255;

  p = symtab[i1][i2];
  while (p) {
    r = strcmp(p->name, s);
    if (r < 0 || !r && p->arity <= n) {
      q = p;
      p = p->next;
    } else 
      p = (symboltype *)NULL;
  } 
  if (q) {
    if (!strcmp(q->name,s) && q->arity == n)
      return 0;
  }
  p = (symboltype *)malloc(sizeof(symboltype));
  p->name = malloc(strlen(s)+1);
  strcpy(p->name, s);
  p->arity = n;
  if (q) {
    p->next = q->next;
    q->next = p;
  } else {
    p->next = symtab[i1][i2];
    symtab[i1][i2] = p;
  }
  return 1;
}

symboltype *findsymbol(s, n)
char *s;
int n;
{
  int i1, i2;
  symboltype *p, *q = (symboltype *)NULL;
  int r;

  i1 = s[0];
  i2 = (i1 ? s[1] + n : n) & 255;
  p = symtab[i1][i2];
  while (p) {
    r = strcmp(p->name, s);
    if (r < 0 || !r && p->arity < n) {
      q = p;
      p = p->next;
    } else
      p = (symboltype *)NULL;
  }
  if (q) p = q->next; else p = symtab[i1][i2];
  if (p)
    r = strcmp(p->name, s);
  else 
    r = 1;
  if (!p || r || !r && p->arity != n) {
    addsymbol(s,n);
    return getsymbol(s, n);
  } else if (q) 
    return q->next;
  else 
    return symtab[i1][i2];
}

void showsymtab()
{
  int i1, i2;

  for (i1=0; i1<256; i1++)
    for (i2=0; i2<256; i2++) 
      if (symtab[i1][i2]) {
        symboltype *p = symtab[i1][i2];
        printf("[%3d,%3d]: (%c,%c)  ", i1, i2, i1, i2 >= 32 ? i2 : ' ');
        while (p) {
          printf("%s/%d ", p->name, p->arity);
          p = p->next;
        }
        puts("");
      }
}
