;;;  FILES.P

/*  These are the Pop-11 parts of FILES.PL. See its implementation
    section for an explanation.
*/


define exists_file( Directory, File, Extension );
    lvars Directory, File, Extension;
    lvars Repeater, FullName;
    sys_file_match( File><'', Directory><'*'><Extension, false, false) ->
      Repeater;
    if (Repeater() ->> FullName) = termin then
        0
    elseif FullName = false then
        'BUG: exists_file'.pr; 1.nl;
    else
        FullName.consword
    endif;
enddefine;


define add_file_defaults( Directory, Name, Extension );
    lvars Directory, Name, Extension;
    lvars Parts;          
    sysfileparse( Name ) -> Parts;
    (Parts(1) ><
     Parts(2) ><
     if Parts(3) = '' then Directory else Parts(3) endif ><
     Parts(4) ><
     if Parts(5) = '' then Extension else Parts(5) endif ><
     Parts(6)
    ).consword
enddefine;


define print_file( Name, Printer, Delete );
    lvars Name, Printer, Delete;
    if Delete = "nodelete" then '/DELETE' else '' endif -> Delete;                   
    sysobey( '$ PRINT ' >< Name >< '/QUEUE=' >< Printer >< Delete );
enddefine;
