(defun print (x)
   (princ x)
   (princ CR)
)
;
; Sorting example taken from LISP for the BBC micro by
;   Normal & Cattell
;
; (sort '(12 4 5 444 7 9) ) ==> (4 57 9 444)
;
;To test try (sort (gen-ran-list 100))
;
(defun make-node (val left right)
   (list left val right))
;(defun left-subtree (tree)
;   (car tree))
;(defun right-subtree (tree)
;   (caddr tree))
;(defun item-in-node (tree)
;   (cadr tree))
(defun left-subtree (x) (car x))
(defun right-subtree (tree)
   (car (cdr (cdr tree))))
(defun item-in-node (tree)
   (car (cdr tree)))
(defun print-tree (tree)
   (cond
      ((null tree) nil)
      (t    (print-tree (left-subtree tree))
         (print (item-in-node tree))
         (print-tree (right-subtree tree))
      )
   )
)
(defun sort (item-list &optional tree)
   (do-while item-list
      (setq tree (add-item (car item-list) tree))
      (setq item-list (cdr item-list))
   )
   (print-tree tree)
)
(defun add-item (item tree)
   (cond
      ((null tree) (make-node item nil nil))
      ((> item (item-in-node tree))
            (left-put-in-subtree item tree)
      )
      (t (right-put-in-subtree item tree))
   )
)
(defun left-put-in-subtree (item tree)
   (make-node
      (item-in-node tree)
      (add-item item (left-subtree tree))
      (right-subtree tree)
   )
)
(defun right-put-in-subtree (item tree)
   (make-node
      (item-in-node tree)
      (left-subtree tree)
      (add-item item (right-subtree tree))
   )
)
;
; Generate a list of <n> random strings
;
(defun gen-ran-list (n)
   (setq return nil)
   (do-while (> n 0)
      (setq n (- n 1))
      (setq return (cons (random 3000) return))
   )
   return
)
