;;;;
;;;; Lexical Scope by term re-writing Version 0.1
;;;;
;;;;	by Bill Birch	3 March 93
;;;;
;;;;	
;;;;	
;;;;	Lexical environments are created by substitution of variables.
;;;;
;;
;;	Substitute  - replace all occurences of b with a,
;;				  skipping quoted expressions.
;;
(defun substitute (a b s)
   (cond
      ((eq s b) a)   
      ((atom s) s)   
      (else (cond
	  		((equal (car s) 'quote) s)
			(else  
			  (cons (substitute a b (car s))
   	          (substitute a b (cdr s))))))))
;;
(defun rewrite (formals defs form &optional new-formals new-defs)
	(setq new-formals (gensyms formals))
	(setq new-defs (gensyms defs))
		(subst-list new-defs defs
				(subst-list
					new-formals
					formals
					form)))

;;
;; Substitute a list of items 
;;
(defun subst-list (to from on)
	(cond ((null to) on)
		(else (subst-list 
			(cdr to) 
			(cdr from) 
			(substitute (car to) (car from) on)))))

;;
;; Reurn a list of gensyms as long as the list passed in.
;;
(defun gensyms (l)
	(unless (null l)
		(cons (gensym) (gensyms (cdr l)))))
;;
;; Set a list of variables with the values given, 
;; each in turn.
;;
(defun setlis (vars vals)
	(cond ((null vars) '())
		(else
			(set (car vars) (car vals))
			(cons (car vars) 
				(setlis (cdr vars) (cdr vals))))))

;;
;; Find all first-level (define) statements in a form body
;; return a list of the names to be defined.
;;
(defun find-defs (form)
	(cond
		((null form) '())
		((and
			(consp (car form))
			(eq (caar form) 'defun))
				(cons (cadar form)
					(find-defs (cdr form))))))

(defun remove-switches (arglst)
	(cond
		((null arglst) '())
		((member (car arglst) '(&rest &optional &aux))
			(remove-switches (cdr arglst)))
		(else (cons (car arglst) (remove-switches (cdr arglst)))))) 

(df function (form)
	(cond ((atom form) form)
		(else
			(rewrite (remove-switches (cadr form))
					 (find-defs (cddr form)) 
					 form))))
;;
;; Macro to define variables and procedures.
;;
(df define (args &rest body)
	(cond ((atom args) (set args (eval (car body))))
		(else 
			(set (car args)  (function 
				  	(eval `(lambda ,(cdr args) ,@body)))))))

(df defun (name args &rest body)
	(eval `(setq ,name (function (lambda ,args ,@body))))
	name)

;; END-OF-FILE
