;;;;-----------------------------------------------------
;;;;   OBJECT ORIENTED Finite State Machine
;;;;
;;;; Define the basic class for FSMs
;;;;

(defnew 'fsm 'classes 
   ; Inheritable Slots
   '(
   (state nil)   ; State of the FSM
   )   
   ; Non-Inherited Slots (These are Methods)
   '(
   ;   Basic method to process incoming events
   (handle-event 
          (lambda (this event) 
(princ*
  "handle-event: " "FSM= " this 
   " state= " (get this 'state) 
   " event= " event)
   (cond ((null (get this 'state)) ; check state
      (princ "handle-event nil state" ))
      (t 
	  ;  The next statements:
	  ;   Invoke the method for this event in the
	  ;   object for the current state.  Set the FSM state
	  ;   to the return value of the dispatch.
         (putprop this 
            (dispatch    
               event
               (get this 'state)  
               (list (get this 'state) event)
            ) 
            'state
         )
		 (princ*
            "handle-event:" " Changing " "state " "to "
            (get this 'state) CR CR)
      )
   )
)
    )
   )
)
;
; Generic function to send an event to an FSM
(defun ev (fsm event)
   (dispatch 'handle-event fsm (list fsm event)))
;
;------------------------------------------------------------------------------
; EXAMPLE Finite State Machine.:
;A PARSER FOR COLLECTING QUOTED STRINGS
;

;  First define the FSM
(defnew 'qp 'fsm    ; <name> followed by its <class>
   ; Inheritable slots
   '(
   (state qp-not-in)
   )
   ; Non-inheritable slots which are usually methods.
   nil; No special methods for this FSM
)


; Now define the default actions for any given state
;
(defnew 'qp-state 'classes nil '(
   ;
   (char          ; This is a method for the CHAR event
		(lambda (i j)   'qp-not-in))   ; No actions, newstate only

   (aquote          ; This is a method for the AQUOTE event
		(lambda (i j)  'qp-not-in)) ) )

; Now fill out the states, each one in turn.
;
; NB. Each of these declarations inherits its behaviour from the above
;   so these event handlers replace the inherited behaviour.
;
;  The FSM is in this state when searching for a leading quote.
;	ie it is not-in the quoted region.
;
(defnew 'qp-not-in 'qp-state nil
   '(
   (aquote          ; when a quote character is received...
(lambda (i j) 
   (print* "Action:" " reset " "save " "buffer" ) 
   'qp-in))   ; New State
   )
)
;  The FSM is in this state when accumulating the quoted string.
;	ie it is in the quoted region.
;
(defnew 'qp-in 'qp-state nil
   '(
   (char ; event = character
		(lambda (i j) 
			(print* "Action: " "save " "char " "in " "buffer, " "increment" ) 
			'qp-in)   ; New state
   )
   (aquote 
	(lambda (i j) 
		(print* "Action: " "write " "out " "collected " "string" ) 
   		'qp-not-in)   ; New State
   ) ) )
;------------------------------------------------------------------------------
; Test sequence   A"A"A"
(defun r ()
	(ev 'qp 'char)     
	(ev 'qp 'aquote)
	(ev 'qp 'char)
	(ev 'qp 'aquote)
	(ev 'qp 'char)
	(ev 'qp 'aquote))
(r)
