;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	B Y T E    June 1986
;
;	MUSICAL FRACTALS by Charles Dodge and Cutis R. Bahn
;
;
;
;
(defun not (pred)
	(null pred))
(defun blank() (princ '\ ))
(defun terpri () (princ '\
))
;
;	Translation of WHITE.BAS into bLISP:
;	"a program to generate white noise" (sic)
;
(defun white (n)		; n -- number of notes to play
	(setq out ()) 	; start with an empty tune
	; Build a tune in a list:
	(do-while (not (equal n 0))
		(setq out (cons 
			(list 0 		; Channel
			(+ (random 25) 45)	; Note number
			 64 			; Velocity
			(random 4))		; Note Length
			out)			;
		)
		(setq n (- n 1)) 	; decrement the number of notes
	)
	; Now play the tune
	(PlayTune out)
)
;
;
;	Translation of BROWN.BAS into bLISP:
;	"a program to generate Brownian noise" (sic)
;
;
(defun brownbas (number)
	(setq out ())
	(setq n 6000)				; N=60
	(setq l 200)				; L=2
	(setq x 1)
	(do-while (< x (+ number 1))		; FOR x = 1 TO 25
							; REM R varies the range
		(setq d (brownian 300))			; GOSUB 130
		(setq n (+ n d))			; N=N+D
		(cond 
			; IF N>120 or N<25 THEN N=N-2*D
			((or (> n 12000) (< n 2500))
				 (setq n (- n (* d 2)))
			)
			(t t)
		)
							; R=.667
		(setq d (brownian 66))			; GOSUB 130
		(setq l (+ l d))			; l = l + d
		(cond 
			; IF L<1 or L>4 THEN L=L-2*D
			((or (> l 400) (< l 100))
				(setq l (- l (* d 2)))
			)
			(t t)
		)
		; _PHRASE(1,"L=L;",N=N;")
		; But build a list to be played later
		(setq out (cons 
			(list 0 (/ n 100) 64 (/ l 100))
					out)
		)
		(setq x (+ x 1))	; NEXT X
	)
	(PlayTune out)
)
; REM BROWNIAN ROUTINE
(defun brownian (range)
	(setq s 0)					; S=0 ; REM S is Sum
	(setq I 1)					; FOR I = 1 to 12
	(do-while (< I 13)
		(setq s (+ s (random 100)))		; S = S+RND(1)
		(setq I (+ I 1))			; NEXT I
	)
	; D = INT(R*(S-6))
	(/ (* range (- s 600)) 100)
	; RETURN
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	IOVERF.BAS
;
;	Listing 3: a program to generate 1/f noise.
;
(defun ioverf (number)
	(setq out ())
	(setq N 0)
	(setq L 0)
	(setq LL 800)
	(setq LN 1600)
	(setq S 6000)
	(setq x 1)
	(do-while (< x (+ number 1))		; FOR x = 1 TO 25
		(setq D N)			; D = N
		(sub130)			; GOSUB 130
		(setq N D)			; N = D
		(setq SN (+ N S))	; SN = N + S
		(setq D L)			; D = L
		(sub130)			; GOSUB 130
		(setq L D)			; L = D
		(setq SL (+ L 100))		; SL = L+1
		; _PHRASE(1,"L=SL;",N=SN;")
		; But build a list to be played later
		(setq out (cons 
			(list 0 (/ SN 100) 64 (/ SL 100))
					out)
		)
		(setq x (+ x 1))	; NEXT X
	)
	(PlayTune out)
)

;130 REM 1/f Routine
;135 REM L is last value. K is 1/2 poss
;136 REM values. PROBIT=1/K
;
(defun sub130 ()
	(setq L D)
	(setq D 0)
	(setq K 1600)
	(setq PROBIT 4)	
	(sub150)
)

(defun sub150 ()
	(setq J (/ L K))
	(cond ((equal J 1) (setq L (- L K))) (t t))
	(setq U (random 100))
	(cond ((< U PROBIT) (setq J (- 1 J))) (t t))
	(setq D (+ D (* J K) ))
	(setq K (/ K 2))
	(setq PROHIBIT (* PROBIT 2))
	(cond ((> K 100) (sub150)) (t t))
)
