; Lisp example to show how to draw
; dragon and c!-curves

; (drawc) ; draws a c-curve
; (drawd) ; draws a dragon curve
; this example will only work in medium or high resolution
; (in low resolution the example is drawn mostly of the screen !)
; try chnging the value of min!-length to 8 and try again
; then change it to 1 and try (drawc) it will take a long time !!
(defun sqrt (i) (exp (/ (log i) 2.0)))
(setq minlength 100)
(setq pi 3.1415927)

(defun init ()
	(GraphOpen)
)


; use this to draw a nice c curve on a medium res screen

(defun drawc ()
  (init)
  (setq curx 4500)
  (setq cury 1600)
  (ccurve 1350 pi)
  (princ "Continue Y? ")
  (read)
	(GraphClose)
)

; use this to draw a nice dragon curve on a medium res screen

(defun drawd ()
  (init)
  (setq curx 1700)
  (setq cury 900)
  (dragon 1600 0 1)
  (princ "Continue Y? ")
  (read)
	(GraphClose)
)

(defun plotline (length angle)
  ((lambda (x1 y1)
    (line curx cury x1 y1)
    (setq curx x1)
    (setq cury y1)
  )
 (+ curx (* 2 (cos angle) length))
 (+ cury (* (sin angle) length))
 )
)

(defun ccurve (length angle)
   (cond ((< length minlength)(plotline length angle))
         (t (ccurve (/ length (sqrt 2.0))
                      (+ angle (/ pi 4.0)))
            (ccurve (/ length (sqrt 2.0))
                      (- angle (/ pi 4.0))))))

(defun dragon (length angle sign)
  (cond ((< length minlength)(plotline length angle))
        (t (dragon (/ length (sqrt 2.0))
              (+ angle (* sign (/ pi 4.0))) 1.0)
           (dragon (/ length (sqrt 2.0))
              (- angle (* sign (/ pi 4.0))) -1.0)))) 


