(let ((s (find-symbol "PURIFY" "LISP")))
  (unintern s "LISP")
  (import s "EXT")
  (export s "EXT"))

(in-package "LISP")
(defmacro type-specifier-atom (type)
  "Returns the broad class of which TYPE is a specific subclass."
  `(if (atom ,type) ,type (car ,type)))


(defun coerce (object output-type-spec)
  "Coerces the Object to an object of type Output-Type-Spec."
  (let ((output-type-spec (type-expand output-type-spec)))
    (cond
     ((typep object output-type-spec)
      object)
     ((eq output-type-spec 'character)
      (character object))
     ((eq output-type-spec 'function)
      (eval `#',object))
     ((numberp object)
      (cond
       ((subtypep output-type-spec 'single-float)
	(%single-float object))
       ((subtypep output-type-spec 'double-float)
	(%double-float object))
       ((subtypep output-type-spec 'complex)
	(complex object))
       (t
	(error "~S can't be converted to type ~S." object output-type-spec))))
     (t
      (typecase object
	(list
	 (case (type-specifier-atom output-type-spec)
	   ((simple-string string simple-base-string base-string)
	    (list-to-string* object))
	   ((simple-bit-vector bit-vector) (list-to-bit-vector* object))
	   ((simple-vector vector array simple-array)
	    (list-to-vector* object output-type-spec))
	   (t (error "Can't coerce ~S to type ~S." object output-type-spec))))
	(simple-string
	 (case (type-specifier-atom output-type-spec)
	   (list (vector-to-list* object))
	   ;; Can't coerce a string to a bit-vector!
	   ((simple-vector vector array simple-array)
	    (vector-to-vector* object output-type-spec))
	   (t (error "Can't coerce ~S to type ~S." object output-type-spec))))
	(simple-bit-vector
	 (case (type-specifier-atom output-type-spec)
	   (list (vector-to-list* object))
	   ;; Can't coerce a bit-vector to a string!
	   ((simple-vector vector array simple-array)
	    (vector-to-vector* object output-type-spec))
	   (t (error "Can't coerce ~S to type ~S." object output-type-spec))))
	(simple-vector
	 (case (type-specifier-atom output-type-spec)
	   (list (vector-to-list* object))
	   ((simple-string string simple-base-string base-string)
	  (vector-to-string* object))
	   ((simple-bit-vector bit-vector) (vector-to-bit-vector* object))
	   ((vector array simple-array)
	    (vector-to-vector* object output-type-spec))
	   (t (error "Can't coerce ~S to type ~S." object output-type-spec))))
	(string
	 (case (type-specifier-atom output-type-spec)
	   (list (vector-to-list* object))
	   ((simple-string simple-base-string)
	    (string-to-simple-string* object))
	   ;; Can't coerce a string to a bit-vector!
	   ((simple-vector vector simple-array array)
	    (vector-to-vector* object output-type-spec))
	   (t (error "Can't coerce ~S to type ~S." object output-type-spec))))
	(bit-vector
	 (case (type-specifier-atom output-type-spec)
	   (list (vector-to-list* object))
	   ;; Can't coerce a bit-vector to a string!
	   (simple-bit-vector (bit-vector-to-simple-bit-vector* object))
	   ((simple-vector vector array simple-array)
	    (vector-to-vector* object output-type-spec))
	   (t (error "Can't coerce ~S to type ~S." object output-type-spec))))
	(vector
	 (case (type-specifier-atom output-type-spec)
	   (list (vector-to-list* object))
	   ((simple-string string base-string simple-base-string)
	    (vector-to-string* object))
	   ((simple-bit-vector bit-vector) (vector-to-bit-vector* object))
	   ((simple-vector vector array simple-array)
	    (vector-to-vector* object output-type-spec))
	   (t (error "Can't coerce ~S to type ~S." object output-type-spec))))
      (t
       (error "~S is an inappropriate type of object for coerce." object)))))))

(in-package :kernel)

(defun abs (number)
  "Returns the absolute value of the number."
  (number-dispatch ((number number))
    (((foreach single-float double-float fixnum rational))
     (if (minusp number) (- number) number))
    ((complex)
     (let ((rx (realpart number))
	   (ix (imagpart number)))
       (etypecase rx
	 (rational
	  (sqrt (+ (* rx rx) (* ix ix))))
	 (single-float
	  (coerce (%hypot (coerce rx 'double-float)
			  (coerce ix 'double-float))
		  'single-float))
	 (double-float
	  (%hypot rx ix)))))))

(in-package "C")

(defun byte-compiling (&rest goo)
  (declare (ignore goo))
  (if (eq *byte-compiling* :maybe)
      (or (eq *byte-compile* t)
	  (policy nil (zerop speed) (<= debug 1)))
      (and *byte-compile* *byte-compiling*)))
