
(in-package "USER")

(eval-when (compile load eval)
  (let ((sym (find-symbol "FEATUREP" :lisp)))
    (unintern sym :lisp)
    (import sym :ext)
    (export sym :ext)))

(export 'debug::*stack-top-hint* :debug)
(defvar debug:*stack-top-hint*)

(export 'di::flush-frames-above :di)

(export 'ext::bytes-consed-between-gcs :ext)
(defsetf ext:bytes-consed-between-gcs lisp::%set-bytes-consed-between-gcs)

(in-package "C")

;;;; Other utility functions for accessing the backend.

(export '(target-featurep backend-featurep native-featurep))

(defun target-featurep (feature)
  "Same as EXT:FEATUREP, except use the features found in *TARGET-BACKEND*."
  (let ((*features* (or (backend-features *target-backend*)
			*features*)))
    (featurep feature)))

(defun backend-featurep (feature)
  "Same as EXT:FEATUREP, except use the features found in *BACKEND*."
  (let ((*features* (or (backend-features *backend*)
			*features*)))
    (featurep feature)))

(defun native-featurep (feature)
  "Same as EXT:FEATUREP, except use the features found in *NATIVE-BACKEND*."
  (let ((*features* (or (backend-features *native-backend*)
			*features*)))
    (featurep feature)))
