# Error-Handling fr CLISP
# Bruno Haible 8.1.1994

#include "lispbibl.c"


# SYS::*RECURSIVE-ERROR-COUNT* = Rekursionstiefe der Ausgabe von Errormeldungen

# UP: Beginnt die Ausgabe einer Errormeldung.
# begin_error()
# < STACK_0: Stream (i.a. *ERROR-OUTPUT*)
# < STACK_1: Wert von *error-handler*
# < STACK_2: Argumentliste fr *error-handler*
# < STACK_3: Condition-Typ (i.a. SIMPLE-ERROR) oder NIL
# erniedrigt STACK um 7
  local void begin_error (void);
  local void begin_error()
    { end_system_call(); # keine Betriebssystem-Operation luft mehr
      #ifdef PENDING_INTERRUPTS
      interrupt_pending = FALSE; # Ctrl-C-Wartezeit ist gleich beendet
      begin_system_call();
      #ifdef HAVE_UALARM
      ualarm(0,0); # SIGALRM-Timer abbrechen
      #else
      alarm(0); # SIGALRM-Timer abbrechen
      #endif
      end_system_call();
      #endif
      # Error-Count erhhen, bei >3 Ausgabe-Abbruch:
      dynamic_bind(S(recursive_error_count),fixnum_inc(Symbol_value(S(recursive_error_count)),1));
      if (!mposfixnump(Symbol_value(S(recursive_error_count)))) # sollte ein Fixnum >=0 sein
        { Symbol_value(S(recursive_error_count)) = Fixnum_0; } # sonst Notkorrektur
      if (posfixnum_to_L(Symbol_value(S(recursive_error_count))) > 3)
        { # Mehrfach verschachtelte Fehlermeldung.
          Symbol_value(S(recursive_error_count)) = Fixnum_0; # Error-Count lschen
          # *PRINT-PRETTY* an NIL binden (um Speicher zu sparen):
          dynamic_bind(S(print_pretty),NIL);
          fehler(serious_condition,
                 DEUTSCH ? "Unausgebbare Fehlermeldung" :
                 ENGLISH ? "Unprintable error message" :
                 FRANCAIS ? "Message inimprimable" :
                 ""
                );
        }
     {var reg1 object error_handler = Symbol_value(S(error_handler)); # *ERROR-HANDLER*
      if (!nullp(error_handler))
        # *ERROR-HANDER* /= NIL
        { pushSTACK(NIL); pushSTACK(NIL); pushSTACK(error_handler);
          pushSTACK(make_string_output_stream()); # String-Output-Stream
        }
        else
        if (nullp(Symbol_value(S(use_clcs)))) # SYS::*USE-CLCS*
          # *ERROR-HANDER* = NIL, SYS::*USE-CLCS* = NIL
          { pushSTACK(NIL); pushSTACK(NIL); pushSTACK(NIL);
            pushSTACK(var_stream(S(error_output))); # Stream *ERROR-OUTPUT*
            terpri(&STACK_0); # neue Zeile
            write_sstring(&STACK_0,O(error_string1)); # "*** - " ausgeben
          }
          else
          # *ERROR-HANDER* = NIL, SYS::*USE-CLCS* /= NIL
          { pushSTACK(S(simple_error)); pushSTACK(NIL); pushSTACK(unbound);
            pushSTACK(make_string_output_stream()); # String-Output-Stream
          }
    }}

# UP: Gibt ein Error-Objekt aus.
  local void write_errorobject (object obj);
  local void write_errorobject(obj)
    var reg1 object obj;
    { if (nullp(STACK_1))
        { dynamic_bind(S(prin_stream),unbound); # SYS::*PRIN-STREAM* an #<UNBOUND> binden
          dynamic_bind(S(print_escape),T); # *PRINT-ESCAPE* an T binden
          prin1(&STACK_(0+3+3),obj); # direkt ausgeben
          dynamic_unbind();
          dynamic_unbind();
        }
        else
        { # obj auf die Argumentliste schieben:
          pushSTACK(obj);
          obj = allocate_cons();
          Car(obj) = popSTACK();
          Cdr(obj) = STACK_2; STACK_2 = obj;
          # und "~S" in den Format-String schreiben:
          write_schar(&STACK_0,'~'); write_schar(&STACK_0,'S');
    }   }

# UP: Gibt ein Error-Character aus.
  local void write_errorchar (object obj);
  local void write_errorchar(obj)
    var reg1 object obj;
    { if (nullp(STACK_1))
        { write_char(&STACK_0,obj); } # direkt ausgeben
        else
        { # obj auf die Argumentliste schieben:
          pushSTACK(obj);
          obj = allocate_cons();
          Car(obj) = popSTACK();
          Cdr(obj) = STACK_2; STACK_2 = obj;
          # und "~A" in den Format-String schreiben:
          write_schar(&STACK_0,'~'); write_schar(&STACK_0,'A');
    }   }

# UP: Gibt einen Errorstring aus. Bei jeder Tilde '~' wird ein Objekt aus dem
# Stack ausgegeben, bei jedem '$' wird ein Character aus dem Stack ausgegeben.
# write_errorstring(errorstring)
# > STACK_0: Stream usw.
# > errorstring: Errorstring (ein unverschieblicher ASCIZ-String)
# > STACK_7, STACK_8, ...: Argumente (fr jedes '~' bzw. '$' eines),
#   in umgekehrter Reihenfolge wie bei FUNCALL !
# < ergebnis: STACK-Wert oberhalb des Stream und der Argumente
  local object* write_errorstring (const char* errorstring);
  local object* write_errorstring(errorstring)
    var reg1 const char* errorstring;
    { var reg2 object* argptr = args_end_pointer STACKop 7; # Pointer bern Stream und Frame
      loop
        { var reg3 uintB ch = *errorstring++; # nchstes Zeichen
          if (ch==0) break; # String zu Ende?
          if (ch=='~') # Tilde?
            # ja -> ein Objekt vom Stack ausgeben:
            { write_errorobject(BEFORE(argptr)); }
          elif (ch=='$') # '$' ?
            # ja -> ein Character vom Stack ausgeben:
            { write_errorchar(BEFORE(argptr)); }
          else
            # nein -> Zeichen normal ausgeben:
            { write_char(&STACK_0,code_char(ch)); }
        }
      return argptr;
    }

# Beendet die Ausgabe einer Fehlermeldung und startet neuen Driver.
# end_error();
  nonreturning_function(local, end_error, (object* stackptr));
  local void end_error(stackptr)
    var reg2 object* stackptr;
    { if (nullp(STACK_1))
        # *ERROR-HANDER* = NIL, SYS::*USE-CLCS* = NIL
        { skipSTACK(4); # Fehlermeldung wurde schon ausgegeben
          dynamic_unbind(); # Bindungsframe fr sys::*recursive-error-count* auflsen,
                            # da keine Fehlermeldungs-Ausgabe mehr aktiv
          set_args_end_pointer(stackptr);
          break_driver(NIL); # Break-Driver aufrufen (kehrt nicht zurck)
        }
        else
        { STACK_0 = get_output_stream_string(&STACK_0);
         {var reg4 object arguments = nreverse(STACK_2);
          # Stackaufbau: type, args, handler, errorstring.
          if (!eq(STACK_1,unbound))
            # *ERROR-HANDER* /= NIL
            { # Stackaufbau: nil, args, handler, errorstring.
              # (apply *error-handler* nil errorstring args) ausfhren:
              check_SP(); check_STACK();
              {var reg1 object error_handler = STACK_1; STACK_1 = NIL;
               apply(error_handler,2,arguments);
               skipSTACK(2);
              }
              dynamic_unbind(); # Bindungsframe fr sys::*recursive-error-count* auflsen,
                                # da keine Fehlermeldungs-Ausgabe mehr aktiv
              set_args_end_pointer(stackptr);
              break_driver(NIL); # Break-Driver aufrufen (kehrt nicht zurck)
            }
            else
            # *ERROR-HANDER* = NIL, SYS::*USE-CLCS* /= NIL
            { # Stackaufbau: type, args, --, errorstring.
              var reg1 object type = STACK_3;
              var reg5 object errorstring = STACK_0;
              skipSTACK(4);
              dynamic_unbind(); # Bindungsframe fr sys::*recursive-error-count* auflsen
              # (APPLY #'coerce-to-condition errorstring args 'error type keyword-arguments)
              # ausfhren:
              pushSTACK(errorstring); pushSTACK(arguments); pushSTACK(S(error)); pushSTACK(type);
             {var reg3 uintC argcount = 4;
              # arithmetic-error, division-by-zero, floating-point-overflow, floating-point-underflow
              #   --> ergnze :operation :operands ??
              # cell-error, uncound-variable, undefined-function
              #   --> ergnze :name
              if (eq(type,S(simple_cell_error))
                  || eq(type,S(simple_unbound_variable))
                  || eq(type,S(simple_undefined_function))
                 )
                { pushSTACK(S(Kname)); pushSTACK(BEFORE(stackptr)); # :name ...
                  argcount += 2;
                }
              # type-error --> ergnze :datum, :expected-type
              if (eq(type,S(simple_type_error)))
                { pushSTACK(S(Kexpected_type)); pushSTACK(BEFORE(stackptr)); # :expected-type ...
                  pushSTACK(S(Kdatum)); pushSTACK(BEFORE(stackptr)); # :datum ...
                  argcount += 4;
                }
              # package-error --> ergnze :package
              if (eq(type,S(simple_package_error)))
                { pushSTACK(S(Kpackage)); pushSTACK(BEFORE(stackptr)); # :package ...
                  argcount += 2;
                }
              # stream-error, end-of-file --> ergnze :stream
              if (eq(type,S(simple_stream_error))
                  || eq(type,S(simple_end_of_file))
                 )
                { pushSTACK(S(Kstream)); pushSTACK(BEFORE(stackptr)); # :stream ...
                  argcount += 2;
                }
              # file-error --> ergnze :pathname
              if (eq(type,S(simple_file_error)))
                { pushSTACK(S(Kpathname)); pushSTACK(BEFORE(stackptr)); # :pathname ...
                  argcount += 2;
                }
              funcall(S(coerce_to_condition),argcount); # (SYS::COERCE-TO-CONDITION ...)
              # set_args_end_pointer(stackptr); # wozu? macht das Debuggen nur schwieriger!
              pushSTACK(value1); # condition retten
              pushSTACK(value1); funcall(L(clcs_signal),1); # (SIGNAL condition)
              dynamic_bind(S(prin_stream),unbound); # SYS::*PRIN-STREAM* an #<UNBOUND> binden
              pushSTACK(STACK_(0+3)); # condition
              funcall(L(invoke_debugger),1); # (INVOKE-DEBUGGER condition)
            }}
        }}
      NOTREACHED
    }

# Fehlermeldung mit Errorstring. Kehrt nicht zurck.
# fehler(errortype,errorstring);
# > errortype: Condition-Typ
# > errorstring: Konstanter ASCIZ-String.
#   Bei jeder Tilde wird ein LISP-Objekt vom STACK genommen und statt der
#   Tilde ausgegeben.
# > auf dem STACK: Initialisierungswerte fr die Condition, je nach errortype
  nonreturning_function(global, fehler, (conditiontype errortype, const char * errorstring));
  global void fehler(errortype,errorstring)
    var reg2 conditiontype errortype;
    var reg1 const char * errorstring;
    { begin_error(); # Fehlermeldung anfangen
      if (!nullp(STACK_3)) # *ERROR-HANDLER* = NIL, SYS::*USE-CLCS* /= NIL ?
        { # Error-Typ-Symbol zu errortype auswhlen:
          var reg3 object sym = S(simple_condition); # erster Error-Typ
          sym = objectplus(sym,
                           (soint)(sizeof(*TheSymbol(sym))<<(oint_addr_shift-addr_shift))
                           * (uintL)errortype
                          );
          STACK_3 = sym;
        }
      end_error(write_errorstring(errorstring)); # Fehlermeldung ausgeben, beenden
    }

#ifdef ATARI
  # Behandlung von BIOS- und GEMDOS-Fehlern
  # OS_error(errorcode);
  # > sintW errorcode: negativer Fehlercode
    nonreturning_function(global, OS_error, (sintW errorcode));
    global void OS_error(errorcode)
      var reg2 sintW errorcode;
      { clr_break_sem_4(); # keine GEMDOS-Operation mehr aktiv
        begin_error(); # Fehlermeldung anfangen
       {var reg1 uintW errcode = -errorcode; # positive Fehlernummer
        # Meldungbeginn ausgeben:
        write_errorstring(errcode < 32
                           ? # Fehlernummern <32 kommen vom BIOS
                             (DEUTSCH ? "BIOS-Fehler " :
                              ENGLISH ? "BIOS error " :
                              FRANCAIS ? "Erreur BIOS " :
                              ""
                             )
                           : # Fehlernummern >=32 kommen vom GEMDOS
                             (DEUTSCH ? "GEMDOS-Fehler " :
                              ENGLISH ? "GEMDOS error " :
                              FRANCAIS ? "Erreur GEMDOS " :
                              ""
                             )
                         );
        # Fehlernummer ausgeben:
        write_errorobject(fixnum(errcode));
        # nach Mglichkeit noch ausfhrlicher:
        if (errcode < 68)
          {# Zu Fehlernummern <68 ist ein Text da.
           local char* errormsg_table[68] = {
             /*  0 */ DEUTSCH ? "OK, kein Fehler" :
                      ENGLISH ? "Ok, No error" :
                      FRANCAIS ? "Ok, pas d'erreur" :
                      "",
             /*  1 */ DEUTSCH ? "Allgemeiner Fehler" :
                      ENGLISH ? "General error" :
                      FRANCAIS ? "Erreur gnrale" :
                      "",
             /*  2 */ DEUTSCH ? "Laufwerk nicht da oder nicht bereit" :
                      ENGLISH ? "Drive not ready" :
                      "",
             /*  3 */ DEUTSCH ? "Unbekannter Befehl" :
                      ENGLISH ? "Unknown command" :
                      FRANCAIS ? "Commande inconnue" :
                      "",
             /*  4 */ DEUTSCH ? "Prfsumme stimmt nicht" :
                      ENGLISH ? "CRC error" :
                      FRANCAIS ? "Mauvais CRC" :
                      "",
             /*  5 */ DEUTSCH ? "Illegale Anforderung, ungltiger Befehl" :
                      ENGLISH ? "Bad request (invalid command)" :
                      FRANCAIS ? "Requte illgale (commande invalide)" :
                      "",
             /*  6 */ DEUTSCH ? "Track nicht gefunden" :
                      ENGLISH ? "Seek error (track not found)" :
                      FRANCAIS ? "Piste non trouve" :
                      "",
             /*  7 */ DEUTSCH ? "Unknown media (ungltiger Bootsektor)" :
                      ENGLISH ? "Unknown media" :
                      FRANCAIS ? "Mdium inconnu (secteur de boot invalide)" :
                      "",
             /*  8 */ DEUTSCH ? "Sektor nicht gefunden" :
                      ENGLISH ? "Sector not found" :
                      FRANCAIS ? "Secteur non trouv" :
                      "",
             /*  9 */ DEUTSCH ? "Kein Papier" :
                      ENGLISH ? "Printer error (no paper?)" :
                      FRANCAIS ? "Plus de papier" :
                      "",
             /* 10 */ DEUTSCH ? "Fehler beim Schreibzugriff" :
                      ENGLISH ? "Write fault" :
                      FRANCAIS ? "Erreur en criture" :
                      "",
             /* 11 */ DEUTSCH ? "Fehler beim Lesezugriff" :
                      ENGLISH ? "Read fault" :
                      FRANCAIS ? "Erreur en lecture" :
                      "",
             /* 12 */ DEUTSCH ? "Allgemeiner Fehler" :
                      ENGLISH ? "General error" :
                      FRANCAIS ? "Erreur gnrale" :
                      "",
             /* 13 */ DEUTSCH ? "Diskette schreibgeschtzt" :
                      ENGLISH ? "Disk write-protected" :
                      FRANCAIS ? "Disquette protge contre l'criture" :
                      "",
             /* 14 */ DEUTSCH ? "Diskette wurde gewechselt" :
                      ENGLISH ? "Disk was changed" :
                      FRANCAIS ? "La disquette fut change" :
                      "",
             /* 15 */ DEUTSCH ? "Unbekanntes Gert" :
                      ENGLISH ? "Unknown device" :
                      FRANCAIS ? "Device inconnu" :
                      "",
             /* 16 */ DEUTSCH ? "Fehlerhafter Sektor, nicht verifizierbar" :
                      ENGLISH ? "Bad sector encountered during verify" :
                      FRANCAIS ? "Trouv mauvais secteur pendant validation" :
                      "",
             /* 17 */ DEUTSCH ? "Diskette einlegen" :
                      ENGLISH ? "No disk in drive" :
                      FRANCAIS ? "Pas de disquette dans le lecteur" :
                      "",
             /* 18 ... 31 */ "", "", "", "", "", "", "", "", "", "", "", "", "", "",
             /* 32 */ DEUTSCH ? "Ungltige Funktionsnummer" :
                      ENGLISH ? "Invalid function number" :
                      FRANCAIS ? "Numro de fonction incorrect" :
                      "",
             /* 33 */ DEUTSCH ? "Datei nicht gefunden" :
                      ENGLISH ? "File not found" :
                      FRANCAIS ? "Fichier non trouv" :
                      "",
             /* 34 */ DEUTSCH ? "Pfadname nicht gefunden" :
                      ENGLISH ? "Path not found" :
                      FRANCAIS ? "Chemin non trouv" :
                      "",
             /* 35 */ DEUTSCH ? "Zuviele offene Dateien" :
                      ENGLISH ? "Too many files open" :
                      FRANCAIS ? "Trop de fichiers ouverts" :
                      "",
             /* 36 */ DEUTSCH ? "Zugriff verweigert" :
                      ENGLISH ? "Access not possible" :
                      FRANCAIS ? "Accs non possible" :
                      "",
             /* 37 */ DEUTSCH ? "Ungltige Handle-Nummer" :
                      ENGLISH ? "Invalid handle number" :
                      FRANCAIS ? "numro de descripteur de fichier invalide" :
                      "",
             /* 38 */ "",
             /* 39 */ DEUTSCH ? "Nicht gengend Speicher" :
                      ENGLISH ? "Not enough memory" :
                      FRANCAIS ? "Pas assez de mmoire" :
                      "",
             /* 40 */ DEUTSCH ? "Ungltige Speicherblockadresse" :
                      ENGLISH ? "Invalid memory block address" :
                      FRANCAIS ? "Adresse de bloc mmoire invalide" :
                      "",
             /* 41 ... 45 */ "", "", "", "", "",
             /* 46 */ DEUTSCH ? "Ungltige Laufwerksbezeichnung" :
                      ENGLISH ? "Invalid drive spec" :
                      FRANCAIS ? "Mauvais descripteur de lecteur" :
                      "",
             /* 47 */ "",
             /* 48 */ DEUTSCH ? "Datei mte kopiert werden" :
                      ENGLISH ? "Rename across disks impossible" :
                      FRANCAIS ? "Le fichier devrait tre copi" :
                      "",
             /* 49 */ DEUTSCH ? "Keine weiteren Dateien" :
                      ENGLISH ? "No more files" :
                      FRANCAIS ? "Pas plus de fichiers" :
                      "",
             /* 50 ... 63 */ "", "", "", "", "", "", "", "", "", "", "", "", "", "",
             /* 64 */ DEUTSCH ? "Bereichsberschreitung" :
                      ENGLISH ? "Range error, context unknown" :
                      FRANCAIS ? "Valeur hors d'intervalle de validit" :
                      "",
             /* 65 */ DEUTSCH ? "Interner Fehler (Diskettenwechsel?)" :
                      ENGLISH ? "Internal error" :
                      FRANCAIS ? "Erreur interne (changement de disquette?)" :
                      "",
             /* 66 */ DEUTSCH ? "Kein ladbares Programm" :
                      ENGLISH ? "Invalid program load format" :
                      FRANCAIS ? "Fichier non excutable" :
                      "",
             /* 67 */ DEUTSCH ? "SETBLOCK darf nicht mehr Speicher belegen" :
                      ENGLISH ? "SETBLOCK failed, growth restraints" :
                      FRANCAIS ? "SETBLOCK ne peut pas occuper plus de mmoire" :
                      "",
             };
           var reg2 char* errormsg = errormsg_table[errcode];
           if (!(errormsg[0] == 0)) # nichtleere Meldung?
             { write_errorstring(": ");
               write_errorstring(errormsg);
             }
          }
        end_error(args_end_pointer STACKop 7); # Fehlermeldung beenden
      }}
#endif # ATARI

#ifdef AMIGAOS
  # Behandlung von AMIGAOS-Fehlern
  # OS_error();
  # > IoErr(): Fehlercode
    nonreturning_function(global, OS_error, (void));
    global void OS_error ()
      { var reg1 uintC errcode = IoErr(); # Fehlernummer
        end_system_call();
        clr_break_sem_4(); # keine AMIGAOS-Operation mehr aktiv
        begin_error(); # Fehlermeldung anfangen
        # Meldungbeginn ausgeben:
        write_errorstring(DEUTSCH ? "AmigaOS-Fehler " :
                          ENGLISH ? "Amiga OS error " :
                          FRANCAIS ? "Erreur AmigaDOS " :
                          ""
                         );
        # Fehlernummer ausgeben:
        write_errorobject(fixnum(errcode));
        { local char* error100_msg_table[2*23] = {
            /* 100 */ "", "",
            /* 101 */ "", "",
            /* 102 */ "", "",
            /* 103 */ "ERROR_NO_FREE_STORE",
                      ENGLISH ? "not enough memory available" :
                      DEUTSCH ? "nicht gengend Speicher vorhanden" :
                      FRANCAIS ? "Pas assez de mmoire" :
                      "",
            /* 104 */ "", "",
            /* 105 */ "ERROR_TASK_TABLE_FULL",
                      ENGLISH ? "process table full" :
                      DEUTSCH ? "keine weiteren CLI Prozesse mehr" :
                      FRANCAIS ? "La table des processus est pleine" :
                      "",
            /* 106 */ "", "",
            /* 107 */ "", "",
            /* 108 */ "", "",
            /* 109 */ "", "",
            /* 110 */ "", "",
            /* 111 */ "", "",
            /* 112 */ "", "",
            /* 113 */ "", "",
            /* 114 */ "ERROR_BAD_TEMPLATE",
                      ENGLISH ? "bad template" :
                      DEUTSCH ? "ungltiges Muster" :
                      FRANCAIS ? "mauvais schma" :
                      "",
            /* 115 */ "ERROR_BAD_NUMBER",
                      ENGLISH ? "bad number" :
                      DEUTSCH ? "ungltige Zahl" :
                      FRANCAIS ? "mauvais nombre" :
                      "",
            /* 116 */ "ERROR_REQUIRED_ARG_MISSING",
                      ENGLISH ? "required argument missing" :
                      DEUTSCH ? "bentigtes Schlsselwort nicht vorhanden" :
                      FRANCAIS ? "mot cl manque" :
                      "",
            /* 117 */ "ERROR_KEY_NEEDS_ARG",
                      ENGLISH ? "value after keyword missing" :
                      DEUTSCH ? "kein Wert nach Schlsselwort vorhanden" :
                      FRANCAIS ? "mot cl sans valeur" :
                      "",
            /* 118 */ "ERROR_TOO_MANY_ARGS",
                      ENGLISH ? "wrong number of arguments" :
                      DEUTSCH ? "falsche Anzahl Argumente" :
                      FRANCAIS ? "mauvais nombre d'arguments" :
                      "",
            /* 119 */ "ERROR_UNMATCHED_QUOTES",
                      ENGLISH ? "unmatched quotes" :
                      DEUTSCH ? "ausstehende Anfhrungszeichen" :
                      FRANCAIS ? "guillemets non termins" :
                      "",
            /* 120 */ "ERROR_LINE_TOO_LONG",
                      ENGLISH ? "argument line invalid or too long" :
                      DEUTSCH ? "ungltige Zeile oder Zeile zu lang" :
                      FRANCAIS ? "ligne est mauvaise ou trop longue" :
                      "",
            /* 121 */ "ERROR_FILE_NOT_OBJECT",
                      ENGLISH ? "file is not executable" :
                      DEUTSCH ? "Datei ist nicht ausfhrbar" :
                      FRANCAIS ? "fichier non excutable" :
                      "",
            /* 122 */ "ERROR_INVALID_RESIDENT_LIBRARY",
                      ENGLISH ? "invalid resident library" :
                      DEUTSCH ? "ungltige residente Library" :
                      FRANCAIS ? "Librarie rsidente non valide" :
                      "",
            };
          local char* error200_msg_table[2*44] = {
            /* 200 */ "", "",
            /* 201 */ "ERROR_NO_DEFAULT_DIR",
                      ENGLISH ? "" :
                      DEUTSCH ? "" :
                      FRANCAIS ? "" :
                      "",
            /* 202 */ "ERROR_OBJECT_IN_USE",
                      ENGLISH ? "object is in use" :
                      DEUTSCH ? "Objekt wird schon benutzt" :
                      FRANCAIS ? "l'objet est utilis" :
                      "",
            /* 203 */ "ERROR_OBJECT_EXISTS",
                      ENGLISH ? "object already exists" :
                      DEUTSCH ? "Objekt existiert bereits" :
                      FRANCAIS ? "l'objet existe dj" :
                      "",
            /* 204 */ "ERROR_DIR_NOT_FOUND",
                      ENGLISH ? "directory not found" :
                      DEUTSCH ? "Verzeichnis nicht gefunden" :
                      FRANCAIS ? "rpertoire non trouv" :
                      "",
            /* 205 */ "ERROR_OBJECT_NOT_FOUND",
                      ENGLISH ? "object not found" :
                      DEUTSCH ? "Objekt nicht gefunden" :
                      FRANCAIS ? "objet non trouv" :
                      "",
            /* 206 */ "ERROR_BAD_STREAM_NAME",
                      ENGLISH ? "invalid window description" :
                      DEUTSCH ? "ungltige Fensterbeschreibung" :
                      FRANCAIS ? "mauvais descripteur de fentre" :
                      "",
            /* 207 */ "ERROR_OBJECT_TOO_LARGE",
                      ENGLISH ? "object too large" :
                      DEUTSCH ? "Objekt zu gro" :
                      FRANCAIS ? "objet trop grand" :
                      "",
            /* 208 */ "", "",
            /* 209 */ "ERROR_ACTION_NOT_KNOWN",
                      ENGLISH ? "packet request type unknown" :
                      DEUTSCH ? "unbekannter Pakettyp" : # ??
                      FRANCAIS ? "Type de paquet inconnu" :
                      "",
            /* 210 */ "ERROR_INVALID_COMPONENT_NAME",
                      ENGLISH ? "object name invalid" :
                      DEUTSCH ? "ungltiger Objektname" :
                      FRANCAIS ? "nom d'objet incorrect" :
                      "",
            /* 211 */ "ERROR_INVALID_LOCK",
                      ENGLISH ? "invalid object lock" :
                      DEUTSCH ? "ungltiger Objektlock" :
                      FRANCAIS ? "lock invalide d'un objet" :
                      "",
            /* 212 */ "ERROR_OBJECT_WRONG_TYPE",
                      ENGLISH ? "object is not of required type" :
                      DEUTSCH ? "Objekt ist nicht von bentigten Typ" :
                      FRANCAIS ? "objet de mauvais type" :
                      "",
            /* 213 */ "ERROR_DISK_NOT_VALIDATED",
                      ENGLISH ? "disk not validated" :
                      DEUTSCH ? "Datentrger ist nicht validiert" :
                      FRANCAIS ? "volume non valid" :
                      "",
            /* 214 */ "ERROR_DISK_WRITE_PROTECTED",
                      ENGLISH ? "disk is write-protected" :
                      DEUTSCH ? "Datentrger ist schreibgeschtzt" :
                      FRANCAIS ? "disquette protge contre l'criture" :
                      "",
            /* 215 */ "ERROR_RENAME_ACROSS_DEVICES",
                      ENGLISH ? "rename across devices attempted" :
                      DEUTSCH ? "rename ber Laufwerke versucht" :
                      FRANCAIS ? "rename  travers des units distinctes" :
                      "",
            /* 216 */ "ERROR_DIRECTORY_NOT_EMPTY",
                      ENGLISH ? "directory not empty" :
                      DEUTSCH ? "Verzeichnis ist nicht leer" :
                      FRANCAIS ? "rpertoire non vide" :
                      "",
            /* 217 */ "ERROR_TOO_MANY_LEVELS",
                      ENGLISH ? "too many levels" :
                      DEUTSCH ? "" :
                      FRANCAIS ? "" :
                      "",
            /* 218 */ "ERROR_DEVICE_NOT_MOUNTED",
                      ENGLISH ? "device (or volume) is not mounted" :
                      DEUTSCH ? "Datentrger ist in keinem Laufwerk" :
                      FRANCAIS ? "l'unit n'est dans aucun lecteur" :
                      "",
            /* 219 */ "ERROR_SEEK_ERROR",
                      ENGLISH ? "seek failure" :
                      DEUTSCH ? "seek schlug fehl" :
                      FRANCAIS ? "erreur pendant un dplacement (seek)" :
                      "",
            /* 220 */ "ERROR_COMMENT_TOO_BIG",
                      ENGLISH ? "comment is too long" :
                      DEUTSCH ? "Kommentar ist zu lang" :
                      FRANCAIS ? "Commentaire trop long" :
                      "",
            /* 221 */ "ERROR_DISK_FULL",
                      ENGLISH ? "disk is full" :
                      DEUTSCH ? "Datentrger ist voll" :
                      FRANCAIS ? "support plein" :
                      "",
            /* 222 */ "ERROR_DELETE_PROTECTED",
                      ENGLISH ? "object is protected from deletion" :
                      DEUTSCH ? "Datei ist gegen Lschen geschtzt" :
                      FRANCAIS ? "objet est protg contre l'effacement" :
                      "",
            /* 223 */ "ERROR_WRITE_PROTECTED",
                      ENGLISH ? "file is write protected" :
                      DEUTSCH ? "Datei ist schreibgeschtzt" :
                      FRANCAIS ? "fichier protg contre l'criture" :
                      "",
            /* 224 */ "ERROR_READ_PROTECTED",
                      ENGLISH ? "file is read protected" :
                      DEUTSCH ? "Datei ist lesegeschtzt" :
                      FRANCAIS ? "fichier protg contre la lecture" :
                      "",
            /* 225 */ "ERROR_NOT_A_DOS_DISK",
                      ENGLISH ? "not a valid DOS disk" :
                      DEUTSCH ? "kein gltiger DOS-Datentrger" :
                      FRANCAIS ? "disque non DOS" :
                      "",
            /* 226 */ "ERROR_NO_DISK",
                      ENGLISH ? "no disk in drive" :
                      DEUTSCH ? "kein Datentrger im Laufwerk" :
                      FRANCAIS ? "pas de disquette dans le lecteur" :
                      "",
            /* 227 */ "", "",
            /* 228 */ "", "",
            /* 229 */ "", "",
            /* 230 */ "", "",
            /* 231 */ "", "",
            /* 232 */ "ERROR_NO_MORE_ENTRIES",
                      ENGLISH ? "no more entries in directory" :
                      DEUTSCH ? "keine weiteren Verzeichniseintrge mehr" :
                      FRANCAIS ? "pas plus d'entres dans le rpertoire" :
                      "",
            /* 233 */ "ERROR_IS_SOFT_LINK",
                      ENGLISH ? "object is soft link" :
                      DEUTSCH ? "Objekt ist ein Softlink" :
                      FRANCAIS ? "l'objet est un soft link" :
                      "",
            /* 234 */ "ERROR_OBJECT_LINKED",
                      ENGLISH ? "object is linked" :
                      DEUTSCH ? "Objekt ist ein Link" : # ??
                      FRANCAIS ? "l'objet est li" :
                      "",
            /* 235 */ "ERROR_BAD_HUNK",
                      ENGLISH ? "bad loadfile hunk" :
                      DEUTSCH ? "Datei teilweise nicht ladbar" : # ??
                      FRANCAIS ? "fichier pas entirement chargeable" : # ??
                      "",
            /* 236 */ "ERROR_NOT_IMPLEMENTED",
                      ENGLISH ? "function not implemented" :
                      DEUTSCH ? "unimplementierte Funktion" :
                      FRANCAIS ? "fonction non implmente" :
                      "",
            /* 237 */ "", "",
            /* 238 */ "", "",
            /* 239 */ "", "",
            /* 240 */ "ERROR_RECORD_NOT_LOCKED",
                      ENGLISH ? "record not locked" :
                      DEUTSCH ? "" :
                      FRANCAIS ? "" :
                      "",
            /* 241 */ "ERROR_LOCK_COLLISION",
                      ENGLISH ? "record lock collision" :
                      DEUTSCH ? "" :
                      FRANCAIS ? "" :
                      "",
            /* 242 */ "ERROR_LOCK_TIMEOUT",
                      ENGLISH ? "record lock timeout" :
                      DEUTSCH ? "" :
                      FRANCAIS ? "" :
                      "",
            /* 243 */ "ERROR_UNLOCK_ERROR",
                      ENGLISH ? "record unlock error" :
                      DEUTSCH ? "" :
                      FRANCAIS ? "" :
                      "",
            };
          local char* error300_msg_table[2*6] = {
            /* 300 */ "", "",
            /* 301 */ "", "",
            /* 302 */ "", "",
            /* 303 */ "ERROR_BUFFER_OVERFLOW",
                      ENGLISH ? "buffer overflow" :
                      DEUTSCH ? "Puffer-berlauf" :
                      FRANCAIS ? "dbordement de tampon" :
                      "",
            /* 304 */ "ERROR_BREAK",
                      ENGLISH ? "break" :
                      DEUTSCH ? "Unterbrechung" :
                      FRANCAIS ? "interruption" :
                      "",
            /* 305 */ "ERROR_NOT_EXECUTABLE",
                      ENGLISH ? "file not executable" :
                      DEUTSCH ? "Datei ist nicht ausfhrbar" :
                      FRANCAIS ? "fichier non excutable" :
                      "",
            };
          var reg3 char* errorname = "";
          var reg3 char* errormsg = "";
          var reg2 uintC index;
          if (errcode == 0)
            { errorname = "";
              errormsg =
                /*  0 */ DEUTSCH ? "OK, kein Fehler" :
                         ENGLISH ? "Ok, No error" :
                         FRANCAIS ? "Ok, pas d'erreur" :
                         "";
            }
          elif ((index = errcode-100) < 23)
            { errorname = error100_msg_table[2*index];
              errormsg = error100_msg_table[2*index+1];
            }
          elif ((index = errcode-200) < 44)
            { errorname = error200_msg_table[2*index];
              errormsg = error200_msg_table[2*index+1];
            }
          elif ((index = errcode-300) < 6)
            { errorname = error300_msg_table[2*index];
              errormsg = error300_msg_table[2*index+1];
            }
          if (!(errorname[0] == 0)) # bekannter Name?
            { write_errorstring(" (");
              write_errorstring(errorname);
              write_errorstring(")");
            }
          if (!(errormsg[0] == 0)) # nichtleere Meldung?
            { write_errorstring(": ");
              write_errorstring(errormsg);
            }
        }
        # Fehlercode lschen (frs nchste Mal):
        ((struct Process *)FindTask(NULL))->pr_Result2 = 0L;
        end_error(args_end_pointer STACKop 7); # Fehlermeldung beenden
      }
#endif

#ifdef DJUNIX
  # Behandlung von DJUNIX-(DOS-)Fehlern
  # OS_error();
  # > int errno: Fehlercode
    nonreturning_function(global, OS_error, (void));
    global void OS_error ()
      { var reg1 uintC errcode = errno; # positive Fehlernummer
        end_system_call();
        clr_break_sem_4(); # keine DOS-Operation mehr aktiv
        begin_error(); # Fehlermeldung anfangen
        # Meldungbeginn ausgeben:
        write_errorstring(DEUTSCH ? "DJDOS-Fehler " :
                          ENGLISH ? "DJDOS error " :
                          FRANCAIS ? "Erreur DJDOS " :
                          ""
                         );
        # Fehlernummer ausgeben:
        write_errorobject(fixnum(errcode));
        # nach Mglichkeit noch ausfhrlicher:
        if (errcode < 36)
          {# Zu Fehlernummern <36 ist ein Text da.
           local char* errormsg_table[2*36] = {
             /*  0 */ "", "",
             /*  1 */ "ENOSYS",
                      ENGLISH ? "Function not implemented" :
                      DEUTSCH ? "Funktion ist nicht implementiert" :
                      FRANCAIS ? "fonction non implmente" :
                      "",
             /*  2 */ "ENOENT",
                      ENGLISH ? "No such file or directory" :
                      DEUTSCH ? "File oder Directory existiert nicht" :
                      FRANCAIS ? "fichier ou rpertoire non existant" :
                      "",
             /*  3 */ "ENOTDIR",
                      ENGLISH ? "Not a directory" :
                      DEUTSCH ? "Das ist kein Directory" :
                      FRANCAIS ? "n'est pas un rpertoire" :
                      "",
             /*  4 */ "EMFILE",
                      ENGLISH ? "Too many open files" :
                      DEUTSCH ? "Zu viele offene Files" :
                      FRANCAIS ? "Trop de fichiers ouverts" :
                      "",
             /*  5 */ "EACCES",
                      ENGLISH ? "Permission denied" :
                      DEUTSCH ? "Keine Berechtigung" :
                      FRANCAIS ? "Accs dni" :
                      "",
             /*  6 */ "EBADF",
                      ENGLISH ? "Bad file number" :
                      DEUTSCH ? "File-Descriptor wurde nicht fr diese Operation geffnet" :
                      FRANCAIS ? "descripteur de fichier non allou" :
                      "",
             /*  7 */ "EARENA",
                      ENGLISH ? "Memory control blocks destroyed" :
                      DEUTSCH ? "Speicherverwaltung ist durcheinander" :
                      FRANCAIS ? "gestionnaire de mmoire perdu" :
                      "",
             /*  8 */ "ENOMEM",
                      ENGLISH ? "Not enough memory" :
                      DEUTSCH ? "Hauptspeicher oder Swapspace reicht nicht" :
                      FRANCAIS ? "Pas assez de mmoire" :
                      "",
             /*  9 */ "ESEGV",
                      ENGLISH ? "Invalid memory address" :
                      DEUTSCH ? "Ungltige Speicher-Adresse" :
                      FRANCAIS ? "adresse mmoire illicite" :
                      "",
             /* 10 */ "EBADENV",
                      ENGLISH ? "Invalid environment" :
                      DEUTSCH ? "Ungltiges Environment" :
                      FRANCAIS ? "environnement incorrect" :
                      "",
             /* 11 */ "", "",
             /* 12 */ "EACCODE",
                      ENGLISH ? "Invalid access code" :
                      DEUTSCH ? "Ungltiger Zugriffsmodus" :
                      FRANCAIS ? "mode d'accs illgal" :
                      "",
             /* 13...14 */ "", "", "", "",
             /* 15 */ "ENODEV",
                      ENGLISH ? "No such device" :
                      DEUTSCH ? "Gert nicht da oder unpassend" :
                      FRANCAIS ? "il n'y a pas de telle unit" :
                      "",
             /* 16 */ "ECURDIR",
                      ENGLISH ? "Attempt to remove the current directory" :
                      DEUTSCH ? "Das aktuelle Verzeichnis kann nicht entfernt werden" :
                      FRANCAIS ? "Le rpertoire courant ne peut pas tre effac" :
                      "",
             /* 17 */ "ENOTSAME",
                      ENGLISH ? "Can't move to other than the same device" :
                      DEUTSCH ? "Verschieben geht nicht ber Laufwerksgrenzen hinweg" :
                      FRANCAIS ? "ne peux pas dplacer au-del de l'unit" :
                      "",
             /* 18 */ "ENOMORE",
                      ENGLISH ? "No more files" :
                      DEUTSCH ? "Keine weiteren Dateien" :
                      FRANCAIS ? "pas plus de fichier" :
                      "",
             /* 19 */ "EINVAL",
                      ENGLISH ? "Invalid argument" :
                      DEUTSCH ? "Ungltiger Parameter" :
                      FRANCAIS ? "Paramtre illicite" :
                      "",
             /* 20 */ "E2BIG",
                      ENGLISH ? "Arg list too long" :
                      DEUTSCH ? "Zu lange Argumentliste" :
                      FRANCAIS ? "liste d'arguments trop longue" :
                      "",
             /* 21 */ "ENOEXEC",
                      ENGLISH ? "Exec format error" :
                      DEUTSCH ? "Kein ausfhrbares Programm" :
                      FRANCAIS ? "Programme non excutable" :
                      "",
             /* 22 */ "EXDEV",
                      ENGLISH ? "Cross-device link" :
                      DEUTSCH ? "Links knnen nur aufs selbe Gert gehen" :
                      FRANCAIS ? "liens uniquement sur la mme unit" :
                      "",
             /* 23...27 */ "", "", "", "", "", "", "", "", "", "",
             /* 28...32 */ "", "", "", "", "", "", "", "", "", "",
             /* 33 */ "EDOM",
                      ENGLISH ? "Argument out of domain" :
                      DEUTSCH ? "Argument zu mathematischer Funktion auerhalb des Definitionsbereichs" :
                      FRANCAIS ? "argument hors du domaine de dfinition d'une fonction mathmatique" :
                      "",
             /* 34 */ "ERANGE",
                      ENGLISH ? "Result too large" :
                      DEUTSCH ? "Ergebnis mathematischer Funktion zu gro" :
                      FRANCAIS ? "dbordement de valeur" :
                      "",
             /* 35 */ "EEXIST",
                      ENGLISH ? "File exists" :
                      DEUTSCH ? "File existiert schon" :
                      FRANCAIS ? "Le fichier existe dj" :
                      "",
             };
           var reg2 char* errorname = errormsg_table[2*errcode];
           var reg2 char* errormsg = errormsg_table[2*errcode+1];
           if (!(errorname[0] == 0)) # bekannter Name?
             { write_errorstring(" (");
               write_errorstring(errorname);
               write_errorstring(")");
             }
           if (!(errormsg[0] == 0)) # nichtleere Meldung?
             { write_errorstring(": ");
               write_errorstring(errormsg);
             }
          }
        end_error(args_end_pointer STACKop 7); # Fehlermeldung beenden
      }
#endif

#if defined(UNIX) || defined(EMUNIX) || defined(WATCOM)
  # Behandlung von UNIX-Fehlern
  # OS_error();
  # > int errno: Fehlercode
    nonreturning_function(global, OS_error, (void));
    global void OS_error ()
      { var reg1 uintC errcode = errno; # positive Fehlernummer
        end_system_call();
        clr_break_sem_4(); # keine UNIX-Operation mehr aktiv
        begin_error(); # Fehlermeldung anfangen
       {# Meldungbeginn ausgeben:
        write_errorstring(DEUTSCH ? "UNIX-Fehler " :
                          ENGLISH ? "UNIX error " :
                          FRANCAIS ? "Erreur UNIX " :
                          ""
                         );
        # Fehlernummer ausgeben:
        write_errorobject(fixnum(errcode));
        #if 0
        { # Fehlermeldung des Betriebssystems ausgeben:
          if (errcode < sys_nerr)
            { var reg2 char* errormsg = sys_errlist[errcode];
              write_errorstring(": ");
              write_errorstring(errormsg);
        }   }
        #else # nach Mglichkeit noch ausfhrlicher:
        { # Tabelle der Fehlermeldungen wird von GENERRORS.C generiert:
          #include "errors.c"
          if (errcode < errcode_limit)
            # Zu dieser Fehlernummer ist ein Text da.
            { var reg2 char* errorname = errormsg_table[2*errcode];
              var reg2 char* errormsg = errormsg_table[2*errcode+1];
              if (!(errorname[0] == 0)) # bekannter Name?
                { write_errorstring(" (");
                  write_errorstring(errorname);
                  write_errorstring(")");
                }
              if (!(errormsg[0] == 0)) # nichtleere Meldung?
                { write_errorstring(": ");
                  write_errorstring(errormsg);
                }
        }   }
        #endif
       }
        errno = 0; # Fehlercode lschen (frs nchste Mal)
        end_error(args_end_pointer STACKop 7); # Fehlermeldung beenden
      }
#endif # UNIX || EMUNIX || WATCOM

LISPFUN(error,1,0,rest,nokey,0,NIL)
# (ERROR errorstring {expr})
# Kehrt nicht zurck.
# (defun error (errorstring &rest args)
#   (if (or *error-handler* (not *use-clcs*))
#     (progn
#       (if *error-handler*
#         (apply *error-handler* nil errorstring args)
#         (progn
#           (terpri *error-output*)
#           (write-string "*** - " *error-output*)
#           (apply #'format *error-output* errorstring args)
#       ) )
#       (funcall *break-driver* nil)
#     )
#     (let ((condition (coerce-to-condition errorstring args 'error 'simple-error)))
#       (signal condition)
#       (invoke-debugger condition)
#     )
# ) )
  { if (!nullp(Symbol_value(S(error_handler))) || nullp(Symbol_value(S(use_clcs))))
      { begin_error(); # Fehlermeldung anfangen
        rest_args_pointer skipSTACKop 1; # Pointer ber die Argumente
        {var reg5 object fun;
         var reg4 object arg1;
         if (nullp(STACK_1))
           { fun = S(format); arg1 = STACK_0; } # (FORMAT *error-output* ...)
           else
           { fun = STACK_1; arg1 = NIL; } # (FUNCALL *error-handler* NIL ...)
         skipSTACK(3);
         # Errormeldung ausgeben:
         #   (FORMAT *ERROR-OUTPUT* errorstring {expr})
         # bzw. ({handler} nil errorstring {expr})
         pushSTACK(arg1);
         { var reg1 object* ptr = rest_args_pointer;
           var reg3 uintC count;
           dotimespC(count,1+argcount, { pushSTACK(NEXT(ptr)); } );
         }
         funcall(fun,2+argcount); # fun (= FORMAT bzw. handler) aufrufen
        }
        # Fehlermeldung beenden, vgl. end_error():
        dynamic_unbind(); # Keine Fehlermeldungs-Ausgabe mehr aktiv
        set_args_end_pointer(rest_args_pointer); # STACK aufrumen
        break_driver(NIL); # Break-Driver aufrufen (kehrt nicht zurck)
      }
      else
      { {var reg1 object arguments = listof(argcount); pushSTACK(arguments); }
        pushSTACK(S(error));
        pushSTACK(S(simple_error));
        funcall(S(coerce_to_condition),4); # (SYS::COERCE-TO-CONDITION ...)
        pushSTACK(value1); # condition retten
        pushSTACK(value1); funcall(L(clcs_signal),1); # (SIGNAL condition)
        dynamic_bind(S(prin_stream),unbound); # SYS::*PRIN-STREAM* an #<UNBOUND> binden
        pushSTACK(STACK_(0+3)); # condition
        funcall(L(invoke_debugger),1); # (INVOKE-DEBUGGER condition)
      }
    NOTREACHED
  }

LISPFUNN(defclcs,1)
# (SYSTEM::%DEFCLCS error-types)
# setzt die fr ERROR-OF-TYPE bentigten Daten.
  { O(error_types) = popSTACK();
    value1 = NIL; mv_count=0;
  }

# Konvertiert einen Condition-Typ zur entsprechenden Simple-Condition.
# convert_simple_condition(type)
  local object convert_simple_condition (object type);
  local object convert_simple_condition(type)
    var reg2 object type;
    { # Vektor O(error_types) wie eine Aliste durchlaufen:
      var reg4 object v = O(error_types);
      var reg1 object* ptr = &TheSvector(v)->data[0];
      var reg3 uintL count;
      dotimesL(count,TheSvector(v)->length,
               { if (eq(type,Car(*ptr))) { return Cdr(*ptr); }
                 ptr++;
               });
      return type; # nicht gefunden -> Typ unverndert lassen
    }

LISPFUN(error_of_type,2,0,rest,nokey,0,NIL)
# (SYSTEM::ERROR-OF-TYPE type {keyword value}* errorstring {expr}*)
# Kehrt nicht zurck.
# (defun error-of-type (type &rest arguments)
#   ; Keyword-Argumente von den anderen Argumenten abspalten:
#   (let ((keyword-arguments '()))
#     (loop
#       (unless (and (consp arguments) (keywordp (car arguments))) (return))
#       (push (pop arguments) keyword-arguments)
#       (push (pop arguments) keyword-arguments)
#     )
#     (setq keyword-arguments (nreverse keyword-arguments))
#     (let ((errorstring (first arguments))
#           (args (rest arguments)))
#       ; Los geht's!
#       (if (or *error-handler* (not *use-clcs*))
#         (progn
#           (if *error-handler*
#             (apply *error-handler* nil errorstring args)
#             (progn
#               (terpri *error-output*)
#               (write-string "*** - " *error-output*)
#               (apply #'format *error-output* errorstring args)
#           ) )
#           (funcall *break-driver* nil)
#         )
#         (let ((condition
#                 (apply #'coerce-to-condition errorstring args
#                        'error (convert-simple-condition type) keyword-arguments
#              )) )
#           (signal condition)
#           (invoke-debugger condition)
#         )
# ) ) ) )
  { var reg6 uintC keyword_argcount = 0;
    rest_args_pointer skipSTACKop 1; # Pointer ber die Argumente hinter type
    while (argcount>=2)
      { var reg3 object next_arg = Next(rest_args_pointer); # nchstes Argument
        if (!(symbolp(next_arg) && keywordp(next_arg))) break; # Keyword?
        rest_args_pointer skipSTACKop -2; argcount -= 2; keyword_argcount += 2;
      }
    # Nchstes Argument hoffentlich ein String.
    if (!nullp(Symbol_value(S(error_handler))) || nullp(Symbol_value(S(use_clcs))))
      { # Der Typ und die Keyword-Argumente werden ignoriert.
        begin_error(); # Fehlermeldung anfangen
        {var reg5 object fun;
         var reg4 object arg1;
         if (nullp(STACK_1))
           { fun = S(format); arg1 = STACK_0; } # (FORMAT *error-output* ...)
           else
           { fun = STACK_1; arg1 = NIL; } # (FUNCALL *error-handler* NIL ...)
         skipSTACK(3);
         # Errormeldung ausgeben:
         #   (FORMAT *ERROR-OUTPUT* errorstring {expr})
         # bzw. ({handler} nil errorstring {expr})
         pushSTACK(arg1);
         { var reg1 object* ptr = rest_args_pointer;
           var reg3 uintC count;
           dotimespC(count,1+argcount, { pushSTACK(NEXT(ptr)); } );
         }
         funcall(fun,2+argcount); # fun (= FORMAT bzw. handler) aufrufen
        }
        # Fehlermeldung beenden, vgl. end_error():
        dynamic_unbind(); # Keine Fehlermeldungs-Ausgabe mehr aktiv
        set_args_end_pointer(rest_args_pointer); # STACK aufrumen
        break_driver(NIL); # Break-Driver aufrufen (kehrt nicht zurck)
      }
      else
      { var reg5 object arguments = listof(argcount);
        # Stackaufbau: type, {keyword, value}*, errorstring.
        # Ein wenig im Stack umordnen:
        var reg4 object errorstring = STACK_0;
        pushSTACK(NIL); pushSTACK(NIL);
        { var reg1 object* ptr2 = args_end_pointer;
          var reg2 object* ptr1 = ptr2 STACKop 3;
          var reg3 uintC count;
          dotimesC(count,keyword_argcount, { BEFORE(ptr2) = BEFORE(ptr1); } );
          BEFORE(ptr2) = convert_simple_condition(BEFORE(ptr1));
          BEFORE(ptr2) = S(error);
          BEFORE(ptr2) = arguments;
          BEFORE(ptr2) = errorstring;
        }
        # Stackaufbau: errorstring, args, ERROR, type, {keyword, value}*.
        funcall(S(coerce_to_condition),4+keyword_argcount); # (SYS::COERCE-TO-CONDITION ...)
        pushSTACK(value1); # condition retten
        pushSTACK(value1); funcall(L(clcs_signal),1); # (SIGNAL condition)
        dynamic_bind(S(prin_stream),unbound); # SYS::*PRIN-STREAM* an #<UNBOUND> binden
        pushSTACK(STACK_(0+3)); # condition
        funcall(L(invoke_debugger),1); # (INVOKE-DEBUGGER condition)
      }
    NOTREACHED
  }

LISPFUNN(invoke_debugger,1)
# (INVOKE-DEBUGGER condition), CLtL2 S. 915
# Kehrt nicht zurck.
# (defun invoke-debugger (condition)
#   (when *debugger-hook*
#     (let ((debugger-hook *debugger-hook*)
#           (*debugger-hook* nil))
#       (funcall debugger-hook condition debugger-hook)
#   ) )
#   (funcall *break-driver* nil condition t)
# )
  { var reg1 object hook = Symbol_value(S(debugger_hook));
    if (!nullp(hook))
      { var reg2 object condition = STACK_0;
        dynamic_bind(S(debugger_hook),NIL); # *DEBUGGER-HOOK* an NIL binden
        pushSTACK(condition); pushSTACK(hook); funcall(hook,2); # Debugger-Hook aufrufen
        dynamic_unbind();
      }
    # *BREAK-DRIVER* kann hier als /= NIL angenommen werden.
    pushSTACK(NIL); pushSTACK(STACK_(0+1)); pushSTACK(T);
    funcall(Symbol_value(S(break_driver)),3); # Break-Driver aufrufen
    reset(); # kehrt wider Erwarten zurck -> zur nchsten Schleife zurck
    NOTREACHED
  }

# UP: Fhrt eine Break-Schleife wegen Tastaturunterbrechung aus.
# > STACK_0 : aufrufende Funktion
# verndert STACK, kann GC auslsen
  global void tast_break (void);
  global void tast_break()
    {
      #ifdef PENDING_INTERRUPTS
      interrupt_pending = FALSE; # Ctrl-C-Wartezeit ist gleich beendet
      begin_system_call();
      #ifdef HAVE_UALARM
      ualarm(0,0); # SIGALRM-Timer abbrechen
      #else
      alarm(0); # SIGALRM-Timer abbrechen
      #endif
      end_system_call();
      #endif
      # Simuliere begin_error(), 7 Elemente auf den STACK:
      pushSTACK(NIL); pushSTACK(NIL); pushSTACK(NIL);
      pushSTACK(NIL); pushSTACK(NIL); pushSTACK(NIL);
      pushSTACK(var_stream(S(debug_io))); # Stream *DEBUG-IO*
      terpri(&STACK_0); # neue Zeile
      write_sstring(&STACK_0,O(error_string1)); # "*** - " ausgeben
      # String ausgeben, Aufrufernamen verbrauchen, STACK aufrumen:
      set_args_end_pointer(
        write_errorstring(DEUTSCH ? "~: Tastatur-Interrupt" :
                          ENGLISH ? "~: User break" :
                          FRANCAIS ? "~ : Interruption clavier" :
                          "~"
                         ));
      break_driver(T); # Break-Driver aufrufen
    }

LISPFUN(clcs_signal,1,0,rest,nokey,0,NIL)
# (SIGNAL datum {arg}*), CLtL2 S. 888
# (defun signal (datum &rest arguments)
#   (let ((condition
#           (coerce-to-condition datum arguments 'signal
#                                'simple-condition ; CLtL2 p. 918 specifies this
#        )) )
#     (when (typep condition *break-on-signals*)
#       ; Enter the debugger prior to signalling the condition
#       (restart-case (invoke-debugger condition)
#         (continue ())
#     ) )
#     (invoke-handlers condition)
#     nil
# ) )
  { {var reg1 object arguments = listof(argcount); pushSTACK(arguments); }
    pushSTACK(S(clcs_signal));
    pushSTACK(S(simple_condition));
    funcall(S(coerce_to_condition),4); # (SYS::COERCE-TO-CONDITION ...)
    pushSTACK(value1); # condition retten
    pushSTACK(value1); pushSTACK(Symbol_value(S(break_on_signals)));
    funcall(S(safe_typep),2); # (SYS::SAFE-TYPEP condition *BREAK-ON-SIGNALS*)
    if (!nullp(value1))
      # Break-Driver aufrufen: (funcall *break-driver* t condition t)
      { # *BREAK-DRIVER* kann hier als /= NIL angenommen werden.
        pushSTACK(T); pushSTACK(STACK_(0+1)); pushSTACK(T);
        funcall(Symbol_value(S(break_driver)),3);
      }
   {var reg1 object condition = popSTACK(); # condition zurck
    invoke_handlers(condition); # Handler aufrufen
    value1 = NIL; mv_count=1; # Wert NIL
  }}

# Fehlermeldung, wenn ein Objekt keine Liste ist.
# fehler_list(obj);
# > arg: Nicht-Liste
# > subr_self: Aufrufer (ein SUBR)
  nonreturning_function(global, fehler_list, (object obj));
  global void fehler_list(obj)
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(list)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj); pushSTACK(TheSubr(subr_self)->name);
      fehler(type_error,
             DEUTSCH ? "~: ~ ist keine Liste." :
             ENGLISH ? "~: ~ is not a list" :
             FRANCAIS ? "~ : ~ n'est pas une liste." :
             ""
            );
    }

# Fehlermeldung, wenn ein Objekt kein Symbol ist.
# fehler_kein_symbol(caller,obj);
# > caller: Aufrufer (ein Symbol)
# > obj: Nicht-Symbol
  nonreturning_function(global, fehler_kein_symbol, (object caller, object obj));
  global void fehler_kein_symbol(caller,obj)
    var reg2 object caller;
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(symbol)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj);
      pushSTACK(caller);
      fehler(type_error,
             DEUTSCH ? "~: ~ ist kein Symbol." :
             ENGLISH ? "~: ~ is not a symbol" :
             FRANCAIS ? "~ : ~ n'est pas un symbole." :
             ""
            );
    }

# Fehlermeldung, wenn ein Objekt kein Symbol ist.
# fehler_symbol(obj);
# > subr_self: Aufrufer (ein SUBR oder FSUBR)
# > obj: Nicht-Symbol
  nonreturning_function(global, fehler_symbol, (object obj));
  global void fehler_symbol(obj)
    var reg2 object obj;
    { var reg1 object aufrufer = subr_self;
      aufrufer = (subrp(aufrufer) ? TheSubr(aufrufer)->name : TheFsubr(aufrufer)->name);
      fehler_kein_symbol(aufrufer,obj);
    }

# Fehlermeldung, wenn ein Objekt kein Simple-Vector ist.
# fehler_kein_svector(caller,obj);
# > caller: Aufrufer (ein Symbol)
# > obj: Nicht-Svector
  nonreturning_function(global, fehler_kein_svector, (object caller, object obj));
  global void fehler_kein_svector(caller,obj)
    var reg2 object caller;
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(simple_vector)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj);
      pushSTACK(caller);
      fehler(type_error,
             DEUTSCH ? "~: ~ ist kein Simple-Vector." :
             ENGLISH ? "~: ~ is not a simple-vector" :
             FRANCAIS ? "~: ~ n'est pas de type SIMPLE-VECTOR." :
             ""
            );
    }

# Fehlermeldung, wenn ein Objekt kein Vektor ist.
# fehler_vector(obj);
# > subr_self: Aufrufer (ein SUBR)
# > obj: Nicht-Vektor
  nonreturning_function(global, fehler_vector, (object obj));
  global void fehler_vector(obj)
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(vector)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj); pushSTACK(TheSubr(subr_self)->name);
      fehler(type_error,
             DEUTSCH ? "~: ~ ist kein Vektor." :
             ENGLISH ? "~: ~ is not a vector" :
             FRANCAIS ? "~: ~ n'est pas un vecteur." :
             ""
            );
    }

# Fehlermeldung, falls ein Argument kein Character ist:
# fehler_char(obj);
# > obj: Das fehlerhafte Argument
# > subr_self: Aufrufer (ein SUBR)
  nonreturning_function(global, fehler_char, (object obj));
  global void fehler_char(obj)
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(character)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj); pushSTACK(TheSubr(subr_self)->name);
      fehler(type_error,
             DEUTSCH ? "~: Argument ~ ist kein Character." :
             ENGLISH ? "~: argument ~ is not a character" :
             FRANCAIS ? "~: L'argument ~ n'est pas un caractre." :
             ""
            );
    }

# Fehler, wenn Argument kein String-Char ist.
# fehler_string_char(obj);
# > obj: fehlerhaftes Argument
# > subr_self: Aufrufer (ein SUBR)
  nonreturning_function(global, fehler_string_char, (object obj));
  global void fehler_string_char(obj)
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(string_char)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj); pushSTACK(TheSubr(subr_self)->name);
      fehler(type_error,
             DEUTSCH ? "~: ~ ist kein String-Char." :
             ENGLISH ? "~: ~ is not a string-char" :
             FRANCAIS ? "~ : ~ n'est pas de type STRING-CHAR." :
             ""
            );
    }

# Fehlermeldung, falls ein Argument kein String ist:
# > obj: Das fehlerhafte Argument
# > subr_self: Aufrufer (ein SUBR)
  nonreturning_function(global, fehler_string, (object obj));
  global void fehler_string(obj)
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(string)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj); pushSTACK(TheSubr(subr_self)->name);
      fehler(type_error,
             DEUTSCH ? "~: Argument ~ ist kein String." :
             ENGLISH ? "~: argument ~ is not a string" :
             FRANCAIS ? "~: L'argument ~ n'est pas une chane." :
             ""
            );
    }

# Fehlermeldung, falls ein Argument kein Simple-String ist:
# > obj: Das fehlerhafte Argument
# > subr_self: Aufrufer (ein SUBR)
  nonreturning_function(global, fehler_sstring, (object obj));
  global void fehler_sstring(obj)
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(simple_string)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj); pushSTACK(TheSubr(subr_self)->name);
      fehler(type_error,
             DEUTSCH ? "~: Argument ~ ist kein Simple-String." :
             ENGLISH ? "~: argument ~ is not a simple string" :
             FRANCAIS ? "~: L'argument ~ n'est pas de type SIMPLE-STRING." :
             ""
            );
    }

# Fehlermeldung, wenn ein Argument kein Stream ist:
# fehler_stream(obj);
# > obj: Das fehlerhafte Argument
# > subr_self: Aufrufer (ein SUBR)
  nonreturning_function(global, fehler_stream, (object obj));
  global void fehler_stream(obj)
    var reg1 object obj;
    { pushSTACK(obj); # Wert fr Slot DATUM von TYPE-ERROR
      pushSTACK(S(stream)); # Wert fr Slot EXPECTED-TYPE von TYPE-ERROR
      pushSTACK(obj); pushSTACK(TheSubr(subr_self)->name);
      fehler(type_error,
             DEUTSCH ? "~: Argument mu ein Stream sein, nicht ~" :
             ENGLISH ? "~: argument ~ should be a stream" :
             FRANCAIS ? "~ : L'argument doit tre de type STREAM et non pas ~." :
             ""
            );
    }

