/*
                                ********

Copyright 1992 by BBN Systems and Technologies, A division of Bolt,
Beranek and Newman Inc.

Permission to use, copy, modify and distribute this software and its
documentation is hereby granted without fee, provided that the above
copyright notice and this permission appear in all copies and in
supporting documentation, and that the name Bolt, Beranek and Newman
Inc. not be used in advertising or publicity pertaining to distribution
of the software without specific, written prior permission.  In
addition, BBN makes no respresentation about the suitability of this
software for any purposes.  It is provided "AS IS" without express or
implied warranties including (but not limited to) all implied warranties
of merchantability and fitness.  In no event shall BBN be liable for any
special, indirect or consequential damages whatsoever resulting from
loss of use, data or profits, whether in an action of contract,
negligence or other tortuous action, arising out of or in connection
with the use or performance of this software.

                                ********
*/

/* Emacs: This is -*- C -*- code. */

/* User defined primitive declarations */

#include "usrdef.h"

long MAX_PRIMITIVE = 675; /* = 0x2a3 */

extern Pointer
       Prim_get_environment_variable(),
       Prim_get_user_name(),
       Prim_get_user_home_directory(),
       Prim_current_file_time(),
       Prim_file_time_to_string(),
       Prim_uid_to_string(),
       Prim_gid_to_string(),
       Prim_file_directory_p(),
       Prim_file_symlink_p(),
       Prim_file_attributes(),
       Prim_Set_Fluid_Bindings(),
       Prim_Get_Fluid_Bindings(),
       Prim_With_Saved_Fluid_Bindings(),
       Prim_Add_Fluid_Binding(),
       Prim_Touch(),
       Prim_Future_P(),
       Prim_Set_Car_If_Eq(),
       Prim_Set_Cdr_If_Eq(),
       Prim_Vector_Set_If_Eq(),
       Prim_Set_Cxr_If_Eq(),
       Prim_Future_Ref(),
       Prim_Future_Set(),
       Prim_Future_Size(),
       Prim_Lock_Future(),
       Prim_Unlock_Future(),
       Prim_Future_To_Vector(),
       Prim_Future_Eq(),
       Prim_Make_Initial_Process(),
       Send_Global_Interrupt(),
       Prim_Show_Pure(),
       Prim_Show_Env(),
       Prim_Stack_Trace(),
       Prim_Find_Symbol(),
       Prim_Debug_Flags(),
       Prim_Find_Who_Points(),
       Prim_Print_Memory(),
       Suspend(),
       Get_Character_From_Buffer(),
       Return_External_Msg(),
       Prim_Get_Next_Hash_Number(),
       Prim_Get_Stream_Number(),
       Prim_BFIO_Task_Hash(),
       Prim_BFIO_Task_Unhash(),
       Prim_BFIO_Read_Char(),
       Prim_BFIO_Read_String(),
       Prim_BFIO_Kick_Input_Server(),
       Prim_Set_Queue_Level(),
       Prim_Set_Idle_Limit(),
       Prim_Get_Work(),
       Prim_Put_Work(),
       Prim_Get_Place_In_Code(),
       Drain_Work_Queue(),
       Prim_Await_Sync(),
       Prim_N_Interps(),
       Prim_My_Interp_Number(),
       Prim_work_queue_length(),
       Prim_work_queue_sizes(),
       Prim_n_idle_procs(),
       Prim_system_active(),
       Prim_Get_Stats(),
       Prim_get_comline_option(),
       Prim_get_hardware_info(),
       Prim_get_hardware_stack(),
       Prim_Set_Subsumer_Hack(),
       Prim_Get_Useful_Meters(),
       Prim_Set_Debug_Flag(),
       Prim_Timing_Info(),
       Prim_Move_To_Codespace(),
       Prim_Get_Pointer_Processor(),
       Prim_My_Proc(),
       Prim_Enqueue_Head(),
       Prim_Enqueue_Tail(),
       Prim_Dequeue_Head(),
       Prim_Dequeue_Tail(),
       Prim_Atomic_Add_Car(),
       Prim_Atomic_Add_Cdr(),
       Prim_Atomic_Add_Vector(),
       Prim_Logical_And(),
       Prim_Logical_Ior(),
       Prim_Logical_Not(),
       Prim_Logical_Lsh(),
       Prim_Logical_Rsh(),
       Prim_Purify_Code(),
       Prim_Impurify_Code(),
       Prim_Start_Preempting(),
       Prim_Stop_Preempting(),
       Prim_Spawn_Process(),
       Prim_Make_Cheap_Future(),
       Prim_Determine(),
       Prim_Await_Future(),
       Prim_Change_Priority(),
       Prim_Inherit_Up(),
       Prim_Inherit_Down(),
       Prim_Scheduler(),
       Prim_Current_Future(),
       Prim_Set_Current_Future(),
       prim_idf_mant(),
       prim_idf_exp(),
       prim_decode_sign(),
       prim_df_mant(),
       prim_df_exp(),
       prim_float_parameter(),
       prim_float_infinity_p(),
       prim_float_nan_p(),
       prim_hash_float(),
       prim_ash(),
       prim_format_fixed_flonum_to_string(),
       prim_format_exponential_flonum_to_string(),
       prim_cl_computerized_flonum_to_string(),
       prim_integer_length(),
       prim_cl_parse_number(),
       Prim_CL_File_Open_Fd(),
       Prim_CL_File_Close_Fd(),
       prim_cl_file_author(),
       prim_cl_file_write_date(),
       prim_print_address(),
       prim_make_io_error_code(),
       prim_io_error_code_p(),
       prim_get_io_error_code_num(),
       prim_make_symbol(),
       prim_cl_add_clsav(),
       prim_cl_get_clsav(),
       prim_cl_get_name(),
       prim_cl_expanded_symbol_p(),
       prim_cl_function_symbol_p(),
       prim_cl_function_symbol_parent(),
       prim_cl_fast_symbol_plist(),
       prim_cl_fast_system_symbol_plist(),
       prim_cl_string_capitalize(),
       prim_string_capitalize_bang(),
       prim_getrusage(),
       prim_get_internal_run_time(),
       prim_get_internal_time_units_per_second(),
       prim_get_universal_time(),
       prim_get_time_zone(),
       prim_unix_ctime(),
       prim_unix_inverse_ctime(),
       prim_cl_get_host_name(),
       prim_cl_scan_directory(),
       prim_cl_directoryp(),
       prim_sleep(),
       Prim_G_Vector_Alloc(),
       Prim_G_Vector_Ref(),
       Prim_G_Vector_Set(),
       Prim_G_Vector_Length(),
       Prim_Get_G_Vector_Subtype(),
       Prim_Set_G_Vector_Subtype(),
       Prim_Make_Structure_G_Vector(),
       prim_svref(),
       prim_svset(),
       Prim_SubString_Equal(),
       prim_cl_overwrite_string(),
       prim_pkg_add_symbol_to_ht(),
       prim_pkg_find_symbol(),
       prim_pkg_intern_string(),
       prim_get_symbol(),
       prim_rm_symbol_from_ht(),
       Prim_Make_OBArray(),
       prim_pkg_lookup_name(),
       prim_pkg_add_name(),
       prim_pkg_remove_name(),
       Prim_Make_CL_Package(),
       Prim_Hash_A_String(),
       prim_boole(),
       prim_with_values(),
       prim_values(),
       prim_values_list(),
       Prim_Make_Complex(),
       Prim_Complex_Real(),
       Prim_Complex_Imag(),
       Prim_Make_Ratio(),
       Prim_Ratio_Numerator(),
       Prim_Ratio_Denominator(),
       Prim_generic_zerop(),
       Prim_generic_plusp(),
       Prim_generic_minusp(),
       Prim_generic_oddp(),
       Prim_generic_evenp(),
       Prim_generic_equal(),
       Prim_generic_notequal(),
       Prim_generic_lessthan(),
       Prim_generic_greaterthan(),
       Prim_generic_lessequalthan(),
       Prim_generic_greaterequalthan(),
       Prim_generic_max(),
       Prim_generic_min(),
       Prim_generic_plus(),
       Prim_generic_minus(),
       Prim_generic_multiply(),
       Prim_generic_divide(),
       Prim_generic_one_plus(),
       Prim_generic_one_minus(),
       Prim_generic_conjugate(),
       Prim_generic_gcd(),
       Prim_generic_lcm(),
       Prim_generic_exp(),
       Prim_generic_expt(),
       Prim_generic_log(),
       Prim_generic_sqrt(),
       Prim_generic_isqrt(),
       Prim_generic_abs(),
       Prim_generic_phase(),
       Prim_generic_signum(),
       Prim_generic_sin(),
       Prim_generic_cos(),
       Prim_generic_tan(),
       Prim_generic_cis(),
       Prim_generic_asin(),
       Prim_generic_acos(),
       Prim_generic_atan(),
       Prim_generic_pi(),
       Prim_generic_sinh(),
       Prim_generic_cosh(),
       Prim_generic_tanh(),
       Prim_generic_asinh(),
       Prim_generic_acosh(),
       Prim_generic_atanh(),
       Prim_generic_float(),
       Prim_generic_rational(),
       Prim_generic_rationalize(),
       Prim_generic_floor(),
       Prim_generic_ceiling(),
       Prim_generic_truncate(),
       Prim_generic_round(),
       prim_system_vector_32b_ref(),
       prim_system_vector_32b_set(),
       prim_system_vector_32b_length(),
       prim_cl_make_file_stream(),
       prim_cl_string_open(),
       prim_cl_make_string_output_stream(),
       prim_cl_make_string_input_stream(),
       prim_cl_get_output_stream_string(),
       prim_cl_make_the_tty_stream(),
       prim_cl_make_broadcast_stream(),
       prim_cl_make_concatenated_stream(),
       prim_cl_make_synonym_stream(),
       prim_cl_make_two_way_stream(),
       prim_cl_make_echo_stream(),
       prim_cl_read_char(),
       prim_cl_read_char_no_hang(),
       prim_cl_unread_char(),
       prim_cl_listen(),
       prim_cl_clear_input(),
       prim_cl_read_byte(),
       prim_cl_write_char(),
       prim_cl_internal_write_char(),
       cl_prim_write_string(),
       cl_prim_write_line(),
       prim_cl_internal_write_string(),
       prim_cl_internal_write_string_start_end(),
       prim_cl_finish_output(),
       prim_cl_force_output(),
       prim_cl_clear_output(),
       prim_cl_write_byte(),
       prim_cl_file_position(),
       prim_cl_file_length(),
       prim_cl_isa_tty(),
       prim_cl_close(),
       prim_cl_read_string(),
       prim_cl_read_line(),
       prim_cl_charpos(),
       prim_cl_peek_char(),
       prim_cl_stream_element_type(),
       prim_cl_stream_direction(),
       prim_cl_stream_pathname(),
       prim_cl_closed_stream_p(),
       prim_cl_file_stream_p(),
       prim_cl_string_stream_p(),
       prim_cl_tty_stream_p(),
       prim_cl_broadcast_stream_p(),
       prim_cl_concat_stream_p(),
       prim_cl_synonym_stream_p(),
       prim_cl_two_way_stream_p(),
       prim_cl_echo_stream_p(),
       prim_broadcast_stream_streams(),
       prim_concatenated_stream_streams(),
       prim_synonym_stream_symbol(),
       prim_two_way_stream_input_stream(),
       prim_two_way_stream_output_stream(),
       prim_echo_stream_input_stream(),
       prim_echo_stream_output_stream(),
       prim_string_input_stream_index(),
       prim_stream_info(),
       prim_set_stream_info(),
       prim_set_bfio_mode(),
       prim_cl_array_dimension_limit(),
       prim_cl_array_rank_limit(),
       prim_cl_array_total_size_limit(),
       prim_simple_array_p(),
       prim_vector_length(),
       prim_cl_make_array(),
       prim_cl_aref(),
       prim_cl_bit(),
       prim_cl_sbit(),
       prim_cl_aset(),
       prim_cl_bitset(),
       prim_cl_sbitset(),
       prim_cl_array_element_type(),
       prim_cl_array_rank(),
       prim_cl_array_dimension(),
       prim_cl_array_dimensions(),
       prim_cl_array_total_size(),
       prim_cl_array_in_bounds_p(),
       prim_cl_array_row_major_index(),
       prim_cl_adjustable_array_p(),
       prim_cl_array_has_fill_ptr(),
       prim_cl_fill_pointer(),
       prim_cl_set_fill_pointer(),
       prim_cl_vector_push(),
       prim_cl_vector_push_extend(),
       prim_vector_pop(),
       prim_array_is_displaced_p(),
       prim_cl_arrayp(),
       prim_cl_find_data_vector(),
       prim_cl_elt(),
       prim_cl_elt_set(),
       prim_adjust_array(),
       prim_cl_ivector_equal(),
       prim_elog_init(),
       prim_elog_setup(),
       prim_elog_define(),
       prim_elog_log(),
       prim_elog_output(),
       Prim_Apply(),
       Prim_Catch(),
       Prim_Non_Reentrant_Catch(),
       Prim_Enable_Interrupts(),
       Prim_Error_Procedure(),
       Prim_Get_Fixed_Objects_Vector(),
       Prim_Force(),
       Prim_Execute_At_New_Point(),
       Prim_Make_State_Space(),
       Prim_Current_Dynamic_State(),
       Prim_Set_Dynamic_State(),
       Prim_Scode_Eval(),
       Prim_Set_Interrupt_Enables(),
       Prim_Set_Current_History(),
       Prim_Set_Fixed_Objects_Vector(),
       Prim_Translate_To_Point(),
       Prim_With_History_Disabled(),
       Prim_With_Interrupt_Mask(),
       Prim_With_Interrupts_Reduced(),
       Prim_Within_Control_Point(),
       Prim_With_Threaded_Stack(),
       Prim_Zero_Fixnum(),
       Prim_Negative_Fixnum(),
       Prim_Positive_Fixnum(),
       Prim_Equal_Fixnum(),
       Prim_Less_Fixnum(),
       Prim_Greater_Fixnum(),
       Prim_One_Plus_Fixnum(),
       Prim_M_1_Plus_Fixnum(),
       Prim_Plus_Fixnum(),
       Prim_Minus_Fixnum(),
       Prim_Multiply_Fixnum(),
       Prim_Divide_Fixnum(),
       Prim_Gcd_Fixnum(),
       Prim_Hunk3_Cons(),
       Prim_Hunk3_Cxr(),
       Prim_Hunk3_Set_Cxr(),
       Prim_Sys_H3_0(),
       Prim_Sys_H3_1(),
       Prim_Sys_H3_2(),
       Prim_SH3_Set_0(),
       Prim_SH3_Set_1(),
       Prim_SH3_Set_2(),
       Prim_Cons(),
       Prim_Cdr(),
       Prim_Car(),
       Prim_General_Car_Cdr(),
       Prim_Assq(),
       Prim_Length(),
       Prim_Memq(),
       Prim_Set_Car(),
       Prim_Set_Cdr(),
       Prim_Pair(),
       Prim_Sys_Pair(),
       Prim_Sys_Pair_Car(),
       Prim_Sys_Pair_Cdr(),
       Prim_Sys_Pair_Cons(),
       Prim_Sys_Set_Car(),
       Prim_Sys_Set_Cdr(),
       Prim_Eval_Step(),
       Prim_Apply_Step(),
       Prim_Return_Step(),
       Prim_Make_Empty_String(),
       Prim_Make_Fld_String(),
       Prim_Build_String_From_List(),
       Prim_Equal_String_To_List(),
       Prim_Insert_String(),
       Prim_String_Equal(),
       Prim_Overwrite_String(),
       Prim_Substring(),
       Prim_Substring_Search(),
       Prim_Substring_To_List(),
       Prim_Raise_String(),
       Prim_Raise_Char(),
       Prim_String_Less(),
       Prim_String_Position(),
       Prim_Truncate_String(),
       Prim_Vector_8b(),
       Prim_Vector_8b_Cons(),
       Prim_Vec_8b_Size(),
       Prim_Vector_Cons(),
       Prim_vector(),
       Prim_Sys_Vector(),
       Prim_Vector_Size(),
       Prim_Sys_Vec_Size(),
       Prim_Vector_Ref(),
       Prim_Sys_Vector_Ref(),
       Prim_Vector_Set(),
       Prim_Sys_Vec_Set(),
       Prim_CL_Vector_Set(),
       Prim_CL_Sys_Vec_Set(),
       Prim_Subvector_To_List(),
       Prim_Sys_Subvector_To_List(),
       Prim_List_To_Vector(),
       Prim_Sys_List_To_Vector(),
       Prim_subvector_move_right(),
       Prim_subvector_move_left(),
       Prim_vector_fill(),
       Prim_Chk_And_Cln_Input_Channel(),
       Prim_Get_Next_Interrupt_Char(),
       Prim_System_Clock(),
       Prim_real_time_clock(),
       Prim_Setup_Timer_Interrupt(),
       Prim_current_year(),
       Prim_current_month(),
       Prim_current_day(),
       Prim_current_hour(),
       Prim_current_minute(),
       Prim_current_second(),
       Prim_Non_Restartable_Exit(),
       Prim_Restartable_Exit(),
       Prim_Set_Run_Light(),
       Prim_under_emacs_p(),
       Prim_Close_Lost_Open_Files(),
       Prim_Rehash(),
       Prim_Null(),
       Prim_Eq(),
       Prim_Make_Non_Pointer(),
       Prim_Primitive_Datum(),
       Prim_Unsigned_Primitive_Datum(),
       Prim_Prim_Type(),
       Prim_Non_Touching_Prim_Type(),
       Prim_Gc_Type(),
       Prim_Prim_Type_QM(),
       Prim_Non_Touching_Prim_Type_QM(),
       Prim_Primitive_Set_Type(),
       Prim_And_Make_Object(),
       Prim_System_Memory_Ref(),
       Prim_System_Memory_Set(),
       Prim_Make_Cell(),
       Prim_Cell_Contents(),
       Prim_Cell(),
       Prim_Set_Cell_Contents(),
       Prim_Non_Marked_Vector_Cons(),
       Prim_Insert_Non_Marked_Vector(),
       Prim_Map_Code_To_Address(),
       Prim_Map_Address_To_Code(),
       Prim_Map_Prim_Address_To_Arity(),
       Prim_Get_Primitive_Counts(),
       Prim_Get_Primitive_Name(),
       Prim_Get_Primitive_Address(),
       Prim_Lexical_Assignment(),
       Prim_Lexical_Reference(),
       Prim_Local_Reference(),
       Prim_Local_Assignment(),
       Prim_Unassigned_Test(),
       Prim_Unbound_Test(),
       Prim_Unreferenceable_Test(),
       Prim_Temp_Printer(),
       Prim_String_To_Symbol(),
       Prim_Intern_Character_List(),
       Prim_String_Hash(),
       Prim_string_hash_mod(),
       Prim_Character_List_Hash(),
       Prim_Prim_Fasdump(),
       Prim_Prim_Fasdump_Fd(),
       Prim_Band_Dump(),
       prim_set_cl_fasload_check(),
       Prim_Binary_Fasload(),
       Prim_Binary_Fasload_Fd(),
       Prim_reload_band_name(),
       Prim_Band_Load(),
       Slave_Before_Sync(),
       Slave_After_Sync(),
       Master_Before_Sync(),
       Master_GC(),
       GC_Needed(),
       Prim_Primitive_Purify(),
       Prim_Pure_P(),
       Prim_Constant_P(),
       Prim_Get_Next_Constant(),
       Prim_Garbage_Collect(),
       Prim_Impurify(),
       Prim_comp_code_address_block(),
       Prim_comp_code_address_offset(),
       Prim_Stack_Top_Address(),
       Prim_Compiled_Entry_Type(),
       Prim_Coerce_To_Closure(),
       Prim_Fix_To_Big(),
       Prim_Big_To_Fix(),
       Prim_Listify_Bignum(),
       Prim_Plus_Bignum(),
       Prim_Minus_Bignum(),
       Prim_Multiply_Bignum(),
       Prim_Divide_Bignum(),
       Prim_Zero_Bignum(),
       Prim_Positive_Bignum(),
       Prim_Negative_Bignum(),
       Prim_Equal_Bignum(),
       Prim_Greater_Bignum(),
       Prim_Less_Bignum(),
       Prim_Plus_Flonum(),
       Prim_Minus_Flonum(),
       Prim_Multiply_Flonum(),
       Prim_Divide_Flonum(),
       Prim_Equal_Flonum(),
       Prim_Greater_Flonum(),
       Prim_Less_Flonum(),
       Prim_Sine_Flonum(),
       Prim_Cosine_Flonum(),
       Prim_Arctan_Flonum(),
       Prim_Exp_Flonum(),
       Prim_Ln_Flonum(),
       Prim_Sqrt_Flonum(),
       Prim_Zero_Flonum(),
       Prim_Positive_Flonum(),
       Prim_Negative_Flonum(),
       Prim_Int_To_Float(),
       Prim_Truncate_Flonum(),
       Prim_Round_Flonum(),
       Prim_Zero(),
       Prim_Positive(),
       Prim_Negative(),
       Prim_One_Plus(),
       Prim_M_1_Plus(),
       Prim_Equal_Number(),
       Prim_Less(),
       Prim_Greater(),
       Prim_Plus(),
       Prim_Minus(),
       Prim_Multiply(),
       Prim_Divide(),
       Prim_Integer_Divide(),
       Prim_Sqrt(),
       Prim_Exp(),
       Prim_Ln(),
       Prim_Sine(),
       Prim_Cosine(),
       Prim_Arctan(),
       Prim_Truncate(),
       Prim_Round(),
       Prim_Floor(),
       Prim_Ceiling(),
       Prim_Make_Char(),
       Prim_Char_Bits(),
       Prim_Char_Code(),
       Prim_Char_To_Integer(),
       Prim_Integer_To_Char(),
       Prim_Char_Downcase(),
       Prim_Char_Upcase(),
       Prim_Ascii_To_Char(),
       Prim_Char_To_Ascii(),
       Prim_Char_Ascii_P(),
       Prim_File_Open_Channel(),
       Prim_File_Close_Channel(),
       Prim_File_Eof_P(),
       Prim_File_Length(),
       Prim_File_Read_Char(),
       Prim_File_Fill_Input_Buffer_Offset(),
       Prim_File_Fill_Input_Buffer(),
       Prim_File_Write_Char(),
       Prim_File_Write_String(),
       Prim_File_Exists(),
       Prim_Copy_File(),
       Prim_Rename_File(),
       Prim_Remove_File(),
       Prim_Link_File(),
       Prim_working_dir_pathname(),
       Prim_set_working_dir_pathname(),
       Prim_Make_Directory(),
       Prim_open_directory(),
       Prim_directory_read(),
       prim_fasopen_write(),
       prim_fasopen_read(),
       prim_fasclose(),
       prim_fasseek(),
       prim_faspos(),
       Prim_String_Allocate(),
       Prim_String_P(),
       Prim_String_Length(),
       Prim_String_Maximum_Length(),
       Prim_Set_String_Length(),
       Prim_String_Ref(),
       Prim_Vec_8b_Ref(),
       Prim_String_Set(),
       Prim_Vec_8b_Set(),
       Prim_Substring_Move_Right(),
       Prim_Substring_Move_Left(),
       Prim_Vec_8b_Fill(),
       Prim_Vec_8b_Find_Next_Char(),
       Prim_Vec_8b_Find_Prev_Char(),
       Prim_Vec_8b_Find_Next_Char_Ci(),
       Prim_Vec_8b_Find_Prev_Char_Ci(),
       Prim_Find_Next_Char_In_Set(),
       Prim_Find_Prev_Char_In_Set(),
       Prim_Substring_Equal(),
       Prim_Substring_Ci_Equal(),
       Prim_Substring_Less(),
       Prim_Substring_Upcase(),
       Prim_Substring_Downcase(),
       Prim_Match_Forward(),
       Prim_Match_Forward_Ci(),
       Prim_Match_Backward(),
       Prim_Match_Backward_Ci(),
       Prim_Tty_Read_Char_Ready_P(),
       Prim_Tty_Read_Char(),
       Prim_Tty_Read_Char_Immediate(),
       Prim_Tty_Read_Finish(),
       Prim_Tty_Write_Char(),
       Prim_Tty_Write_String(),
       Prim_tty_flush_output(),
       Prim_Tty_Beep(),
       Prim_Tty_Clear(),
       Prim_Photo_Open(),
       Prim_Photo_Close(),
       Prim_Tty_Move_Cursor(),
       Prim_Tty_Get_Cursor(),
       Prim_Screen_X_Size(),
       Prim_Screen_Y_Size(),
       Prim_Clear_To_End_Of_Line(),
       Prim_Microcode_Identify(),
       Prim_Microcode_Tables_Filename(),
       Prim_Get_Command_Line(),
       Prim_String_To_Syntax_Entry(),
       Prim_Char_To_Syntax_Code(),
       Prim_Quoted_Char_P(),
       Prim_Scan_Backward_Prefix_Chars(),
       Prim_Scan_Forward_To_Word(),
       Prim_Scan_Word_Forward(),
       Prim_Scan_Word_Backward(),
       Prim_Scan_List_Forward(),
       Prim_Scan_List_Backward(),
       Prim_Scan_Sexps_Forward(),
       Prim_bit_string_allocate(),
       Prim_bit_string_p(),
       Prim_make_bit_string(),
       Prim_bit_string_fill_x(),
       Prim_bit_string_length(),
       Prim_bit_string_ref(),
       Prim_bit_string_clear_x(),
       Prim_bit_string_set_x(),
       Prim_bit_string_zero_p(),
       Prim_bit_string_equal_p(),
       Prim_bit_string_move_x(),
       Prim_bit_string_movec_x(),
       Prim_bit_string_or_x(),
       Prim_bit_string_and_x(),
       Prim_bit_string_andc_x(),
       Prim_bit_string_xor_x(),
       Prim_bit_substring_move_right_x(),
       Prim_unsigned_to_bit_string(),
       Prim_bit_string_to_unsigned(),
       Prim_read_bits_x(),
       Prim_write_bits_x(),
       Prim_bitstr_find_next_set_bit(),
       Prim_re_char_set_adjoin(),
       Prim_re_compile_fastmap(),
       Prim_re_match_substring(),
       Prim_re_search_substr_forward(),
       Prim_re_search_substr_backward(),
       Prim_re_match_buffer(),
       Prim_re_search_buffer_forward(),
       Prim_re_search_buffer_backward();

Pointer
Prim_Inexistent()
{
  Primitive_0_Args();

  Primitive_Error(ERR_UNIMPLEMENTED_PRIMITIVE);
  /*NOTREACHED*/
}

Pointer (*(Primitive_Procedure_Table[]))() = {
  Prim_Await_Future                        /*  1 "%AWAIT-FUTURE"                                Primitive   0x0 in ffuture.c */,
  Prim_Change_Priority                     /*  2 "%CHANGE-PRIORITY"                             Primitive   0x1 in ffuture.c */,
  Prim_Determine                           /*  3 "%DETERMINE!"                                  Primitive   0x2 in ffuture.c */,
  Prim_Inherit_Down                        /*  2 "%INHERIT-PRIORITY-DOWN"                       Primitive   0x3 in ffuture.c */,
  Prim_Inherit_Up                          /*  2 "%INHERIT-PRIORITY-UP"                         Primitive   0x4 in ffuture.c */,
  Prim_Scheduler                           /*  0 "%RESCHEDULE"                                  Primitive   0x5 in ffuture.c */,
  prim_set_cl_fasload_check                /*  1 "%SET-CL-FASLOAD-CHECK!"                       Primitive   0x6 in fasload.c */,
  Prim_Spawn_Process                       /*  3 "%SPAWN-PROCESS"                               Primitive   0x7 in ffuture.c */,
  Prim_Start_Preempting                    /*  0 "%START-PREEMPTING"                            Primitive   0x8 in ffuture.c */,
  Prim_Stop_Preempting                     /*  0 "%STOP-PREEMPTING"                             Primitive   0x9 in ffuture.c */,
  prim_svset                               /*  3 "%SVSET"                                       Primitive   0xa in gvector.c */,
  Prim_Multiply                            /*  2 "&*"                                           Primitive   0xb in generic.c */,
  Prim_Plus                                /*  2 "&+"                                           Primitive   0xc in generic.c */,
  Prim_Minus                               /*  2 "&-"                                           Primitive   0xd in generic.c */,
  Prim_Divide                              /*  2 "&/"                                           Primitive   0xe in generic.c */,
  Prim_Less                                /*  2 "&<"                                           Primitive   0xf in generic.c */,
  Prim_Equal_Number                        /*  2 "&="                                           Primitive  0x10 in generic.c */,
  Prim_Greater                             /*  2 "&>"                                           Primitive  0x11 in generic.c */,
  Prim_Arctan                              /*  1 "&ATAN"                                        Primitive  0x12 in generic.c */,
  Prim_And_Make_Object                     /*  2 "&MAKE-OBJECT"                                 Primitive  0x13 in prim.c */,
  Prim_M_1_Plus                            /*  1 "-1+"                                          Primitive  0x14 in generic.c */,
  Prim_One_Plus                            /*  1 "1+"                                           Primitive  0x15 in generic.c */,
  Prim_Add_Fluid_Binding                   /*  3 "ADD-FLUID-BINDING!"                           Primitive  0x16 in fhooks.c */,
  Prim_Apply                               /*  2 "APPLY"                                        Primitive  0x17 in hooks.c */,
  Prim_Arctan_Flonum                       /*  1 "ARCTAN-FLONUM"                                Primitive  0x18 in flonum.c */,
  Prim_Ascii_To_Char                       /*  1 "ASCII->CHAR"                                  Primitive  0x19 in character.c */,
  prim_ash                                 /*  2 "ASH"                                          Primitive  0x1a in cl-arith.c */,
  Prim_Assq                                /*  2 "ASSQ"                                         Primitive  0x1b in list.c */,
  Prim_Atomic_Add_Car                      /*  2 "ATOMIC-ADD-CAR!"                              Primitive  0x1c in parallel.c */,
  Prim_Atomic_Add_Cdr                      /*  2 "ATOMIC-ADD-CDR!"                              Primitive  0x1d in parallel.c */,
  Prim_Atomic_Add_Vector                   /*  3 "ATOMIC-ADD-VECTOR!"                           Primitive  0x1e in parallel.c */,
  Prim_Await_Sync                          /*  1 "AWAIT-SYNCHRONY"                              Primitive  0x1f in bf-prims.c */,
  Prim_Get_Stream_Number                   /*  0 "BFIO-GET-STREAM-NUMBER"                       Primitive  0x20 in bf-io.c */,
  Prim_BFIO_Kick_Input_Server              /*  0 "BFIO-KICK-INPUT-SERVER"                       Primitive  0x21 in bf-io.c */,
  Prim_Get_Next_Hash_Number                /*  0 "BFIO-NEXT-HASH-NUMBER"                        Primitive  0x22 in bf-io.c */,
  Prim_BFIO_Read_Char                      /*  2 "BFIO-READ-CHAR"                               Primitive  0x23 in bf-io.c */,
  Prim_BFIO_Read_String                    /*  3 "BFIO-READ-STRING"                             Primitive  0x24 in bf-io.c */,
  Prim_BFIO_Task_Hash                      /*  1 "BFIO-TASK-HASH"                               Primitive  0x25 in bf-io.c */,
  Prim_BFIO_Task_Unhash                    /*  1 "BFIO-TASK-UNHASH"                             Primitive  0x26 in bf-io.c */,
  Prim_Binary_Fasload                      /*  1 "BINARY-FASLOAD"                               Primitive  0x27 in fasload.c */,
  Prim_Binary_Fasload_Fd                   /*  2 "BINARY-FASLOAD-FD"                            Primitive  0x28 in fasload.c */,
  Prim_bit_string_to_unsigned              /*  1 "BIT-STRING->UNSIGNED-INTEGER"                 Primitive  0x29 in bitstr.c */,
  Prim_bit_string_allocate                 /*  1 "BIT-STRING-ALLOCATE"                          Primitive  0x2a in bitstr.c */,
  Prim_bit_string_and_x                    /*  2 "BIT-STRING-AND!"                              Primitive  0x2b in bitstr.c */,
  Prim_bit_string_andc_x                   /*  2 "BIT-STRING-ANDC!"                             Primitive  0x2c in bitstr.c */,
  Prim_bit_string_clear_x                  /*  2 "BIT-STRING-CLEAR!"                            Primitive  0x2d in bitstr.c */,
  Prim_bit_string_fill_x                   /*  2 "BIT-STRING-FILL!"                             Primitive  0x2e in bitstr.c */,
  Prim_bit_string_length                   /*  1 "BIT-STRING-LENGTH"                            Primitive  0x2f in bitstr.c */,
  Prim_bit_string_move_x                   /*  2 "BIT-STRING-MOVE!"                             Primitive  0x30 in bitstr.c */,
  Prim_bit_string_movec_x                  /*  2 "BIT-STRING-MOVEC!"                            Primitive  0x31 in bitstr.c */,
  Prim_bit_string_or_x                     /*  2 "BIT-STRING-OR!"                               Primitive  0x32 in bitstr.c */,
  Prim_bit_string_ref                      /*  2 "BIT-STRING-REF"                               Primitive  0x33 in bitstr.c */,
  Prim_bit_string_set_x                    /*  2 "BIT-STRING-SET!"                              Primitive  0x34 in bitstr.c */,
  Prim_bit_string_xor_x                    /*  2 "BIT-STRING-XOR!"                              Primitive  0x35 in bitstr.c */,
  Prim_bit_string_zero_p                   /*  1 "BIT-STRING-ZERO?"                             Primitive  0x36 in bitstr.c */,
  Prim_bit_string_equal_p                  /*  2 "BIT-STRING=?"                                 Primitive  0x37 in bitstr.c */,
  Prim_bit_string_p                        /*  1 "BIT-STRING?"                                  Primitive  0x38 in bitstr.c */,
  Prim_bitstr_find_next_set_bit            /*  3 "BIT-SUBSTRING-FIND-NEXT-SET-BIT"              Primitive  0x39 in bitstr.c */,
  Prim_bit_substring_move_right_x          /*  5 "BIT-SUBSTRING-MOVE-RIGHT!"                    Primitive  0x3a in bitstr.c */,
  prim_boole                               /*  3 "BOOLE"                                        Primitive  0x3b in bool.c */,
  Prim_Catch                               /*  1 "CALL-WITH-CURRENT-CONTINUATION"               Primitive  0x3c in hooks.c */,
  Prim_Car                                 /*  1 "CAR"                                          Primitive  0x3d in list.c */,
  Prim_Cdr                                 /*  1 "CDR"                                          Primitive  0x3e in list.c */,
  Prim_Ceiling                             /*  1 "CEILING"                                      Primitive  0x3f in generic.c */,
  Prim_Cell_Contents                       /*  1 "CELL-CONTENTS"                                Primitive  0x40 in prim.c */,
  Prim_Cell                                /*  1 "CELL?"                                        Primitive  0x41 in prim.c */,
  Prim_Char_To_Ascii                       /*  1 "CHAR->ASCII"                                  Primitive  0x42 in character.c */,
  Prim_Char_To_Integer                     /*  1 "CHAR->INTEGER"                                Primitive  0x43 in character.c */,
  Prim_Char_To_Syntax_Code                 /*  2 "CHAR->SYNTAX-CODE"                            Primitive  0x44 in syntax.c */,
  Prim_Char_Ascii_P                        /*  1 "CHAR-ASCII?"                                  Primitive  0x45 in character.c */,
  Prim_Char_Bits                           /*  1 "CHAR-BITS"                                    Primitive  0x46 in character.c */,
  Prim_Char_Code                           /*  1 "CHAR-CODE"                                    Primitive  0x47 in character.c */,
  Prim_Char_Downcase                       /*  1 "CHAR-DOWNCASE"                                Primitive  0x48 in character.c */,
  Prim_Char_Upcase                         /*  1 "CHAR-UPCASE"                                  Primitive  0x49 in character.c */,
  Prim_Character_List_Hash                 /*  1 "CHARACTER-LIST-HASH"                          Primitive  0x4a in intern.c */,
  Prim_Raise_Char                          /*  1 "CHARACTER-UPCASE"                             Primitive  0x4b in string.c */,
  Prim_Chk_And_Cln_Input_Channel           /*  2 "CHECK-AND-CLEAN-UP-INPUT-CHANNEL"             Primitive  0x4c in sysprim.c */,
  prim_cl_make_broadcast_stream            /*  2 "CL-%MAKE-BROADCAST-STREAM"                    Primitive  0x4d in cl-streams.c */,
  prim_cl_make_concatenated_stream         /*  1 "CL-%MAKE-CONCATENATED-STREAM"                 Primitive  0x4e in cl-streams.c */,
  prim_cl_add_clsav                        /*  1 "CL-ADD-CLSAV"                                 Primitive  0x4f in cl-symbol.c */,
  prim_adjust_array                        /* -1 "CL-ADJUST-ARRAY"                              Primitive  0x50 in cl-array.c */,
  prim_cl_adjustable_array_p               /*  1 "CL-ADJUSTABLE-ARRAY-P"                        Primitive  0x51 in cl-array.c */,
  prim_cl_aref                             /* -1 "CL-AREF"                                      Primitive  0x52 in cl-array.c */,
  prim_cl_array_dimension                  /*  2 "CL-ARRAY-DIMENSION"                           Primitive  0x53 in cl-array.c */,
  prim_cl_array_dimension_limit            /*  0 "CL-ARRAY-DIMENSION-LIMIT"                     Primitive  0x54 in cl-array.c */,
  prim_cl_array_dimensions                 /*  1 "CL-ARRAY-DIMENSIONS"                          Primitive  0x55 in cl-array.c */,
  prim_cl_array_element_type               /*  1 "CL-ARRAY-ELEMENT-TYPE"                        Primitive  0x56 in cl-array.c */,
  prim_cl_array_has_fill_ptr               /*  1 "CL-ARRAY-HAS-FILL-POINTER-P"                  Primitive  0x57 in cl-array.c */,
  prim_cl_array_in_bounds_p                /* -1 "CL-ARRAY-IN-BOUNDS-P"                         Primitive  0x58 in cl-array.c */,
  prim_array_is_displaced_p                /*  1 "CL-ARRAY-IS-DISPLACED-P"                      Primitive  0x59 in cl-array.c */,
  prim_cl_array_rank                       /*  1 "CL-ARRAY-RANK"                                Primitive  0x5a in cl-array.c */,
  prim_cl_array_rank_limit                 /*  0 "CL-ARRAY-RANK-LIMIT"                          Primitive  0x5b in cl-array.c */,
  prim_cl_array_row_major_index            /* -1 "CL-ARRAY-ROW-MAJOR-INDEX"                     Primitive  0x5c in cl-array.c */,
  prim_cl_array_total_size                 /*  1 "CL-ARRAY-TOTAL-SIZE"                          Primitive  0x5d in cl-array.c */,
  prim_cl_array_total_size_limit           /*  0 "CL-ARRAY-TOTAL-SIZE-LIMIT"                    Primitive  0x5e in cl-array.c */,
  prim_cl_arrayp                           /*  1 "CL-ARRAYP"                                    Primitive  0x5f in cl-array.c */,
  prim_cl_aset                             /* -1 "CL-ASET"                                      Primitive  0x60 in cl-array.c */,
  prim_cl_bit                              /* -1 "CL-BIT"                                       Primitive  0x61 in cl-array.c */,
  prim_cl_bitset                           /* -1 "CL-BITSET"                                    Primitive  0x62 in cl-array.c */,
  prim_broadcast_stream_streams            /*  1 "CL-BROADCAST-STREAM-STREAMS"                  Primitive  0x63 in cl-streams.c */,
  prim_cl_broadcast_stream_p               /*  1 "CL-BROADCAST-STREAM?"                         Primitive  0x64 in cl-streams.c */,
  prim_cl_charpos                          /* -1 "CL-CHARPOS"                                   Primitive  0x65 in cl-streams.c */,
  prim_cl_clear_input                      /* -1 "CL-CLEAR-INPUT"                               Primitive  0x66 in cl-streams.c */,
  prim_cl_clear_output                     /* -1 "CL-CLEAR-OUTPUT"                              Primitive  0x67 in cl-streams.c */,
  prim_cl_close                            /* -1 "CL-CLOSE"                                     Primitive  0x68 in cl-streams.c */,
  prim_cl_closed_stream_p                  /*  1 "CL-CLOSED-STREAM?"                            Primitive  0x69 in cl-streams.c */,
  prim_cl_computerized_flonum_to_string    /*  2 "CL-COMPUTERIZED-FLONUM-TO-STRING"             Primitive  0x6a in cl-arith.c */,
  prim_concatenated_stream_streams         /*  1 "CL-CONCATENATED-STREAM-STREAMS"               Primitive  0x6b in cl-streams.c */,
  prim_cl_concat_stream_p                  /*  1 "CL-CONCATENATED-STREAM?"                      Primitive  0x6c in cl-streams.c */,
  prim_cl_directoryp                       /*  1 "CL-DIRECTORY?"                                Primitive  0x6d in cl-time.c */,
  prim_echo_stream_input_stream            /*  1 "CL-ECHO-STREAM-INPUT-STREAM"                  Primitive  0x6e in cl-streams.c */,
  prim_echo_stream_output_stream           /*  1 "CL-ECHO-STREAM-OUTPUT-STREAM"                 Primitive  0x6f in cl-streams.c */,
  prim_cl_echo_stream_p                    /*  1 "CL-ECHO-STREAM?"                              Primitive  0x70 in cl-streams.c */,
  prim_cl_elt                              /*  2 "CL-ELT"                                       Primitive  0x71 in cl-array.c */,
  prim_cl_elt_set                          /*  3 "CL-ELT-SET"                                   Primitive  0x72 in cl-array.c */,
  prim_cl_expanded_symbol_p                /*  1 "CL-EXPANDED-SYMBOL?"                          Primitive  0x73 in cl-symbol.c */,
  prim_cl_fast_symbol_plist                /*  1 "CL-FAST-SYMBOL-PLIST"                         Primitive  0x74 in cl-symbol.c */,
  prim_cl_fast_system_symbol_plist         /*  1 "CL-FAST-SYSTEM-SYMBOL-PLIST"                  Primitive  0x75 in cl-symbol.c */,
  prim_cl_file_author                      /*  1 "CL-FILE-AUTHOR"                               Primitive  0x76 in cl-fileio.c */,
  Prim_CL_File_Close_Fd                    /*  1 "CL-FILE-CLOSE-FD"                             Primitive  0x77 in cl-fileio.c */,
  prim_cl_file_length                      /*  1 "CL-FILE-LENGTH"                               Primitive  0x78 in cl-streams.c */,
  Prim_CL_File_Open_Fd                     /*  4 "CL-FILE-OPEN-FD"                              Primitive  0x79 in cl-fileio.c */,
  prim_cl_file_position                    /* -1 "CL-FILE-POSITION"                             Primitive  0x7a in cl-streams.c */,
  prim_cl_file_stream_p                    /*  1 "CL-FILE-STREAM?"                              Primitive  0x7b in cl-streams.c */,
  prim_cl_file_write_date                  /*  1 "CL-FILE-WRITE-DATE"                           Primitive  0x7c in cl-fileio.c */,
  prim_cl_fill_pointer                     /*  1 "CL-FILL-POINTER"                              Primitive  0x7d in cl-array.c */,
  prim_cl_find_data_vector                 /*  1 "CL-FIND-DATA-VECTOR"                          Primitive  0x7e in cl-array.c */,
  prim_cl_finish_output                    /* -1 "CL-FINISH-OUTPUT"                             Primitive  0x7f in cl-streams.c */,
  prim_cl_force_output                     /* -1 "CL-FORCE-OUTPUT"                              Primitive  0x80 in cl-streams.c */,
  prim_format_exponential_flonum_to_string /*  7 "CL-FORMAT-EXPONENTIAL-FLONUM-TO-STRING"       Primitive  0x81 in cl-arith.c */,
  prim_format_fixed_flonum_to_string       /*  5 "CL-FORMAT-FIXED-FLONUM-TO-STRING"             Primitive  0x82 in cl-arith.c */,
  prim_cl_function_symbol_p                /*  1 "CL-FUNCTION-SYMBOL?"                          Primitive  0x83 in cl-symbol.c */,
  prim_cl_get_clsav                        /*  1 "CL-GET-CLSAV"                                 Primitive  0x84 in cl-symbol.c */,
  prim_cl_function_symbol_parent           /*  1 "CL-GET-FUNCTION-SYMBOL-PARENT"                Primitive  0x85 in cl-symbol.c */,
  prim_cl_get_host_name                    /*  0 "CL-GET-HOST-NAME"                             Primitive  0x86 in cl-time.c */,
  prim_cl_get_output_stream_string         /*  1 "CL-GET-OUTPUT-STREAM-STRING"                  Primitive  0x87 in cl-streams.c */,
  prim_cl_get_name                         /*  1 "CL-GET-SYMBOL-NAME"                           Primitive  0x88 in cl-symbol.c */,
  prim_cl_internal_write_char              /*  1 "CL-INTERNAL-WRITE-CHAR"                       Primitive  0x89 in cl-streams.c */,
  prim_cl_internal_write_string            /*  2 "CL-INTERNAL-WRITE-STRING"                     Primitive  0x8a in cl-streams.c */,
  prim_cl_internal_write_string_start_end  /*  4 "CL-INTERNAL-WRITE-STRING-START-END"           Primitive  0x8b in cl-streams.c */,
  prim_cl_isa_tty                          /*  1 "CL-ISA-TTY-P"                                 Primitive  0x8c in cl-streams.c */,
  prim_cl_ivector_equal                    /*  2 "CL-IVECTOR-EQUAL"                             Primitive  0x8d in cl-ivector.c */,
  prim_cl_listen                           /* -1 "CL-LISTEN"                                    Primitive  0x8e in cl-streams.c */,
  prim_cl_make_array                       /* -1 "CL-MAKE-ARRAY"                                Primitive  0x8f in cl-array.c */,
  prim_cl_make_echo_stream                 /*  2 "CL-MAKE-ECHO-STREAM"                          Primitive  0x90 in cl-streams.c */,
  prim_cl_make_file_stream                 /*  5 "CL-MAKE-FILE-STREAM"                          Primitive  0x91 in cl-streams.c */,
  prim_cl_make_string_input_stream         /* -1 "CL-MAKE-STRING-INPUT-STREAM"                  Primitive  0x92 in cl-streams.c */,
  prim_cl_make_string_output_stream        /*  0 "CL-MAKE-STRING-OUTPUT-STREAM"                 Primitive  0x93 in cl-streams.c */,
  prim_cl_make_synonym_stream              /*  1 "CL-MAKE-SYNONYM-STREAM"                       Primitive  0x94 in cl-streams.c */,
  prim_cl_make_the_tty_stream              /*  0 "CL-MAKE-THE-TTY-STREAM"                       Primitive  0x95 in cl-streams.c */,
  prim_cl_make_two_way_stream              /*  2 "CL-MAKE-TWO-WAY-STREAM"                       Primitive  0x96 in cl-streams.c */,
  prim_cl_overwrite_string                 /*  5 "CL-OVERWRITE-STRING"                          Primitive  0x97 in stringmisc.c */,
  prim_cl_parse_number                     /*  2 "CL-PARSE-NUMBER"                              Primitive  0x98 in cl-arith.c */,
  prim_cl_peek_char                        /* -1 "CL-PEEK-CHAR"                                 Primitive  0x99 in cl-streams.c */,
  prim_cl_read_byte                        /* -1 "CL-READ-BYTE"                                 Primitive  0x9a in cl-streams.c */,
  prim_cl_read_char                        /* -1 "CL-READ-CHAR"                                 Primitive  0x9b in cl-streams.c */,
  prim_cl_read_char_no_hang                /* -1 "CL-READ-CHAR-NO-HANG"                         Primitive  0x9c in cl-streams.c */,
  prim_cl_read_line                        /* -1 "CL-READ-LINE"                                 Primitive  0x9d in cl-streams.c */,
  prim_cl_read_string                      /* -1 "CL-READ-STRING"                               Primitive  0x9e in cl-streams.c */,
  prim_cl_sbit                             /* -1 "CL-SBIT"                                      Primitive  0x9f in cl-array.c */,
  prim_cl_sbitset                          /* -1 "CL-SBITSET"                                   Primitive  0xa0 in cl-array.c */,
  prim_cl_scan_directory                   /*  1 "CL-SCAN-DIRECTORY"                            Primitive  0xa1 in cl-time.c */,
  prim_set_bfio_mode                       /*  2 "CL-SET-BFIO-MODE!"                            Primitive  0xa2 in cl-streams.c */,
  prim_cl_set_fill_pointer                 /*  2 "CL-SET-FILL-POINTER"                          Primitive  0xa3 in cl-array.c */,
  prim_set_stream_info                     /*  2 "CL-SET-STREAM-INFO!"                          Primitive  0xa4 in cl-streams.c */,
  prim_simple_array_p                      /*  1 "CL-SIMPLE-ARRAY-P"                            Primitive  0xa5 in cl-array.c */,
  prim_sleep                               /*  1 "CL-SLEEP"                                     Primitive  0xa6 in cl-time.c */,
  prim_cl_stream_direction                 /*  1 "CL-STREAM-DIRECTION"                          Primitive  0xa7 in cl-streams.c */,
  prim_cl_stream_element_type              /*  1 "CL-STREAM-ELEMENT-TYPE"                       Primitive  0xa8 in cl-streams.c */,
  prim_stream_info                         /*  1 "CL-STREAM-INFO"                               Primitive  0xa9 in cl-streams.c */,
  prim_cl_stream_pathname                  /*  1 "CL-STREAM-PATHNAME"                           Primitive  0xaa in cl-streams.c */,
  prim_cl_string_capitalize                /*  1 "CL-STRING-CAPITALIZE"                         Primitive  0xab in cl-symbol.c */,
  prim_string_capitalize_bang              /*  1 "CL-STRING-CAPITALIZE!"                        Primitive  0xac in cl-symbol.c */,
  prim_string_input_stream_index           /*  1 "CL-STRING-INPUT-STREAM-INDEX"                 Primitive  0xad in cl-streams.c */,
  prim_cl_string_open                      /*  4 "CL-STRING-OPEN"                               Primitive  0xae in cl-streams.c */,
  prim_cl_string_stream_p                  /*  1 "CL-STRING-STREAM?"                            Primitive  0xaf in cl-streams.c */,
  prim_synonym_stream_symbol               /*  1 "CL-SYNONYM-STREAM-SYMBOL"                     Primitive  0xb0 in cl-streams.c */,
  prim_cl_synonym_stream_p                 /*  1 "CL-SYNONYM-STREAM?"                           Primitive  0xb1 in cl-streams.c */,
  Prim_CL_Sys_Vec_Set                      /*  3 "CL-SYSTEM-VECTOR-SET!"                        Primitive  0xb2 in vector.c */,
  prim_cl_tty_stream_p                     /*  1 "CL-TTY-STREAM?"                               Primitive  0xb3 in cl-streams.c */,
  prim_two_way_stream_input_stream         /*  1 "CL-TWO-WAY-STREAM-INPUT-STREAM"               Primitive  0xb4 in cl-streams.c */,
  prim_two_way_stream_output_stream        /*  1 "CL-TWO-WAY-STREAM-OUTPUT-STREAM"              Primitive  0xb5 in cl-streams.c */,
  prim_cl_two_way_stream_p                 /*  1 "CL-TWO-WAY-STREAM?"                           Primitive  0xb6 in cl-streams.c */,
  prim_cl_unread_char                      /* -1 "CL-UNREAD-CHAR"                               Primitive  0xb7 in cl-streams.c */,
  prim_vector_length                       /*  1 "CL-VECTOR-LENGTH"                             Primitive  0xb8 in cl-array.c */,
  prim_vector_pop                          /*  1 "CL-VECTOR-POP"                                Primitive  0xb9 in cl-array.c */,
  prim_cl_vector_push                      /*  2 "CL-VECTOR-PUSH"                               Primitive  0xba in cl-array.c */,
  prim_cl_vector_push_extend               /* -1 "CL-VECTOR-PUSH-EXTEND"                        Primitive  0xbb in cl-array.c */,
  Prim_CL_Vector_Set                       /*  3 "CL-VECTOR-SET!"                               Primitive  0xbc in vector.c */,
  prim_cl_write_byte                       /*  2 "CL-WRITE-BYTE"                                Primitive  0xbd in cl-streams.c */,
  prim_cl_write_char                       /* -1 "CL-WRITE-CHAR"                                Primitive  0xbe in cl-streams.c */,
  cl_prim_write_line                       /* -1 "CL-WRITE-LINE"                                Primitive  0xbf in cl-streams.c */,
  cl_prim_write_string                     /* -1 "CL-WRITE-STRING"                              Primitive  0xc0 in cl-streams.c */,
  Prim_Clear_To_End_Of_Line                /*  0 "CLEAR-TO-END-OF-LINE"                         Primitive  0xc1 in ttyio.c */,
  Prim_Close_Lost_Open_Files               /*  1 "CLOSE-LOST-OPEN-FILES"                        Primitive  0xc2 in daemon.c */,
  Prim_Move_To_Codespace                   /*  1 "CODE->CODE-SPACE"                             Primitive  0xc3 in bf-prims.c */,
  Prim_Big_To_Fix                          /*  1 "COERCE-BIGNUM-TO-FIXNUM"                      Primitive  0xc4 in bignum.c */,
  Prim_Fix_To_Big                          /*  1 "COERCE-FIXNUM-TO-BIGNUM"                      Primitive  0xc5 in bignum.c */,
  Prim_Int_To_Float                        /*  1 "COERCE-INTEGER-TO-FLONUM"                     Primitive  0xc6 in flonum.c */,
  Prim_Coerce_To_Closure                   /*  2 "COERCE-TO-COMPILED-PROCEDURE"                 Primitive  0xc7 in comutl.c */,
  Prim_comp_code_address_block             /*  1 "COMPILED-CODE-ADDRESS->BLOCK"                 Primitive  0xc8 in comutl.c */,
  Prim_comp_code_address_offset            /*  1 "COMPILED-CODE-ADDRESS->OFFSET"                Primitive  0xc9 in comutl.c */,
  Prim_Compiled_Entry_Type                 /*  1 "COMPILED-ENTRY-KIND"                          Primitive  0xca in comutl.c */,
  Prim_Cons                                /*  2 "CONS"                                         Primitive  0xcb in list.c */,
  Prim_Constant_P                          /*  1 "CONSTANT?"                                    Primitive  0xcc in bf-purify.c */,
  Prim_Copy_File                           /*  2 "COPY-FILE"                                    Primitive  0xcd in fileio.c */,
  Prim_Cosine                              /*  1 "COS"                                          Primitive  0xce in generic.c */,
  Prim_Cosine_Flonum                       /*  1 "COSINE-FLONUM"                                Primitive  0xcf in flonum.c */,
  Prim_current_day                         /*  0 "CURRENT-DAY"                                  Primitive  0xd0 in sysprim.c */,
  Prim_Current_Dynamic_State               /*  1 "CURRENT-DYNAMIC-STATE"                        Primitive  0xd1 in hooks.c */,
  Prim_current_file_time                   /*  0 "CURRENT-FILE-TIME"                            Primitive  0xd2 in unixprim.c */,
  Prim_Current_Future                      /*  0 "CURRENT-FUTURE"                               Primitive  0xd3 in ffuture.c */,
  Prim_current_hour                        /*  0 "CURRENT-HOUR"                                 Primitive  0xd4 in sysprim.c */,
  Prim_current_minute                      /*  0 "CURRENT-MINUTE"                               Primitive  0xd5 in sysprim.c */,
  Prim_current_month                       /*  0 "CURRENT-MONTH"                                Primitive  0xd6 in sysprim.c */,
  Prim_current_second                      /*  0 "CURRENT-SECOND"                               Primitive  0xd7 in sysprim.c */,
  Prim_get_user_name                       /*  0 "CURRENT-USER-NAME"                            Primitive  0xd8 in unixprim.c */,
  Prim_current_year                        /*  0 "CURRENT-YEAR"                                 Primitive  0xd9 in sysprim.c */,
  Prim_Debug_Flags                         /*  0 "DEBUG-FLAGS"                                  Primitive  0xda in xdebug.c */,
  Prim_Temp_Printer                        /*  1 "DEBUGGING-PRINTER"                            Primitive  0xdb in debug.c */,
  prim_df_exp                              /*  1 "DECODE-FLOAT-EXPONENT"                        Primitive  0xdc in cl-arith.c */,
  prim_df_mant                             /*  1 "DECODE-FLOAT-MANTISSA"                        Primitive  0xdd in cl-arith.c */,
  prim_decode_sign                         /*  1 "DECODE-FLOAT-SIGN"                            Primitive  0xde in cl-arith.c */,
  Prim_Dequeue_Head                        /*  1 "DEQUEUE-HEAD!"                                Primitive  0xdf in parallel.c */,
  Prim_Dequeue_Tail                        /*  1 "DEQUEUE-TAIL!"                                Primitive  0xe0 in parallel.c */,
  Prim_directory_read                      /*  0 "DIRECTORY-READ"                               Primitive  0xe1 in fileio.c */,
  Prim_Divide_Bignum                       /*  2 "DIVIDE-BIGNUM"                                Primitive  0xe2 in bignum.c */,
  Prim_Divide_Fixnum                       /*  2 "DIVIDE-FIXNUM"                                Primitive  0xe3 in fixnum.c */,
  Prim_Divide_Flonum                       /*  2 "DIVIDE-FLONUM"                                Primitive  0xe4 in flonum.c */,
  Drain_Work_Queue                         /*  0 "DRAIN-WORK-QUEUE!"                            Primitive  0xe5 in bf-prims.c */,
  Prim_Band_Dump                           /*  2 "DUMP-BAND"                                    Primitive  0xe6 in fasdump.c */,
  Prim_Enable_Interrupts                   /*  1 "ENABLE-INTERRUPTS!"                           Primitive  0xe7 in hooks.c */,
  Prim_Enqueue_Head                        /*  2 "ENQUEUE-HEAD!"                                Primitive  0xe8 in parallel.c */,
  Prim_Enqueue_Tail                        /*  2 "ENQUEUE-TAIL!"                                Primitive  0xe9 in parallel.c */,
  Prim_Eq                                  /*  2 "EQ?"                                          Primitive  0xea in prim.c */,
  Prim_Equal_Bignum                        /*  2 "EQUAL-BIGNUM?"                                Primitive  0xeb in bignum.c */,
  Prim_Equal_Fixnum                        /*  2 "EQUAL-FIXNUM?"                                Primitive  0xec in fixnum.c */,
  Prim_Equal_Flonum                        /*  2 "EQUAL-FLONUM?"                                Primitive  0xed in flonum.c */,
  Prim_Equal_String_To_List                /*  2 "EQUAL-STRING-TO-LIST?"                        Primitive  0xee in string.c */,
  Prim_Error_Procedure                     /*  3 "ERROR-PROCEDURE"                              Primitive  0xef in hooks.c */,
  Prim_Execute_At_New_Point                /*  4 "EXECUTE-AT-NEW-STATE-POINT"                   Primitive  0xf0 in hooks.c */,
  Prim_Non_Restartable_Exit                /*  0 "EXIT"                                         Primitive  0xf1 in sysprim.c */,
  Prim_Exp                                 /*  1 "EXP"                                          Primitive  0xf2 in generic.c */,
  Prim_Exp_Flonum                          /*  1 "EXP-FLONUM"                                   Primitive  0xf3 in flonum.c */,
  prim_fasclose                            /*  1 "FASCLOSE"                                     Primitive  0xf4 in fileio.c */,
  prim_fasopen_read                        /*  1 "FASOPEN-READ"                                 Primitive  0xf5 in fileio.c */,
  prim_fasopen_write                       /*  1 "FASOPEN-WRITE"                                Primitive  0xf6 in fileio.c */,
  prim_faspos                              /*  1 "FASPOS"                                       Primitive  0xf7 in fileio.c */,
  prim_fasseek                             /*  2 "FASSEEK"                                      Primitive  0xf8 in fileio.c */,
  Prim_file_attributes                     /*  1 "FILE-ATTRIBUTES"                              Primitive  0xf9 in unixprim.c */,
  Prim_File_Close_Channel                  /*  1 "FILE-CLOSE-CHANNEL"                           Primitive  0xfa in fileio.c */,
  Prim_file_directory_p                    /*  1 "FILE-DIRECTORY?"                              Primitive  0xfb in unixprim.c */,
  Prim_File_Eof_P                          /*  1 "FILE-EOF?"                                    Primitive  0xfc in fileio.c */,
  Prim_File_Exists                         /*  1 "FILE-EXISTS?"                                 Primitive  0xfd in fileio.c */,
  Prim_File_Fill_Input_Buffer              /*  2 "FILE-FILL-INPUT-BUFFER"                       Primitive  0xfe in fileio.c */,
  Prim_File_Fill_Input_Buffer_Offset       /*  3 "FILE-FILL-INPUT-BUFFER-OFFSET"                Primitive  0xff in fileio.c */,
  Prim_File_Length                         /*  1 "FILE-LENGTH"                                  Primitive 0x100 in fileio.c */,
  Prim_File_Open_Channel                   /*  2 "FILE-OPEN-CHANNEL"                            Primitive 0x101 in fileio.c */,
  Prim_File_Read_Char                      /*  1 "FILE-READ-CHAR"                               Primitive 0x102 in fileio.c */,
  Prim_file_symlink_p                      /*  1 "FILE-SYMLINK?"                                Primitive 0x103 in unixprim.c */,
  Prim_file_time_to_string                 /*  1 "FILE-TIME->STRING"                            Primitive 0x104 in unixprim.c */,
  Prim_File_Write_Char                     /*  2 "FILE-WRITE-CHAR"                              Primitive 0x105 in fileio.c */,
  Prim_File_Write_String                   /*  2 "FILE-WRITE-STRING"                            Primitive 0x106 in fileio.c */,
  Prim_Find_Symbol                         /*  1 "FIND-SYMBOL"                                  Primitive 0x107 in xdebug.c */,
  Prim_Find_Who_Points                     /*  3 "FIND-WHO-POINTS"                              Primitive 0x108 in xdebug.c */,
  prim_float_infinity_p                    /*  1 "FLOAT-INFINITY?"                              Primitive 0x109 in cl-arith.c */,
  prim_float_nan_p                         /*  1 "FLOAT-NAN?"                                   Primitive 0x10a in cl-arith.c */,
  prim_float_parameter                     /*  2 "FLOAT-PARAMETER"                              Primitive 0x10b in cl-arith.c */,
  Prim_Floor                               /*  1 "FLOOR"                                        Primitive 0x10c in generic.c */,
  Prim_Force                               /*  1 "FORCE"                                        Primitive 0x10d in hooks.c */,
  Prim_Future_To_Vector                    /*  1 "FUTURE->VECTOR"                               Primitive 0x10e in future.c */,
  Prim_Future_Ref                          /*  2 "FUTURE-REF"                                   Primitive 0x10f in future.c */,
  Prim_Future_Set                          /*  3 "FUTURE-SET!"                                  Primitive 0x110 in future.c */,
  Prim_Future_Size                         /*  1 "FUTURE-SIZE"                                  Primitive 0x111 in future.c */,
  Prim_Future_P                            /*  1 "FUTURE?"                                      Primitive 0x112 in future.c */,
  Prim_G_Vector_Alloc                      /*  1 "G-VECTOR-ALLOC"                               Primitive 0x113 in gvector.c */,
  Prim_G_Vector_Length                     /*  1 "G-VECTOR-LENGTH"                              Primitive 0x114 in gvector.c */,
  Prim_G_Vector_Ref                        /*  2 "G-VECTOR-REF"                                 Primitive 0x115 in gvector.c */,
  Prim_G_Vector_Set                        /*  3 "G-VECTOR-SET!"                                Primitive 0x116 in gvector.c */,
  Prim_Garbage_Collect                     /*  1 "GARBAGE-COLLECT"                              Primitive 0x117 in bf-purify.c */,
  GC_Needed                                /*  0 "GC-NEEDED?"                                   Primitive 0x118 in bf-gc.c */,
  Prim_Gcd_Fixnum                          /*  2 "GCD-FIXNUM"                                   Primitive 0x119 in fixnum.c */,
  Prim_General_Car_Cdr                     /*  2 "GENERAL-CAR-CDR"                              Primitive 0x11a in list.c */,
  Prim_generic_multiply                    /* -1 "GENERIC-*"                                    Primitive 0x11b in cl-generic.c */,
  Prim_generic_plus                        /* -1 "GENERIC-+"                                    Primitive 0x11c in cl-generic.c */,
  Prim_generic_minus                       /* -1 "GENERIC--"                                    Primitive 0x11d in cl-generic.c */,
  Prim_generic_divide                      /* -1 "GENERIC-/"                                    Primitive 0x11e in cl-generic.c */,
  Prim_generic_notequal                    /* -1 "GENERIC-/="                                   Primitive 0x11f in cl-generic.c */,
  Prim_generic_one_plus                    /*  1 "GENERIC-1+"                                   Primitive 0x120 in cl-generic.c */,
  Prim_generic_one_minus                   /*  1 "GENERIC-1-"                                   Primitive 0x121 in cl-generic.c */,
  Prim_generic_lessthan                    /* -1 "GENERIC-<"                                    Primitive 0x122 in cl-generic.c */,
  Prim_generic_lessequalthan               /* -1 "GENERIC-<="                                   Primitive 0x123 in cl-generic.c */,
  Prim_generic_equal                       /* -1 "GENERIC-="                                    Primitive 0x124 in cl-generic.c */,
  Prim_generic_greaterthan                 /* -1 "GENERIC->"                                    Primitive 0x125 in cl-generic.c */,
  Prim_generic_greaterequalthan            /* -1 "GENERIC->="                                   Primitive 0x126 in cl-generic.c */,
  Prim_generic_abs                         /*  1 "GENERIC-ABS"                                  Primitive 0x127 in cl-generic.c */,
  Prim_generic_acos                        /*  1 "GENERIC-ACOS"                                 Primitive 0x128 in cl-generic.c */,
  Prim_generic_acosh                       /*  1 "GENERIC-ACOSH"                                Primitive 0x129 in cl-generic.c */,
  Prim_generic_asin                        /*  1 "GENERIC-ASIN"                                 Primitive 0x12a in cl-generic.c */,
  Prim_generic_asinh                       /*  1 "GENERIC-ASINH"                                Primitive 0x12b in cl-generic.c */,
  Prim_generic_atan                        /* -1 "GENERIC-ATAN"                                 Primitive 0x12c in cl-generic.c */,
  Prim_generic_atanh                       /*  1 "GENERIC-ATANH"                                Primitive 0x12d in cl-generic.c */,
  Prim_generic_ceiling                     /* -1 "GENERIC-CEILING"                              Primitive 0x12e in cl-generic.c */,
  Prim_generic_cis                         /*  1 "GENERIC-CIS"                                  Primitive 0x12f in cl-generic.c */,
  Prim_generic_conjugate                   /*  1 "GENERIC-CONJUGATE"                            Primitive 0x130 in cl-generic.c */,
  Prim_generic_cos                         /*  1 "GENERIC-COS"                                  Primitive 0x131 in cl-generic.c */,
  Prim_generic_cosh                        /*  1 "GENERIC-COSH"                                 Primitive 0x132 in cl-generic.c */,
  Prim_generic_evenp                       /*  1 "GENERIC-EVENP"                                Primitive 0x133 in cl-generic.c */,
  Prim_generic_exp                         /*  1 "GENERIC-EXP"                                  Primitive 0x134 in cl-generic.c */,
  Prim_generic_expt                        /*  2 "GENERIC-EXPT"                                 Primitive 0x135 in cl-generic.c */,
  Prim_generic_float                       /* -1 "GENERIC-FLOAT"                                Primitive 0x136 in cl-generic.c */,
  Prim_generic_floor                       /* -1 "GENERIC-FLOOR"                                Primitive 0x137 in cl-generic.c */,
  Prim_generic_gcd                         /* -1 "GENERIC-GCD"                                  Primitive 0x138 in cl-generic.c */,
  Prim_generic_isqrt                       /*  1 "GENERIC-ISQRT"                                Primitive 0x139 in cl-generic.c */,
  Prim_generic_lcm                         /* -1 "GENERIC-LCM"                                  Primitive 0x13a in cl-generic.c */,
  Prim_generic_log                         /* -1 "GENERIC-LOG"                                  Primitive 0x13b in cl-generic.c */,
  Prim_generic_max                         /* -1 "GENERIC-MAX"                                  Primitive 0x13c in cl-generic.c */,
  Prim_generic_min                         /* -1 "GENERIC-MIN"                                  Primitive 0x13d in cl-generic.c */,
  Prim_generic_minusp                      /*  1 "GENERIC-MINUSP"                               Primitive 0x13e in cl-generic.c */,
  Prim_generic_oddp                        /*  1 "GENERIC-ODDP"                                 Primitive 0x13f in cl-generic.c */,
  Prim_generic_phase                       /*  1 "GENERIC-PHASE"                                Primitive 0x140 in cl-generic.c */,
  Prim_generic_pi                          /*  0 "GENERIC-PI"                                   Primitive 0x141 in cl-generic.c */,
  Prim_generic_plusp                       /*  1 "GENERIC-PLUSP"                                Primitive 0x142 in cl-generic.c */,
  Prim_generic_rational                    /*  1 "GENERIC-RATIONAL"                             Primitive 0x143 in cl-generic.c */,
  Prim_generic_rationalize                 /*  1 "GENERIC-RATIONALIZE"                          Primitive 0x144 in cl-generic.c */,
  Prim_generic_round                       /* -1 "GENERIC-ROUND"                                Primitive 0x145 in cl-generic.c */,
  Prim_generic_signum                      /*  1 "GENERIC-SIGNUM"                               Primitive 0x146 in cl-generic.c */,
  Prim_generic_sin                         /*  1 "GENERIC-SIN"                                  Primitive 0x147 in cl-generic.c */,
  Prim_generic_sinh                        /*  1 "GENERIC-SINH"                                 Primitive 0x148 in cl-generic.c */,
  Prim_generic_sqrt                        /*  1 "GENERIC-SQRT"                                 Primitive 0x149 in cl-generic.c */,
  Prim_generic_tan                         /*  1 "GENERIC-TAN"                                  Primitive 0x14a in cl-generic.c */,
  Prim_generic_tanh                        /*  1 "GENERIC-TANH"                                 Primitive 0x14b in cl-generic.c */,
  Prim_generic_truncate                    /* -1 "GENERIC-TRUNCATE"                             Primitive 0x14c in cl-generic.c */,
  Prim_generic_zerop                       /*  1 "GENERIC-ZEROP"                                Primitive 0x14d in cl-generic.c */,
  Get_Character_From_Buffer                /*  1 "GET-CHARACTER-FROM-BUFFER!"                   Primitive 0x14e in bf-io.c */,
  Prim_Get_Command_Line                    /*  0 "GET-COMMAND-LINE"                             Primitive 0x14f in boot.c */,
  Prim_get_comline_option                  /*  2 "GET-COMMAND-LINE-OPTION"                      Primitive 0x150 in bf-prims.c */,
  Prim_get_environment_variable            /*  1 "GET-ENVIRONMENT-VARIABLE"                     Primitive 0x151 in unixprim.c */,
  Prim_Get_Fixed_Objects_Vector            /*  0 "GET-FIXED-OBJECTS-VECTOR"                     Primitive 0x152 in hooks.c */,
  Prim_Get_Fluid_Bindings                  /*  0 "GET-FLUID-BINDINGS"                           Primitive 0x153 in fhooks.c */,
  Prim_Get_G_Vector_Subtype                /*  1 "GET-G-VECTOR-SUBTYPE"                         Primitive 0x154 in gvector.c */,
  Prim_get_hardware_stack                  /*  1 "GET-HARDWARE-STACK-SLOT"                      Primitive 0x155 in bf-prims.c */,
  Prim_get_hardware_info                   /*  0 "GET-HARDWARE-TRAP-INFO"                       Primitive 0x156 in bf-prims.c */,
  prim_get_internal_run_time               /*  0 "GET-INTERNAL-RUN-TIME"                        Primitive 0x157 in cl-time.c */,
  prim_get_internal_time_units_per_second  /*  0 "GET-INTERNAL-TIME-UNITS-PER-SECOND"           Primitive 0x158 in cl-time.c */,
  prim_get_io_error_code_num               /*  1 "GET-IO-ERROR-CODE-NUM"                        Primitive 0x159 in cl-fileio.c */,
  Prim_Get_Next_Constant                   /*  0 "GET-NEXT-CONSTANT"                            Primitive 0x15a in bf-purify.c */,
  Prim_Get_Next_Interrupt_Char             /*  0 "GET-NEXT-INTERRUPT-CHARACTER"                 Primitive 0x15b in sysprim.c */,
  Prim_Get_Pointer_Processor               /*  1 "GET-PHYSICAL-NODE"                            Primitive 0x15c in bf-prims.c */,
  Prim_Get_Place_In_Code                   /*  1 "GET-PLACE-IN-CODE"                            Primitive 0x15d in bf-prims.c */,
  Prim_Get_Primitive_Address               /*  2 "GET-PRIMITIVE-ADDRESS"                        Primitive 0x15e in extern.c */,
  Prim_Get_Primitive_Counts                /*  0 "GET-PRIMITIVE-COUNTS"                         Primitive 0x15f in extern.c */,
  Prim_Get_Primitive_Name                  /*  1 "GET-PRIMITIVE-NAME"                           Primitive 0x160 in extern.c */,
  prim_getrusage                           /* -1 "GET-RESOURCE-USAGE-VECTOR"                    Primitive 0x161 in cl-time.c */,
  Prim_Get_Stats                           /*  0 "GET-STATISTICS"                               Primitive 0x162 in bf-prims.c */,
  prim_get_time_zone                       /*  0 "GET-TIME-ZONE"                                Primitive 0x163 in cl-time.c */,
  Prim_Timing_Info                         /*  2 "GET-TIMING-INFO"                              Primitive 0x164 in bf-prims.c */,
  prim_get_universal_time                  /*  0 "GET-UNIVERSAL-TIME"                           Primitive 0x165 in cl-time.c */,
  Prim_Get_Useful_Meters                   /*  0 "GET-USEFUL-METERS"                            Primitive 0x166 in bf-prims.c */,
  Prim_get_user_home_directory             /*  1 "GET-USER-HOME-DIRECTORY"                      Primitive 0x167 in unixprim.c */,
  Prim_Get_Work                            /*  1 "GET-WORK"                                     Primitive 0x168 in bf-prims.c */,
  Prim_gid_to_string                       /*  1 "GID->STRING"                                  Primitive 0x169 in unixprim.c */,
  Send_Global_Interrupt                    /*  3 "GLOBAL-INTERRUPT"                             Primitive 0x16a in bf-interco.c */,
  Prim_Greater_Bignum                      /*  2 "GREATER-THAN-BIGNUM?"                         Primitive 0x16b in bignum.c */,
  Prim_Greater_Fixnum                      /*  2 "GREATER-THAN-FIXNUM?"                         Primitive 0x16c in fixnum.c */,
  Prim_Greater_Flonum                      /*  2 "GREATER-THAN-FLONUM?"                         Primitive 0x16d in flonum.c */,
  Prim_Restartable_Exit                    /*  0 "HALT"                                         Primitive 0x16e in sysprim.c */,
  Prim_Hunk3_Cons                          /*  3 "HUNK3-CONS"                                   Primitive 0x16f in hunk.c */,
  Prim_Hunk3_Cxr                           /*  2 "HUNK3-CXR"                                    Primitive 0x170 in hunk.c */,
  Prim_Hunk3_Set_Cxr                       /*  3 "HUNK3-SET-CXR!"                               Primitive 0x171 in hunk.c */,
  Prim_Complex_Imag                        /*  1 "IMAGPART"                                     Primitive 0x172 in cl-generic.c */,
  Prim_Impurify_Code                       /*  0 "IMPURIFY-CODE-SPACE"                          Primitive 0x173 in parallel.c */,
  Prim_Insert_Non_Marked_Vector            /*  3 "INSERT-NON-MARKED-VECTOR!"                    Primitive 0x174 in random.c */,
  Prim_Insert_String                       /*  3 "INSERT-STRING"                                Primitive 0x175 in string.c */,
  Prim_Overwrite_String                    /*  3 "INSERT-STRING!"                               Primitive 0x176 in string.c */,
  Prim_Integer_To_Char                     /*  1 "INTEGER->CHAR"                                Primitive 0x177 in character.c */,
  prim_idf_exp                             /*  1 "INTEGER-DECODE-FLOAT-EXPONENT"                Primitive 0x178 in cl-arith.c */,
  prim_idf_mant                            /*  1 "INTEGER-DECODE-FLOAT-MANTISSA"                Primitive 0x179 in cl-arith.c */,
  Prim_Integer_Divide                      /*  2 "INTEGER-DIVIDE"                               Primitive 0x17a in generic.c */,
  prim_integer_length                      /*  1 "INTEGER-LENGTH"                               Primitive 0x17b in cl-arith.c */,
  Prim_Intern_Character_List               /*  1 "INTERN-CHARACTER-LIST"                        Primitive 0x17c in intern.c */,
  prim_io_error_code_p                     /*  1 "IO-ERROR-CODE-P"                              Primitive 0x17d in cl-fileio.c */,
  Prim_Length                              /*  1 "LENGTH"                                       Primitive 0x17e in list.c */,
  Prim_Less_Bignum                         /*  2 "LESS-THAN-BIGNUM?"                            Primitive 0x17f in bignum.c */,
  Prim_Less_Fixnum                         /*  2 "LESS-THAN-FIXNUM?"                            Primitive 0x180 in fixnum.c */,
  Prim_Less_Flonum                         /*  2 "LESS-THAN-FLONUM?"                            Primitive 0x181 in flonum.c */,
  Prim_Lexical_Assignment                  /*  3 "LEXICAL-ASSIGNMENT"                           Primitive 0x182 in lookup.c */,
  Prim_Lexical_Reference                   /*  2 "LEXICAL-REFERENCE"                            Primitive 0x183 in lookup.c */,
  Prim_Unassigned_Test                     /*  2 "LEXICAL-UNASSIGNED?"                          Primitive 0x184 in lookup.c */,
  Prim_Unbound_Test                        /*  2 "LEXICAL-UNBOUND?"                             Primitive 0x185 in lookup.c */,
  Prim_Unreferenceable_Test                /*  2 "LEXICAL-UNREFERENCEABLE?"                     Primitive 0x186 in lookup.c */,
  Prim_Link_File                           /*  3 "LINK-FILE"                                    Primitive 0x187 in fileio.c */,
  Prim_Build_String_From_List              /*  1 "LIST->STRING"                                 Primitive 0x188 in string.c */,
  Prim_List_To_Vector                      /*  1 "LIST->VECTOR"                                 Primitive 0x189 in vector.c */,
  Prim_Listify_Bignum                      /*  2 "LISTIFY-BIGNUM"                               Primitive 0x18a in bignum.c */,
  Prim_Ln_Flonum                           /*  1 "LN-FLONUM"                                    Primitive 0x18b in flonum.c */,
  Prim_Band_Load                           /*  1 "LOAD-BAND"                                    Primitive 0x18c in fasload.c */,
  Prim_Local_Assignment                    /*  3 "LOCAL-ASSIGNMENT"                             Primitive 0x18d in lookup.c */,
  Prim_Local_Reference                     /*  2 "LOCAL-REFERENCE"                              Primitive 0x18e in lookup.c */,
  Prim_Lock_Future                         /*  1 "LOCK-FUTURE!"                                 Primitive 0x18f in future.c */,
  Prim_Ln                                  /*  1 "LOG"                                          Primitive 0x190 in generic.c */,
  Prim_Logical_And                         /*  2 "LOGICAL-AND"                                  Primitive 0x191 in parallel.c */,
  Prim_Logical_Ior                         /*  2 "LOGICAL-IOR"                                  Primitive 0x192 in parallel.c */,
  Prim_Logical_Lsh                         /*  2 "LOGICAL-LSH"                                  Primitive 0x193 in parallel.c */,
  Prim_Logical_Not                         /*  1 "LOGICAL-NOT"                                  Primitive 0x194 in parallel.c */,
  Prim_Logical_Rsh                         /*  2 "LOGICAL-RSH"                                  Primitive 0x195 in parallel.c */,
  Prim_make_bit_string                     /*  2 "MAKE-BIT-STRING"                              Primitive 0x196 in bitstr.c */,
  Prim_Make_Cell                           /*  1 "MAKE-CELL"                                    Primitive 0x197 in prim.c */,
  Prim_Make_Char                           /*  2 "MAKE-CHAR"                                    Primitive 0x198 in character.c */,
  Prim_Make_Cheap_Future                   /*  3 "MAKE-CHEAP-FUTURE"                            Primitive 0x199 in ffuture.c */,
  Prim_Make_CL_Package                     /*  1 "MAKE-CL-PACKAGE"                              Primitive 0x19a in cl-pkgs.c */,
  Prim_Make_Complex                        /* -1 "MAKE-COMPLEX"                                 Primitive 0x19b in cl-generic.c */,
  Prim_Make_Directory                      /*  1 "MAKE-DIRECTORY"                               Primitive 0x19c in fileio.c */,
  Prim_Make_Empty_String                   /*  1 "MAKE-EMPTY-STRING"                            Primitive 0x19d in string.c */,
  Prim_Make_Fld_String                     /*  2 "MAKE-FILLED-STRING"                           Primitive 0x19e in string.c */,
  Prim_Make_Initial_Process                /*  1 "MAKE-INITIAL-PROCESS"                         Primitive 0x19f in future.c */,
  prim_make_io_error_code                  /*  1 "MAKE-IO-ERROR-CODE"                           Primitive 0x1a0 in cl-fileio.c */,
  Prim_Make_Non_Pointer                    /*  1 "MAKE-NON-POINTER-OBJECT"                      Primitive 0x1a1 in prim.c */,
  Prim_Make_OBArray                        /*  0 "MAKE-OBARRAY"                                 Primitive 0x1a2 in cl-pkgs.c */,
  Prim_Make_Ratio                          /*  2 "MAKE-RATIO"                                   Primitive 0x1a3 in cl-generic.c */,
  Prim_Make_State_Space                    /*  1 "MAKE-STATE-SPACE"                             Primitive 0x1a4 in hooks.c */,
  Prim_Make_Structure_G_Vector             /*  2 "MAKE-STRUCTURE-G-VECTOR"                      Primitive 0x1a5 in gvector.c */,
  prim_make_symbol                         /*  1 "MAKE-SYMBOL"                                  Primitive 0x1a6 in cl-symbol.c */,
  Prim_Map_Code_To_Address                 /*  2 "MAP-CODE-TO-MACHINE-ADDRESS"                  Primitive 0x1a7 in extern.c */,
  Prim_Map_Address_To_Code                 /*  2 "MAP-MACHINE-ADDRESS-TO-CODE"                  Primitive 0x1a8 in extern.c */,
  Master_Before_Sync                       /*  0 "MASTER-GC-BEFORE-SYNC"                        Primitive 0x1a9 in bf-gc.c */,
  Master_GC                                /*  1 "MASTER-GC-LOOP"                               Primitive 0x1aa in bf-gc.c */,
  Prim_Memq                                /*  2 "MEMQ"                                         Primitive 0x1ab in list.c */,
  Prim_Microcode_Identify                  /*  0 "MICROCODE-IDENTIFY"                           Primitive 0x1ac in boot.c */,
  Prim_Microcode_Tables_Filename           /*  0 "MICROCODE-TABLES-FILENAME"                    Primitive 0x1ad in boot.c */,
  Prim_Minus_Bignum                        /*  2 "MINUS-BIGNUM"                                 Primitive 0x1ae in bignum.c */,
  Prim_Minus_Fixnum                        /*  2 "MINUS-FIXNUM"                                 Primitive 0x1af in fixnum.c */,
  Prim_Minus_Flonum                        /*  2 "MINUS-FLONUM"                                 Primitive 0x1b0 in flonum.c */,
  Prim_M_1_Plus_Fixnum                     /*  1 "MINUS-ONE-PLUS-FIXNUM"                        Primitive 0x1b1 in fixnum.c */,
  Prim_Multiply_Bignum                     /*  2 "MULTIPLY-BIGNUM"                              Primitive 0x1b2 in bignum.c */,
  Prim_Multiply_Fixnum                     /*  2 "MULTIPLY-FIXNUM"                              Primitive 0x1b3 in fixnum.c */,
  Prim_Multiply_Flonum                     /*  2 "MULTIPLY-FLONUM"                              Primitive 0x1b4 in flonum.c */,
  Prim_My_Interp_Number                    /*  0 "MY-INTERPRETER-NUMBER"                        Primitive 0x1b5 in bf-prims.c */,
  Prim_My_Proc                             /*  0 "MY-PROCESSOR-NUMBER"                          Primitive 0x1b6 in bf-prims.c */,
  Prim_n_idle_procs                        /*  0 "N-IDLE-PROCESSORS"                            Primitive 0x1b7 in bf-prims.c */,
  Prim_N_Interps                           /*  0 "N-INTERPRETERS"                               Primitive 0x1b8 in bf-prims.c */,
  Prim_Negative_Bignum                     /*  1 "NEGATIVE-BIGNUM?"                             Primitive 0x1b9 in bignum.c */,
  Prim_Negative_Fixnum                     /*  1 "NEGATIVE-FIXNUM?"                             Primitive 0x1ba in fixnum.c */,
  Prim_Negative_Flonum                     /*  1 "NEGATIVE-FLONUM?"                             Primitive 0x1bb in flonum.c */,
  Prim_Negative                            /*  1 "NEGATIVE?"                                    Primitive 0x1bc in generic.c */,
  Prim_Non_Marked_Vector_Cons              /*  1 "NON-MARKED-VECTOR-CONS"                       Primitive 0x1bd in random.c */,
  Prim_Non_Reentrant_Catch                 /*  1 "NON-REENTRANT-CALL-WITH-CURRENT-CONTINUATION" Primitive 0x1be in hooks.c */,
  Prim_Future_Eq                           /*  2 "NON-TOUCHING-EQ?"                             Primitive 0x1bf in future.c */,
  Prim_Non_Touching_Prim_Type              /*  1 "NON-TOUCHING-PRIMITIVE-TYPE"                  Primitive 0x1c0 in prim.c */,
  Prim_Non_Touching_Prim_Type_QM           /*  2 "NON-TOUCHING-PRIMITIVE-TYPE?"                 Primitive 0x1c1 in prim.c */,
  Prim_Null                                /*  1 "NULL?"                                        Primitive 0x1c2 in prim.c */,
  Prim_One_Plus_Fixnum                     /*  1 "ONE-PLUS-FIXNUM"                              Primitive 0x1c3 in fixnum.c */,
  Prim_open_directory                      /*  1 "OPEN-DIRECTORY"                               Primitive 0x1c4 in fileio.c */,
  Prim_Pair                                /*  1 "PAIR?"                                        Primitive 0x1c5 in list.c */,
  Prim_Photo_Close                         /*  0 "PHOTO-CLOSE"                                  Primitive 0x1c6 in ttyio.c */,
  Prim_Photo_Open                          /*  1 "PHOTO-OPEN"                                   Primitive 0x1c7 in ttyio.c */,
  prim_pkg_add_name                        /*  3 "PKG-ADD-NAME"                                 Primitive 0x1c8 in cl-pkgs.c */,
  prim_pkg_add_symbol_to_ht                /*  2 "PKG-ADD-SYMBOL-TO-HASH-TABLE"                 Primitive 0x1c9 in cl-pkgs.c */,
  prim_pkg_find_symbol                     /*  3 "PKG-FIND-SYMBOL"                              Primitive 0x1ca in cl-pkgs.c */,
  prim_get_symbol                          /*  3 "PKG-GET-SYMBOL-FROM-HASH-TABLE"               Primitive 0x1cb in cl-pkgs.c */,
  prim_pkg_intern_string                   /*  3 "PKG-INTERN-STRING"                            Primitive 0x1cc in cl-pkgs.c */,
  prim_pkg_lookup_name                     /*  2 "PKG-LOOKUP-NAME"                              Primitive 0x1cd in cl-pkgs.c */,
  prim_pkg_remove_name                     /*  2 "PKG-REMOVE-NAME"                              Primitive 0x1ce in cl-pkgs.c */,
  prim_rm_symbol_from_ht                   /*  2 "PKG-REMOVE-SYMBOL-FROM-HASH-TABLE"            Primitive 0x1cf in cl-pkgs.c */,
  Prim_Plus_Bignum                         /*  2 "PLUS-BIGNUM"                                  Primitive 0x1d0 in bignum.c */,
  Prim_Plus_Fixnum                         /*  2 "PLUS-FIXNUM"                                  Primitive 0x1d1 in fixnum.c */,
  Prim_Plus_Flonum                         /*  2 "PLUS-FLONUM"                                  Primitive 0x1d2 in flonum.c */,
  Prim_Positive_Bignum                     /*  1 "POSITIVE-BIGNUM?"                             Primitive 0x1d3 in bignum.c */,
  Prim_Positive_Fixnum                     /*  1 "POSITIVE-FIXNUM?"                             Primitive 0x1d4 in fixnum.c */,
  Prim_Positive_Flonum                     /*  1 "POSITIVE-FLONUM?"                             Primitive 0x1d5 in flonum.c */,
  Prim_Positive                            /*  1 "POSITIVE?"                                    Primitive 0x1d6 in generic.c */,
  prim_elog_define                         /*  3 "PRIM-ELOG-DEFINE"                             Primitive 0x1d7 in elog.c */,
  prim_elog_init                           /*  1 "PRIM-ELOG-INIT"                               Primitive 0x1d8 in elog.c */,
  prim_elog_log                            /* -1 "PRIM-ELOG-LOG"                                Primitive 0x1d9 in elog.c */,
  prim_elog_output                         /*  0 "PRIM-ELOG-OUTPUT"                             Primitive 0x1da in elog.c */,
  prim_elog_setup                          /*  3 "PRIM-ELOG-SETUP"                              Primitive 0x1db in elog.c */,
  Prim_Apply_Step                          /*  3 "PRIMITIVE-APPLY-STEP"                         Primitive 0x1dc in step.c */,
  Prim_Primitive_Datum                     /*  1 "PRIMITIVE-DATUM"                              Primitive 0x1dd in prim.c */,
  Prim_Eval_Step                           /*  3 "PRIMITIVE-EVAL-STEP"                          Primitive 0x1de in step.c */,
  Prim_Prim_Fasdump                        /*  3 "PRIMITIVE-FASDUMP"                            Primitive 0x1df in fasdump.c */,
  Prim_Prim_Fasdump_Fd                     /*  4 "PRIMITIVE-FASDUMP-FD"                         Primitive 0x1e0 in fasdump.c */,
  Prim_Gc_Type                             /*  1 "PRIMITIVE-GC-TYPE"                            Primitive 0x1e1 in prim.c */,
  Prim_Impurify                            /*  1 "PRIMITIVE-IMPURIFY"                           Primitive 0x1e2 in bf-purify.c */,
  Prim_Map_Prim_Address_To_Arity           /*  1 "PRIMITIVE-PROCEDURE-ARITY"                    Primitive 0x1e3 in extern.c */,
  Prim_Primitive_Purify                    /*  2 "PRIMITIVE-PURIFY"                             Primitive 0x1e4 in bf-purify.c */,
  Prim_Return_Step                         /*  2 "PRIMITIVE-RETURN-STEP"                        Primitive 0x1e5 in step.c */,
  Prim_Primitive_Set_Type                  /*  2 "PRIMITIVE-SET-TYPE"                           Primitive 0x1e6 in prim.c */,
  Prim_Prim_Type                           /*  1 "PRIMITIVE-TYPE"                               Primitive 0x1e7 in prim.c */,
  Prim_Prim_Type_QM                        /*  2 "PRIMITIVE-TYPE?"                              Primitive 0x1e8 in prim.c */,
  prim_print_address                       /*  1 "PRINT-ADDRESS"                                Primitive 0x1e9 in cl-fileio.c */,
  Prim_Print_Memory                        /*  2 "PRINT-MEMORY"                                 Primitive 0x1ea in xdebug.c */,
  Prim_Pure_P                              /*  1 "PURE?"                                        Primitive 0x1eb in bf-purify.c */,
  Prim_Purify_Code                         /*  0 "PURIFY-CODE-SPACE"                            Primitive 0x1ec in parallel.c */,
  Prim_Put_Work                            /*  1 "PUT-WORK"                                     Primitive 0x1ed in bf-prims.c */,
  Prim_Quoted_Char_P                       /*  4 "QUOTED-CHAR?"                                 Primitive 0x1ee in syntax.c */,
  Prim_Ratio_Denominator                   /*  1 "RATIO-DENOMINATOR"                            Primitive 0x1ef in cl-generic.c */,
  Prim_Ratio_Numerator                     /*  1 "RATIO-NUMERATOR"                              Primitive 0x1f0 in cl-generic.c */,
  Prim_re_char_set_adjoin                  /*  2 "RE-CHAR-SET-ADJOIN!"                          Primitive 0x1f1 in rgxprim.c */,
  Prim_re_compile_fastmap                  /*  4 "RE-COMPILE-FASTMAP"                           Primitive 0x1f2 in rgxprim.c */,
  Prim_re_match_buffer                     /*  7 "RE-MATCH-BUFFER"                              Primitive 0x1f3 in rgxprim.c */,
  Prim_re_match_substring                  /*  7 "RE-MATCH-SUBSTRING"                           Primitive 0x1f4 in rgxprim.c */,
  Prim_re_search_buffer_backward           /*  7 "RE-SEARCH-BUFFER-BACKWARD"                    Primitive 0x1f5 in rgxprim.c */,
  Prim_re_search_buffer_forward            /*  7 "RE-SEARCH-BUFFER-FORWARD"                     Primitive 0x1f6 in rgxprim.c */,
  Prim_re_search_substr_backward           /*  7 "RE-SEARCH-SUBSTRING-BACKWARD"                 Primitive 0x1f7 in rgxprim.c */,
  Prim_re_search_substr_forward            /*  7 "RE-SEARCH-SUBSTRING-FORWARD"                  Primitive 0x1f8 in rgxprim.c */,
  Prim_read_bits_x                         /*  3 "READ-BITS!"                                   Primitive 0x1f9 in bitstr.c */,
  Prim_real_time_clock                     /*  0 "REAL-TIME-CLOCK"                              Primitive 0x1fa in sysprim.c */,
  Prim_Complex_Real                        /*  1 "REALPART"                                     Primitive 0x1fb in cl-generic.c */,
  Prim_Rehash                              /*  2 "REHASH"                                       Primitive 0x1fc in daemon.c */,
  Prim_reload_band_name                    /*  0 "RELOAD-BAND-NAME"                             Primitive 0x1fd in fasload.c */,
  Prim_Remove_File                         /*  1 "REMOVE-FILE"                                  Primitive 0x1fe in fileio.c */,
  Prim_Rename_File                         /*  2 "RENAME-FILE"                                  Primitive 0x1ff in fileio.c */,
  Return_External_Msg                      /*  0 "RETURN-EXTERNAL-MESSAGE"                      Primitive 0x200 in bf-io.c */,
  Prim_Round                               /*  1 "ROUND"                                        Primitive 0x201 in generic.c */,
  Prim_Round_Flonum                        /*  1 "ROUND-FLONUM"                                 Primitive 0x202 in flonum.c */,
  Prim_Scan_Backward_Prefix_Chars          /*  4 "SCAN-BACKWARD-PREFIX-CHARS"                   Primitive 0x203 in syntax.c */,
  Prim_Scan_Forward_To_Word                /*  4 "SCAN-FORWARD-TO-WORD"                         Primitive 0x204 in syntax.c */,
  Prim_Scan_List_Backward                  /*  7 "SCAN-LIST-BACKWARD"                           Primitive 0x205 in syntax.c */,
  Prim_Scan_List_Forward                   /*  7 "SCAN-LIST-FORWARD"                            Primitive 0x206 in syntax.c */,
  Prim_Scan_Sexps_Forward                  /*  7 "SCAN-SEXPS-FORWARD"                           Primitive 0x207 in syntax.c */,
  Prim_Scan_Word_Backward                  /*  4 "SCAN-WORD-BACKWARD"                           Primitive 0x208 in syntax.c */,
  Prim_Scan_Word_Forward                   /*  4 "SCAN-WORD-FORWARD"                            Primitive 0x209 in syntax.c */,
  Prim_Scode_Eval                          /*  2 "SCODE-EVAL"                                   Primitive 0x20a in hooks.c */,
  Prim_Screen_X_Size                       /*  0 "SCREEN-X-SIZE"                                Primitive 0x20b in ttyio.c */,
  Prim_Screen_Y_Size                       /*  0 "SCREEN-Y-SIZE"                                Primitive 0x20c in ttyio.c */,
  Prim_Set_Car                             /*  2 "SET-CAR!"                                     Primitive 0x20d in list.c */,
  Prim_Set_Car_If_Eq                       /*  3 "SET-CAR-IF-EQ?!"                              Primitive 0x20e in future.c */,
  Prim_Set_Cdr                             /*  2 "SET-CDR!"                                     Primitive 0x20f in list.c */,
  Prim_Set_Cdr_If_Eq                       /*  3 "SET-CDR-IF-EQ?!"                              Primitive 0x210 in future.c */,
  Prim_Set_Cell_Contents                   /*  2 "SET-CELL-CONTENTS!"                           Primitive 0x211 in prim.c */,
  Prim_Set_Dynamic_State                   /*  1 "SET-CURRENT-DYNAMIC-STATE!"                   Primitive 0x212 in hooks.c */,
  Prim_Set_Current_Future                  /*  1 "SET-CURRENT-FUTURE!"                          Primitive 0x213 in ffuture.c */,
  Prim_Set_Current_History                 /*  1 "SET-CURRENT-HISTORY!"                         Primitive 0x214 in hooks.c */,
  Prim_Set_Cxr_If_Eq                       /*  4 "SET-CXR-IF-EQ?!"                              Primitive 0x215 in future.c */,
  Prim_Set_Debug_Flag                      /*  2 "SET-DEBUG-FLAG!"                              Primitive 0x216 in bf-prims.c */,
  Prim_Set_Fixed_Objects_Vector            /*  1 "SET-FIXED-OBJECTS-VECTOR!"                    Primitive 0x217 in hooks.c */,
  Prim_Set_Fluid_Bindings                  /*  1 "SET-FLUID-BINDINGS!"                          Primitive 0x218 in fhooks.c */,
  Prim_Set_G_Vector_Subtype                /*  2 "SET-G-VECTOR-SUBTYPE!"                        Primitive 0x219 in gvector.c */,
  Prim_Set_Idle_Limit                      /*  1 "SET-IDLE-LIMIT!"                              Primitive 0x21a in bf-prims.c */,
  Prim_Set_Interrupt_Enables               /*  1 "SET-INTERRUPT-ENABLES!"                       Primitive 0x21b in hooks.c */,
  Prim_Set_Queue_Level                     /*  1 "SET-QUEUE-OVERFLOW-LEVEL!"                    Primitive 0x21c in bf-prims.c */,
  Prim_Set_Run_Light                       /*  1 "SET-RUN-LIGHT!"                               Primitive 0x21d in sysprim.c */,
  Prim_Set_String_Length                   /*  2 "SET-STRING-LENGTH!"                           Primitive 0x21e in stringprim.c */,
  Prim_Set_Subsumer_Hack                   /*  2 "SET-SUBSUMPTION-RATIO!"                       Primitive 0x21f in bf-prims.c */,
  Prim_set_working_dir_pathname            /*  1 "SET-WORKING-DIRECTORY-PATHNAME!"              Primitive 0x220 in fileio.c */,
  Prim_Setup_Timer_Interrupt               /*  2 "SETUP-TIMER-INTERRUPT"                        Primitive 0x221 in sysprim.c */,
  Prim_Show_Env                            /*  1 "SHOW-ENV"                                     Primitive 0x222 in xdebug.c */,
  Prim_Show_Pure                           /*  0 "SHOW-PURE"                                    Primitive 0x223 in xdebug.c */,
  Prim_Sine                                /*  1 "SIN"                                          Primitive 0x224 in generic.c */,
  Prim_Sine_Flonum                         /*  1 "SINE-FLONUM"                                  Primitive 0x225 in flonum.c */,
  Slave_After_Sync                         /*  0 "SLAVE-GC-AFTER-SYNC"                          Primitive 0x226 in bf-gc.c */,
  Slave_Before_Sync                        /*  0 "SLAVE-GC-BEFORE-SYNC"                         Primitive 0x227 in bf-gc.c */,
  Prim_Sqrt                                /*  1 "SQRT"                                         Primitive 0x228 in generic.c */,
  Prim_Sqrt_Flonum                         /*  1 "SQRT-FLONUM"                                  Primitive 0x229 in flonum.c */,
  Prim_Stack_Top_Address                   /*  0 "STACK-TOP-ADDRESS"                            Primitive 0x22a in comutl.c */,
  Prim_Stack_Trace                         /*  0 "STACK-TRACE"                                  Primitive 0x22b in xdebug.c */,
  Prim_String_To_Symbol                    /*  1 "STRING->SYMBOL"                               Primitive 0x22c in intern.c */,
  Prim_String_To_Syntax_Entry              /*  1 "STRING->SYNTAX-ENTRY"                         Primitive 0x22d in syntax.c */,
  Prim_String_Allocate                     /*  1 "STRING-ALLOCATE"                              Primitive 0x22e in stringprim.c */,
  Prim_String_Equal                        /*  2 "STRING-EQUAL?"                                Primitive 0x22f in string.c */,
  Prim_String_Hash                         /*  1 "STRING-HASH"                                  Primitive 0x230 in intern.c */,
  Prim_string_hash_mod                     /*  2 "STRING-HASH-MOD"                              Primitive 0x231 in intern.c */,
  Prim_String_Length                       /*  1 "STRING-LENGTH"                                Primitive 0x232 in stringprim.c */,
  Prim_String_Less                         /*  2 "STRING-LESS?"                                 Primitive 0x233 in string.c */,
  Prim_String_Maximum_Length               /*  1 "STRING-MAXIMUM-LENGTH"                        Primitive 0x234 in stringprim.c */,
  Prim_String_Position                     /*  3 "STRING-POSITION"                              Primitive 0x235 in string.c */,
  Prim_String_Ref                          /*  2 "STRING-REF"                                   Primitive 0x236 in stringprim.c */,
  Prim_String_Set                          /*  3 "STRING-SET!"                                  Primitive 0x237 in stringprim.c */,
  Prim_Raise_String                        /*  1 "STRING-UPCASE"                                Primitive 0x238 in string.c */,
  Prim_String_P                            /*  1 "STRING?"                                      Primitive 0x239 in stringprim.c */,
  Prim_Substring                           /*  3 "SUBSTRING"                                    Primitive 0x23a in string.c */,
  Prim_Substring_To_List                   /*  3 "SUBSTRING->LIST"                              Primitive 0x23b in string.c */,
  Prim_Substring_Ci_Equal                  /*  6 "SUBSTRING-CI=?"                               Primitive 0x23c in stringprim.c */,
  Prim_Substring_Downcase                  /*  3 "SUBSTRING-DOWNCASE!"                          Primitive 0x23d in stringprim.c */,
  Prim_SubString_Equal                     /*  6 "SUBSTRING-EQUAL?"                             Primitive 0x23e in stringmisc.c */,
  Prim_Find_Next_Char_In_Set               /*  4 "SUBSTRING-FIND-NEXT-CHAR-IN-SET"              Primitive 0x23f in stringprim.c */,
  Prim_Find_Prev_Char_In_Set               /*  4 "SUBSTRING-FIND-PREVIOUS-CHAR-IN-SET"          Primitive 0x240 in stringprim.c */,
  Prim_Match_Backward                      /*  6 "SUBSTRING-MATCH-BACKWARD"                     Primitive 0x241 in stringprim.c */,
  Prim_Match_Backward_Ci                   /*  6 "SUBSTRING-MATCH-BACKWARD-CI"                  Primitive 0x242 in stringprim.c */,
  Prim_Match_Forward                       /*  6 "SUBSTRING-MATCH-FORWARD"                      Primitive 0x243 in stringprim.c */,
  Prim_Match_Forward_Ci                    /*  6 "SUBSTRING-MATCH-FORWARD-CI"                   Primitive 0x244 in stringprim.c */,
  Prim_Substring_Move_Left                 /*  5 "SUBSTRING-MOVE-LEFT!"                         Primitive 0x245 in stringprim.c */,
  Prim_Substring_Move_Right                /*  5 "SUBSTRING-MOVE-RIGHT!"                        Primitive 0x246 in stringprim.c */,
  Prim_Substring_Search                    /*  2 "SUBSTRING-SEARCH"                             Primitive 0x247 in string.c */,
  Prim_Substring_Upcase                    /*  3 "SUBSTRING-UPCASE!"                            Primitive 0x248 in stringprim.c */,
  Prim_Substring_Less                      /*  6 "SUBSTRING<?"                                  Primitive 0x249 in stringprim.c */,
  Prim_Substring_Equal                     /*  6 "SUBSTRING=?"                                  Primitive 0x24a in stringprim.c */,
  Prim_Subvector_To_List                   /*  3 "SUBVECTOR->LIST"                              Primitive 0x24b in vector.c */,
  Prim_vector_fill                         /*  4 "SUBVECTOR-FILL!"                              Primitive 0x24c in vector.c */,
  Prim_subvector_move_left                 /*  5 "SUBVECTOR-MOVE-LEFT!"                         Primitive 0x24d in vector.c */,
  Prim_subvector_move_right                /*  5 "SUBVECTOR-MOVE-RIGHT!"                        Primitive 0x24e in vector.c */,
  prim_svref                               /*  2 "SVREF"                                        Primitive 0x24f in gvector.c */,
  Prim_Hash_A_String                       /*  3 "SX-HASH-SIMPLE-STRING"                        Primitive 0x250 in bool.c */,
  prim_hash_float                          /*  1 "SXHASH-FLOAT"                                 Primitive 0x251 in cl-arith.c */,
  Prim_system_active                       /*  0 "SYSTEM-ACTIVE?"                               Primitive 0x252 in bf-prims.c */,
  Prim_System_Clock                        /*  0 "SYSTEM-CLOCK"                                 Primitive 0x253 in sysprim.c */,
  Prim_Sys_H3_0                            /*  1 "SYSTEM-HUNK3-CXR0"                            Primitive 0x254 in hunk.c */,
  Prim_Sys_H3_1                            /*  1 "SYSTEM-HUNK3-CXR1"                            Primitive 0x255 in hunk.c */,
  Prim_Sys_H3_2                            /*  1 "SYSTEM-HUNK3-CXR2"                            Primitive 0x256 in hunk.c */,
  Prim_SH3_Set_0                           /*  2 "SYSTEM-HUNK3-SET-CXR0!"                       Primitive 0x257 in hunk.c */,
  Prim_SH3_Set_1                           /*  2 "SYSTEM-HUNK3-SET-CXR1!"                       Primitive 0x258 in hunk.c */,
  Prim_SH3_Set_2                           /*  2 "SYSTEM-HUNK3-SET-CXR2!"                       Primitive 0x259 in hunk.c */,
  Prim_Sys_List_To_Vector                  /*  2 "SYSTEM-LIST-TO-VECTOR"                        Primitive 0x25a in vector.c */,
  Prim_System_Memory_Ref                   /*  2 "SYSTEM-MEMORY-REF"                            Primitive 0x25b in prim.c */,
  Prim_System_Memory_Set                   /*  3 "SYSTEM-MEMORY-SET!"                           Primitive 0x25c in prim.c */,
  Prim_Sys_Pair_Car                        /*  1 "SYSTEM-PAIR-CAR"                              Primitive 0x25d in list.c */,
  Prim_Sys_Pair_Cdr                        /*  1 "SYSTEM-PAIR-CDR"                              Primitive 0x25e in list.c */,
  Prim_Sys_Pair_Cons                       /*  3 "SYSTEM-PAIR-CONS"                             Primitive 0x25f in list.c */,
  Prim_Sys_Set_Car                         /*  2 "SYSTEM-PAIR-SET-CAR!"                         Primitive 0x260 in list.c */,
  Prim_Sys_Set_Cdr                         /*  2 "SYSTEM-PAIR-SET-CDR!"                         Primitive 0x261 in list.c */,
  Prim_Sys_Pair                            /*  1 "SYSTEM-PAIR?"                                 Primitive 0x262 in list.c */,
  Prim_Sys_Subvector_To_List               /*  3 "SYSTEM-SUBVECTOR-TO-LIST"                     Primitive 0x263 in vector.c */,
  prim_system_vector_32b_length            /*  1 "SYSTEM-VECTOR-32B-LENGTH"                     Primitive 0x264 in cl-streams.c */,
  prim_system_vector_32b_ref               /*  2 "SYSTEM-VECTOR-32B-REF"                        Primitive 0x265 in cl-streams.c */,
  prim_system_vector_32b_set               /*  3 "SYSTEM-VECTOR-32B-SET!"                       Primitive 0x266 in cl-streams.c */,
  Prim_Sys_Vector_Ref                      /*  2 "SYSTEM-VECTOR-REF"                            Primitive 0x267 in vector.c */,
  Prim_Sys_Vec_Set                         /*  3 "SYSTEM-VECTOR-SET!"                           Primitive 0x268 in vector.c */,
  Prim_Sys_Vec_Size                        /*  1 "SYSTEM-VECTOR-SIZE"                           Primitive 0x269 in vector.c */,
  Prim_Sys_Vector                          /*  1 "SYSTEM-VECTOR?"                               Primitive 0x26a in vector.c */,
  Prim_Touch                               /*  1 "TOUCH"                                        Primitive 0x26b in future.c */,
  Prim_Translate_To_Point                  /*  1 "TRANSLATE-TO-STATE-POINT"                     Primitive 0x26c in hooks.c */,
  Prim_Truncate                            /*  1 "TRUNCATE"                                     Primitive 0x26d in generic.c */,
  Prim_Truncate_Flonum                     /*  1 "TRUNCATE-FLONUM"                              Primitive 0x26e in flonum.c */,
  Prim_Truncate_String                     /*  2 "TRUNCATE-STRING!"                             Primitive 0x26f in string.c */,
  Prim_Tty_Beep                            /*  0 "TTY-BEEP"                                     Primitive 0x270 in ttyio.c */,
  Prim_Tty_Clear                           /*  0 "TTY-CLEAR"                                    Primitive 0x271 in ttyio.c */,
  Prim_tty_flush_output                    /*  0 "TTY-FLUSH-OUTPUT"                             Primitive 0x272 in ttyio.c */,
  Prim_Tty_Get_Cursor                      /*  0 "TTY-GET-CURSOR"                               Primitive 0x273 in ttyio.c */,
  Prim_Tty_Move_Cursor                     /*  2 "TTY-MOVE-CURSOR"                              Primitive 0x274 in ttyio.c */,
  Prim_Tty_Read_Char                       /*  0 "TTY-READ-CHAR"                                Primitive 0x275 in ttyio.c */,
  Prim_Tty_Read_Char_Immediate             /*  0 "TTY-READ-CHAR-IMMEDIATE"                      Primitive 0x276 in ttyio.c */,
  Prim_Tty_Read_Char_Ready_P               /*  1 "TTY-READ-CHAR-READY?"                         Primitive 0x277 in ttyio.c */,
  Prim_Tty_Read_Finish                     /*  0 "TTY-READ-FINISH"                              Primitive 0x278 in ttyio.c */,
  Prim_Tty_Write_Char                      /*  1 "TTY-WRITE-CHAR"                               Primitive 0x279 in ttyio.c */,
  Prim_Tty_Write_String                    /*  1 "TTY-WRITE-STRING"                             Primitive 0x27a in ttyio.c */,
  Prim_uid_to_string                       /*  1 "UID->STRING"                                  Primitive 0x27b in unixprim.c */,
  Prim_under_emacs_p                       /*  0 "UNDER-EMACS?"                                 Primitive 0x27c in sysprim.c */,
  prim_unix_ctime                          /*  1 "UNIX-CTIME"                                   Primitive 0x27d in cl-time.c */,
  prim_unix_inverse_ctime                  /*  2 "UNIX-INVERSE-CTIME"                           Primitive 0x27e in cl-time.c */,
  Prim_Unlock_Future                       /*  1 "UNLOCK-FUTURE!"                               Primitive 0x27f in future.c */,
  Prim_unsigned_to_bit_string              /*  2 "UNSIGNED-INTEGER->BIT-STRING"                 Primitive 0x280 in bitstr.c */,
  Prim_Unsigned_Primitive_Datum            /*  1 "UNSIGNED-PRIMITIVE-DATUM"                     Primitive 0x281 in prim.c */,
  prim_values                              /* -1 "VALUES"                                       Primitive 0x282 in values.c */,
  prim_values_list                         /*  1 "VALUES-LIST"                                  Primitive 0x283 in values.c */,
  Prim_vector                              /* -1 "VECTOR"                                       Primitive 0x284 in vector.c */,
  Prim_Vector_8b_Cons                      /*  1 "VECTOR-8B-CONS"                               Primitive 0x285 in string.c */,
  Prim_Vec_8b_Fill                         /*  4 "VECTOR-8B-FILL!"                              Primitive 0x286 in stringprim.c */,
  Prim_Vec_8b_Find_Next_Char               /*  4 "VECTOR-8B-FIND-NEXT-CHAR"                     Primitive 0x287 in stringprim.c */,
  Prim_Vec_8b_Find_Next_Char_Ci            /*  4 "VECTOR-8B-FIND-NEXT-CHAR-CI"                  Primitive 0x288 in stringprim.c */,
  Prim_Vec_8b_Find_Prev_Char               /*  4 "VECTOR-8B-FIND-PREVIOUS-CHAR"                 Primitive 0x289 in stringprim.c */,
  Prim_Vec_8b_Find_Prev_Char_Ci            /*  4 "VECTOR-8B-FIND-PREVIOUS-CHAR-CI"              Primitive 0x28a in stringprim.c */,
  Prim_Vec_8b_Ref                          /*  2 "VECTOR-8B-REF"                                Primitive 0x28b in stringprim.c */,
  Prim_Vec_8b_Set                          /*  3 "VECTOR-8B-SET!"                               Primitive 0x28c in stringprim.c */,
  Prim_Vec_8b_Size                         /*  1 "VECTOR-8B-SIZE"                               Primitive 0x28d in string.c */,
  Prim_Vector_8b                           /*  1 "VECTOR-8B?"                                   Primitive 0x28e in string.c */,
  Prim_Vector_Cons                         /*  2 "VECTOR-CONS"                                  Primitive 0x28f in vector.c */,
  Prim_Vector_Size                         /*  1 "VECTOR-LENGTH"                                Primitive 0x290 in vector.c */,
  Prim_Vector_Ref                          /*  2 "VECTOR-REF"                                   Primitive 0x291 in vector.c */,
  Prim_Vector_Set                          /*  3 "VECTOR-SET!"                                  Primitive 0x292 in vector.c */,
  Prim_Vector_Set_If_Eq                    /*  4 "VECTOR-SET-IF-EQ?!"                           Primitive 0x293 in future.c */,
  Suspend                                  /*  1 "WAIT"                                         Primitive 0x294 in bf-io.c */,
  Prim_With_History_Disabled               /*  1 "WITH-HISTORY-DISABLED"                        Primitive 0x295 in hooks.c */,
  Prim_With_Interrupt_Mask                 /*  2 "WITH-INTERRUPT-MASK"                          Primitive 0x296 in hooks.c */,
  Prim_With_Interrupts_Reduced             /*  2 "WITH-INTERRUPTS-REDUCED"                      Primitive 0x297 in hooks.c */,
  Prim_With_Saved_Fluid_Bindings           /*  1 "WITH-SAVED-FLUID-BINDINGS"                    Primitive 0x298 in fhooks.c */,
  Prim_With_Threaded_Stack                 /*  2 "WITH-THREADED-CONTINUATION"                   Primitive 0x299 in hooks.c */,
  prim_with_values                         /*  2 "WITH-VALUES"                                  Primitive 0x29a in values.c */,
  Prim_Within_Control_Point                /*  2 "WITHIN-CONTROL-POINT"                         Primitive 0x29b in hooks.c */,
  Prim_work_queue_length                   /*  0 "WORK-QUEUE-LENGTH"                            Primitive 0x29c in bf-prims.c */,
  Prim_work_queue_sizes                    /*  1 "WORK-QUEUE-SIZES"                             Primitive 0x29d in bf-prims.c */,
  Prim_working_dir_pathname                /*  0 "WORKING-DIRECTORY-PATHNAME"                   Primitive 0x29e in fileio.c */,
  Prim_write_bits_x                        /*  3 "WRITE-BITS!"                                  Primitive 0x29f in bitstr.c */,
  Prim_Zero_Bignum                         /*  1 "ZERO-BIGNUM?"                                 Primitive 0x2a0 in bignum.c */,
  Prim_Zero_Fixnum                         /*  1 "ZERO-FIXNUM?"                                 Primitive 0x2a1 in fixnum.c */,
  Prim_Zero_Flonum                         /*  1 "ZERO-FLONUM?"                                 Primitive 0x2a2 in flonum.c */,
  Prim_Zero                                /*  1 "ZERO?"                                        Primitive 0x2a3 in generic.c */,
  Prim_Inexistent                          /*  0 "INEXISTENT-PRIMITIVE"                         Primitive   ??? in Findprim.c */
};

char *Primitive_Name_Table[] = {
  "%AWAIT-FUTURE",
  "%CHANGE-PRIORITY",
  "%DETERMINE!",
  "%INHERIT-PRIORITY-DOWN",
  "%INHERIT-PRIORITY-UP",
  "%RESCHEDULE",
  "%SET-CL-FASLOAD-CHECK!",
  "%SPAWN-PROCESS",
  "%START-PREEMPTING",
  "%STOP-PREEMPTING",
  "%SVSET",
  "&*",
  "&+",
  "&-",
  "&/",
  "&<",
  "&=",
  "&>",
  "&ATAN",
  "&MAKE-OBJECT",
  "-1+",
  "1+",
  "ADD-FLUID-BINDING!",
  "APPLY",
  "ARCTAN-FLONUM",
  "ASCII->CHAR",
  "ASH",
  "ASSQ",
  "ATOMIC-ADD-CAR!",
  "ATOMIC-ADD-CDR!",
  "ATOMIC-ADD-VECTOR!",
  "AWAIT-SYNCHRONY",
  "BFIO-GET-STREAM-NUMBER",
  "BFIO-KICK-INPUT-SERVER",
  "BFIO-NEXT-HASH-NUMBER",
  "BFIO-READ-CHAR",
  "BFIO-READ-STRING",
  "BFIO-TASK-HASH",
  "BFIO-TASK-UNHASH",
  "BINARY-FASLOAD",
  "BINARY-FASLOAD-FD",
  "BIT-STRING->UNSIGNED-INTEGER",
  "BIT-STRING-ALLOCATE",
  "BIT-STRING-AND!",
  "BIT-STRING-ANDC!",
  "BIT-STRING-CLEAR!",
  "BIT-STRING-FILL!",
  "BIT-STRING-LENGTH",
  "BIT-STRING-MOVE!",
  "BIT-STRING-MOVEC!",
  "BIT-STRING-OR!",
  "BIT-STRING-REF",
  "BIT-STRING-SET!",
  "BIT-STRING-XOR!",
  "BIT-STRING-ZERO?",
  "BIT-STRING=?",
  "BIT-STRING?",
  "BIT-SUBSTRING-FIND-NEXT-SET-BIT",
  "BIT-SUBSTRING-MOVE-RIGHT!",
  "BOOLE",
  "CALL-WITH-CURRENT-CONTINUATION",
  "CAR",
  "CDR",
  "CEILING",
  "CELL-CONTENTS",
  "CELL?",
  "CHAR->ASCII",
  "CHAR->INTEGER",
  "CHAR->SYNTAX-CODE",
  "CHAR-ASCII?",
  "CHAR-BITS",
  "CHAR-CODE",
  "CHAR-DOWNCASE",
  "CHAR-UPCASE",
  "CHARACTER-LIST-HASH",
  "CHARACTER-UPCASE",
  "CHECK-AND-CLEAN-UP-INPUT-CHANNEL",
  "CL-%MAKE-BROADCAST-STREAM",
  "CL-%MAKE-CONCATENATED-STREAM",
  "CL-ADD-CLSAV",
  "CL-ADJUST-ARRAY",
  "CL-ADJUSTABLE-ARRAY-P",
  "CL-AREF",
  "CL-ARRAY-DIMENSION",
  "CL-ARRAY-DIMENSION-LIMIT",
  "CL-ARRAY-DIMENSIONS",
  "CL-ARRAY-ELEMENT-TYPE",
  "CL-ARRAY-HAS-FILL-POINTER-P",
  "CL-ARRAY-IN-BOUNDS-P",
  "CL-ARRAY-IS-DISPLACED-P",
  "CL-ARRAY-RANK",
  "CL-ARRAY-RANK-LIMIT",
  "CL-ARRAY-ROW-MAJOR-INDEX",
  "CL-ARRAY-TOTAL-SIZE",
  "CL-ARRAY-TOTAL-SIZE-LIMIT",
  "CL-ARRAYP",
  "CL-ASET",
  "CL-BIT",
  "CL-BITSET",
  "CL-BROADCAST-STREAM-STREAMS",
  "CL-BROADCAST-STREAM?",
  "CL-CHARPOS",
  "CL-CLEAR-INPUT",
  "CL-CLEAR-OUTPUT",
  "CL-CLOSE",
  "CL-CLOSED-STREAM?",
  "CL-COMPUTERIZED-FLONUM-TO-STRING",
  "CL-CONCATENATED-STREAM-STREAMS",
  "CL-CONCATENATED-STREAM?",
  "CL-DIRECTORY?",
  "CL-ECHO-STREAM-INPUT-STREAM",
  "CL-ECHO-STREAM-OUTPUT-STREAM",
  "CL-ECHO-STREAM?",
  "CL-ELT",
  "CL-ELT-SET",
  "CL-EXPANDED-SYMBOL?",
  "CL-FAST-SYMBOL-PLIST",
  "CL-FAST-SYSTEM-SYMBOL-PLIST",
  "CL-FILE-AUTHOR",
  "CL-FILE-CLOSE-FD",
  "CL-FILE-LENGTH",
  "CL-FILE-OPEN-FD",
  "CL-FILE-POSITION",
  "CL-FILE-STREAM?",
  "CL-FILE-WRITE-DATE",
  "CL-FILL-POINTER",
  "CL-FIND-DATA-VECTOR",
  "CL-FINISH-OUTPUT",
  "CL-FORCE-OUTPUT",
  "CL-FORMAT-EXPONENTIAL-FLONUM-TO-STRING",
  "CL-FORMAT-FIXED-FLONUM-TO-STRING",
  "CL-FUNCTION-SYMBOL?",
  "CL-GET-CLSAV",
  "CL-GET-FUNCTION-SYMBOL-PARENT",
  "CL-GET-HOST-NAME",
  "CL-GET-OUTPUT-STREAM-STRING",
  "CL-GET-SYMBOL-NAME",
  "CL-INTERNAL-WRITE-CHAR",
  "CL-INTERNAL-WRITE-STRING",
  "CL-INTERNAL-WRITE-STRING-START-END",
  "CL-ISA-TTY-P",
  "CL-IVECTOR-EQUAL",
  "CL-LISTEN",
  "CL-MAKE-ARRAY",
  "CL-MAKE-ECHO-STREAM",
  "CL-MAKE-FILE-STREAM",
  "CL-MAKE-STRING-INPUT-STREAM",
  "CL-MAKE-STRING-OUTPUT-STREAM",
  "CL-MAKE-SYNONYM-STREAM",
  "CL-MAKE-THE-TTY-STREAM",
  "CL-MAKE-TWO-WAY-STREAM",
  "CL-OVERWRITE-STRING",
  "CL-PARSE-NUMBER",
  "CL-PEEK-CHAR",
  "CL-READ-BYTE",
  "CL-READ-CHAR",
  "CL-READ-CHAR-NO-HANG",
  "CL-READ-LINE",
  "CL-READ-STRING",
  "CL-SBIT",
  "CL-SBITSET",
  "CL-SCAN-DIRECTORY",
  "CL-SET-BFIO-MODE!",
  "CL-SET-FILL-POINTER",
  "CL-SET-STREAM-INFO!",
  "CL-SIMPLE-ARRAY-P",
  "CL-SLEEP",
  "CL-STREAM-DIRECTION",
  "CL-STREAM-ELEMENT-TYPE",
  "CL-STREAM-INFO",
  "CL-STREAM-PATHNAME",
  "CL-STRING-CAPITALIZE",
  "CL-STRING-CAPITALIZE!",
  "CL-STRING-INPUT-STREAM-INDEX",
  "CL-STRING-OPEN",
  "CL-STRING-STREAM?",
  "CL-SYNONYM-STREAM-SYMBOL",
  "CL-SYNONYM-STREAM?",
  "CL-SYSTEM-VECTOR-SET!",
  "CL-TTY-STREAM?",
  "CL-TWO-WAY-STREAM-INPUT-STREAM",
  "CL-TWO-WAY-STREAM-OUTPUT-STREAM",
  "CL-TWO-WAY-STREAM?",
  "CL-UNREAD-CHAR",
  "CL-VECTOR-LENGTH",
  "CL-VECTOR-POP",
  "CL-VECTOR-PUSH",
  "CL-VECTOR-PUSH-EXTEND",
  "CL-VECTOR-SET!",
  "CL-WRITE-BYTE",
  "CL-WRITE-CHAR",
  "CL-WRITE-LINE",
  "CL-WRITE-STRING",
  "CLEAR-TO-END-OF-LINE",
  "CLOSE-LOST-OPEN-FILES",
  "CODE->CODE-SPACE",
  "COERCE-BIGNUM-TO-FIXNUM",
  "COERCE-FIXNUM-TO-BIGNUM",
  "COERCE-INTEGER-TO-FLONUM",
  "COERCE-TO-COMPILED-PROCEDURE",
  "COMPILED-CODE-ADDRESS->BLOCK",
  "COMPILED-CODE-ADDRESS->OFFSET",
  "COMPILED-ENTRY-KIND",
  "CONS",
  "CONSTANT?",
  "COPY-FILE",
  "COS",
  "COSINE-FLONUM",
  "CURRENT-DAY",
  "CURRENT-DYNAMIC-STATE",
  "CURRENT-FILE-TIME",
  "CURRENT-FUTURE",
  "CURRENT-HOUR",
  "CURRENT-MINUTE",
  "CURRENT-MONTH",
  "CURRENT-SECOND",
  "CURRENT-USER-NAME",
  "CURRENT-YEAR",
  "DEBUG-FLAGS",
  "DEBUGGING-PRINTER",
  "DECODE-FLOAT-EXPONENT",
  "DECODE-FLOAT-MANTISSA",
  "DECODE-FLOAT-SIGN",
  "DEQUEUE-HEAD!",
  "DEQUEUE-TAIL!",
  "DIRECTORY-READ",
  "DIVIDE-BIGNUM",
  "DIVIDE-FIXNUM",
  "DIVIDE-FLONUM",
  "DRAIN-WORK-QUEUE!",
  "DUMP-BAND",
  "ENABLE-INTERRUPTS!",
  "ENQUEUE-HEAD!",
  "ENQUEUE-TAIL!",
  "EQ?",
  "EQUAL-BIGNUM?",
  "EQUAL-FIXNUM?",
  "EQUAL-FLONUM?",
  "EQUAL-STRING-TO-LIST?",
  "ERROR-PROCEDURE",
  "EXECUTE-AT-NEW-STATE-POINT",
  "EXIT",
  "EXP",
  "EXP-FLONUM",
  "FASCLOSE",
  "FASOPEN-READ",
  "FASOPEN-WRITE",
  "FASPOS",
  "FASSEEK",
  "FILE-ATTRIBUTES",
  "FILE-CLOSE-CHANNEL",
  "FILE-DIRECTORY?",
  "FILE-EOF?",
  "FILE-EXISTS?",
  "FILE-FILL-INPUT-BUFFER",
  "FILE-FILL-INPUT-BUFFER-OFFSET",
  "FILE-LENGTH",
  "FILE-OPEN-CHANNEL",
  "FILE-READ-CHAR",
  "FILE-SYMLINK?",
  "FILE-TIME->STRING",
  "FILE-WRITE-CHAR",
  "FILE-WRITE-STRING",
  "FIND-SYMBOL",
  "FIND-WHO-POINTS",
  "FLOAT-INFINITY?",
  "FLOAT-NAN?",
  "FLOAT-PARAMETER",
  "FLOOR",
  "FORCE",
  "FUTURE->VECTOR",
  "FUTURE-REF",
  "FUTURE-SET!",
  "FUTURE-SIZE",
  "FUTURE?",
  "G-VECTOR-ALLOC",
  "G-VECTOR-LENGTH",
  "G-VECTOR-REF",
  "G-VECTOR-SET!",
  "GARBAGE-COLLECT",
  "GC-NEEDED?",
  "GCD-FIXNUM",
  "GENERAL-CAR-CDR",
  "GENERIC-*",
  "GENERIC-+",
  "GENERIC--",
  "GENERIC-/",
  "GENERIC-/=",
  "GENERIC-1+",
  "GENERIC-1-",
  "GENERIC-<",
  "GENERIC-<=",
  "GENERIC-=",
  "GENERIC->",
  "GENERIC->=",
  "GENERIC-ABS",
  "GENERIC-ACOS",
  "GENERIC-ACOSH",
  "GENERIC-ASIN",
  "GENERIC-ASINH",
  "GENERIC-ATAN",
  "GENERIC-ATANH",
  "GENERIC-CEILING",
  "GENERIC-CIS",
  "GENERIC-CONJUGATE",
  "GENERIC-COS",
  "GENERIC-COSH",
  "GENERIC-EVENP",
  "GENERIC-EXP",
  "GENERIC-EXPT",
  "GENERIC-FLOAT",
  "GENERIC-FLOOR",
  "GENERIC-GCD",
  "GENERIC-ISQRT",
  "GENERIC-LCM",
  "GENERIC-LOG",
  "GENERIC-MAX",
  "GENERIC-MIN",
  "GENERIC-MINUSP",
  "GENERIC-ODDP",
  "GENERIC-PHASE",
  "GENERIC-PI",
  "GENERIC-PLUSP",
  "GENERIC-RATIONAL",
  "GENERIC-RATIONALIZE",
  "GENERIC-ROUND",
  "GENERIC-SIGNUM",
  "GENERIC-SIN",
  "GENERIC-SINH",
  "GENERIC-SQRT",
  "GENERIC-TAN",
  "GENERIC-TANH",
  "GENERIC-TRUNCATE",
  "GENERIC-ZEROP",
  "GET-CHARACTER-FROM-BUFFER!",
  "GET-COMMAND-LINE",
  "GET-COMMAND-LINE-OPTION",
  "GET-ENVIRONMENT-VARIABLE",
  "GET-FIXED-OBJECTS-VECTOR",
  "GET-FLUID-BINDINGS",
  "GET-G-VECTOR-SUBTYPE",
  "GET-HARDWARE-STACK-SLOT",
  "GET-HARDWARE-TRAP-INFO",
  "GET-INTERNAL-RUN-TIME",
  "GET-INTERNAL-TIME-UNITS-PER-SECOND",
  "GET-IO-ERROR-CODE-NUM",
  "GET-NEXT-CONSTANT",
  "GET-NEXT-INTERRUPT-CHARACTER",
  "GET-PHYSICAL-NODE",
  "GET-PLACE-IN-CODE",
  "GET-PRIMITIVE-ADDRESS",
  "GET-PRIMITIVE-COUNTS",
  "GET-PRIMITIVE-NAME",
  "GET-RESOURCE-USAGE-VECTOR",
  "GET-STATISTICS",
  "GET-TIME-ZONE",
  "GET-TIMING-INFO",
  "GET-UNIVERSAL-TIME",
  "GET-USEFUL-METERS",
  "GET-USER-HOME-DIRECTORY",
  "GET-WORK",
  "GID->STRING",
  "GLOBAL-INTERRUPT",
  "GREATER-THAN-BIGNUM?",
  "GREATER-THAN-FIXNUM?",
  "GREATER-THAN-FLONUM?",
  "HALT",
  "HUNK3-CONS",
  "HUNK3-CXR",
  "HUNK3-SET-CXR!",
  "IMAGPART",
  "IMPURIFY-CODE-SPACE",
  "INSERT-NON-MARKED-VECTOR!",
  "INSERT-STRING",
  "INSERT-STRING!",
  "INTEGER->CHAR",
  "INTEGER-DECODE-FLOAT-EXPONENT",
  "INTEGER-DECODE-FLOAT-MANTISSA",
  "INTEGER-DIVIDE",
  "INTEGER-LENGTH",
  "INTERN-CHARACTER-LIST",
  "IO-ERROR-CODE-P",
  "LENGTH",
  "LESS-THAN-BIGNUM?",
  "LESS-THAN-FIXNUM?",
  "LESS-THAN-FLONUM?",
  "LEXICAL-ASSIGNMENT",
  "LEXICAL-REFERENCE",
  "LEXICAL-UNASSIGNED?",
  "LEXICAL-UNBOUND?",
  "LEXICAL-UNREFERENCEABLE?",
  "LINK-FILE",
  "LIST->STRING",
  "LIST->VECTOR",
  "LISTIFY-BIGNUM",
  "LN-FLONUM",
  "LOAD-BAND",
  "LOCAL-ASSIGNMENT",
  "LOCAL-REFERENCE",
  "LOCK-FUTURE!",
  "LOG",
  "LOGICAL-AND",
  "LOGICAL-IOR",
  "LOGICAL-LSH",
  "LOGICAL-NOT",
  "LOGICAL-RSH",
  "MAKE-BIT-STRING",
  "MAKE-CELL",
  "MAKE-CHAR",
  "MAKE-CHEAP-FUTURE",
  "MAKE-CL-PACKAGE",
  "MAKE-COMPLEX",
  "MAKE-DIRECTORY",
  "MAKE-EMPTY-STRING",
  "MAKE-FILLED-STRING",
  "MAKE-INITIAL-PROCESS",
  "MAKE-IO-ERROR-CODE",
  "MAKE-NON-POINTER-OBJECT",
  "MAKE-OBARRAY",
  "MAKE-RATIO",
  "MAKE-STATE-SPACE",
  "MAKE-STRUCTURE-G-VECTOR",
  "MAKE-SYMBOL",
  "MAP-CODE-TO-MACHINE-ADDRESS",
  "MAP-MACHINE-ADDRESS-TO-CODE",
  "MASTER-GC-BEFORE-SYNC",
  "MASTER-GC-LOOP",
  "MEMQ",
  "MICROCODE-IDENTIFY",
  "MICROCODE-TABLES-FILENAME",
  "MINUS-BIGNUM",
  "MINUS-FIXNUM",
  "MINUS-FLONUM",
  "MINUS-ONE-PLUS-FIXNUM",
  "MULTIPLY-BIGNUM",
  "MULTIPLY-FIXNUM",
  "MULTIPLY-FLONUM",
  "MY-INTERPRETER-NUMBER",
  "MY-PROCESSOR-NUMBER",
  "N-IDLE-PROCESSORS",
  "N-INTERPRETERS",
  "NEGATIVE-BIGNUM?",
  "NEGATIVE-FIXNUM?",
  "NEGATIVE-FLONUM?",
  "NEGATIVE?",
  "NON-MARKED-VECTOR-CONS",
  "NON-REENTRANT-CALL-WITH-CURRENT-CONTINUATION",
  "NON-TOUCHING-EQ?",
  "NON-TOUCHING-PRIMITIVE-TYPE",
  "NON-TOUCHING-PRIMITIVE-TYPE?",
  "NULL?",
  "ONE-PLUS-FIXNUM",
  "OPEN-DIRECTORY",
  "PAIR?",
  "PHOTO-CLOSE",
  "PHOTO-OPEN",
  "PKG-ADD-NAME",
  "PKG-ADD-SYMBOL-TO-HASH-TABLE",
  "PKG-FIND-SYMBOL",
  "PKG-GET-SYMBOL-FROM-HASH-TABLE",
  "PKG-INTERN-STRING",
  "PKG-LOOKUP-NAME",
  "PKG-REMOVE-NAME",
  "PKG-REMOVE-SYMBOL-FROM-HASH-TABLE",
  "PLUS-BIGNUM",
  "PLUS-FIXNUM",
  "PLUS-FLONUM",
  "POSITIVE-BIGNUM?",
  "POSITIVE-FIXNUM?",
  "POSITIVE-FLONUM?",
  "POSITIVE?",
  "PRIM-ELOG-DEFINE",
  "PRIM-ELOG-INIT",
  "PRIM-ELOG-LOG",
  "PRIM-ELOG-OUTPUT",
  "PRIM-ELOG-SETUP",
  "PRIMITIVE-APPLY-STEP",
  "PRIMITIVE-DATUM",
  "PRIMITIVE-EVAL-STEP",
  "PRIMITIVE-FASDUMP",
  "PRIMITIVE-FASDUMP-FD",
  "PRIMITIVE-GC-TYPE",
  "PRIMITIVE-IMPURIFY",
  "PRIMITIVE-PROCEDURE-ARITY",
  "PRIMITIVE-PURIFY",
  "PRIMITIVE-RETURN-STEP",
  "PRIMITIVE-SET-TYPE",
  "PRIMITIVE-TYPE",
  "PRIMITIVE-TYPE?",
  "PRINT-ADDRESS",
  "PRINT-MEMORY",
  "PURE?",
  "PURIFY-CODE-SPACE",
  "PUT-WORK",
  "QUOTED-CHAR?",
  "RATIO-DENOMINATOR",
  "RATIO-NUMERATOR",
  "RE-CHAR-SET-ADJOIN!",
  "RE-COMPILE-FASTMAP",
  "RE-MATCH-BUFFER",
  "RE-MATCH-SUBSTRING",
  "RE-SEARCH-BUFFER-BACKWARD",
  "RE-SEARCH-BUFFER-FORWARD",
  "RE-SEARCH-SUBSTRING-BACKWARD",
  "RE-SEARCH-SUBSTRING-FORWARD",
  "READ-BITS!",
  "REAL-TIME-CLOCK",
  "REALPART",
  "REHASH",
  "RELOAD-BAND-NAME",
  "REMOVE-FILE",
  "RENAME-FILE",
  "RETURN-EXTERNAL-MESSAGE",
  "ROUND",
  "ROUND-FLONUM",
  "SCAN-BACKWARD-PREFIX-CHARS",
  "SCAN-FORWARD-TO-WORD",
  "SCAN-LIST-BACKWARD",
  "SCAN-LIST-FORWARD",
  "SCAN-SEXPS-FORWARD",
  "SCAN-WORD-BACKWARD",
  "SCAN-WORD-FORWARD",
  "SCODE-EVAL",
  "SCREEN-X-SIZE",
  "SCREEN-Y-SIZE",
  "SET-CAR!",
  "SET-CAR-IF-EQ?!",
  "SET-CDR!",
  "SET-CDR-IF-EQ?!",
  "SET-CELL-CONTENTS!",
  "SET-CURRENT-DYNAMIC-STATE!",
  "SET-CURRENT-FUTURE!",
  "SET-CURRENT-HISTORY!",
  "SET-CXR-IF-EQ?!",
  "SET-DEBUG-FLAG!",
  "SET-FIXED-OBJECTS-VECTOR!",
  "SET-FLUID-BINDINGS!",
  "SET-G-VECTOR-SUBTYPE!",
  "SET-IDLE-LIMIT!",
  "SET-INTERRUPT-ENABLES!",
  "SET-QUEUE-OVERFLOW-LEVEL!",
  "SET-RUN-LIGHT!",
  "SET-STRING-LENGTH!",
  "SET-SUBSUMPTION-RATIO!",
  "SET-WORKING-DIRECTORY-PATHNAME!",
  "SETUP-TIMER-INTERRUPT",
  "SHOW-ENV",
  "SHOW-PURE",
  "SIN",
  "SINE-FLONUM",
  "SLAVE-GC-AFTER-SYNC",
  "SLAVE-GC-BEFORE-SYNC",
  "SQRT",
  "SQRT-FLONUM",
  "STACK-TOP-ADDRESS",
  "STACK-TRACE",
  "STRING->SYMBOL",
  "STRING->SYNTAX-ENTRY",
  "STRING-ALLOCATE",
  "STRING-EQUAL?",
  "STRING-HASH",
  "STRING-HASH-MOD",
  "STRING-LENGTH",
  "STRING-LESS?",
  "STRING-MAXIMUM-LENGTH",
  "STRING-POSITION",
  "STRING-REF",
  "STRING-SET!",
  "STRING-UPCASE",
  "STRING?",
  "SUBSTRING",
  "SUBSTRING->LIST",
  "SUBSTRING-CI=?",
  "SUBSTRING-DOWNCASE!",
  "SUBSTRING-EQUAL?",
  "SUBSTRING-FIND-NEXT-CHAR-IN-SET",
  "SUBSTRING-FIND-PREVIOUS-CHAR-IN-SET",
  "SUBSTRING-MATCH-BACKWARD",
  "SUBSTRING-MATCH-BACKWARD-CI",
  "SUBSTRING-MATCH-FORWARD",
  "SUBSTRING-MATCH-FORWARD-CI",
  "SUBSTRING-MOVE-LEFT!",
  "SUBSTRING-MOVE-RIGHT!",
  "SUBSTRING-SEARCH",
  "SUBSTRING-UPCASE!",
  "SUBSTRING<?",
  "SUBSTRING=?",
  "SUBVECTOR->LIST",
  "SUBVECTOR-FILL!",
  "SUBVECTOR-MOVE-LEFT!",
  "SUBVECTOR-MOVE-RIGHT!",
  "SVREF",
  "SX-HASH-SIMPLE-STRING",
  "SXHASH-FLOAT",
  "SYSTEM-ACTIVE?",
  "SYSTEM-CLOCK",
  "SYSTEM-HUNK3-CXR0",
  "SYSTEM-HUNK3-CXR1",
  "SYSTEM-HUNK3-CXR2",
  "SYSTEM-HUNK3-SET-CXR0!",
  "SYSTEM-HUNK3-SET-CXR1!",
  "SYSTEM-HUNK3-SET-CXR2!",
  "SYSTEM-LIST-TO-VECTOR",
  "SYSTEM-MEMORY-REF",
  "SYSTEM-MEMORY-SET!",
  "SYSTEM-PAIR-CAR",
  "SYSTEM-PAIR-CDR",
  "SYSTEM-PAIR-CONS",
  "SYSTEM-PAIR-SET-CAR!",
  "SYSTEM-PAIR-SET-CDR!",
  "SYSTEM-PAIR?",
  "SYSTEM-SUBVECTOR-TO-LIST",
  "SYSTEM-VECTOR-32B-LENGTH",
  "SYSTEM-VECTOR-32B-REF",
  "SYSTEM-VECTOR-32B-SET!",
  "SYSTEM-VECTOR-REF",
  "SYSTEM-VECTOR-SET!",
  "SYSTEM-VECTOR-SIZE",
  "SYSTEM-VECTOR?",
  "TOUCH",
  "TRANSLATE-TO-STATE-POINT",
  "TRUNCATE",
  "TRUNCATE-FLONUM",
  "TRUNCATE-STRING!",
  "TTY-BEEP",
  "TTY-CLEAR",
  "TTY-FLUSH-OUTPUT",
  "TTY-GET-CURSOR",
  "TTY-MOVE-CURSOR",
  "TTY-READ-CHAR",
  "TTY-READ-CHAR-IMMEDIATE",
  "TTY-READ-CHAR-READY?",
  "TTY-READ-FINISH",
  "TTY-WRITE-CHAR",
  "TTY-WRITE-STRING",
  "UID->STRING",
  "UNDER-EMACS?",
  "UNIX-CTIME",
  "UNIX-INVERSE-CTIME",
  "UNLOCK-FUTURE!",
  "UNSIGNED-INTEGER->BIT-STRING",
  "UNSIGNED-PRIMITIVE-DATUM",
  "VALUES",
  "VALUES-LIST",
  "VECTOR",
  "VECTOR-8B-CONS",
  "VECTOR-8B-FILL!",
  "VECTOR-8B-FIND-NEXT-CHAR",
  "VECTOR-8B-FIND-NEXT-CHAR-CI",
  "VECTOR-8B-FIND-PREVIOUS-CHAR",
  "VECTOR-8B-FIND-PREVIOUS-CHAR-CI",
  "VECTOR-8B-REF",
  "VECTOR-8B-SET!",
  "VECTOR-8B-SIZE",
  "VECTOR-8B?",
  "VECTOR-CONS",
  "VECTOR-LENGTH",
  "VECTOR-REF",
  "VECTOR-SET!",
  "VECTOR-SET-IF-EQ?!",
  "WAIT",
  "WITH-HISTORY-DISABLED",
  "WITH-INTERRUPT-MASK",
  "WITH-INTERRUPTS-REDUCED",
  "WITH-SAVED-FLUID-BINDINGS",
  "WITH-THREADED-CONTINUATION",
  "WITH-VALUES",
  "WITHIN-CONTROL-POINT",
  "WORK-QUEUE-LENGTH",
  "WORK-QUEUE-SIZES",
  "WORKING-DIRECTORY-PATHNAME",
  "WRITE-BITS!",
  "ZERO-BIGNUM?",
  "ZERO-FIXNUM?",
  "ZERO-FLONUM?",
  "ZERO?"
};

int Primitive_Arity_Table[] = {
  1,
  2,
  3,
  2,
  2,
  0,
  1,
  3,
  0,
  0,
  3,
  2,
  2,
  2,
  2,
  2,
  2,
  2,
  1,
  2,
  1,
  1,
  3,
  2,
  1,
  1,
  2,
  2,
  2,
  2,
  3,
  1,
  0,
  0,
  0,
  2,
  3,
  1,
  1,
  1,
  2,
  1,
  1,
  2,
  2,
  2,
  2,
  1,
  2,
  2,
  2,
  2,
  2,
  2,
  1,
  2,
  1,
  3,
  5,
  3,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  1,
  -1,
  1,
  -1,
  2,
  0,
  1,
  1,
  1,
  -1,
  1,
  1,
  0,
  -1,
  1,
  0,
  1,
  -1,
  -1,
  -1,
  1,
  1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  3,
  1,
  1,
  1,
  1,
  1,
  1,
  4,
  -1,
  1,
  1,
  1,
  1,
  -1,
  -1,
  7,
  5,
  1,
  1,
  1,
  0,
  1,
  1,
  1,
  2,
  4,
  1,
  2,
  -1,
  -1,
  2,
  5,
  -1,
  0,
  1,
  0,
  2,
  5,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  2,
  2,
  2,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  4,
  1,
  1,
  1,
  3,
  1,
  1,
  1,
  1,
  -1,
  1,
  1,
  2,
  -1,
  3,
  2,
  -1,
  -1,
  -1,
  0,
  1,
  1,
  1,
  1,
  1,
  2,
  1,
  1,
  1,
  2,
  1,
  2,
  1,
  1,
  0,
  1,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  2,
  2,
  2,
  0,
  2,
  1,
  2,
  2,
  2,
  2,
  2,
  2,
  2,
  3,
  4,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  1,
  1,
  1,
  1,
  1,
  2,
  3,
  1,
  2,
  1,
  1,
  1,
  2,
  2,
  1,
  3,
  1,
  1,
  2,
  1,
  1,
  1,
  2,
  3,
  1,
  1,
  1,
  1,
  2,
  3,
  1,
  0,
  2,
  2,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  1,
  -1,
  -1,
  -1,
  -1,
  -1,
  1,
  1,
  1,
  1,
  1,
  -1,
  1,
  -1,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  -1,
  -1,
  -1,
  1,
  -1,
  -1,
  -1,
  -1,
  1,
  1,
  1,
  0,
  1,
  1,
  1,
  -1,
  1,
  1,
  1,
  1,
  1,
  1,
  -1,
  1,
  1,
  0,
  2,
  1,
  0,
  0,
  1,
  1,
  0,
  0,
  0,
  1,
  0,
  0,
  1,
  1,
  2,
  0,
  1,
  -1,
  0,
  0,
  2,
  0,
  0,
  1,
  1,
  1,
  3,
  2,
  2,
  2,
  0,
  3,
  2,
  3,
  1,
  0,
  3,
  3,
  3,
  1,
  1,
  1,
  2,
  1,
  1,
  1,
  1,
  2,
  2,
  2,
  3,
  2,
  2,
  2,
  2,
  3,
  1,
  1,
  2,
  1,
  1,
  3,
  2,
  1,
  1,
  2,
  2,
  2,
  1,
  2,
  2,
  1,
  2,
  3,
  1,
  -1,
  1,
  1,
  2,
  1,
  1,
  1,
  0,
  2,
  1,
  2,
  1,
  2,
  2,
  0,
  1,
  2,
  0,
  0,
  2,
  2,
  2,
  1,
  2,
  2,
  2,
  0,
  0,
  0,
  0,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  1,
  2,
  1,
  1,
  1,
  1,
  0,
  1,
  3,
  2,
  3,
  3,
  3,
  2,
  2,
  2,
  2,
  2,
  2,
  1,
  1,
  1,
  1,
  3,
  1,
  -1,
  0,
  3,
  3,
  1,
  3,
  3,
  4,
  1,
  1,
  1,
  2,
  2,
  2,
  1,
  2,
  1,
  2,
  1,
  0,
  1,
  4,
  1,
  1,
  2,
  4,
  7,
  7,
  7,
  7,
  7,
  7,
  3,
  0,
  1,
  2,
  0,
  1,
  2,
  0,
  1,
  1,
  4,
  4,
  7,
  7,
  7,
  4,
  4,
  2,
  0,
  0,
  2,
  3,
  2,
  3,
  2,
  1,
  1,
  1,
  4,
  2,
  1,
  1,
  2,
  1,
  1,
  1,
  1,
  2,
  2,
  1,
  2,
  1,
  0,
  1,
  1,
  0,
  0,
  1,
  1,
  0,
  0,
  1,
  1,
  1,
  2,
  1,
  2,
  1,
  2,
  1,
  3,
  2,
  3,
  1,
  1,
  3,
  3,
  6,
  3,
  6,
  4,
  4,
  6,
  6,
  6,
  6,
  5,
  5,
  2,
  3,
  6,
  6,
  3,
  4,
  5,
  5,
  2,
  3,
  1,
  0,
  0,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  2,
  3,
  1,
  1,
  3,
  2,
  2,
  1,
  3,
  1,
  2,
  3,
  2,
  3,
  1,
  1,
  1,
  1,
  1,
  1,
  2,
  0,
  0,
  0,
  0,
  2,
  0,
  0,
  1,
  0,
  1,
  1,
  1,
  0,
  1,
  2,
  1,
  2,
  1,
  -1,
  1,
  -1,
  1,
  4,
  4,
  4,
  4,
  4,
  2,
  3,
  1,
  1,
  2,
  1,
  2,
  3,
  4,
  1,
  1,
  2,
  2,
  1,
  2,
  2,
  2,
  0,
  1,
  0,
  3,
  1,
  1,
  1,
  1
};

int Primitive_Count_Table[] = {
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (5 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (5 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (5 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (5 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (7 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (6 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (6 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (6 * sizeof(Pointer)),
  (6 * sizeof(Pointer)),
  (6 * sizeof(Pointer)),
  (6 * sizeof(Pointer)),
  (5 * sizeof(Pointer)),
  (5 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (6 * sizeof(Pointer)),
  (6 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (5 * sizeof(Pointer)),
  (5 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (-1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (4 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (2 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (0 * sizeof(Pointer)),
  (3 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer)),
  (1 * sizeof(Pointer))
};

